/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSDedicatedWorkerContext.h"

#include "DedicatedWorkerContext.h"
#include "EventListener.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDedicatedWorkerContextTableValues[] =
{
    { "onmessage", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDedicatedWorkerContextOnmessage), (intptr_t)setJSDedicatedWorkerContextOnmessage, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDedicatedWorkerContextTable = { 2, 1, JSDedicatedWorkerContextTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDedicatedWorkerContextPrototypeTableValues[] =
{
    { "postMessage", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDedicatedWorkerContextPrototypeFunctionPostMessage), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDedicatedWorkerContextPrototypeTable = { 2, 1, JSDedicatedWorkerContextPrototypeTableValues, 0 };
static const HashTable* getJSDedicatedWorkerContextPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDedicatedWorkerContextPrototypeTable);
}

const ClassInfo JSDedicatedWorkerContextPrototype::s_info = { "DedicatedWorkerContextPrototype", &Base::s_info, 0, getJSDedicatedWorkerContextPrototypeTable, CREATE_METHOD_TABLE(JSDedicatedWorkerContextPrototype) };

bool JSDedicatedWorkerContextPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDedicatedWorkerContextPrototype* thisObject = jsCast<JSDedicatedWorkerContextPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDedicatedWorkerContextPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDedicatedWorkerContextPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDedicatedWorkerContextPrototype* thisObject = jsCast<JSDedicatedWorkerContextPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDedicatedWorkerContextPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSDedicatedWorkerContextTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDedicatedWorkerContextTable);
}

const ClassInfo JSDedicatedWorkerContext::s_info = { "DedicatedWorkerContext", &Base::s_info, 0, getJSDedicatedWorkerContextTable , CREATE_METHOD_TABLE(JSDedicatedWorkerContext) };

JSDedicatedWorkerContext::JSDedicatedWorkerContext(JSGlobalData& globalData, Structure* structure, PassRefPtr<DedicatedWorkerContext> impl)
    : JSWorkerContext(globalData, structure, impl)
{
}

bool JSDedicatedWorkerContext::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDedicatedWorkerContext* thisObject = jsCast<JSDedicatedWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDedicatedWorkerContext, Base>(exec, getJSDedicatedWorkerContextTable(exec), thisObject, propertyName, slot);
}

bool JSDedicatedWorkerContext::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDedicatedWorkerContext* thisObject = jsCast<JSDedicatedWorkerContext*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDedicatedWorkerContext, Base>(exec, getJSDedicatedWorkerContextTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDedicatedWorkerContextOnmessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDedicatedWorkerContext* castedThis = jsCast<JSDedicatedWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DedicatedWorkerContext* impl = static_cast<DedicatedWorkerContext*>(castedThis->impl());
    if (EventListener* listener = impl->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


void JSDedicatedWorkerContext::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSDedicatedWorkerContext* thisObject = jsCast<JSDedicatedWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSDedicatedWorkerContext, Base>(exec, propertyName, value, getJSDedicatedWorkerContextTable(exec), thisObject, slot);
}

void setJSDedicatedWorkerContextOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDedicatedWorkerContext* castedThis = jsCast<JSDedicatedWorkerContext*>(thisObject);
    DedicatedWorkerContext* impl = static_cast<DedicatedWorkerContext*>(castedThis->impl());
    impl->setOnmessage(createJSAttributeEventListener(exec, value, thisObject));
}


EncodedJSValue JSC_HOST_CALL jsDedicatedWorkerContextPrototypeFunctionPostMessage(ExecState* exec)
{
    JSDedicatedWorkerContext* castedThis = toJSDedicatedWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDedicatedWorkerContext::s_info);
    return JSValue::encode(castedThis->postMessage(exec));
}

DedicatedWorkerContext* toDedicatedWorkerContext(JSC::JSValue value)
{
    return value.inherits(&JSDedicatedWorkerContext::s_info) ? jsCast<JSDedicatedWorkerContext*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
