/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLTableColElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLTableColElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLTableColElement* kit(WebCore::HTMLTableColElement* obj)
{
    return WEBKIT_DOM_HTML_TABLE_COL_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLTableColElement* core(WebKitDOMHTMLTableColElement* request)
{
    return request ? static_cast<WebCore::HTMLTableColElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLTableColElement* wrapHTMLTableColElement(WebCore::HTMLTableColElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_TABLE_COL_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_TABLE_COL_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLTableColElement, webkit_dom_html_table_col_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALIGN,
    PROP_CH,
    PROP_CH_OFF,
    PROP_SPAN,
    PROP_V_ALIGN,
    PROP_WIDTH,
};

static void webkit_dom_html_table_col_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableColElement* self = WEBKIT_DOM_HTML_TABLE_COL_ELEMENT(object);
    WebCore::HTMLTableColElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH: {
        coreSelf->setAttribute(WebCore::HTMLNames::charAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH_OFF: {
        coreSelf->setAttribute(WebCore::HTMLNames::charoffAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SPAN: {
        coreSelf->setSpan((g_value_get_long(value)));
        break;
    }
    case PROP_V_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::valignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_col_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableColElement* self = WEBKIT_DOM_HTML_TABLE_COL_ELEMENT(object);
    WebCore::HTMLTableColElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_CH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charAttr)));
        break;
    }
    case PROP_CH_OFF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charoffAttr)));
        break;
    }
    case PROP_SPAN: {
        g_value_set_long(value, coreSelf->span());
        break;
    }
    case PROP_V_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valignAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_col_element_class_init(WebKitDOMHTMLTableColElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_table_col_element_set_property;
    gobjectClass->get_property = webkit_dom_html_table_col_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_table_col_element_align", /* short description */
                                                           "read-write  gchar* HTMLTableColElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH,
                                    g_param_spec_string("ch", /* name */
                                                           "html_table_col_element_ch", /* short description */
                                                           "read-write  gchar* HTMLTableColElement.ch", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH_OFF,
                                    g_param_spec_string("ch-off", /* name */
                                                           "html_table_col_element_ch-off", /* short description */
                                                           "read-write  gchar* HTMLTableColElement.ch-off", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SPAN,
                                    g_param_spec_long("span", /* name */
                                                           "html_table_col_element_span", /* short description */
                                                           "read-write  glong HTMLTableColElement.span", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_V_ALIGN,
                                    g_param_spec_string("v-align", /* name */
                                                           "html_table_col_element_v-align", /* short description */
                                                           "read-write  gchar* HTMLTableColElement.v-align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_table_col_element_width", /* short description */
                                                           "read-write  gchar* HTMLTableColElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_table_col_element_init(WebKitDOMHTMLTableColElement* request)
{
}

gchar*
webkit_dom_html_table_col_element_get_align(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_table_col_element_set_align(WebKitDOMHTMLTableColElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_col_element_get_ch(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charAttr));
    return result;
}

void
webkit_dom_html_table_col_element_set_ch(WebKitDOMHTMLTableColElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charAttr, convertedValue);
}

gchar*
webkit_dom_html_table_col_element_get_ch_off(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}

void
webkit_dom_html_table_col_element_set_ch_off(WebKitDOMHTMLTableColElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charoffAttr, convertedValue);
}

glong
webkit_dom_html_table_col_element_get_span(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    glong result = item->span();
    return result;
}

void
webkit_dom_html_table_col_element_set_span(WebKitDOMHTMLTableColElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    item->setSpan(value);
}

gchar*
webkit_dom_html_table_col_element_get_v_align(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}

void
webkit_dom_html_table_col_element_set_v_align(WebKitDOMHTMLTableColElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_col_element_get_width(WebKitDOMHTMLTableColElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self), 0);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_table_col_element_set_width(WebKitDOMHTMLTableColElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_COL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableColElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

