/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLPropertiesCollection.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMStringListPrivate.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLPropertiesCollectionPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMPropertyNodeListPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(MICRODATA)

namespace WebKit {

WebKitDOMHTMLPropertiesCollection* kit(WebCore::HTMLPropertiesCollection* obj)
{
    return WEBKIT_DOM_HTML_PROPERTIES_COLLECTION(kit(static_cast<WebCore::HTMLCollection*>(obj)));
}

WebCore::HTMLPropertiesCollection* core(WebKitDOMHTMLPropertiesCollection* request)
{
    return request ? static_cast<WebCore::HTMLPropertiesCollection*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLPropertiesCollection* wrapHTMLPropertiesCollection(WebCore::HTMLPropertiesCollection* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_PROPERTIES_COLLECTION(g_object_new(WEBKIT_TYPE_DOM_HTML_PROPERTIES_COLLECTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(MICRODATA)

G_DEFINE_TYPE(WebKitDOMHTMLPropertiesCollection, webkit_dom_html_properties_collection, WEBKIT_TYPE_DOM_HTML_COLLECTION)

enum {
    PROP_0,
    PROP_LENGTH,
    PROP_NAMES,
};

static void webkit_dom_html_properties_collection_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(MICRODATA)
    WebKitDOMHTMLPropertiesCollection* self = WEBKIT_DOM_HTML_PROPERTIES_COLLECTION(object);
    WebCore::HTMLPropertiesCollection* coreSelf = WebKit::core(self);
#endif // ENABLE(MICRODATA)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(MICRODATA)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    case PROP_NAMES: {
#if ENABLE(MICRODATA)
        RefPtr<WebCore::DOMStringList> ptr = coreSelf->names();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_properties_collection_class_init(WebKitDOMHTMLPropertiesCollectionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_html_properties_collection_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "html_properties_collection_length", /* short description */
                                                           "read-only  gulong HTMLPropertiesCollection.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAMES,
                                    g_param_spec_object("names", /* name */
                                                           "html_properties_collection_names", /* short description */
                                                           "read-only  WebKitDOMDOMStringList* HTMLPropertiesCollection.names", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_STRING_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_properties_collection_init(WebKitDOMHTMLPropertiesCollection* request)
{
}

WebKitDOMNode*
webkit_dom_html_properties_collection_item(WebKitDOMHTMLPropertiesCollection* self, gulong index)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PROPERTIES_COLLECTION(self), 0);
    WebCore::HTMLPropertiesCollection* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

WebKitDOMPropertyNodeList*
webkit_dom_html_properties_collection_named_item(WebKitDOMHTMLPropertiesCollection* self, const gchar* name)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PROPERTIES_COLLECTION(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::HTMLPropertiesCollection* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::PropertyNodeList> gobjectResult = WTF::getPtr(item->propertyNodeList(convertedName));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

gulong
webkit_dom_html_properties_collection_get_length(WebKitDOMHTMLPropertiesCollection* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PROPERTIES_COLLECTION(self), 0);
    WebCore::HTMLPropertiesCollection* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return static_cast<gulong>(0);
#endif /* ENABLE(MICRODATA) */
}

WebKitDOMDOMStringList*
webkit_dom_html_properties_collection_get_names(WebKitDOMHTMLPropertiesCollection* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PROPERTIES_COLLECTION(self), 0);
    WebCore::HTMLPropertiesCollection* item = WebKit::core(self);
    RefPtr<WebCore::DOMStringList> gobjectResult = WTF::getPtr(item->names());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

