/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLKeygenElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLKeygenElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLKeygenElement* kit(WebCore::HTMLKeygenElement* obj)
{
    return WEBKIT_DOM_HTML_KEYGEN_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLKeygenElement* core(WebKitDOMHTMLKeygenElement* request)
{
    return request ? static_cast<WebCore::HTMLKeygenElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLKeygenElement* wrapHTMLKeygenElement(WebCore::HTMLKeygenElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_KEYGEN_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_KEYGEN_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLKeygenElement, webkit_dom_html_keygen_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_AUTOFOCUS,
    PROP_CHALLENGE,
    PROP_DISABLED,
    PROP_FORM,
    PROP_KEYTYPE,
    PROP_NAME,
    PROP_TYPE,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_LABELS,
};

static void webkit_dom_html_keygen_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLKeygenElement* self = WEBKIT_DOM_HTML_KEYGEN_ELEMENT(object);
    WebCore::HTMLKeygenElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_CHALLENGE: {
        coreSelf->setAttribute(WebCore::HTMLNames::challengeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_KEYTYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::keytypeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_keygen_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLKeygenElement* self = WEBKIT_DOM_HTML_KEYGEN_ELEMENT(object);
    WebCore::HTMLKeygenElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
        break;
    }
    case PROP_CHALLENGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::challengeAttr)));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_KEYTYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::keytypeAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_LABELS: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->labels();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_keygen_element_class_init(WebKitDOMHTMLKeygenElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_keygen_element_set_property;
    gobjectClass->get_property = webkit_dom_html_keygen_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOFOCUS,
                                    g_param_spec_boolean("autofocus", /* name */
                                                           "html_keygen_element_autofocus", /* short description */
                                                           "read-write  gboolean HTMLKeygenElement.autofocus", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHALLENGE,
                                    g_param_spec_string("challenge", /* name */
                                                           "html_keygen_element_challenge", /* short description */
                                                           "read-write  gchar* HTMLKeygenElement.challenge", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_keygen_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLKeygenElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_keygen_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLKeygenElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_KEYTYPE,
                                    g_param_spec_string("keytype", /* name */
                                                           "html_keygen_element_keytype", /* short description */
                                                           "read-write  gchar* HTMLKeygenElement.keytype", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_keygen_element_name", /* short description */
                                                           "read-write  gchar* HTMLKeygenElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_keygen_element_type", /* short description */
                                                           "read-only  gchar* HTMLKeygenElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_keygen_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLKeygenElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_keygen_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLKeygenElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_keygen_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLKeygenElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABELS,
                                    g_param_spec_object("labels", /* name */
                                                           "html_keygen_element_labels", /* short description */
                                                           "read-only  WebKitDOMNodeList* HTMLKeygenElement.labels", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_keygen_element_init(WebKitDOMHTMLKeygenElement* request)
{
}

gboolean
webkit_dom_html_keygen_element_check_validity(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), FALSE);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_keygen_element_set_custom_validity(WebKitDOMHTMLKeygenElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

gboolean
webkit_dom_html_keygen_element_get_autofocus(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), FALSE);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autofocusAttr);
    return result;
}

void
webkit_dom_html_keygen_element_set_autofocus(WebKitDOMHTMLKeygenElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value);
}

gchar*
webkit_dom_html_keygen_element_get_challenge(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::challengeAttr));
    return result;
}

void
webkit_dom_html_keygen_element_set_challenge(WebKitDOMHTMLKeygenElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::challengeAttr, convertedValue);
}

gboolean
webkit_dom_html_keygen_element_get_disabled(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), FALSE);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_keygen_element_set_disabled(WebKitDOMHTMLKeygenElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_keygen_element_get_form(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_keygen_element_get_keytype(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::keytypeAttr));
    return result;
}

void
webkit_dom_html_keygen_element_set_keytype(WebKitDOMHTMLKeygenElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::keytypeAttr, convertedValue);
}

gchar*
webkit_dom_html_keygen_element_get_name(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_keygen_element_set_name(WebKitDOMHTMLKeygenElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gboolean
webkit_dom_html_keygen_element_get_will_validate(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), FALSE);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_keygen_element_get_validity(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_keygen_element_get_validation_message(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMNodeList*
webkit_dom_html_keygen_element_get_labels(WebKitDOMHTMLKeygenElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_KEYGEN_ELEMENT(self), 0);
    WebCore::HTMLKeygenElement* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->labels());
    return WebKit::kit(gobjectResult.get());
}

