/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLDivElement.h"

#include "HTMLDivElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDivElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDivElementAlign), (intptr_t)setJSHTMLDivElementAlign, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDivElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDivElementTable = { 5, 3, JSHTMLDivElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLDivElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDivElementConstructorTable = { 1, 0, JSHTMLDivElementConstructorTableValues, 0 };
const ClassInfo JSHTMLDivElementConstructor::s_info = { "HTMLDivElementConstructor", &Base::s_info, &JSHTMLDivElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLDivElementConstructor) };

JSHTMLDivElementConstructor::JSHTMLDivElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLDivElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLDivElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLDivElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDivElementConstructor, JSDOMWrapper>(exec, &JSHTMLDivElementConstructorTable, jsCast<JSHTMLDivElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLDivElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDivElementConstructor, JSDOMWrapper>(exec, &JSHTMLDivElementConstructorTable, jsCast<JSHTMLDivElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDivElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDivElementPrototypeTable = { 1, 0, JSHTMLDivElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLDivElementPrototype::s_info = { "HTMLDivElementPrototype", &Base::s_info, &JSHTMLDivElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLDivElementPrototype) };

JSObject* JSHTMLDivElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDivElement>(exec, globalObject);
}

const ClassInfo JSHTMLDivElement::s_info = { "HTMLDivElement", &Base::s_info, &JSHTMLDivElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLDivElement) };

JSHTMLDivElement::JSHTMLDivElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDivElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLDivElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLDivElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLDivElementPrototype::create(exec->globalData(), globalObject, JSHTMLDivElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDivElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDivElement* thisObject = jsCast<JSHTMLDivElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLDivElement, Base>(exec, &JSHTMLDivElementTable, thisObject, propertyName, slot);
}

bool JSHTMLDivElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDivElement* thisObject = jsCast<JSHTMLDivElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLDivElement, Base>(exec, &JSHTMLDivElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLDivElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDivElement* castedThis = jsCast<JSHTMLDivElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDivElement* impl = static_cast<HTMLDivElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLDivElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDivElement* domObject = jsCast<JSHTMLDivElement*>(asObject(slotBase));
    return JSHTMLDivElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLDivElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLDivElement* thisObject = jsCast<JSHTMLDivElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLDivElement, Base>(exec, propertyName, value, &JSHTMLDivElementTable, thisObject, slot);
}

void setJSHTMLDivElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDivElement* castedThis = jsCast<JSHTMLDivElement*>(thisObject);
    HTMLDivElement* impl = static_cast<HTMLDivElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLDivElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDivElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
