/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPluginArray.h"

#include "DOMPlugin.h"
#include "DOMPluginArray.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMPlugin.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMPluginArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginArrayTable = { 5, 3, JSDOMPluginArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMPluginArrayConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginArrayConstructorTable = { 1, 0, JSDOMPluginArrayConstructorTableValues, 0 };
const ClassInfo JSDOMPluginArrayConstructor::s_info = { "PluginArrayConstructor", &Base::s_info, &JSDOMPluginArrayConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMPluginArrayConstructor) };

JSDOMPluginArrayConstructor::JSDOMPluginArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMPluginArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMPluginArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMPluginArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMPluginArrayConstructor, JSDOMWrapper>(exec, &JSDOMPluginArrayConstructorTable, jsCast<JSDOMPluginArrayConstructor*>(cell), propertyName, slot);
}

bool JSDOMPluginArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMPluginArrayConstructor, JSDOMWrapper>(exec, &JSDOMPluginArrayConstructorTable, jsCast<JSDOMPluginArrayConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMPluginArrayPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionNamedItem), (intptr_t)1, NoIntrinsic },
    { "refresh", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionRefresh), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginArrayPrototypeTable = { 8, 7, JSDOMPluginArrayPrototypeTableValues, 0 };
const ClassInfo JSDOMPluginArrayPrototype::s_info = { "PluginArrayPrototype", &Base::s_info, &JSDOMPluginArrayPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMPluginArrayPrototype) };

JSObject* JSDOMPluginArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPluginArray>(exec, globalObject);
}

bool JSDOMPluginArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPluginArrayPrototype* thisObject = jsCast<JSDOMPluginArrayPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, thisObject, propertyName, slot);
}

bool JSDOMPluginArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPluginArrayPrototype* thisObject = jsCast<JSDOMPluginArrayPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDOMPluginArray::s_info = { "PluginArray", &Base::s_info, &JSDOMPluginArrayTable, 0 , CREATE_METHOD_TABLE(JSDOMPluginArray) };

JSDOMPluginArray::JSDOMPluginArray(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMPluginArray> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMPluginArray::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMPluginArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMPluginArrayPrototype::create(exec->globalData(), globalObject, JSDOMPluginArrayPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSDOMPluginArray::destroy(JSC::JSCell* cell)
{
    JSDOMPluginArray* thisObject = static_cast<JSDOMPluginArray*>(cell);
    thisObject->JSDOMPluginArray::~JSDOMPluginArray();
}

JSDOMPluginArray::~JSDOMPluginArray()
{
    releaseImplIfNotNull();
}

bool JSDOMPluginArray::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPluginArray* thisObject = jsCast<JSDOMPluginArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSDOMPluginArray>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMPluginArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, thisObject, propertyName, slot);
}

bool JSDOMPluginArray::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPluginArray* thisObject = jsCast<JSDOMPluginArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSDOMPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMPluginArray*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, thisObject, propertyName, descriptor);
}

bool JSDOMPluginArray::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSDOMPluginArray* thisObject = jsCast<JSDOMPluginArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<DOMPluginArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsDOMPluginArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPluginArray* castedThis = jsCast<JSDOMPluginArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPluginArray* impl = static_cast<DOMPluginArray*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsDOMPluginArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPluginArray* domObject = jsCast<JSDOMPluginArray*>(asObject(slotBase));
    return JSDOMPluginArray::getConstructor(exec, domObject->globalObject());
}

void JSDOMPluginArray::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSDOMPluginArray* thisObject = jsCast<JSDOMPluginArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<DOMPluginArray*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSDOMPluginArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPluginArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = jsCast<JSDOMPluginArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPluginArray::s_info);
    DOMPluginArray* impl = static_cast<DOMPluginArray*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = jsCast<JSDOMPluginArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPluginArray::s_info);
    DOMPluginArray* impl = static_cast<DOMPluginArray*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->namedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionRefresh(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = jsCast<JSDOMPluginArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPluginArray::s_info);
    DOMPluginArray* impl = static_cast<DOMPluginArray*>(castedThis->impl());
    bool reload(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->refresh(reload);
    return JSValue::encode(jsUndefined());
}


JSValue JSDOMPluginArray::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMPluginArray* thisObj = jsCast<JSDOMPluginArray*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<DOMPluginArray*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSDOMPluginArray* jsDOMPluginArray)
{
    if (jsDOMPluginArray->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMPluginArrayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMPluginArray* jsDOMPluginArray = jsCast<JSDOMPluginArray*>(handle.get().asCell());
    if (!isObservable(jsDOMPluginArray))
        return false;
    Frame* root = jsDOMPluginArray->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSDOMPluginArrayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMPluginArray* jsDOMPluginArray = jsCast<JSDOMPluginArray*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMPluginArray->impl(), jsDOMPluginArray);
    jsDOMPluginArray->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMPluginArray* impl)
{
    return wrap<JSDOMPluginArray>(exec, globalObject, impl);
}

DOMPluginArray* toDOMPluginArray(JSC::JSValue value)
{
    return value.inherits(&JSDOMPluginArray::s_info) ? jsCast<JSDOMPluginArray*>(asObject(value))->impl() : 0;
}

}
