/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* methods;
	ValaList* fields;
	ValaList* constants;
	ValaList* properties;
	ValaList* signals;
	ValaList* virtuals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base, ValaMethod* m);
static ValaList* vala_interface_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_field (ValaSymbol* base, ValaField* f);
static void vala_interface_real_add_constant (ValaSymbol* base, ValaConstant* c);
static void vala_interface_real_add_property (ValaSymbol* base, ValaProperty* prop);
static ValaList* vala_interface_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_interface_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_interface_real_get_signals (ValaObjectTypeSymbol* base);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_interface_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_interface_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_interface_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_interface_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_interface_get_classes (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_interface_get_structs (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_interface_get_enums (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_interface_get_delegates (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface* vala_interface_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaInterface* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaInterface* vala_interface_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void vala_interface_add_prerequisite (ValaInterface* self, ValaDataType* type) {
	ValaList* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = type;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void vala_interface_prepend_prerequisite (ValaInterface* self, ValaDataType* type) {
	ValaList* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = type;
	vala_list_insert (_tmp0_, 0, _tmp1_);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_interface_get_prerequisites (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void vala_interface_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaInterface * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp5_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	gboolean _tmp24_ = FALSE;
	ValaMethod* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaList* _tmp46_;
	ValaMethod* _tmp47_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	ValaMethod* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	ValaMethod* _tmp53_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMethod* _tmp4_;
		_tmp1_ = m;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "construction methods may only be declared within classes and structs");
		_tmp4_ = m;
		vala_code_node_set_error ((ValaCodeNode*) _tmp4_, TRUE);
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_method_get_binding (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaMethod* _tmp8_;
		ValaObjectType* _tmp9_;
		ValaObjectType* _tmp10_;
		ValaParameter* _tmp11_;
		ValaParameter* _tmp12_;
		ValaMethod* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		ValaMethod* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaMethod* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp8_ = m;
		_tmp9_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		vala_method_set_this_parameter (_tmp8_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
		_tmp13_ = m;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = m;
		_tmp17_ = vala_method_get_this_parameter (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = m;
		_tmp22_ = vala_method_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	}
	_tmp25_ = m;
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_VOID_TYPE)) {
		ValaMethod* _tmp28_;
		ValaList* _tmp29_;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp28_ = m;
		_tmp29_ = vala_method_get_postconditions (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp24_ = _tmp32_ > 0;
		_vala_iterable_unref0 (_tmp30_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaMethod* _tmp33_;
		ValaMethod* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		ValaMethod* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		_tmp33_ = m;
		_tmp34_ = m;
		_tmp35_ = vala_callable_get_return_type ((ValaCallable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_data_type_copy (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_local_variable_new (_tmp38_, "result", NULL, _tmp40_);
		_tmp42_ = _tmp41_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp33_, _tmp42_);
		_vala_code_node_unref0 (_tmp42_);
		_vala_code_node_unref0 (_tmp38_);
		_tmp43_ = m;
		_tmp44_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp43_);
		_tmp45_ = _tmp44_;
		vala_local_variable_set_is_result (_tmp45_, TRUE);
	}
	_tmp46_ = self->priv->methods;
	_tmp47_ = m;
	vala_collection_add ((ValaCollection*) _tmp46_, _tmp47_);
	_tmp48_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = m;
	_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = m;
	vala_scope_add (_tmp49_, _tmp52_, (ValaSymbol*) _tmp53_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_interface_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this interface. The field
 * must be private and static.
 *
 * @param f a field
 */
static void vala_interface_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaField* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaField* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaField* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = f;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = f;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = f;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_interface_get_fields (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this interface.
 *
 * @param c a constant
 */
static void vala_interface_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_interface_get_constants (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void vala_interface_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaInterface * self;
	ValaProperty* _tmp0_;
	ValaField* _tmp1_;
	ValaField* _tmp2_;
	ValaList* _tmp7_;
	ValaProperty* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaProperty* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaProperty* _tmp14_;
	ValaProperty* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* _tmp18_;
	ValaParameter* _tmp19_;
	ValaProperty* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	ValaProperty* _tmp23_;
	ValaParameter* _tmp24_;
	ValaParameter* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	ValaProperty* _tmp28_;
	ValaParameter* _tmp29_;
	ValaParameter* _tmp30_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp1_ = vala_property_get_field (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaProperty* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaProperty* _tmp6_;
		_tmp3_ = prop;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp3_);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "automatic properties are not allowed in interfaces");
		_tmp6_ = prop;
		vala_code_node_set_error ((ValaCodeNode*) _tmp6_, TRUE);
		return;
	}
	_tmp7_ = self->priv->properties;
	_tmp8_ = prop;
	vala_collection_add ((ValaCollection*) _tmp7_, _tmp8_);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = prop;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = prop;
	vala_scope_add (_tmp10_, _tmp13_, (ValaSymbol*) _tmp14_);
	_tmp15_ = prop;
	_tmp16_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_parameter_new ("this", (ValaDataType*) _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	vala_property_set_this_parameter (_tmp15_, _tmp19_);
	_vala_code_node_unref0 (_tmp19_);
	_vala_code_node_unref0 (_tmp17_);
	_tmp20_ = prop;
	_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = prop;
	_tmp24_ = vala_property_get_this_parameter (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_symbol_get_name ((ValaSymbol*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = prop;
	_tmp29_ = vala_property_get_this_parameter (_tmp28_);
	_tmp30_ = _tmp29_;
	vala_scope_add (_tmp22_, _tmp27_, (ValaSymbol*) _tmp30_);
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_interface_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified signal as a member to this interface.
 *
 * @param sig a signal
 */
static void vala_interface_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaSignal* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaSignal* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSignal* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	_tmp1_ = sig;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = sig;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sig;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_interface_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaInterface * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaInterface*) base;
	_tmp0_ = self->priv->signals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static ValaList* vala_interface_real_get_virtuals (ValaInterface* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList* vala_interface_get_virtuals (ValaInterface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_interface_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaClass* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaClass* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaClass* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = cl;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cl;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cl;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_interface_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaStruct* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaStruct* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaStruct* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = st;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = st;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = st;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_interface_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaEnum* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaEnum* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaEnum* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = en;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = en;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = en;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_interface_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaInterface * self;
	ValaList* _tmp0_;
	ValaDelegate* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaDelegate* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaDelegate* _tmp7_;
	self = (ValaInterface*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = d;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = d;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = d;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static void vala_interface_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInterface * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_interface (_tmp0_, self);
}


static void vala_interface_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp13_;
		gint _p_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _p_index = 0;
		_tmp13_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp13_;
		_tmp14_ = _p_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaTypeParameter* _tmp23_;
			ValaCodeVisitor* _tmp24_;
			_tmp17_ = _p_index;
			_p_index = _tmp17_ + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = _p_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			p = (ValaTypeParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, _tmp24_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _en_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _en_index = 0;
		_tmp25_ = self->priv->enums;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_en_list = _tmp26_;
		_tmp27_ = _en_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_en_size = _tmp29_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaEnum* en = NULL;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaEnum* _tmp36_;
			ValaCodeVisitor* _tmp37_;
			_tmp30_ = _en_index;
			_en_index = _tmp30_ + 1;
			_tmp31_ = _en_index;
			_tmp32_ = _en_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _en_list;
			_tmp34_ = _en_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			en = (ValaEnum*) _tmp35_;
			_tmp36_ = en;
			_tmp37_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, _tmp37_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _m_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _m_index = 0;
		_tmp38_ = self->priv->methods;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_m_list = _tmp39_;
		_tmp40_ = _m_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_m_size = _tmp42_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaMethod* m = NULL;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_;
			ValaMethod* _tmp49_;
			ValaCodeVisitor* _tmp50_;
			_tmp43_ = _m_index;
			_m_index = _tmp43_ + 1;
			_tmp44_ = _m_index;
			_tmp45_ = _m_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _m_list;
			_tmp47_ = _m_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			m = (ValaMethod*) _tmp48_;
			_tmp49_ = m;
			_tmp50_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, _tmp50_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		gint _f_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _f_index = 0;
		_tmp51_ = self->priv->fields;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_f_list = _tmp52_;
		_tmp53_ = _f_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_f_size = _tmp55_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaField* f = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaField* _tmp62_;
			ValaCodeVisitor* _tmp63_;
			_tmp56_ = _f_index;
			_f_index = _tmp56_ + 1;
			_tmp57_ = _f_index;
			_tmp58_ = _f_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _f_list;
			_tmp60_ = _f_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			f = (ValaField*) _tmp61_;
			_tmp62_ = f;
			_tmp63_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp62_, _tmp63_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		gint _c_size = 0;
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _c_index = 0;
		_tmp64_ = self->priv->constants;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_c_list = _tmp65_;
		_tmp66_ = _c_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_c_size = _tmp68_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			ValaConstant* c = NULL;
			ValaList* _tmp72_;
			gint _tmp73_;
			gpointer _tmp74_;
			ValaConstant* _tmp75_;
			ValaCodeVisitor* _tmp76_;
			_tmp69_ = _c_index;
			_c_index = _tmp69_ + 1;
			_tmp70_ = _c_index;
			_tmp71_ = _c_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _c_list;
			_tmp73_ = _c_index;
			_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
			c = (ValaConstant*) _tmp74_;
			_tmp75_ = c;
			_tmp76_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp75_, _tmp76_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		gint _prop_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _prop_index = 0;
		_tmp77_ = self->priv->properties;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_prop_list = _tmp78_;
		_tmp79_ = _prop_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_prop_size = _tmp81_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaProperty* prop = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaProperty* _tmp88_;
			ValaCodeVisitor* _tmp89_;
			_tmp82_ = _prop_index;
			_prop_index = _tmp82_ + 1;
			_tmp83_ = _prop_index;
			_tmp84_ = _prop_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _prop_list;
			_tmp86_ = _prop_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			prop = (ValaProperty*) _tmp87_;
			_tmp88_ = prop;
			_tmp89_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, _tmp89_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _sig_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _sig_index = 0;
		_tmp90_ = self->priv->signals;
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_sig_list = _tmp91_;
		_tmp92_ = _sig_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_sig_size = _tmp94_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			ValaSignal* sig = NULL;
			ValaList* _tmp98_;
			gint _tmp99_;
			gpointer _tmp100_;
			ValaSignal* _tmp101_;
			ValaCodeVisitor* _tmp102_;
			_tmp95_ = _sig_index;
			_sig_index = _tmp95_ + 1;
			_tmp96_ = _sig_index;
			_tmp97_ = _sig_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _sig_list;
			_tmp99_ = _sig_index;
			_tmp100_ = vala_list_get (_tmp98_, _tmp99_);
			sig = (ValaSignal*) _tmp100_;
			_tmp101_ = sig;
			_tmp102_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, _tmp102_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp103_;
		ValaList* _tmp104_;
		gint _cl_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _cl_index = 0;
		_tmp103_ = self->priv->classes;
		_tmp104_ = _vala_iterable_ref0 (_tmp103_);
		_cl_list = _tmp104_;
		_tmp105_ = _cl_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_cl_size = _tmp107_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaClass* cl = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaClass* _tmp114_;
			ValaCodeVisitor* _tmp115_;
			_tmp108_ = _cl_index;
			_cl_index = _tmp108_ + 1;
			_tmp109_ = _cl_index;
			_tmp110_ = _cl_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _cl_list;
			_tmp112_ = _cl_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			cl = (ValaClass*) _tmp113_;
			_tmp114_ = cl;
			_tmp115_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp114_, _tmp115_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp116_;
		ValaList* _tmp117_;
		gint _st_size = 0;
		ValaList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _st_index = 0;
		_tmp116_ = self->priv->structs;
		_tmp117_ = _vala_iterable_ref0 (_tmp116_);
		_st_list = _tmp117_;
		_tmp118_ = _st_list;
		_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_st_size = _tmp120_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp121_;
			gint _tmp122_;
			gint _tmp123_;
			ValaStruct* st = NULL;
			ValaList* _tmp124_;
			gint _tmp125_;
			gpointer _tmp126_;
			ValaStruct* _tmp127_;
			ValaCodeVisitor* _tmp128_;
			_tmp121_ = _st_index;
			_st_index = _tmp121_ + 1;
			_tmp122_ = _st_index;
			_tmp123_ = _st_size;
			if (!(_tmp122_ < _tmp123_)) {
				break;
			}
			_tmp124_ = _st_list;
			_tmp125_ = _st_index;
			_tmp126_ = vala_list_get (_tmp124_, _tmp125_);
			st = (ValaStruct*) _tmp126_;
			_tmp127_ = st;
			_tmp128_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp127_, _tmp128_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp129_;
		ValaList* _tmp130_;
		gint _d_size = 0;
		ValaList* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		gint _d_index = 0;
		_tmp129_ = self->priv->delegates;
		_tmp130_ = _vala_iterable_ref0 (_tmp129_);
		_d_list = _tmp130_;
		_tmp131_ = _d_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_d_size = _tmp133_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			ValaDelegate* d = NULL;
			ValaList* _tmp137_;
			gint _tmp138_;
			gpointer _tmp139_;
			ValaDelegate* _tmp140_;
			ValaCodeVisitor* _tmp141_;
			_tmp134_ = _d_index;
			_d_index = _tmp134_ + 1;
			_tmp135_ = _d_index;
			_tmp136_ = _d_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _d_list;
			_tmp138_ = _d_index;
			_tmp139_ = vala_list_get (_tmp137_, _tmp138_);
			d = (ValaDelegate*) _tmp139_;
			_tmp140_ = d;
			_tmp141_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp140_, _tmp141_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base) {
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaInterface * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == _tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _prerequisite_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _prerequisite_index = 0;
		_tmp1_ = self->priv->prerequisites;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_prerequisite_list = _tmp2_;
		_tmp3_ = _prerequisite_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_prerequisite_size = _tmp5_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_tmp6_ = _prerequisite_index;
			_prerequisite_index = _tmp6_ + 1;
			_tmp7_ = _prerequisite_index;
			_tmp8_ = _prerequisite_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _prerequisite_list;
			_tmp10_ = _prerequisite_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			prerequisite = (ValaDataType*) _tmp11_;
			_tmp13_ = prerequisite;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				gboolean _tmp20_;
				_tmp16_ = prerequisite;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp19_);
				_tmp12_ = _tmp20_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void vala_interface_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				ValaDataType* _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = old_type;
				_tmp11_ = _tmp9_ == _tmp10_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp11_) {
					ValaList* _tmp12_;
					gint _tmp13_;
					ValaDataType* _tmp14_;
					ValaDataType* _tmp15_;
					_tmp12_ = self->priv->prerequisites;
					_tmp13_ = i;
					_tmp14_ = new_type;
					vala_list_set (_tmp12_, _tmp13_, _tmp14_);
					_tmp15_ = new_type;
					vala_code_node_set_parent_node ((ValaCodeNode*) _tmp15_, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_interface_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaClass* prereq_class = NULL;
	ValaMap* positions = NULL;
	GHashFunc _tmp258_;
	GEqualFunc _tmp259_;
	GEqualFunc _tmp260_;
	ValaHashMap* _tmp261_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp339_;
	ValaCodeContext* _tmp362_;
	ValaSemanticAnalyzer* _tmp363_;
	ValaSemanticAnalyzer* _tmp364_;
	ValaSourceFile* _tmp365_;
	ValaCodeContext* _tmp366_;
	ValaSemanticAnalyzer* _tmp367_;
	ValaSemanticAnalyzer* _tmp368_;
	ValaSymbol* _tmp369_;
	gboolean _tmp370_;
	gboolean _tmp371_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp28_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _prerequisite_reference_index = 0;
		_tmp28_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp28_;
		_tmp29_ = _prerequisite_reference_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_prerequisite_reference_size = _tmp31_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_;
			ValaCodeContext* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaDataType* _tmp41_;
			gboolean _tmp42_;
			_tmp32_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp32_ + 1;
			_tmp33_ = _prerequisite_reference_index;
			_tmp34_ = _prerequisite_reference_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _prerequisite_reference_list;
			_tmp36_ = _prerequisite_reference_index;
			_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
			prerequisite_reference = (ValaDataType*) _tmp37_;
			_tmp38_ = context;
			_tmp39_ = vala_code_context_get_analyzer (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = prerequisite_reference;
			_tmp42_ = vala_semantic_analyzer_is_type_accessible (_tmp40_, (ValaSymbol*) self, _tmp41_);
			if (!_tmp42_) {
				ValaSourceReference* _tmp43_;
				ValaSourceReference* _tmp44_;
				ValaDataType* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp44_ = _tmp43_;
				_tmp45_ = prerequisite_reference;
				_tmp46_ = vala_code_node_to_string ((ValaCodeNode*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp47_, _tmp49_);
				_tmp51_ = _tmp50_;
				vala_report_error (_tmp44_, _tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp52_;
		gint _prereq_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _prereq_index = 0;
		_tmp52_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp52_;
		_tmp53_ = _prereq_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_prereq_size = _tmp55_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaTypeSymbol* class_or_interface = NULL;
			ValaDataType* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaTypeSymbol* _tmp66_;
			ValaTypeSymbol* _tmp67_;
			ValaTypeSymbol* _tmp77_;
			_tmp56_ = _prereq_index;
			_prereq_index = _tmp56_ + 1;
			_tmp57_ = _prereq_index;
			_tmp58_ = _prereq_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _prereq_list;
			_tmp60_ = _prereq_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			prereq = (ValaDataType*) _tmp61_;
			_tmp62_ = prereq;
			_tmp63_ = vala_data_type_get_data_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_code_node_ref0 (_tmp64_);
			class_or_interface = _tmp65_;
			_tmp66_ = class_or_interface;
			if (_tmp66_ == NULL) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp67_ = class_or_interface;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = class_or_interface;
				_tmp73_ = vala_code_node_to_string ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strdup_printf ("Prerequisite `%s` of interface `%s` is not a class or interface", _tmp71_, _tmp74_);
				_tmp76_ = _tmp75_;
				vala_report_error (_tmp69_, _tmp76_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp71_);
				result = FALSE;
				_vala_code_node_unref0 (class_or_interface);
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp77_ = class_or_interface;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_CLASS)) {
				ValaClass* _tmp78_;
				ValaTypeSymbol* _tmp91_;
				ValaClass* _tmp92_;
				_tmp78_ = prereq_class;
				if (_tmp78_ != NULL) {
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					ValaTypeSymbol* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					ValaClass* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp82_ = _tmp81_;
					_tmp83_ = class_or_interface;
					_tmp84_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = prereq_class;
					_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp82_, _tmp85_, _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp80_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp85_);
					_g_free0 (_tmp82_);
					result = FALSE;
					_vala_code_node_unref0 (class_or_interface);
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp91_ = class_or_interface;
				_tmp92_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp92_;
			}
			_vala_code_node_unref0 (class_or_interface);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp93_;
		ValaList* _tmp94_;
		gint _type_size = 0;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _type_index = 0;
		_tmp93_ = self->priv->prerequisites;
		_tmp94_ = _vala_iterable_ref0 (_tmp93_);
		_type_list = _tmp94_;
		_tmp95_ = _type_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_type_size = _tmp97_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp98_;
			gint _tmp99_;
			gint _tmp100_;
			ValaDataType* type = NULL;
			ValaList* _tmp101_;
			gint _tmp102_;
			gpointer _tmp103_;
			ValaDataType* _tmp104_;
			ValaCodeContext* _tmp105_;
			_tmp98_ = _type_index;
			_type_index = _tmp98_ + 1;
			_tmp99_ = _type_index;
			_tmp100_ = _type_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _type_list;
			_tmp102_ = _type_index;
			_tmp103_ = vala_list_get (_tmp101_, _tmp102_);
			type = (ValaDataType*) _tmp103_;
			_tmp104_ = type;
			_tmp105_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp104_, _tmp105_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp106_;
		gint _p_size = 0;
		ValaList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _p_index = 0;
		_tmp106_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp106_;
		_tmp107_ = _p_list;
		_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_p_size = _tmp109_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp113_;
			gint _tmp114_;
			gpointer _tmp115_;
			ValaTypeParameter* _tmp116_;
			ValaCodeContext* _tmp117_;
			_tmp110_ = _p_index;
			_p_index = _tmp110_ + 1;
			_tmp111_ = _p_index;
			_tmp112_ = _p_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _p_list;
			_tmp114_ = _p_index;
			_tmp115_ = vala_list_get (_tmp113_, _tmp114_);
			p = (ValaTypeParameter*) _tmp115_;
			_tmp116_ = p;
			_tmp117_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp116_, _tmp117_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp118_;
		ValaList* _tmp119_;
		gint _en_size = 0;
		ValaList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gint _en_index = 0;
		_tmp118_ = self->priv->enums;
		_tmp119_ = _vala_iterable_ref0 (_tmp118_);
		_en_list = _tmp119_;
		_tmp120_ = _en_list;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		_en_size = _tmp122_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			ValaEnum* en = NULL;
			ValaList* _tmp126_;
			gint _tmp127_;
			gpointer _tmp128_;
			ValaEnum* _tmp129_;
			ValaCodeContext* _tmp130_;
			_tmp123_ = _en_index;
			_en_index = _tmp123_ + 1;
			_tmp124_ = _en_index;
			_tmp125_ = _en_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _en_list;
			_tmp127_ = _en_index;
			_tmp128_ = vala_list_get (_tmp126_, _tmp127_);
			en = (ValaEnum*) _tmp128_;
			_tmp129_ = en;
			_tmp130_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp129_, _tmp130_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp131_;
		ValaList* _tmp132_;
		gint _m_size = 0;
		ValaList* _tmp133_;
		gint _tmp134_;
		gint _tmp135_;
		gint _m_index = 0;
		_tmp131_ = self->priv->methods;
		_tmp132_ = _vala_iterable_ref0 (_tmp131_);
		_m_list = _tmp132_;
		_tmp133_ = _m_list;
		_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
		_tmp135_ = _tmp134_;
		_m_size = _tmp135_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			ValaMethod* m = NULL;
			ValaList* _tmp139_;
			gint _tmp140_;
			gpointer _tmp141_;
			ValaMethod* _tmp142_;
			ValaCodeContext* _tmp143_;
			gboolean _tmp144_ = FALSE;
			ValaMethod* _tmp145_;
			gboolean _tmp146_;
			gboolean _tmp147_;
			_tmp136_ = _m_index;
			_m_index = _tmp136_ + 1;
			_tmp137_ = _m_index;
			_tmp138_ = _m_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _m_list;
			_tmp140_ = _m_index;
			_tmp141_ = vala_list_get (_tmp139_, _tmp140_);
			m = (ValaMethod*) _tmp141_;
			_tmp142_ = m;
			_tmp143_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp142_, _tmp143_);
			_tmp145_ = m;
			_tmp146_ = vala_method_get_is_virtual (_tmp145_);
			_tmp147_ = _tmp146_;
			if (_tmp147_) {
				_tmp144_ = TRUE;
			} else {
				ValaMethod* _tmp148_;
				gboolean _tmp149_;
				gboolean _tmp150_;
				_tmp148_ = m;
				_tmp149_ = vala_method_get_is_abstract (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp144_ = _tmp150_;
			}
			if (_tmp144_) {
				ValaList* _tmp151_;
				ValaMethod* _tmp152_;
				_tmp151_ = self->priv->virtuals;
				_tmp152_ = m;
				vala_collection_add ((ValaCollection*) _tmp151_, (ValaSymbol*) _tmp152_);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp153_;
		ValaList* _tmp154_;
		gint _f_size = 0;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _f_index = 0;
		_tmp153_ = self->priv->fields;
		_tmp154_ = _vala_iterable_ref0 (_tmp153_);
		_f_list = _tmp154_;
		_tmp155_ = _f_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_f_size = _tmp157_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			ValaField* f = NULL;
			ValaList* _tmp161_;
			gint _tmp162_;
			gpointer _tmp163_;
			ValaField* _tmp164_;
			ValaCodeContext* _tmp165_;
			_tmp158_ = _f_index;
			_f_index = _tmp158_ + 1;
			_tmp159_ = _f_index;
			_tmp160_ = _f_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _f_list;
			_tmp162_ = _f_index;
			_tmp163_ = vala_list_get (_tmp161_, _tmp162_);
			f = (ValaField*) _tmp163_;
			_tmp164_ = f;
			_tmp165_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp164_, _tmp165_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp166_;
		ValaList* _tmp167_;
		gint _c_size = 0;
		ValaList* _tmp168_;
		gint _tmp169_;
		gint _tmp170_;
		gint _c_index = 0;
		_tmp166_ = self->priv->constants;
		_tmp167_ = _vala_iterable_ref0 (_tmp166_);
		_c_list = _tmp167_;
		_tmp168_ = _c_list;
		_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
		_tmp170_ = _tmp169_;
		_c_size = _tmp170_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			ValaConstant* c = NULL;
			ValaList* _tmp174_;
			gint _tmp175_;
			gpointer _tmp176_;
			ValaConstant* _tmp177_;
			ValaCodeContext* _tmp178_;
			_tmp171_ = _c_index;
			_c_index = _tmp171_ + 1;
			_tmp172_ = _c_index;
			_tmp173_ = _c_size;
			if (!(_tmp172_ < _tmp173_)) {
				break;
			}
			_tmp174_ = _c_list;
			_tmp175_ = _c_index;
			_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
			c = (ValaConstant*) _tmp176_;
			_tmp177_ = c;
			_tmp178_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp177_, _tmp178_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp179_;
		ValaList* _tmp180_;
		gint _sig_size = 0;
		ValaList* _tmp181_;
		gint _tmp182_;
		gint _tmp183_;
		gint _sig_index = 0;
		_tmp179_ = self->priv->signals;
		_tmp180_ = _vala_iterable_ref0 (_tmp179_);
		_sig_list = _tmp180_;
		_tmp181_ = _sig_list;
		_tmp182_ = vala_collection_get_size ((ValaCollection*) _tmp181_);
		_tmp183_ = _tmp182_;
		_sig_size = _tmp183_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			ValaSignal* sig = NULL;
			ValaList* _tmp187_;
			gint _tmp188_;
			gpointer _tmp189_;
			ValaSignal* _tmp190_;
			ValaCodeContext* _tmp191_;
			ValaSignal* _tmp192_;
			gboolean _tmp193_;
			gboolean _tmp194_;
			_tmp184_ = _sig_index;
			_sig_index = _tmp184_ + 1;
			_tmp185_ = _sig_index;
			_tmp186_ = _sig_size;
			if (!(_tmp185_ < _tmp186_)) {
				break;
			}
			_tmp187_ = _sig_list;
			_tmp188_ = _sig_index;
			_tmp189_ = vala_list_get (_tmp187_, _tmp188_);
			sig = (ValaSignal*) _tmp189_;
			_tmp190_ = sig;
			_tmp191_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, _tmp191_);
			_tmp192_ = sig;
			_tmp193_ = vala_signal_get_is_virtual (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_) {
				ValaList* _tmp195_;
				ValaSignal* _tmp196_;
				_tmp195_ = self->priv->virtuals;
				_tmp196_ = sig;
				vala_collection_add ((ValaCollection*) _tmp195_, (ValaSymbol*) _tmp196_);
			}
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp197_;
		ValaList* _tmp198_;
		gint _prop_size = 0;
		ValaList* _tmp199_;
		gint _tmp200_;
		gint _tmp201_;
		gint _prop_index = 0;
		_tmp197_ = self->priv->properties;
		_tmp198_ = _vala_iterable_ref0 (_tmp197_);
		_prop_list = _tmp198_;
		_tmp199_ = _prop_list;
		_tmp200_ = vala_collection_get_size ((ValaCollection*) _tmp199_);
		_tmp201_ = _tmp200_;
		_prop_size = _tmp201_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp202_;
			gint _tmp203_;
			gint _tmp204_;
			ValaProperty* prop = NULL;
			ValaList* _tmp205_;
			gint _tmp206_;
			gpointer _tmp207_;
			ValaProperty* _tmp208_;
			ValaCodeContext* _tmp209_;
			gboolean _tmp210_ = FALSE;
			ValaProperty* _tmp211_;
			gboolean _tmp212_;
			gboolean _tmp213_;
			_tmp202_ = _prop_index;
			_prop_index = _tmp202_ + 1;
			_tmp203_ = _prop_index;
			_tmp204_ = _prop_size;
			if (!(_tmp203_ < _tmp204_)) {
				break;
			}
			_tmp205_ = _prop_list;
			_tmp206_ = _prop_index;
			_tmp207_ = vala_list_get (_tmp205_, _tmp206_);
			prop = (ValaProperty*) _tmp207_;
			_tmp208_ = prop;
			_tmp209_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp208_, _tmp209_);
			_tmp211_ = prop;
			_tmp212_ = vala_property_get_is_virtual (_tmp211_);
			_tmp213_ = _tmp212_;
			if (_tmp213_) {
				_tmp210_ = TRUE;
			} else {
				ValaProperty* _tmp214_;
				gboolean _tmp215_;
				gboolean _tmp216_;
				_tmp214_ = prop;
				_tmp215_ = vala_property_get_is_abstract (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp210_ = _tmp216_;
			}
			if (_tmp210_) {
				ValaList* _tmp217_;
				ValaProperty* _tmp218_;
				_tmp217_ = self->priv->virtuals;
				_tmp218_ = prop;
				vala_collection_add ((ValaCollection*) _tmp217_, (ValaSymbol*) _tmp218_);
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp219_;
		ValaList* _tmp220_;
		gint _cl_size = 0;
		ValaList* _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		gint _cl_index = 0;
		_tmp219_ = self->priv->classes;
		_tmp220_ = _vala_iterable_ref0 (_tmp219_);
		_cl_list = _tmp220_;
		_tmp221_ = _cl_list;
		_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
		_tmp223_ = _tmp222_;
		_cl_size = _tmp223_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp224_;
			gint _tmp225_;
			gint _tmp226_;
			ValaClass* cl = NULL;
			ValaList* _tmp227_;
			gint _tmp228_;
			gpointer _tmp229_;
			ValaClass* _tmp230_;
			ValaCodeContext* _tmp231_;
			_tmp224_ = _cl_index;
			_cl_index = _tmp224_ + 1;
			_tmp225_ = _cl_index;
			_tmp226_ = _cl_size;
			if (!(_tmp225_ < _tmp226_)) {
				break;
			}
			_tmp227_ = _cl_list;
			_tmp228_ = _cl_index;
			_tmp229_ = vala_list_get (_tmp227_, _tmp228_);
			cl = (ValaClass*) _tmp229_;
			_tmp230_ = cl;
			_tmp231_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp230_, _tmp231_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp232_;
		ValaList* _tmp233_;
		gint _st_size = 0;
		ValaList* _tmp234_;
		gint _tmp235_;
		gint _tmp236_;
		gint _st_index = 0;
		_tmp232_ = self->priv->structs;
		_tmp233_ = _vala_iterable_ref0 (_tmp232_);
		_st_list = _tmp233_;
		_tmp234_ = _st_list;
		_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
		_tmp236_ = _tmp235_;
		_st_size = _tmp236_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp237_;
			gint _tmp238_;
			gint _tmp239_;
			ValaStruct* st = NULL;
			ValaList* _tmp240_;
			gint _tmp241_;
			gpointer _tmp242_;
			ValaStruct* _tmp243_;
			ValaCodeContext* _tmp244_;
			_tmp237_ = _st_index;
			_st_index = _tmp237_ + 1;
			_tmp238_ = _st_index;
			_tmp239_ = _st_size;
			if (!(_tmp238_ < _tmp239_)) {
				break;
			}
			_tmp240_ = _st_list;
			_tmp241_ = _st_index;
			_tmp242_ = vala_list_get (_tmp240_, _tmp241_);
			st = (ValaStruct*) _tmp242_;
			_tmp243_ = st;
			_tmp244_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp243_, _tmp244_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp245_;
		ValaList* _tmp246_;
		gint _d_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _d_index = 0;
		_tmp245_ = self->priv->delegates;
		_tmp246_ = _vala_iterable_ref0 (_tmp245_);
		_d_list = _tmp246_;
		_tmp247_ = _d_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_d_size = _tmp249_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			gint _tmp252_;
			ValaDelegate* d = NULL;
			ValaList* _tmp253_;
			gint _tmp254_;
			gpointer _tmp255_;
			ValaDelegate* _tmp256_;
			ValaCodeContext* _tmp257_;
			_tmp250_ = _d_index;
			_d_index = _tmp250_ + 1;
			_tmp251_ = _d_index;
			_tmp252_ = _d_size;
			if (!(_tmp251_ < _tmp252_)) {
				break;
			}
			_tmp253_ = _d_list;
			_tmp254_ = _d_index;
			_tmp255_ = vala_list_get (_tmp253_, _tmp254_);
			d = (ValaDelegate*) _tmp255_;
			_tmp256_ = d;
			_tmp257_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp256_, _tmp257_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp258_ = g_direct_hash;
	_tmp259_ = g_direct_equal;
	_tmp260_ = g_direct_equal;
	_tmp261_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp258_, _tmp259_, _tmp260_);
	positions = (ValaMap*) _tmp261_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp262_;
		ValaList* _tmp263_;
		gint _sym_size = 0;
		ValaList* _tmp264_;
		gint _tmp265_;
		gint _tmp266_;
		gint _sym_index = 0;
		_tmp262_ = self->priv->virtuals;
		_tmp263_ = _vala_iterable_ref0 (_tmp262_);
		_sym_list = _tmp263_;
		_tmp264_ = _sym_list;
		_tmp265_ = vala_collection_get_size ((ValaCollection*) _tmp264_);
		_tmp266_ = _tmp265_;
		_sym_size = _tmp266_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp270_;
			gint _tmp271_;
			gpointer _tmp272_;
			gint ordering = 0;
			ValaSymbol* _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gboolean ordered = FALSE;
			gint _tmp284_;
			gboolean _tmp285_ = FALSE;
			gboolean _tmp286_ = FALSE;
			gboolean _tmp287_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_;
			gboolean _tmp301_ = FALSE;
			gboolean _tmp302_ = FALSE;
			gboolean _tmp303_;
			gboolean _tmp314_ = FALSE;
			gboolean _tmp315_;
			gboolean _tmp317_ = FALSE;
			gboolean _tmp318_;
			_tmp267_ = _sym_index;
			_sym_index = _tmp267_ + 1;
			_tmp268_ = _sym_index;
			_tmp269_ = _sym_size;
			if (!(_tmp268_ < _tmp269_)) {
				break;
			}
			_tmp270_ = _sym_list;
			_tmp271_ = _sym_index;
			_tmp272_ = vala_list_get (_tmp270_, _tmp271_);
			sym = (ValaSymbol*) _tmp272_;
			_tmp273_ = sym;
			_tmp274_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp273_, "CCode", "ordering", -1);
			ordering = _tmp274_;
			_tmp275_ = ordering;
			if (_tmp275_ < -1) {
				ValaSymbol* _tmp276_;
				ValaSourceReference* _tmp277_;
				ValaSourceReference* _tmp278_;
				ValaSymbol* _tmp279_;
				gchar* _tmp280_;
				gchar* _tmp281_;
				gchar* _tmp282_;
				gchar* _tmp283_;
				_tmp276_ = sym;
				_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp276_);
				_tmp278_ = _tmp277_;
				_tmp279_ = sym;
				_tmp280_ = vala_symbol_get_full_name (_tmp279_);
				_tmp281_ = _tmp280_;
				_tmp282_ = g_strdup_printf ("%s: Invalid ordering", _tmp281_);
				_tmp283_ = _tmp282_;
				vala_report_error (_tmp278_, _tmp283_);
				_g_free0 (_tmp283_);
				_g_free0 (_tmp281_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp284_ = ordering;
			ordered = _tmp284_ != -1;
			_tmp287_ = ordered;
			if (_tmp287_) {
				gboolean _tmp288_;
				_tmp288_ = unordered_seen;
				_tmp286_ = _tmp288_;
			} else {
				_tmp286_ = FALSE;
			}
			if (_tmp286_) {
				gboolean _tmp289_;
				_tmp289_ = ordered_seen;
				_tmp285_ = !_tmp289_;
			} else {
				_tmp285_ = FALSE;
			}
			if (_tmp285_) {
				ValaSymbol* _tmp290_;
				ValaSourceReference* _tmp291_;
				ValaSourceReference* _tmp292_;
				ValaSymbol* _tmp293_;
				gchar* _tmp294_;
				gchar* _tmp295_;
				gchar* _tmp296_;
				gchar* _tmp297_;
				_tmp290_ = sym;
				_tmp291_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp293_ = sym;
				_tmp294_ = vala_symbol_get_full_name (_tmp293_);
				_tmp295_ = _tmp294_;
				_tmp296_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp295_);
				_tmp297_ = _tmp296_;
				vala_report_error (_tmp292_, _tmp297_);
				_g_free0 (_tmp297_);
				_g_free0 (_tmp295_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp299_ = ordered_seen;
			if (_tmp299_) {
				_tmp298_ = TRUE;
			} else {
				gboolean _tmp300_;
				_tmp300_ = ordered;
				_tmp298_ = _tmp300_;
			}
			ordered_seen = _tmp298_;
			_tmp303_ = ordered;
			if (!_tmp303_) {
				gboolean _tmp304_;
				_tmp304_ = unordered_seen;
				_tmp302_ = !_tmp304_;
			} else {
				_tmp302_ = FALSE;
			}
			if (_tmp302_) {
				gboolean _tmp305_;
				_tmp305_ = ordered_seen;
				_tmp301_ = _tmp305_;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				ValaSymbol* _tmp306_;
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				ValaSymbol* _tmp309_;
				gchar* _tmp310_;
				gchar* _tmp311_;
				gchar* _tmp312_;
				gchar* _tmp313_;
				_tmp306_ = sym;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = sym;
				_tmp310_ = vala_symbol_get_full_name (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp312_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp311_);
				_tmp313_ = _tmp312_;
				vala_report_error (_tmp308_, _tmp313_);
				_g_free0 (_tmp313_);
				_g_free0 (_tmp311_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp315_ = unordered_seen;
			if (_tmp315_) {
				_tmp314_ = TRUE;
			} else {
				gboolean _tmp316_;
				_tmp316_ = ordered;
				_tmp314_ = !_tmp316_;
			}
			unordered_seen = _tmp314_;
			_tmp318_ = ordered_seen;
			if (!_tmp318_) {
				_tmp317_ = TRUE;
			} else {
				gboolean _tmp319_;
				_tmp319_ = unordered_seen;
				_tmp317_ = !_tmp319_;
			}
			if (_tmp317_) {
				gboolean _tmp320_;
				_tmp320_ = ordered;
				if (_tmp320_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp321_;
					gint _tmp322_;
					gpointer _tmp323_;
					ValaSymbol* _tmp324_;
					ValaMap* _tmp336_;
					gint _tmp337_;
					ValaSymbol* _tmp338_;
					_tmp321_ = positions;
					_tmp322_ = ordering;
					_tmp323_ = vala_map_get (_tmp321_, (gpointer) ((gintptr) _tmp322_));
					prev = (ValaSymbol*) _tmp323_;
					_tmp324_ = prev;
					if (_tmp324_ != NULL) {
						ValaSymbol* _tmp325_;
						ValaSourceReference* _tmp326_;
						ValaSourceReference* _tmp327_;
						ValaSymbol* _tmp328_;
						gchar* _tmp329_;
						gchar* _tmp330_;
						ValaSymbol* _tmp331_;
						const gchar* _tmp332_;
						const gchar* _tmp333_;
						gchar* _tmp334_;
						gchar* _tmp335_;
						_tmp325_ = sym;
						_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp325_);
						_tmp327_ = _tmp326_;
						_tmp328_ = sym;
						_tmp329_ = vala_symbol_get_full_name (_tmp328_);
						_tmp330_ = _tmp329_;
						_tmp331_ = prev;
						_tmp332_ = vala_symbol_get_name (_tmp331_);
						_tmp333_ = _tmp332_;
						_tmp334_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp330_, _tmp333_);
						_tmp335_ = _tmp334_;
						vala_report_error (_tmp327_, _tmp335_);
						_g_free0 (_tmp335_);
						_g_free0 (_tmp330_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp336_ = positions;
					_tmp337_ = ordering;
					_tmp338_ = sym;
					vala_map_set (_tmp336_, (gpointer) ((gintptr) _tmp337_), _tmp338_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp339_ = ordered_seen;
	if (_tmp339_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp340_ = FALSE;
				_tmp340_ = TRUE;
				while (TRUE) {
					gint _tmp342_;
					ValaList* _tmp343_;
					gint _tmp344_;
					gint _tmp345_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp346_;
					gint _tmp347_;
					gpointer _tmp348_;
					ValaSymbol* _tmp349_;
					gboolean _tmp357_;
					gboolean _tmp358_;
					if (!_tmp340_) {
						gint _tmp341_;
						_tmp341_ = i;
						i = _tmp341_ + 1;
					}
					_tmp340_ = FALSE;
					_tmp342_ = i;
					_tmp343_ = self->priv->virtuals;
					_tmp344_ = vala_collection_get_size ((ValaCollection*) _tmp343_);
					_tmp345_ = _tmp344_;
					if (!(_tmp342_ < _tmp345_)) {
						break;
					}
					_tmp346_ = positions;
					_tmp347_ = i;
					_tmp348_ = vala_map_get (_tmp346_, (gpointer) ((gintptr) _tmp347_));
					sym = (ValaSymbol*) _tmp348_;
					_tmp349_ = sym;
					if (_tmp349_ == NULL) {
						ValaSourceReference* _tmp350_;
						ValaSourceReference* _tmp351_;
						gchar* _tmp352_;
						gchar* _tmp353_;
						gint _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						_tmp350_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp351_ = _tmp350_;
						_tmp352_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp353_ = _tmp352_;
						_tmp354_ = i;
						_tmp355_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp353_, _tmp354_);
						_tmp356_ = _tmp355_;
						vala_report_error (_tmp351_, _tmp356_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp353_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp357_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp358_ = _tmp357_;
					if (!_tmp358_) {
						ValaList* _tmp359_;
						gint _tmp360_;
						ValaSymbol* _tmp361_;
						_tmp359_ = self->priv->virtuals;
						_tmp360_ = i;
						_tmp361_ = sym;
						vala_list_set (_tmp359_, _tmp360_, _tmp361_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp362_ = context;
	_tmp363_ = vala_code_context_get_analyzer (_tmp362_);
	_tmp364_ = _tmp363_;
	_tmp365_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp364_, _tmp365_);
	_tmp366_ = context;
	_tmp367_ = vala_code_context_get_analyzer (_tmp366_);
	_tmp368_ = _tmp367_;
	_tmp369_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp368_, _tmp369_);
	_tmp370_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp371_ = _tmp370_;
	result = !_tmp371_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void vala_interface_class_init (ValaInterfaceClass * klass) {
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_interface_real_add_method;
	((ValaObjectTypeSymbolClass *) klass)->get_methods = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_methods;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_interface_real_add_field;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol *, ValaConstant*)) vala_interface_real_add_constant;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_interface_real_add_property;
	((ValaObjectTypeSymbolClass *) klass)->get_properties = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_properties;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol *, ValaSignal*)) vala_interface_real_add_signal;
	((ValaObjectTypeSymbolClass *) klass)->get_signals = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_interface_real_get_signals;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface *)) vala_interface_real_get_virtuals;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol *, ValaClass*)) vala_interface_real_add_class;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol *, ValaStruct*)) vala_interface_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol *, ValaEnum*)) vala_interface_real_add_enum;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol *, ValaDelegate*)) vala_interface_real_add_delegate;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_interface_real_check;
}


static void vala_interface_instance_init (ValaInterface * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->constants = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->virtuals = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->classes = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->structs = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	self->priv->enums = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->delegates = (ValaList*) _tmp21_;
}


static void vala_interface_finalize (ValaCodeNode * obj) {
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->virtuals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_interface_get_type (void) {
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



