#define IN_TP_QT_HEADER
#include "TelepathyQt/connection.h"

namespace Tp
{
namespace Client
{

ConnectionInterface::ConnectionInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterface::ConnectionInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterface::ConnectionInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void ConnectionInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(SelfHandleChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(SelfContactChanged(uint, const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(NewChannel(const QDBusObjectPath&, const QString&, uint, uint, bool)), NULL, NULL);
    disconnect(this, SIGNAL(ConnectionError(const QString&, const QVariantMap&)), NULL, NULL);
    disconnect(this, SIGNAL(StatusChanged(uint, uint)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceAddressingInterface::ConnectionInterfaceAddressingInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceAddressingInterface::ConnectionInterfaceAddressingInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceAddressingInterface::ConnectionInterfaceAddressingInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceAddressingInterface::ConnectionInterfaceAddressingInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceAddressingInterface::ConnectionInterfaceAddressingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceAddressingInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceAliasingInterface::ConnectionInterfaceAliasingInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceAliasingInterface::ConnectionInterfaceAliasingInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceAliasingInterface::ConnectionInterfaceAliasingInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceAliasingInterface::ConnectionInterfaceAliasingInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceAliasingInterface::ConnectionInterfaceAliasingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceAliasingInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(AliasesChanged(const Tp::AliasPairList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceAnonymityInterface::ConnectionInterfaceAnonymityInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceAnonymityInterface::ConnectionInterfaceAnonymityInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceAnonymityInterface::ConnectionInterfaceAnonymityInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceAnonymityInterface::ConnectionInterfaceAnonymityInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceAnonymityInterface::ConnectionInterfaceAnonymityInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceAnonymityInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(AnonymityModesChanged(uint)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceAvatarsInterface::ConnectionInterfaceAvatarsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceAvatarsInterface::ConnectionInterfaceAvatarsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceAvatarsInterface::ConnectionInterfaceAvatarsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceAvatarsInterface::ConnectionInterfaceAvatarsInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceAvatarsInterface::ConnectionInterfaceAvatarsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceAvatarsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(AvatarUpdated(uint, const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(AvatarRetrieved(uint, const QString&, const QByteArray&, const QString&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceBalanceInterface::ConnectionInterfaceBalanceInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceBalanceInterface::ConnectionInterfaceBalanceInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceBalanceInterface::ConnectionInterfaceBalanceInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceBalanceInterface::ConnectionInterfaceBalanceInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceBalanceInterface::ConnectionInterfaceBalanceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceBalanceInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(BalanceChanged(const Tp::CurrencyAmount&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceCapabilitiesInterface::ConnectionInterfaceCapabilitiesInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceCapabilitiesInterface::ConnectionInterfaceCapabilitiesInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceCapabilitiesInterface::ConnectionInterfaceCapabilitiesInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceCapabilitiesInterface::ConnectionInterfaceCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceCapabilitiesInterface::ConnectionInterfaceCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceCapabilitiesInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(CapabilitiesChanged(const Tp::CapabilityChangeList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceCellularInterface::ConnectionInterfaceCellularInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceCellularInterface::ConnectionInterfaceCellularInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceCellularInterface::ConnectionInterfaceCellularInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceCellularInterface::ConnectionInterfaceCellularInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceCellularInterface::ConnectionInterfaceCellularInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceCellularInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(IMSIChanged(const QString&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceClientTypesInterface::ConnectionInterfaceClientTypesInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceClientTypesInterface::ConnectionInterfaceClientTypesInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceClientTypesInterface::ConnectionInterfaceClientTypesInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceClientTypesInterface::ConnectionInterfaceClientTypesInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceClientTypesInterface::ConnectionInterfaceClientTypesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceClientTypesInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(ClientTypesUpdated(uint, const QStringList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactBlockingInterface::ConnectionInterfaceContactBlockingInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactBlockingInterface::ConnectionInterfaceContactBlockingInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactBlockingInterface::ConnectionInterfaceContactBlockingInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactBlockingInterface::ConnectionInterfaceContactBlockingInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactBlockingInterface::ConnectionInterfaceContactBlockingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactBlockingInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(BlockedContactsChanged(const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactCapabilitiesInterface::ConnectionInterfaceContactCapabilitiesInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactCapabilitiesInterface::ConnectionInterfaceContactCapabilitiesInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactCapabilitiesInterface::ConnectionInterfaceContactCapabilitiesInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactCapabilitiesInterface::ConnectionInterfaceContactCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactCapabilitiesInterface::ConnectionInterfaceContactCapabilitiesInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactCapabilitiesInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(ContactCapabilitiesChanged(const Tp::ContactCapabilitiesMap&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactGroupsInterface::ConnectionInterfaceContactGroupsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactGroupsInterface::ConnectionInterfaceContactGroupsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactGroupsInterface::ConnectionInterfaceContactGroupsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactGroupsInterface::ConnectionInterfaceContactGroupsInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactGroupsInterface::ConnectionInterfaceContactGroupsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactGroupsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(GroupsChanged(const Tp::UIntList&, const QStringList&, const QStringList&)), NULL, NULL);
    disconnect(this, SIGNAL(GroupsCreated(const QStringList&)), NULL, NULL);
    disconnect(this, SIGNAL(GroupRenamed(const QString&, const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(GroupsRemoved(const QStringList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactInfoInterface::ConnectionInterfaceContactInfoInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactInfoInterface::ConnectionInterfaceContactInfoInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactInfoInterface::ConnectionInterfaceContactInfoInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactInfoInterface::ConnectionInterfaceContactInfoInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactInfoInterface::ConnectionInterfaceContactInfoInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactInfoInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(ContactInfoChanged(uint, const Tp::ContactInfoFieldList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactListInterface::ConnectionInterfaceContactListInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactListInterface::ConnectionInterfaceContactListInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactListInterface::ConnectionInterfaceContactListInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactListInterface::ConnectionInterfaceContactListInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactListInterface::ConnectionInterfaceContactListInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactListInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(ContactListStateChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(ContactsChangedWithID(const Tp::ContactSubscriptionMap&, const Tp::HandleIdentifierMap&, const Tp::HandleIdentifierMap&)), NULL, NULL);
    disconnect(this, SIGNAL(ContactsChanged(const Tp::ContactSubscriptionMap&, const Tp::UIntList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceContactsInterface::ConnectionInterfaceContactsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceContactsInterface::ConnectionInterfaceContactsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceContactsInterface::ConnectionInterfaceContactsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceContactsInterface::ConnectionInterfaceContactsInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceContactsInterface::ConnectionInterfaceContactsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceContactsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceLocationInterface::ConnectionInterfaceLocationInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceLocationInterface::ConnectionInterfaceLocationInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceLocationInterface::ConnectionInterfaceLocationInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceLocationInterface::ConnectionInterfaceLocationInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceLocationInterface::ConnectionInterfaceLocationInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceLocationInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(LocationUpdated(uint, const QVariantMap&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceMailNotificationInterface::ConnectionInterfaceMailNotificationInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceMailNotificationInterface::ConnectionInterfaceMailNotificationInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceMailNotificationInterface::ConnectionInterfaceMailNotificationInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceMailNotificationInterface::ConnectionInterfaceMailNotificationInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceMailNotificationInterface::ConnectionInterfaceMailNotificationInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceMailNotificationInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(MailsReceived(const Tp::MailList&)), NULL, NULL);
    disconnect(this, SIGNAL(UnreadMailsChanged(uint, const Tp::MailList&, const QStringList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfacePowerSavingInterface::ConnectionInterfacePowerSavingInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfacePowerSavingInterface::ConnectionInterfacePowerSavingInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfacePowerSavingInterface::ConnectionInterfacePowerSavingInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfacePowerSavingInterface::ConnectionInterfacePowerSavingInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfacePowerSavingInterface::ConnectionInterfacePowerSavingInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfacePowerSavingInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(PowerSavingChanged(bool)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfacePresenceInterface::ConnectionInterfacePresenceInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfacePresenceInterface::ConnectionInterfacePresenceInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfacePresenceInterface::ConnectionInterfacePresenceInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfacePresenceInterface::ConnectionInterfacePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfacePresenceInterface::ConnectionInterfacePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfacePresenceInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(PresenceUpdate(const Tp::ContactPresences&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceRequestsInterface::ConnectionInterfaceRequestsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceRequestsInterface::ConnectionInterfaceRequestsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceRequestsInterface::ConnectionInterfaceRequestsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceRequestsInterface::ConnectionInterfaceRequestsInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceRequestsInterface::ConnectionInterfaceRequestsInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceRequestsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(NewChannels(const Tp::ChannelDetailsList&)), NULL, NULL);
    disconnect(this, SIGNAL(ChannelClosed(const QDBusObjectPath&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceServicePointInterface::ConnectionInterfaceServicePointInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceServicePointInterface::ConnectionInterfaceServicePointInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceServicePointInterface::ConnectionInterfaceServicePointInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceServicePointInterface::ConnectionInterfaceServicePointInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceServicePointInterface::ConnectionInterfaceServicePointInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceServicePointInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(ServicePointsChanged(const Tp::ServicePointInfoList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

ConnectionInterfaceSimplePresenceInterface::ConnectionInterfaceSimplePresenceInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

ConnectionInterfaceSimplePresenceInterface::ConnectionInterfaceSimplePresenceInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

ConnectionInterfaceSimplePresenceInterface::ConnectionInterfaceSimplePresenceInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

ConnectionInterfaceSimplePresenceInterface::ConnectionInterfaceSimplePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

ConnectionInterfaceSimplePresenceInterface::ConnectionInterfaceSimplePresenceInterface(const Tp::Client::ConnectionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void ConnectionInterfaceSimplePresenceInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(PresencesChanged(const Tp::SimpleContactPresences&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
