#define IN_TP_QT_HEADER
#include "TelepathyQt/call-stream-endpoint.h"

namespace Tp
{
namespace Client
{

CallStreamEndpointInterface::CallStreamEndpointInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallStreamEndpointInterface::CallStreamEndpointInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallStreamEndpointInterface::CallStreamEndpointInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void CallStreamEndpointInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(RemoteCredentialsSet(const QString&, const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(RemoteCandidatesAdded(const Tp::CandidateList&)), NULL, NULL);
    disconnect(this, SIGNAL(CandidatePairSelected(const Tp::Candidate&, const Tp::Candidate&)), NULL, NULL);
    disconnect(this, SIGNAL(EndpointStateChanged(uint, uint)), NULL, NULL);
    disconnect(this, SIGNAL(ControllingChanged(bool)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
