/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGADVICE_H
#define SKGADVICE_H
/** @file
 * This file defines classes SKGAdvice .
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <qstring.h>
#include <qobject.h>
#include <qvector.h>
#include <qstringlist.h>
#include <qmetatype.h>

#include "skgbasemodeler_export.h"

/**
* This class manages errors
*/
class SKGBASEMODELER_EXPORT SKGAdvice final : public QObject
{
    Q_OBJECT
public:
    /**
     * Advice action
     */
    struct SKGAdviceAction {
        /** The id of the action */
        QString id;

        /** The title of the action */
        QString Title;

        /** The name of the icon of the action */
        QString IconName;

        /** To know if this action is recommended*/
        bool IsRecommended;
    };

    /**
     * List of advice action
     */
    typedef QVector<SKGAdvice::SKGAdviceAction> SKGAdviceActionList;

    /**
     * Priotity
     */
    Q_PROPERTY(int priority READ getPriority WRITE setPriority)
    /**
     * Unique identifier
     */
    Q_PROPERTY(QString uuid READ getUUID WRITE setUUID)
    /**
     * Short message
     */
    Q_PROPERTY(QString shortMessage READ getShortMessage WRITE setShortMessage)
    /**
     * Long message
     */
    Q_PROPERTY(QString longMessage READ getLongMessage WRITE setLongMessage)
    /**
     * Auto corrections
     */
    Q_PROPERTY(SKGAdvice::SKGAdviceActionList autoCorrections READ getAutoCorrections WRITE setAutoCorrections)

    /**
    * Constructor
    */
    explicit SKGAdvice();

    /**
    * Copy constructor
    * @param iAdvice the advice to copy
    */
    SKGAdvice(const SKGAdvice& iAdvice);

    /**
    * Destructor
    */
    ~SKGAdvice() override;

    /**
    * Operator affectation
    * @param iAdvice the advice to copy
    */
    SKGAdvice& operator= (const SKGAdvice& iAdvice);

public Q_SLOTS:
    /**
    * Set the unique identifier
    * @param iUUID the unique identifier
    */
    void setUUID(const QString& iUUID);

    /**
    * Return the unique identifier
    * @return the unique identifier
    */
    QString getUUID() const;

    /**
    * Set the priority
    * @param iPriority the priority
    */
    void setPriority(int iPriority);

    /**
    * Return the priority
    * @return the priority
    */
    int getPriority() const;

    /**
    * Set the short message
    * @param iMessage the short message
    */
    void setShortMessage(const QString& iMessage);

    /**
    * Return the short message
    * @return the short message
    */
    QString getShortMessage() const;

    /**
    * Set the long message
    * @param iMessage the long message
    */
    void setLongMessage(const QString& iMessage);

    /**
    * Return the long message
    * @return the long message
    */
    QString getLongMessage() const;

    /**
    * Set the auto corrections
    * @param iCorrections the auto corrections
    */
    void setAutoCorrections(const QStringList& iCorrections);

    /**
    * Set the auto corrections
    * @param iCorrections the auto corrections
    */
    void setAutoCorrections(const SKGAdvice::SKGAdviceActionList& iCorrections);

    /**
    * Return the auto corrections
    * @return the auto corrections
    */
    SKGAdvice::SKGAdviceActionList getAutoCorrections() const;

private:
    /**
     * the unique identifier
     */
    QString m_uuid;

    /**
    * the priority
    */
    int m_priority;

    /**
     * the short message
     */
    QString m_shortMessage;

    /**
     * the short message
     */
    QString m_longMessage;

    /**
     * the list of auto corrections
     */
    SKGAdvice::SKGAdviceActionList m_autoCorrections;
};
/**
 * Declare the meta type
 */
Q_DECLARE_METATYPE(SKGAdvice)

/**
 * Declare the class
 */
Q_DECLARE_TYPEINFO(SKGAdvice, Q_MOVABLE_TYPE);

/**
 * the SKGAdviceList
 */
typedef QVector<SKGAdvice> SKGAdviceList;

/**
 * Declare the meta type
 */
Q_DECLARE_METATYPE(QVector<SKGAdvice>)
#endif  // SKGADVICE_H
