/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATALIST_ELEMENT)

#include "JSHTMLDataListElement.h"

#include "HTMLCollection.h"
#include "HTMLDataListElement.h"
#include "JSHTMLCollection.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDataListElementTableValues[] =
{
    { "options", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataListElementOptions), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataListElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDataListElementTable = { 4, 3, JSHTMLDataListElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLDataListElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDataListElementConstructorTable = { 1, 0, JSHTMLDataListElementConstructorTableValues, 0 };
const ClassInfo JSHTMLDataListElementConstructor::s_info = { "HTMLDataListElementConstructor", &Base::s_info, &JSHTMLDataListElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLDataListElementConstructor) };

JSHTMLDataListElementConstructor::JSHTMLDataListElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLDataListElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLDataListElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLDataListElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataListElementConstructor, JSDOMWrapper>(exec, &JSHTMLDataListElementConstructorTable, jsCast<JSHTMLDataListElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLDataListElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataListElementConstructor, JSDOMWrapper>(exec, &JSHTMLDataListElementConstructorTable, jsCast<JSHTMLDataListElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDataListElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDataListElementPrototypeTable = { 1, 0, JSHTMLDataListElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLDataListElementPrototype::s_info = { "HTMLDataListElementPrototype", &Base::s_info, &JSHTMLDataListElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLDataListElementPrototype) };

JSObject* JSHTMLDataListElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataListElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataListElement::s_info = { "HTMLDataListElement", &Base::s_info, &JSHTMLDataListElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLDataListElement) };

JSHTMLDataListElement::JSHTMLDataListElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataListElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLDataListElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLDataListElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLDataListElementPrototype::create(exec->globalData(), globalObject, JSHTMLDataListElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataListElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDataListElement* thisObject = jsCast<JSHTMLDataListElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLDataListElement, Base>(exec, &JSHTMLDataListElementTable, thisObject, propertyName, slot);
}

bool JSHTMLDataListElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDataListElement* thisObject = jsCast<JSHTMLDataListElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLDataListElement, Base>(exec, &JSHTMLDataListElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLDataListElementOptions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDataListElement* castedThis = jsCast<JSHTMLDataListElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataListElement* impl = static_cast<HTMLDataListElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->options()));
    return result;
}


JSValue jsHTMLDataListElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDataListElement* domObject = jsCast<JSHTMLDataListElement*>(asObject(slotBase));
    return JSHTMLDataListElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSHTMLDataListElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataListElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATALIST_ELEMENT)
