/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTransformList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGMatrix.h"
#include "JSSVGTransform.h"
#include "SVGTransform.h"
#include "SVGTransformList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTransformListTableValues[] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformListNumberOfItems), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformListTable = { 4, 3, JSSVGTransformListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTransformListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformListConstructorTable = { 1, 0, JSSVGTransformListConstructorTableValues, 0 };
const ClassInfo JSSVGTransformListConstructor::s_info = { "SVGTransformListConstructor", &Base::s_info, &JSSVGTransformListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTransformListConstructor) };

JSSVGTransformListConstructor::JSSVGTransformListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTransformListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTransformListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTransformListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTransformListConstructor, JSDOMWrapper>(exec, &JSSVGTransformListConstructorTable, jsCast<JSSVGTransformListConstructor*>(cell), propertyName, slot);
}

bool JSSVGTransformListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTransformListConstructor, JSDOMWrapper>(exec, &JSSVGTransformListConstructorTable, jsCast<JSSVGTransformListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTransformListPrototypeTableValues[] =
{
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "initialize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionInitialize), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "insertItemBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionInsertItemBefore), (intptr_t)2, NoIntrinsic },
    { "replaceItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionReplaceItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "appendItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionAppendItem), (intptr_t)1, NoIntrinsic },
    { "createSVGTransformFromMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionCreateSVGTransformFromMatrix), (intptr_t)1, NoIntrinsic },
    { "consolidate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTransformListPrototypeFunctionConsolidate), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTransformListPrototypeTable = { 33, 31, JSSVGTransformListPrototypeTableValues, 0 };
const ClassInfo JSSVGTransformListPrototype::s_info = { "SVGTransformListPrototype", &Base::s_info, &JSSVGTransformListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTransformListPrototype) };

JSObject* JSSVGTransformListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTransformList>(exec, globalObject);
}

bool JSSVGTransformListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTransformListPrototype* thisObject = jsCast<JSSVGTransformListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTransformListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTransformListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTransformListPrototype* thisObject = jsCast<JSSVGTransformListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGTransformListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTransformList::s_info = { "SVGTransformList", &Base::s_info, &JSSVGTransformListTable, 0 , CREATE_METHOD_TABLE(JSSVGTransformList) };

JSSVGTransformList::JSSVGTransformList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTransformListPropertyTearOff > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGTransformList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTransformList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTransformListPrototype::create(exec->globalData(), globalObject, JSSVGTransformListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGTransformList::destroy(JSC::JSCell* cell)
{
    JSSVGTransformList* thisObject = static_cast<JSSVGTransformList*>(cell);
    thisObject->JSSVGTransformList::~JSSVGTransformList();
}

JSSVGTransformList::~JSSVGTransformList()
{
    releaseImplIfNotNull();
}

bool JSSVGTransformList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTransformList* thisObject = jsCast<JSSVGTransformList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTransformList, Base>(exec, &JSSVGTransformListTable, thisObject, propertyName, slot);
}

bool JSSVGTransformList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTransformList* thisObject = jsCast<JSSVGTransformList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTransformList, Base>(exec, &JSSVGTransformListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTransformListNumberOfItems(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JSValue result =  jsNumber(castedThis->impl()->numberOfItems());
    return result;
}


JSValue jsSVGTransformListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTransformList* domObject = jsCast<JSSVGTransformList*>(asObject(slotBase));
    return JSSVGTransformList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTransformList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTransformListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGTransform>* item(toSVGTransform(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initialize(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGTransform>* item(toSVGTransform(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertItemBefore(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGTransform>* item(toSVGTransform(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->replaceItem(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGTransform::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGTransform>* item(toSVGTransform(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->appendItem(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionCreateSVGTransformFromMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGMatrix>* matrix(toSVGMatrix(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGTransformFromMatrix(matrix, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformListPrototypeFunctionConsolidate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTransformList::s_info))
        return throwVMTypeError(exec);
    JSSVGTransformList* castedThis = jsCast<JSSVGTransformList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTransformList::s_info);
    SVGTransformListPropertyTearOff * impl = static_cast<SVGTransformListPropertyTearOff *>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->consolidate(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGTransformList* jsSVGTransformList)
{
    if (jsSVGTransformList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGTransformListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGTransformList* jsSVGTransformList = jsCast<JSSVGTransformList*>(handle.get().asCell());
    if (!isObservable(jsSVGTransformList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGTransformListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGTransformList* jsSVGTransformList = jsCast<JSSVGTransformList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGTransformList->impl(), jsSVGTransformList);
    jsSVGTransformList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGTransformListPropertyTearOff * impl)
{
    return wrap<JSSVGTransformList>(exec, globalObject, impl);
}

SVGTransformListPropertyTearOff * toSVGTransformList(JSC::JSValue value)
{
    return value.inherits(&JSSVGTransformList::s_info) ? jsCast<JSSVGTransformList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
