/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGDefsElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGDefsElement.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGDefsElementTableValues[] =
{
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementXmllang), (intptr_t)setJSSVGDefsElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementXmlspace), (intptr_t)setJSSVGDefsElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementStyle), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGDefsElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementTable = { 34, 31, JSSVGDefsElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGDefsElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementConstructorTable = { 1, 0, JSSVGDefsElementConstructorTableValues, 0 };
const ClassInfo JSSVGDefsElementConstructor::s_info = { "SVGDefsElementConstructor", &Base::s_info, &JSSVGDefsElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGDefsElementConstructor) };

JSSVGDefsElementConstructor::JSSVGDefsElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGDefsElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGDefsElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGDefsElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDefsElementConstructor, JSDOMWrapper>(exec, &JSSVGDefsElementConstructorTable, jsCast<JSSVGDefsElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGDefsElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGDefsElementConstructor, JSDOMWrapper>(exec, &JSSVGDefsElementConstructorTable, jsCast<JSSVGDefsElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGDefsElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGDefsElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGDefsElementPrototypeTable = { 17, 15, JSSVGDefsElementPrototypeTableValues, 0 };
const ClassInfo JSSVGDefsElementPrototype::s_info = { "SVGDefsElementPrototype", &Base::s_info, &JSSVGDefsElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGDefsElementPrototype) };

JSObject* JSSVGDefsElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGDefsElement>(exec, globalObject);
}

bool JSSVGDefsElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDefsElementPrototype* thisObject = jsCast<JSSVGDefsElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGDefsElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGDefsElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDefsElementPrototype* thisObject = jsCast<JSSVGDefsElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGDefsElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGDefsElement::s_info = { "SVGDefsElement", &Base::s_info, &JSSVGDefsElementTable, 0 , CREATE_METHOD_TABLE(JSSVGDefsElement) };

JSSVGDefsElement::JSSVGDefsElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGDefsElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGDefsElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGDefsElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGDefsElementPrototype::create(exec->globalData(), globalObject, JSSVGDefsElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGDefsElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGDefsElement* thisObject = jsCast<JSSVGDefsElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, thisObject, propertyName, slot);
}

bool JSSVGDefsElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGDefsElement* thisObject = jsCast<JSSVGDefsElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGDefsElement, Base>(exec, &JSSVGDefsElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGDefsElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGDefsElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGDefsElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGDefsElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGDefsElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGDefsElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGDefsElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGDefsElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGDefsElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGDefsElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGDefsElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGDefsElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGDefsElement* domObject = jsCast<JSSVGDefsElement*>(asObject(slotBase));
    return JSSVGDefsElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGDefsElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGDefsElement* thisObject = jsCast<JSSVGDefsElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGDefsElement, Base>(exec, propertyName, value, &JSSVGDefsElementTable, thisObject, slot);
}

void setJSSVGDefsElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(thisObject);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGDefsElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(thisObject);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGDefsElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGDefsElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGDefsElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGDefsElement::s_info))
        return throwVMTypeError(exec);
    JSSVGDefsElement* castedThis = jsCast<JSSVGDefsElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGDefsElement::s_info);
    SVGDefsElement* impl = static_cast<SVGDefsElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
