/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedString.h"

#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/text/WTFString.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedStringTableValues[] =
{
    { "baseVal", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringBaseVal), (intptr_t)setJSSVGAnimatedStringBaseVal, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedStringTable = { 8, 7, JSSVGAnimatedStringTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedStringConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedStringConstructorTable = { 1, 0, JSSVGAnimatedStringConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedStringConstructor::s_info = { "SVGAnimatedStringConstructor", &Base::s_info, &JSSVGAnimatedStringConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedStringConstructor) };

JSSVGAnimatedStringConstructor::JSSVGAnimatedStringConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedStringConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAnimatedStringPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAnimatedStringConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedStringConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedStringConstructorTable, jsCast<JSSVGAnimatedStringConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedStringConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedStringConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedStringConstructorTable, jsCast<JSSVGAnimatedStringConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedStringPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedStringPrototypeTable = { 1, 0, JSSVGAnimatedStringPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedStringPrototype::s_info = { "SVGAnimatedStringPrototype", &Base::s_info, &JSSVGAnimatedStringPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedStringPrototype) };

JSObject* JSSVGAnimatedStringPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedString>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedString::s_info = { "SVGAnimatedString", &Base::s_info, &JSSVGAnimatedStringTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedString) };

JSSVGAnimatedString::JSSVGAnimatedString(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedString> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedString::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedString::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedStringPrototype::create(exec->globalData(), globalObject, JSSVGAnimatedStringPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedString::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedString* thisObject = static_cast<JSSVGAnimatedString*>(cell);
    thisObject->JSSVGAnimatedString::~JSSVGAnimatedString();
}

JSSVGAnimatedString::~JSSVGAnimatedString()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedString::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedString* thisObject = jsCast<JSSVGAnimatedString*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedString::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedString* thisObject = jsCast<JSSVGAnimatedString*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedStringBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedString* castedThis = jsCast<JSSVGAnimatedString*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedString* impl = static_cast<SVGAnimatedString*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->baseVal());
    return result;
}


JSValue jsSVGAnimatedStringAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedString* castedThis = jsCast<JSSVGAnimatedString*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedString* impl = static_cast<SVGAnimatedString*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->animVal());
    return result;
}


JSValue jsSVGAnimatedStringConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedString* domObject = jsCast<JSSVGAnimatedString*>(asObject(slotBase));
    return JSSVGAnimatedString::getConstructor(exec, domObject->globalObject());
}

void JSSVGAnimatedString::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGAnimatedString* thisObject = jsCast<JSSVGAnimatedString*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGAnimatedString, Base>(exec, propertyName, value, &JSSVGAnimatedStringTable, thisObject, slot);
}

void setJSSVGAnimatedStringBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAnimatedString* castedThis = jsCast<JSSVGAnimatedString*>(thisObject);
    SVGAnimatedString* impl = static_cast<SVGAnimatedString*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setBaseVal(value.isEmpty() ? String() : value.toString(exec)->value(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGAnimatedString::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedStringConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedString* jsSVGAnimatedString)
{
    if (jsSVGAnimatedString->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedStringOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedString* jsSVGAnimatedString = jsCast<JSSVGAnimatedString*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedString))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedStringOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedString* jsSVGAnimatedString = jsCast<JSSVGAnimatedString*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedString->impl(), jsSVGAnimatedString);
    jsSVGAnimatedString->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedString* impl)
{
    return wrap<JSSVGAnimatedString>(exec, globalObject, impl);
}

SVGAnimatedString* toSVGAnimatedString(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedString::s_info) ? jsCast<JSSVGAnimatedString*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
