/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SQL_DATABASE)

#include "JSSQLTransactionSync.h"

#include "SQLResultSet.h"
#include "SQLTransactionSync.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSSQLTransactionSyncPrototypeTableValues[] =
{
    { "executeSql", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSQLTransactionSyncPrototypeFunctionExecuteSql), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSQLTransactionSyncPrototypeTable = { 2, 1, JSSQLTransactionSyncPrototypeTableValues, 0 };
static const HashTable* getJSSQLTransactionSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSSQLTransactionSyncPrototypeTable);
}

const ClassInfo JSSQLTransactionSyncPrototype::s_info = { "SQLTransactionSyncPrototype", &Base::s_info, 0, getJSSQLTransactionSyncPrototypeTable, CREATE_METHOD_TABLE(JSSQLTransactionSyncPrototype) };

JSObject* JSSQLTransactionSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLTransactionSync>(exec, globalObject);
}

bool JSSQLTransactionSyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSQLTransactionSyncPrototype* thisObject = jsCast<JSSQLTransactionSyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSSQLTransactionSyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSSQLTransactionSyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSQLTransactionSyncPrototype* thisObject = jsCast<JSSQLTransactionSyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSSQLTransactionSyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

const ClassInfo JSSQLTransactionSync::s_info = { "SQLTransactionSync", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSSQLTransactionSync) };

JSSQLTransactionSync::JSSQLTransactionSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SQLTransactionSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSQLTransactionSync::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSQLTransactionSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSQLTransactionSyncPrototype::create(exec->globalData(), globalObject, JSSQLTransactionSyncPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSQLTransactionSync::destroy(JSC::JSCell* cell)
{
    JSSQLTransactionSync* thisObject = static_cast<JSSQLTransactionSync*>(cell);
    thisObject->JSSQLTransactionSync::~JSSQLTransactionSync();
}

JSSQLTransactionSync::~JSSQLTransactionSync()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsSQLTransactionSyncPrototypeFunctionExecuteSql(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSQLTransactionSync::s_info))
        return throwVMTypeError(exec);
    JSSQLTransactionSync* castedThis = jsCast<JSSQLTransactionSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSQLTransactionSync::s_info);
    return JSValue::encode(castedThis->executeSql(exec));
}

static inline bool isObservable(JSSQLTransactionSync* jsSQLTransactionSync)
{
    if (jsSQLTransactionSync->hasCustomProperties())
        return true;
    return false;
}

bool JSSQLTransactionSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSQLTransactionSync* jsSQLTransactionSync = jsCast<JSSQLTransactionSync*>(handle.get().asCell());
    if (!isObservable(jsSQLTransactionSync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLTransactionSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSQLTransactionSync* jsSQLTransactionSync = jsCast<JSSQLTransactionSync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSQLTransactionSync->impl(), jsSQLTransactionSync);
    jsSQLTransactionSync->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SQLTransactionSync* impl)
{
    return wrap<JSSQLTransactionSync>(exec, globalObject, impl);
}

SQLTransactionSync* toSQLTransactionSync(JSC::JSValue value)
{
    return value.inherits(&JSSQLTransactionSync::s_info) ? jsCast<JSSQLTransactionSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SQL_DATABASE)
