/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLActiveInfo.h"

#include "KURL.h"
#include "WebGLActiveInfo.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLActiveInfoTableValues[] =
{
    { "size", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLActiveInfoSize), (intptr_t)0, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLActiveInfoType), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLActiveInfoName), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLActiveInfoConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLActiveInfoTable = { 9, 7, JSWebGLActiveInfoTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLActiveInfoConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLActiveInfoConstructorTable = { 1, 0, JSWebGLActiveInfoConstructorTableValues, 0 };
const ClassInfo JSWebGLActiveInfoConstructor::s_info = { "WebGLActiveInfoConstructor", &Base::s_info, &JSWebGLActiveInfoConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLActiveInfoConstructor) };

JSWebGLActiveInfoConstructor::JSWebGLActiveInfoConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLActiveInfoConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLActiveInfoPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLActiveInfoConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLActiveInfoConstructor, JSDOMWrapper>(exec, &JSWebGLActiveInfoConstructorTable, jsCast<JSWebGLActiveInfoConstructor*>(cell), propertyName, slot);
}

bool JSWebGLActiveInfoConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLActiveInfoConstructor, JSDOMWrapper>(exec, &JSWebGLActiveInfoConstructorTable, jsCast<JSWebGLActiveInfoConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLActiveInfoPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLActiveInfoPrototypeTable = { 1, 0, JSWebGLActiveInfoPrototypeTableValues, 0 };
const ClassInfo JSWebGLActiveInfoPrototype::s_info = { "WebGLActiveInfoPrototype", &Base::s_info, &JSWebGLActiveInfoPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLActiveInfoPrototype) };

JSObject* JSWebGLActiveInfoPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLActiveInfo>(exec, globalObject);
}

const ClassInfo JSWebGLActiveInfo::s_info = { "WebGLActiveInfo", &Base::s_info, &JSWebGLActiveInfoTable, 0 , CREATE_METHOD_TABLE(JSWebGLActiveInfo) };

JSWebGLActiveInfo::JSWebGLActiveInfo(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLActiveInfo> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLActiveInfo::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLActiveInfo::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLActiveInfoPrototype::create(exec->globalData(), globalObject, JSWebGLActiveInfoPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLActiveInfo::destroy(JSC::JSCell* cell)
{
    JSWebGLActiveInfo* thisObject = static_cast<JSWebGLActiveInfo*>(cell);
    thisObject->JSWebGLActiveInfo::~JSWebGLActiveInfo();
}

JSWebGLActiveInfo::~JSWebGLActiveInfo()
{
    releaseImplIfNotNull();
}

bool JSWebGLActiveInfo::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLActiveInfo* thisObject = jsCast<JSWebGLActiveInfo*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLActiveInfo, Base>(exec, &JSWebGLActiveInfoTable, thisObject, propertyName, slot);
}

bool JSWebGLActiveInfo::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLActiveInfo* thisObject = jsCast<JSWebGLActiveInfo*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLActiveInfo, Base>(exec, &JSWebGLActiveInfoTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLActiveInfoSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLActiveInfo* castedThis = jsCast<JSWebGLActiveInfo*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLActiveInfo* impl = static_cast<WebGLActiveInfo*>(castedThis->impl());
    JSValue result = jsNumber(impl->size());
    return result;
}


JSValue jsWebGLActiveInfoType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLActiveInfo* castedThis = jsCast<JSWebGLActiveInfo*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLActiveInfo* impl = static_cast<WebGLActiveInfo*>(castedThis->impl());
    JSValue result = jsNumber(impl->type());
    return result;
}


JSValue jsWebGLActiveInfoName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLActiveInfo* castedThis = jsCast<JSWebGLActiveInfo*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLActiveInfo* impl = static_cast<WebGLActiveInfo*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsWebGLActiveInfoConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLActiveInfo* domObject = jsCast<JSWebGLActiveInfo*>(asObject(slotBase));
    return JSWebGLActiveInfo::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLActiveInfo::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLActiveInfoConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLActiveInfo* jsWebGLActiveInfo)
{
    if (jsWebGLActiveInfo->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLActiveInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLActiveInfo* jsWebGLActiveInfo = jsCast<JSWebGLActiveInfo*>(handle.get().asCell());
    if (!isObservable(jsWebGLActiveInfo))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLActiveInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLActiveInfo* jsWebGLActiveInfo = jsCast<JSWebGLActiveInfo*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLActiveInfo->impl(), jsWebGLActiveInfo);
    jsWebGLActiveInfo->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLActiveInfo* impl)
{
    return wrap<JSWebGLActiveInfo>(exec, globalObject, impl);
}

WebGLActiveInfo* toWebGLActiveInfo(JSC::JSValue value)
{
    return value.inherits(&JSWebGLActiveInfo::s_info) ? jsCast<JSWebGLActiveInfo*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
