/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRectList.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSClientRectListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectListTable = { 5, 3, JSClientRectListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSClientRectListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectListConstructorTable = { 1, 0, JSClientRectListConstructorTableValues, 0 };
const ClassInfo JSClientRectListConstructor::s_info = { "ClientRectListConstructor", &Base::s_info, &JSClientRectListConstructorTable, 0, CREATE_METHOD_TABLE(JSClientRectListConstructor) };

JSClientRectListConstructor::JSClientRectListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSClientRectListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSClientRectListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSClientRectListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRectListConstructor, JSDOMWrapper>(exec, &JSClientRectListConstructorTable, jsCast<JSClientRectListConstructor*>(cell), propertyName, slot);
}

bool JSClientRectListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRectListConstructor, JSDOMWrapper>(exec, &JSClientRectListConstructorTable, jsCast<JSClientRectListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSClientRectListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsClientRectListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectListPrototypeTable = { 2, 1, JSClientRectListPrototypeTableValues, 0 };
const ClassInfo JSClientRectListPrototype::s_info = { "ClientRectListPrototype", &Base::s_info, &JSClientRectListPrototypeTable, 0, CREATE_METHOD_TABLE(JSClientRectListPrototype) };

JSObject* JSClientRectListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRectList>(exec, globalObject);
}

bool JSClientRectListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSClientRectListPrototype* thisObject = jsCast<JSClientRectListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSClientRectListPrototypeTable, thisObject, propertyName, slot);
}

bool JSClientRectListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSClientRectListPrototype* thisObject = jsCast<JSClientRectListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSClientRectListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSClientRectList::s_info = { "ClientRectList", &Base::s_info, &JSClientRectListTable, 0 , CREATE_METHOD_TABLE(JSClientRectList) };

JSClientRectList::JSClientRectList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ClientRectList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSClientRectList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSClientRectList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSClientRectListPrototype::create(exec->globalData(), globalObject, JSClientRectListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSClientRectList::destroy(JSC::JSCell* cell)
{
    JSClientRectList* thisObject = static_cast<JSClientRectList*>(cell);
    thisObject->JSClientRectList::~JSClientRectList();
}

JSClientRectList::~JSClientRectList()
{
    releaseImplIfNotNull();
}

bool JSClientRectList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSClientRectList* thisObject = jsCast<JSClientRectList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSClientRectList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<ClientRectList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSClientRectList, Base>(exec, &JSClientRectListTable, thisObject, propertyName, slot);
}

bool JSClientRectList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSClientRectList* thisObject = jsCast<JSClientRectList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSClientRectListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<ClientRectList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSClientRectList, Base>(exec, &JSClientRectListTable, thisObject, propertyName, descriptor);
}

bool JSClientRectList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSClientRectList* thisObject = jsCast<JSClientRectList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<ClientRectList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsClientRectListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRectList* castedThis = jsCast<JSClientRectList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRectList* impl = static_cast<ClientRectList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsClientRectListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRectList* domObject = jsCast<JSClientRectList*>(asObject(slotBase));
    return JSClientRectList::getConstructor(exec, domObject->globalObject());
}

void JSClientRectList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSClientRectList* thisObject = jsCast<JSClientRectList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<ClientRectList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSClientRectList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsClientRectListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClientRectList::s_info))
        return throwVMTypeError(exec);
    JSClientRectList* castedThis = jsCast<JSClientRectList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSClientRectList::s_info);
    ClientRectList* impl = static_cast<ClientRectList*>(castedThis->impl());
    int index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSClientRectList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSClientRectList* thisObj = jsCast<JSClientRectList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<ClientRectList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSClientRectList* jsClientRectList)
{
    if (jsClientRectList->hasCustomProperties())
        return true;
    return false;
}

bool JSClientRectListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSClientRectList* jsClientRectList = jsCast<JSClientRectList*>(handle.get().asCell());
    if (!isObservable(jsClientRectList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSClientRectListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSClientRectList* jsClientRectList = jsCast<JSClientRectList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsClientRectList->impl(), jsClientRectList);
    jsClientRectList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ClientRectList* impl)
{
    return wrap<JSClientRectList>(exec, globalObject, impl);
}

ClientRectList* toClientRectList(JSC::JSValue value)
{
    return value.inherits(&JSClientRectList::s_info) ? jsCast<JSClientRectList*>(asObject(value))->impl() : 0;
}

}
