/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleDeclaration.h"

#include "CSSRule.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSCSSStyleDeclarationCustom.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSStyleDeclarationTableValues[] =
{
    { "cssText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationCssText), (intptr_t)setJSCSSStyleDeclarationCssText, NoIntrinsic },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationLength), (intptr_t)0, NoIntrinsic },
    { "parentRule", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationParentRule), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleDeclarationTable = { 10, 7, JSCSSStyleDeclarationTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSStyleDeclarationConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleDeclarationConstructorTable = { 1, 0, JSCSSStyleDeclarationConstructorTableValues, 0 };
const ClassInfo JSCSSStyleDeclarationConstructor::s_info = { "CSSStyleDeclarationConstructor", &Base::s_info, &JSCSSStyleDeclarationConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSStyleDeclarationConstructor) };

JSCSSStyleDeclarationConstructor::JSCSSStyleDeclarationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSStyleDeclarationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSStyleDeclarationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSStyleDeclarationConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleDeclarationConstructor, JSDOMWrapper>(exec, &JSCSSStyleDeclarationConstructorTable, jsCast<JSCSSStyleDeclarationConstructor*>(cell), propertyName, slot);
}

bool JSCSSStyleDeclarationConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSStyleDeclarationConstructor, JSDOMWrapper>(exec, &JSCSSStyleDeclarationConstructorTable, jsCast<JSCSSStyleDeclarationConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleDeclarationPrototypeTableValues[] =
{
    { "getPropertyValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue), (intptr_t)1, NoIntrinsic },
    { "getPropertyCSSValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue), (intptr_t)1, NoIntrinsic },
    { "removeProperty", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionRemoveProperty), (intptr_t)1, NoIntrinsic },
    { "getPropertyPriority", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority), (intptr_t)1, NoIntrinsic },
    { "setProperty", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionSetProperty), (intptr_t)3, NoIntrinsic },
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "getPropertyShorthand", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand), (intptr_t)1, NoIntrinsic },
    { "isPropertyImplicit", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleDeclarationPrototypeTable = { 17, 15, JSCSSStyleDeclarationPrototypeTableValues, 0 };
const ClassInfo JSCSSStyleDeclarationPrototype::s_info = { "CSSStyleDeclarationPrototype", &Base::s_info, &JSCSSStyleDeclarationPrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSStyleDeclarationPrototype) };

JSObject* JSCSSStyleDeclarationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleDeclaration>(exec, globalObject);
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSStyleDeclarationPrototype* thisObject = jsCast<JSCSSStyleDeclarationPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSStyleDeclarationPrototype* thisObject = jsCast<JSCSSStyleDeclarationPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSStyleDeclaration::s_info = { "CSSStyleDeclaration", &Base::s_info, &JSCSSStyleDeclarationTable, 0 , CREATE_METHOD_TABLE(JSCSSStyleDeclaration) };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSStyleDeclaration> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCSSStyleDeclaration::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSStyleDeclaration::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSStyleDeclarationPrototype::create(exec->globalData(), globalObject, JSCSSStyleDeclarationPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSCSSStyleDeclaration::destroy(JSC::JSCell* cell)
{
    JSCSSStyleDeclaration* thisObject = static_cast<JSCSSStyleDeclaration*>(cell);
    thisObject->JSCSSStyleDeclaration::~JSCSSStyleDeclaration();
}

JSCSSStyleDeclaration::~JSCSSStyleDeclaration()
{
    releaseImplIfNotNull();
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSCSSStyleDeclaration>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, thisObject, propertyName, slot);
}

bool JSCSSStyleDeclaration::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSStyleDeclaration* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSCSSStyleDeclarationTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<CSSStyleDeclaration*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, thisObject, propertyName, descriptor);
}

bool JSCSSStyleDeclaration::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsCSSStyleDeclarationCssText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->cssText());
    return result;
}


JSValue jsCSSStyleDeclarationLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsCSSStyleDeclarationParentRule(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentRule()));
    return result;
}


JSValue jsCSSStyleDeclarationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleDeclaration* domObject = jsCast<JSCSSStyleDeclaration*>(asObject(slotBase));
    return JSCSSStyleDeclaration::getConstructor(exec, domObject->globalObject());
}

void JSCSSStyleDeclaration::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    lookupPut<JSCSSStyleDeclaration, Base>(exec, propertyName, value, &JSCSSStyleDeclarationTable, thisObject, slot);
}

void JSCSSStyleDeclaration::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSCSSStyleDeclaration* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    PutPropertySlot slot(shouldThrow);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void setJSCSSStyleDeclarationCssText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(thisObject);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setCssText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSCSSStyleDeclaration::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleDeclarationConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getPropertyValue(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    return JSValue::encode(castedThis->getPropertyCSSValue(exec));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->removeProperty(propertyName, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getPropertyPriority(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionSetProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& priority(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setProperty(propertyName, value, priority, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getPropertyShorthand(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = jsCast<JSCSSStyleDeclaration*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSStyleDeclaration::s_info);
    CSSStyleDeclaration* impl = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPropertyImplicit(propertyName));
    return JSValue::encode(result);
}


JSValue JSCSSStyleDeclaration::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSCSSStyleDeclaration* thisObj = jsCast<JSCSSStyleDeclaration*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return jsStringOrUndefined(exec, thisObj->impl()->item(index));
}

static inline bool isObservable(JSCSSStyleDeclaration* jsCSSStyleDeclaration)
{
    if (jsCSSStyleDeclaration->hasCustomProperties())
        return true;
    return false;
}

bool JSCSSStyleDeclarationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCSSStyleDeclaration* jsCSSStyleDeclaration = jsCast<JSCSSStyleDeclaration*>(handle.get().asCell());
    if (!isObservable(jsCSSStyleDeclaration))
        return false;
    void* root = WebCore::root(jsCSSStyleDeclaration->impl());
    return visitor.containsOpaqueRoot(root);
}

void JSCSSStyleDeclarationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCSSStyleDeclaration* jsCSSStyleDeclaration = jsCast<JSCSSStyleDeclaration*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCSSStyleDeclaration->impl(), jsCSSStyleDeclaration);
    jsCSSStyleDeclaration->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CSSStyleDeclaration* impl)
{
    return wrap<JSCSSStyleDeclaration>(exec, globalObject, impl);
}

CSSStyleDeclaration* toCSSStyleDeclaration(JSC::JSValue value)
{
    return value.inherits(&JSCSSStyleDeclaration::s_info) ? jsCast<JSCSSStyleDeclaration*>(asObject(value))->impl() : 0;
}

}
