#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#define MIN(a,b) ((a)<(b) ? (a) : (b))
#define ZSTD_STATIC_LINKING_ONLY
#define ZSTD_DISABLE_DEPRECATE_WARNINGS
#include <zstd.h>
#define ZDICT_STATIC_LINKING_ONLY
#define ZDICT_DISABLE_DEPRECATE_WARNINGS
#include <zdict.h>


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(ZSTD_customMem)
/*  1 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // ZSTD_customMem
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(void *, size_t)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 642), // void *
/*  5 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(void)
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 299), // ZSTD_CCtx_params *()(void)
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 323), // ZSTD_CDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_CCtx_params const *, ZSTD_customMem)
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 642), // void const *
/* 13 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 14 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // ZSTD_dictLoadMethod_e
/* 15 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // ZSTD_dictContentType_e
/* 16 */ _CFFI_OP(_CFFI_OP_POINTER, 617), // ZSTD_CCtx_params const *
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 323), // ZSTD_CDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_compressionParameters, ZSTD_customMem)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 24 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // ZSTD_compressionParameters
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 323), // ZSTD_CDict *()(void const *, size_t, int)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 120), // ZSTD_CDict const *()(void *, size_t, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_compressionParameters)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(ZSTD_customMem)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(void *, size_t)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(void)
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 417), // ZSTD_DDict *()(void const *, size_t)
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 417), // ZSTD_DDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_customMem)
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 56 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 333), // ZSTD_DDict const *()(void *, size_t, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 63 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 622), // ZSTD_bounds()(ZSTD_cParameter)
/* 70 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // ZSTD_cParameter
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 622), // ZSTD_bounds()(ZSTD_dParameter)
/* 73 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // ZSTD_dParameter
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ZSTD_compressionParameters()(ZSTD_compressionParameters, unsigned long long, size_t)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12), // unsigned long long
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ZSTD_compressionParameters()(int, unsigned long long, size_t)
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 83 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 626), // ZSTD_frameProgression()(ZSTD_CCtx const *)
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 616), // ZSTD_CCtx const *
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 630), // ZSTD_nextInputType_e()(ZSTD_DCtx *)
/* 89 */ _CFFI_OP(_CFFI_OP_POINTER, 619), // ZSTD_DCtx *
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // ZSTD_parameters()(int, unsigned long long, size_t)
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 94 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION, 173), // ZSTD_threadPool *()(size_t)
/* 97 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 637), // char const *()(size_t)
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 637), // char const *()(void)
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // int()(void)
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *)
/* 107 */ _CFFI_OP(_CFFI_OP_POINTER, 616), // ZSTD_CCtx *
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CCtx const *, unsigned long long)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CCtx_params const *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CDict const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 120 */ _CFFI_OP(_CFFI_OP_POINTER, 618), // ZSTD_CDict const *
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CDict const *, ZSTD_frameParameters, unsigned long long)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 125 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // ZSTD_frameParameters
/* 126 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_ResetDirective)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 130 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // ZSTD_ResetDirective
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_Sequence *, size_t, void const *, size_t)
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 134 */ _CFFI_OP(_CFFI_OP_POINTER, 621), // ZSTD_Sequence *
/* 135 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_cParameter, int)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_compressionParameters)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_frameParameters)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 154 */ _CFFI_OP(_CFFI_OP_POINTER, 631), // ZSTD_outBuffer *
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 154),
/* 159 */ _CFFI_OP(_CFFI_OP_POINTER, 628), // ZSTD_inBuffer *
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *, ZSTD_EndDirective)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 154),
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 165 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ZSTD_EndDirective
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_parameters)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 169 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // ZSTD_parameters
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_threadPool *)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 173 */ _CFFI_OP(_CFFI_OP_POINTER, 636), // ZSTD_threadPool *
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, int)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, int, unsigned long long)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 182 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, unsigned long long)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, ZSTD_Sequence const *, size_t, void const *, size_t)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 192 */ _CFFI_OP(_CFFI_OP_POINTER, 621), // ZSTD_Sequence const *
/* 193 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, size_t *, void const *, size_t, size_t *, ZSTD_EndDirective)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 201 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // size_t *
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 203 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 201),
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 165),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 210 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, ZSTD_CDict const *)
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 219 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, ZSTD_CDict const *, ZSTD_frameParameters)
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, int)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, void const *, size_t, ZSTD_parameters)
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 244 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 246 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 169),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, void const *, size_t, int)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 251 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 252 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 254 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 255 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t)
/* 260 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 262 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_dictContentType_e)
/* 265 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 268 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 271 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 273 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_parameters, unsigned long long)
/* 278 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 280 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 281 */ _CFFI_OP(_CFFI_OP_NOOP, 169),
/* 282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, int)
/* 285 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 287 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 288 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx const *)
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx const *, ZSTD_cParameter, int *)
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 296 */ _CFFI_OP(_CFFI_OP_POINTER, 30), // int *
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *)
/* 299 */ _CFFI_OP(_CFFI_OP_POINTER, 617), // ZSTD_CCtx_params *
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, ZSTD_cParameter, int)
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 299),
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, ZSTD_parameters)
/* 307 */ _CFFI_OP(_CFFI_OP_NOOP, 299),
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 169),
/* 309 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, int)
/* 311 */ _CFFI_OP(_CFFI_OP_NOOP, 299),
/* 312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params const *)
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params const *, ZSTD_cParameter, int *)
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 296),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CDict *)
/* 323 */ _CFFI_OP(_CFFI_OP_POINTER, 618), // ZSTD_CDict *
/* 324 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CDict const *)
/* 326 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 328 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *)
/* 329 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_DDict const *)
/* 332 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 333 */ _CFFI_OP(_CFFI_OP_POINTER, 620), // ZSTD_DDict const *
/* 334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_ResetDirective)
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 337 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_dParameter, int *)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 73),
/* 342 */ _CFFI_OP(_CFFI_OP_NOOP, 296),
/* 343 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_dParameter, int)
/* 345 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 73),
/* 347 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 349 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_format_e)
/* 350 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 351 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // ZSTD_format_e
/* 352 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 353 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *)
/* 354 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 154),
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, size_t)
/* 359 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 360 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 362 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, size_t *, void const *, size_t, size_t *)
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 364 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 365 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 201),
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 369 */ _CFFI_OP(_CFFI_OP_NOOP, 201),
/* 370 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t)
/* 372 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 373 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 374 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 376 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t, ZSTD_DDict const *)
/* 379 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 380 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 381 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 382 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 383 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 384 */ _CFFI_OP(_CFFI_OP_NOOP, 333),
/* 385 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t, void const *, size_t)
/* 387 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 390 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 391 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 392 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 393 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 394 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 395 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t)
/* 396 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 397 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 398 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t, ZSTD_dictContentType_e)
/* 401 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 402 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 403 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 404 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 405 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 406 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 407 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 408 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 409 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 410 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 411 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 412 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 413 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx const *)
/* 414 */ _CFFI_OP(_CFFI_OP_POINTER, 619), // ZSTD_DCtx const *
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DDict *)
/* 417 */ _CFFI_OP(_CFFI_OP_POINTER, 620), // ZSTD_DDict *
/* 418 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 419 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DDict const *)
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 333),
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_Sequence *, size_t)
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 424 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 425 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 426 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_compressionParameters)
/* 427 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_frameHeader *, void const *, size_t)
/* 430 */ _CFFI_OP(_CFFI_OP_POINTER, 625), // ZSTD_frameHeader *
/* 431 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 432 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 433 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 434 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_frameHeader *, void const *, size_t, ZSTD_format_e)
/* 435 */ _CFFI_OP(_CFFI_OP_NOOP, 430),
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 437 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 438 */ _CFFI_OP(_CFFI_OP_NOOP, 351),
/* 439 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 440 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(int)
/* 441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 442 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 443 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t)
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 445 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 446 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, ZSTD_compressionParameters, ZSTD_dictLoadMethod_e)
/* 447 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 448 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 449 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 451 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, ZSTD_dictLoadMethod_e)
/* 452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 453 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 454 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 455 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, int)
/* 456 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 458 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(unsigned long long, unsigned long long)
/* 460 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 461 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 465 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 466 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 467 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 468 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 470 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 472 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 473 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, size_t, void const *, size_t const *, unsigned int)
/* 475 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 476 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 477 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 479 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // size_t const *
/* 480 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 482 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, unsigned int *, void const *, size_t)
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 484 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 485 */ _CFFI_OP(_CFFI_OP_POINTER, 480), // unsigned int *
/* 486 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 487 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 488 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 489 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int)
/* 490 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 492 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 493 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 494 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 495 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 496 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_cover_params_t *)
/* 497 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 498 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 500 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 502 */ _CFFI_OP(_CFFI_OP_POINTER, 510), // ZDICT_cover_params_t *
/* 503 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 504 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_cover_params_t)
/* 505 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 506 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 508 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 509 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 510 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // ZDICT_cover_params_t
/* 511 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_fastCover_params_t *)
/* 513 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 515 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 516 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 517 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 518 */ _CFFI_OP(_CFFI_OP_POINTER, 526), // ZDICT_fastCover_params_t *
/* 519 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 520 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_fastCover_params_t)
/* 521 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 522 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 523 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 524 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 525 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 526 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // ZDICT_fastCover_params_t
/* 527 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 528 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_legacy_params_t)
/* 529 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 531 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 532 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 533 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 534 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // ZDICT_legacy_params_t
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t)
/* 537 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 540 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 541 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 542 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, int)
/* 543 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 544 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 545 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 546 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 547 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 548 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 549 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, unsigned int)
/* 550 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 551 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 552 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 553 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 554 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 555 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 556 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, void const *, size_t const *, unsigned int, ZDICT_params_t)
/* 557 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 558 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 559 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 560 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 561 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 562 */ _CFFI_OP(_CFFI_OP_NOOP, 479),
/* 563 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 564 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // ZDICT_params_t
/* 565 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 566 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void const *, size_t)
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 568 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 569 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 570 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void)
/* 571 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION, 480), // unsigned int()(ZSTD_CDict const *)
/* 573 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 574 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 575 */ _CFFI_OP(_CFFI_OP_FUNCTION, 480), // unsigned int()(ZSTD_DDict const *)
/* 576 */ _CFFI_OP(_CFFI_OP_NOOP, 333),
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 480), // unsigned int()(size_t)
/* 579 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 580 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 581 */ _CFFI_OP(_CFFI_OP_FUNCTION, 480), // unsigned int()(void const *, size_t)
/* 582 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 583 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 584 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION, 480), // unsigned int()(void)
/* 586 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 587 */ _CFFI_OP(_CFFI_OP_FUNCTION, 77), // unsigned long long()(void const *, size_t)
/* 588 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 589 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 590 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 591 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // void *()(void *, size_t)
/* 592 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 593 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 594 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 595 */ _CFFI_OP(_CFFI_OP_FUNCTION, 642), // void()(ZSTD_CCtx *, void *, size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))
/* 596 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 597 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 598 */ _CFFI_OP(_CFFI_OP_POINTER, 463), // size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t)
/* 599 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 600 */ _CFFI_OP(_CFFI_OP_FUNCTION, 642), // void()(ZSTD_CCtx_params *, void *, size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))
/* 601 */ _CFFI_OP(_CFFI_OP_NOOP, 299),
/* 602 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 598),
/* 604 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION, 642), // void()(ZSTD_DCtx *, ZSTD_DCtx const *)
/* 606 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 414),
/* 608 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 609 */ _CFFI_OP(_CFFI_OP_FUNCTION, 642), // void()(ZSTD_threadPool *)
/* 610 */ _CFFI_OP(_CFFI_OP_NOOP, 173),
/* 611 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 612 */ _CFFI_OP(_CFFI_OP_FUNCTION, 642), // void()(void *, void *)
/* 613 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 614 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 615 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 616 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // ZSTD_CCtx
/* 617 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // ZSTD_CCtx_params
/* 618 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // ZSTD_CDict
/* 619 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // ZSTD_DCtx
/* 620 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // ZSTD_DDict
/* 621 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // ZSTD_Sequence
/* 622 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // ZSTD_bounds
/* 623 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // ZSTD_dictAttachPref_e
/* 624 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // ZSTD_forceIgnoreChecksum_e
/* 625 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // ZSTD_frameHeader
/* 626 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // ZSTD_frameProgression
/* 627 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // ZSTD_frameType_e
/* 628 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // ZSTD_inBuffer
/* 629 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // ZSTD_literalCompressionMode_e
/* 630 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // ZSTD_nextInputType_e
/* 631 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // ZSTD_outBuffer
/* 632 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // ZSTD_paramSwitch_e
/* 633 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // ZSTD_refMultipleDDicts_e
/* 634 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // ZSTD_sequenceFormat_e
/* 635 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // ZSTD_strategy
/* 636 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // ZSTD_threadPool
/* 637 */ _CFFI_OP(_CFFI_OP_POINTER, 638), // char const *
/* 638 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 639 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 640 */ _CFFI_OP(_CFFI_OP_POINTER, 591), // void *(*)(void *, size_t)
/* 641 */ _CFFI_OP(_CFFI_OP_POINTER, 612), // void(*)(void *, void *)
/* 642 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_cover_params_t(ZDICT_cover_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->k) | 0);  /* check that 'ZDICT_cover_params_t.k' is an integer */
  (void)((p->d) | 0);  /* check that 'ZDICT_cover_params_t.d' is an integer */
  (void)((p->steps) | 0);  /* check that 'ZDICT_cover_params_t.steps' is an integer */
  (void)((p->nbThreads) | 0);  /* check that 'ZDICT_cover_params_t.nbThreads' is an integer */
  { double *tmp = &p->splitPoint; (void)tmp; }
  (void)((p->shrinkDict) | 0);  /* check that 'ZDICT_cover_params_t.shrinkDict' is an integer */
  (void)((p->shrinkDictMaxRegression) | 0);  /* check that 'ZDICT_cover_params_t.shrinkDictMaxRegression' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_cover_params_t { char x; ZDICT_cover_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_fastCover_params_t(ZDICT_fastCover_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->k) | 0);  /* check that 'ZDICT_fastCover_params_t.k' is an integer */
  (void)((p->d) | 0);  /* check that 'ZDICT_fastCover_params_t.d' is an integer */
  (void)((p->f) | 0);  /* check that 'ZDICT_fastCover_params_t.f' is an integer */
  (void)((p->steps) | 0);  /* check that 'ZDICT_fastCover_params_t.steps' is an integer */
  (void)((p->nbThreads) | 0);  /* check that 'ZDICT_fastCover_params_t.nbThreads' is an integer */
  { double *tmp = &p->splitPoint; (void)tmp; }
  (void)((p->accel) | 0);  /* check that 'ZDICT_fastCover_params_t.accel' is an integer */
  (void)((p->shrinkDict) | 0);  /* check that 'ZDICT_fastCover_params_t.shrinkDict' is an integer */
  (void)((p->shrinkDictMaxRegression) | 0);  /* check that 'ZDICT_fastCover_params_t.shrinkDictMaxRegression' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_fastCover_params_t { char x; ZDICT_fastCover_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_legacy_params_t(ZDICT_legacy_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->selectivityLevel) | 0);  /* check that 'ZDICT_legacy_params_t.selectivityLevel' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_legacy_params_t { char x; ZDICT_legacy_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_params_t(ZDICT_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->compressionLevel) | 0);  /* check that 'ZDICT_params_t.compressionLevel' is an integer */
  (void)((p->notificationLevel) | 0);  /* check that 'ZDICT_params_t.notificationLevel' is an integer */
  (void)((p->dictID) | 0);  /* check that 'ZDICT_params_t.dictID' is an integer */
}
struct _cffi_align_typedef_ZDICT_params_t { char x; ZDICT_params_t y; };

static int _cffi_const_ZSTD_e_continue(unsigned long long *o)
{
  int n = (ZSTD_e_continue) <= 0;
  *o = (unsigned long long)((ZSTD_e_continue) | 0);  /* check that ZSTD_e_continue is an integer */
  return n;
}

static int _cffi_const_ZSTD_e_flush(unsigned long long *o)
{
  int n = (ZSTD_e_flush) <= 0;
  *o = (unsigned long long)((ZSTD_e_flush) | 0);  /* check that ZSTD_e_flush is an integer */
  return n;
}

static int _cffi_const_ZSTD_e_end(unsigned long long *o)
{
  int n = (ZSTD_e_end) <= 0;
  *o = (unsigned long long)((ZSTD_e_end) | 0);  /* check that ZSTD_e_end is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_session_only(unsigned long long *o)
{
  int n = (ZSTD_reset_session_only) <= 0;
  *o = (unsigned long long)((ZSTD_reset_session_only) | 0);  /* check that ZSTD_reset_session_only is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_parameters(unsigned long long *o)
{
  int n = (ZSTD_reset_parameters) <= 0;
  *o = (unsigned long long)((ZSTD_reset_parameters) | 0);  /* check that ZSTD_reset_parameters is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_session_and_parameters(unsigned long long *o)
{
  int n = (ZSTD_reset_session_and_parameters) <= 0;
  *o = (unsigned long long)((ZSTD_reset_session_and_parameters) | 0);  /* check that ZSTD_reset_session_and_parameters is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_Sequence(ZSTD_Sequence *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->offset) | 0);  /* check that 'ZSTD_Sequence.offset' is an integer */
  (void)((p->litLength) | 0);  /* check that 'ZSTD_Sequence.litLength' is an integer */
  (void)((p->matchLength) | 0);  /* check that 'ZSTD_Sequence.matchLength' is an integer */
  (void)((p->rep) | 0);  /* check that 'ZSTD_Sequence.rep' is an integer */
}
struct _cffi_align_typedef_ZSTD_Sequence { char x; ZSTD_Sequence y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_bounds(ZSTD_bounds *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->error) | 0);  /* check that 'ZSTD_bounds.error' is an integer */
  (void)((p->lowerBound) | 0);  /* check that 'ZSTD_bounds.lowerBound' is an integer */
  (void)((p->upperBound) | 0);  /* check that 'ZSTD_bounds.upperBound' is an integer */
}
struct _cffi_align_typedef_ZSTD_bounds { char x; ZSTD_bounds y; };

static int _cffi_const_ZSTD_c_compressionLevel(unsigned long long *o)
{
  int n = (ZSTD_c_compressionLevel) <= 0;
  *o = (unsigned long long)((ZSTD_c_compressionLevel) | 0);  /* check that ZSTD_c_compressionLevel is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_windowLog(unsigned long long *o)
{
  int n = (ZSTD_c_windowLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_windowLog) | 0);  /* check that ZSTD_c_windowLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_hashLog(unsigned long long *o)
{
  int n = (ZSTD_c_hashLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_hashLog) | 0);  /* check that ZSTD_c_hashLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_chainLog(unsigned long long *o)
{
  int n = (ZSTD_c_chainLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_chainLog) | 0);  /* check that ZSTD_c_chainLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_searchLog(unsigned long long *o)
{
  int n = (ZSTD_c_searchLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_searchLog) | 0);  /* check that ZSTD_c_searchLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_minMatch(unsigned long long *o)
{
  int n = (ZSTD_c_minMatch) <= 0;
  *o = (unsigned long long)((ZSTD_c_minMatch) | 0);  /* check that ZSTD_c_minMatch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_targetLength(unsigned long long *o)
{
  int n = (ZSTD_c_targetLength) <= 0;
  *o = (unsigned long long)((ZSTD_c_targetLength) | 0);  /* check that ZSTD_c_targetLength is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_strategy(unsigned long long *o)
{
  int n = (ZSTD_c_strategy) <= 0;
  *o = (unsigned long long)((ZSTD_c_strategy) | 0);  /* check that ZSTD_c_strategy is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_targetCBlockSize(unsigned long long *o)
{
  int n = (ZSTD_c_targetCBlockSize) <= 0;
  *o = (unsigned long long)((ZSTD_c_targetCBlockSize) | 0);  /* check that ZSTD_c_targetCBlockSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_enableLongDistanceMatching(unsigned long long *o)
{
  int n = (ZSTD_c_enableLongDistanceMatching) <= 0;
  *o = (unsigned long long)((ZSTD_c_enableLongDistanceMatching) | 0);  /* check that ZSTD_c_enableLongDistanceMatching is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmHashLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmHashLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmHashLog) | 0);  /* check that ZSTD_c_ldmHashLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmMinMatch(unsigned long long *o)
{
  int n = (ZSTD_c_ldmMinMatch) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmMinMatch) | 0);  /* check that ZSTD_c_ldmMinMatch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmBucketSizeLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmBucketSizeLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmBucketSizeLog) | 0);  /* check that ZSTD_c_ldmBucketSizeLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmHashRateLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmHashRateLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmHashRateLog) | 0);  /* check that ZSTD_c_ldmHashRateLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_contentSizeFlag(unsigned long long *o)
{
  int n = (ZSTD_c_contentSizeFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_contentSizeFlag) | 0);  /* check that ZSTD_c_contentSizeFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_checksumFlag(unsigned long long *o)
{
  int n = (ZSTD_c_checksumFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_checksumFlag) | 0);  /* check that ZSTD_c_checksumFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_dictIDFlag(unsigned long long *o)
{
  int n = (ZSTD_c_dictIDFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_dictIDFlag) | 0);  /* check that ZSTD_c_dictIDFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_nbWorkers(unsigned long long *o)
{
  int n = (ZSTD_c_nbWorkers) <= 0;
  *o = (unsigned long long)((ZSTD_c_nbWorkers) | 0);  /* check that ZSTD_c_nbWorkers is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_jobSize(unsigned long long *o)
{
  int n = (ZSTD_c_jobSize) <= 0;
  *o = (unsigned long long)((ZSTD_c_jobSize) | 0);  /* check that ZSTD_c_jobSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_overlapLog(unsigned long long *o)
{
  int n = (ZSTD_c_overlapLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_overlapLog) | 0);  /* check that ZSTD_c_overlapLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam1(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam1) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam1) | 0);  /* check that ZSTD_c_experimentalParam1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam2(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam2) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam2) | 0);  /* check that ZSTD_c_experimentalParam2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam3(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam3) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam3) | 0);  /* check that ZSTD_c_experimentalParam3 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam4(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam4) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam4) | 0);  /* check that ZSTD_c_experimentalParam4 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam5(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam5) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam5) | 0);  /* check that ZSTD_c_experimentalParam5 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam7(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam7) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam7) | 0);  /* check that ZSTD_c_experimentalParam7 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam8(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam8) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam8) | 0);  /* check that ZSTD_c_experimentalParam8 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam9(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam9) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam9) | 0);  /* check that ZSTD_c_experimentalParam9 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam10(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam10) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam10) | 0);  /* check that ZSTD_c_experimentalParam10 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam11(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam11) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam11) | 0);  /* check that ZSTD_c_experimentalParam11 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam12(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam12) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam12) | 0);  /* check that ZSTD_c_experimentalParam12 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam13(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam13) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam13) | 0);  /* check that ZSTD_c_experimentalParam13 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam14(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam14) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam14) | 0);  /* check that ZSTD_c_experimentalParam14 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam15(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam15) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam15) | 0);  /* check that ZSTD_c_experimentalParam15 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam16(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam16) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam16) | 0);  /* check that ZSTD_c_experimentalParam16 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam17(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam17) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam17) | 0);  /* check that ZSTD_c_experimentalParam17 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam18(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam18) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam18) | 0);  /* check that ZSTD_c_experimentalParam18 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam19(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam19) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam19) | 0);  /* check that ZSTD_c_experimentalParam19 is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_compressionParameters(ZSTD_compressionParameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->windowLog) | 0);  /* check that 'ZSTD_compressionParameters.windowLog' is an integer */
  (void)((p->chainLog) | 0);  /* check that 'ZSTD_compressionParameters.chainLog' is an integer */
  (void)((p->hashLog) | 0);  /* check that 'ZSTD_compressionParameters.hashLog' is an integer */
  (void)((p->searchLog) | 0);  /* check that 'ZSTD_compressionParameters.searchLog' is an integer */
  (void)((p->minMatch) | 0);  /* check that 'ZSTD_compressionParameters.minMatch' is an integer */
  (void)((p->targetLength) | 0);  /* check that 'ZSTD_compressionParameters.targetLength' is an integer */
  { ZSTD_strategy *tmp = &p->strategy; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_compressionParameters { char x; ZSTD_compressionParameters y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_customMem(ZSTD_customMem *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void *(* *tmp)(void *, size_t) = &p->customAlloc; (void)tmp; }
  { void(* *tmp)(void *, void *) = &p->customFree; (void)tmp; }
  { void * *tmp = &p->opaque; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_customMem { char x; ZSTD_customMem y; };

static int _cffi_const_ZSTD_d_windowLogMax(unsigned long long *o)
{
  int n = (ZSTD_d_windowLogMax) <= 0;
  *o = (unsigned long long)((ZSTD_d_windowLogMax) | 0);  /* check that ZSTD_d_windowLogMax is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam1(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam1) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam1) | 0);  /* check that ZSTD_d_experimentalParam1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam2(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam2) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam2) | 0);  /* check that ZSTD_d_experimentalParam2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam3(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam3) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam3) | 0);  /* check that ZSTD_d_experimentalParam3 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam4(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam4) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam4) | 0);  /* check that ZSTD_d_experimentalParam4 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam5(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam5) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam5) | 0);  /* check that ZSTD_d_experimentalParam5 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam6(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam6) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam6) | 0);  /* check that ZSTD_d_experimentalParam6 is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictDefaultAttach(unsigned long long *o)
{
  int n = (ZSTD_dictDefaultAttach) <= 0;
  *o = (unsigned long long)((ZSTD_dictDefaultAttach) | 0);  /* check that ZSTD_dictDefaultAttach is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceAttach(unsigned long long *o)
{
  int n = (ZSTD_dictForceAttach) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceAttach) | 0);  /* check that ZSTD_dictForceAttach is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceCopy(unsigned long long *o)
{
  int n = (ZSTD_dictForceCopy) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceCopy) | 0);  /* check that ZSTD_dictForceCopy is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceLoad(unsigned long long *o)
{
  int n = (ZSTD_dictForceLoad) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceLoad) | 0);  /* check that ZSTD_dictForceLoad is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_auto(unsigned long long *o)
{
  int n = (ZSTD_dct_auto) <= 0;
  *o = (unsigned long long)((ZSTD_dct_auto) | 0);  /* check that ZSTD_dct_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_rawContent(unsigned long long *o)
{
  int n = (ZSTD_dct_rawContent) <= 0;
  *o = (unsigned long long)((ZSTD_dct_rawContent) | 0);  /* check that ZSTD_dct_rawContent is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_fullDict(unsigned long long *o)
{
  int n = (ZSTD_dct_fullDict) <= 0;
  *o = (unsigned long long)((ZSTD_dct_fullDict) | 0);  /* check that ZSTD_dct_fullDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_dlm_byCopy(unsigned long long *o)
{
  int n = (ZSTD_dlm_byCopy) <= 0;
  *o = (unsigned long long)((ZSTD_dlm_byCopy) | 0);  /* check that ZSTD_dlm_byCopy is an integer */
  return n;
}

static int _cffi_const_ZSTD_dlm_byRef(unsigned long long *o)
{
  int n = (ZSTD_dlm_byRef) <= 0;
  *o = (unsigned long long)((ZSTD_dlm_byRef) | 0);  /* check that ZSTD_dlm_byRef is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_validateChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_validateChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_validateChecksum) | 0);  /* check that ZSTD_d_validateChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_ignoreChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_ignoreChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_ignoreChecksum) | 0);  /* check that ZSTD_d_ignoreChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_f_zstd1(unsigned long long *o)
{
  int n = (ZSTD_f_zstd1) <= 0;
  *o = (unsigned long long)((ZSTD_f_zstd1) | 0);  /* check that ZSTD_f_zstd1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_f_zstd1_magicless(unsigned long long *o)
{
  int n = (ZSTD_f_zstd1_magicless) <= 0;
  *o = (unsigned long long)((ZSTD_f_zstd1_magicless) | 0);  /* check that ZSTD_f_zstd1_magicless is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameHeader(ZSTD_frameHeader *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->frameContentSize) | 0);  /* check that 'ZSTD_frameHeader.frameContentSize' is an integer */
  (void)((p->windowSize) | 0);  /* check that 'ZSTD_frameHeader.windowSize' is an integer */
  (void)((p->blockSizeMax) | 0);  /* check that 'ZSTD_frameHeader.blockSizeMax' is an integer */
  { ZSTD_frameType_e *tmp = &p->frameType; (void)tmp; }
  (void)((p->headerSize) | 0);  /* check that 'ZSTD_frameHeader.headerSize' is an integer */
  (void)((p->dictID) | 0);  /* check that 'ZSTD_frameHeader.dictID' is an integer */
  (void)((p->checksumFlag) | 0);  /* check that 'ZSTD_frameHeader.checksumFlag' is an integer */
  (void)((p->_reserved1) | 0);  /* check that 'ZSTD_frameHeader._reserved1' is an integer */
  (void)((p->_reserved2) | 0);  /* check that 'ZSTD_frameHeader._reserved2' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameHeader { char x; ZSTD_frameHeader y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameParameters(ZSTD_frameParameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->contentSizeFlag) | 0);  /* check that 'ZSTD_frameParameters.contentSizeFlag' is an integer */
  (void)((p->checksumFlag) | 0);  /* check that 'ZSTD_frameParameters.checksumFlag' is an integer */
  (void)((p->noDictIDFlag) | 0);  /* check that 'ZSTD_frameParameters.noDictIDFlag' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameParameters { char x; ZSTD_frameParameters y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameProgression(ZSTD_frameProgression *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ingested) | 0);  /* check that 'ZSTD_frameProgression.ingested' is an integer */
  (void)((p->consumed) | 0);  /* check that 'ZSTD_frameProgression.consumed' is an integer */
  (void)((p->produced) | 0);  /* check that 'ZSTD_frameProgression.produced' is an integer */
  (void)((p->flushed) | 0);  /* check that 'ZSTD_frameProgression.flushed' is an integer */
  (void)((p->currentJobID) | 0);  /* check that 'ZSTD_frameProgression.currentJobID' is an integer */
  (void)((p->nbActiveWorkers) | 0);  /* check that 'ZSTD_frameProgression.nbActiveWorkers' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameProgression { char x; ZSTD_frameProgression y; };

static int _cffi_const_ZSTD_frame(unsigned long long *o)
{
  int n = (ZSTD_frame) <= 0;
  *o = (unsigned long long)((ZSTD_frame) | 0);  /* check that ZSTD_frame is an integer */
  return n;
}

static int _cffi_const_ZSTD_skippableFrame(unsigned long long *o)
{
  int n = (ZSTD_skippableFrame) <= 0;
  *o = (unsigned long long)((ZSTD_skippableFrame) | 0);  /* check that ZSTD_skippableFrame is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_auto(unsigned long long *o)
{
  int n = (ZSTD_lcm_auto) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_auto) | 0);  /* check that ZSTD_lcm_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_huffman(unsigned long long *o)
{
  int n = (ZSTD_lcm_huffman) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_huffman) | 0);  /* check that ZSTD_lcm_huffman is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_uncompressed(unsigned long long *o)
{
  int n = (ZSTD_lcm_uncompressed) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_uncompressed) | 0);  /* check that ZSTD_lcm_uncompressed is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_frameHeader(unsigned long long *o)
{
  int n = (ZSTDnit_frameHeader) <= 0;
  *o = (unsigned long long)((ZSTDnit_frameHeader) | 0);  /* check that ZSTDnit_frameHeader is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_blockHeader(unsigned long long *o)
{
  int n = (ZSTDnit_blockHeader) <= 0;
  *o = (unsigned long long)((ZSTDnit_blockHeader) | 0);  /* check that ZSTDnit_blockHeader is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_block(unsigned long long *o)
{
  int n = (ZSTDnit_block) <= 0;
  *o = (unsigned long long)((ZSTDnit_block) | 0);  /* check that ZSTDnit_block is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_lastBlock(unsigned long long *o)
{
  int n = (ZSTDnit_lastBlock) <= 0;
  *o = (unsigned long long)((ZSTDnit_lastBlock) | 0);  /* check that ZSTDnit_lastBlock is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_checksum(unsigned long long *o)
{
  int n = (ZSTDnit_checksum) <= 0;
  *o = (unsigned long long)((ZSTDnit_checksum) | 0);  /* check that ZSTDnit_checksum is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_skippableFrame(unsigned long long *o)
{
  int n = (ZSTDnit_skippableFrame) <= 0;
  *o = (unsigned long long)((ZSTDnit_skippableFrame) | 0);  /* check that ZSTDnit_skippableFrame is an integer */
  return n;
}

static int _cffi_const_ZSTD_ps_auto(unsigned long long *o)
{
  int n = (ZSTD_ps_auto) <= 0;
  *o = (unsigned long long)((ZSTD_ps_auto) | 0);  /* check that ZSTD_ps_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_ps_enable(unsigned long long *o)
{
  int n = (ZSTD_ps_enable) <= 0;
  *o = (unsigned long long)((ZSTD_ps_enable) | 0);  /* check that ZSTD_ps_enable is an integer */
  return n;
}

static int _cffi_const_ZSTD_ps_disable(unsigned long long *o)
{
  int n = (ZSTD_ps_disable) <= 0;
  *o = (unsigned long long)((ZSTD_ps_disable) | 0);  /* check that ZSTD_ps_disable is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_parameters(ZSTD_parameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { ZSTD_compressionParameters *tmp = &p->cParams; (void)tmp; }
  { ZSTD_frameParameters *tmp = &p->fParams; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_parameters { char x; ZSTD_parameters y; };

static int _cffi_const_ZSTD_rmd_refSingleDDict(unsigned long long *o)
{
  int n = (ZSTD_rmd_refSingleDDict) <= 0;
  *o = (unsigned long long)((ZSTD_rmd_refSingleDDict) | 0);  /* check that ZSTD_rmd_refSingleDDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_rmd_refMultipleDDicts(unsigned long long *o)
{
  int n = (ZSTD_rmd_refMultipleDDicts) <= 0;
  *o = (unsigned long long)((ZSTD_rmd_refMultipleDDicts) | 0);  /* check that ZSTD_rmd_refMultipleDDicts is an integer */
  return n;
}

static int _cffi_const_ZSTD_sf_noBlockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_sf_noBlockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_sf_noBlockDelimiters) | 0);  /* check that ZSTD_sf_noBlockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_sf_explicitBlockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_sf_explicitBlockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_sf_explicitBlockDelimiters) | 0);  /* check that ZSTD_sf_explicitBlockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_fast(unsigned long long *o)
{
  int n = (ZSTD_fast) <= 0;
  *o = (unsigned long long)((ZSTD_fast) | 0);  /* check that ZSTD_fast is an integer */
  return n;
}

static int _cffi_const_ZSTD_dfast(unsigned long long *o)
{
  int n = (ZSTD_dfast) <= 0;
  *o = (unsigned long long)((ZSTD_dfast) | 0);  /* check that ZSTD_dfast is an integer */
  return n;
}

static int _cffi_const_ZSTD_greedy(unsigned long long *o)
{
  int n = (ZSTD_greedy) <= 0;
  *o = (unsigned long long)((ZSTD_greedy) | 0);  /* check that ZSTD_greedy is an integer */
  return n;
}

static int _cffi_const_ZSTD_lazy(unsigned long long *o)
{
  int n = (ZSTD_lazy) <= 0;
  *o = (unsigned long long)((ZSTD_lazy) | 0);  /* check that ZSTD_lazy is an integer */
  return n;
}

static int _cffi_const_ZSTD_lazy2(unsigned long long *o)
{
  int n = (ZSTD_lazy2) <= 0;
  *o = (unsigned long long)((ZSTD_lazy2) | 0);  /* check that ZSTD_lazy2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_btlazy2(unsigned long long *o)
{
  int n = (ZSTD_btlazy2) <= 0;
  *o = (unsigned long long)((ZSTD_btlazy2) | 0);  /* check that ZSTD_btlazy2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_btopt(unsigned long long *o)
{
  int n = (ZSTD_btopt) <= 0;
  *o = (unsigned long long)((ZSTD_btopt) | 0);  /* check that ZSTD_btopt is an integer */
  return n;
}

static int _cffi_const_ZSTD_btultra(unsigned long long *o)
{
  int n = (ZSTD_btultra) <= 0;
  *o = (unsigned long long)((ZSTD_btultra) | 0);  /* check that ZSTD_btultra is an integer */
  return n;
}

static int _cffi_const_ZSTD_btultra2(unsigned long long *o)
{
  int n = (ZSTD_btultra2) <= 0;
  *o = (unsigned long long)((ZSTD_btultra2) | 0);  /* check that ZSTD_btultra2 is an integer */
  return n;
}

static void _cffi_const_ZSTD_defaultCMem(char *o)
{
  *(ZSTD_customMem *)o = ZSTD_defaultCMem;
}

static size_t _cffi_d_ZDICT_addEntropyTablesFromBuffer(void * x0, size_t x1, size_t x2, void const * x3, size_t const * x4, unsigned int x5)
{
  return ZDICT_addEntropyTablesFromBuffer(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_addEntropyTablesFromBuffer(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  size_t x2;
  void const * x3;
  size_t const * x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_addEntropyTablesFromBuffer", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_addEntropyTablesFromBuffer(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_addEntropyTablesFromBuffer _cffi_d_ZDICT_addEntropyTablesFromBuffer
#endif

static size_t _cffi_d_ZDICT_finalizeDictionary(void * x0, size_t x1, void const * x2, size_t x3, void const * x4, size_t const * x5, unsigned int x6, ZDICT_params_t x7)
{
  return ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_finalizeDictionary(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  void const * x4;
  size_t const * x5;
  unsigned int x6;
  ZDICT_params_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZDICT_finalizeDictionary", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(564), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_finalizeDictionary(void * x0, size_t x1, void const * x2, size_t x3, void const * x4, size_t const * x5, unsigned int x6, ZDICT_params_t *x7)
{
  size_t result;
  { result = ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, *x7); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_getDictHeaderSize(void const * x0, size_t x1)
{
  return ZDICT_getDictHeaderSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getDictHeaderSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZDICT_getDictHeaderSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getDictHeaderSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getDictHeaderSize _cffi_d_ZDICT_getDictHeaderSize
#endif

static unsigned int _cffi_d_ZDICT_getDictID(void const * x0, size_t x1)
{
  return ZDICT_getDictID(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getDictID(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZDICT_getDictID", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getDictID(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getDictID _cffi_d_ZDICT_getDictID
#endif

static char const * _cffi_d_ZDICT_getErrorName(size_t x0)
{
  return ZDICT_getErrorName(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getErrorName(PyObject *self, PyObject *arg0)
{
  size_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getErrorName(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(637));
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getErrorName _cffi_d_ZDICT_getErrorName
#endif

static unsigned int _cffi_d_ZDICT_isError(size_t x0)
{
  return ZDICT_isError(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_isError(PyObject *self, PyObject *arg0)
{
  size_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_isError(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_isError _cffi_d_ZDICT_isError
#endif

static size_t _cffi_d_ZDICT_optimizeTrainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t * x5)
{
  return ZDICT_optimizeTrainFromBuffer_cover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_optimizeTrainFromBuffer_cover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_cover_params_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_optimizeTrainFromBuffer_cover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(502), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZDICT_cover_params_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(502), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_optimizeTrainFromBuffer_cover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_optimizeTrainFromBuffer_cover _cffi_d_ZDICT_optimizeTrainFromBuffer_cover
#endif

static size_t _cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t * x5)
{
  return ZDICT_optimizeTrainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_fastCover_params_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_optimizeTrainFromBuffer_fastCover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZDICT_fastCover_params_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_optimizeTrainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover _cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4)
{
  return ZDICT_trainFromBuffer(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_trainFromBuffer _cffi_d_ZDICT_trainFromBuffer
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t x5)
{
  return ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_cover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_cover_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_cover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(510), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t x5)
{
  return ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_fastCover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_fastCover_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_fastCover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(526), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_legacy(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_legacy_params_t x5)
{
  return ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_legacy(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_legacy_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_legacy", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(479), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(479), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(534), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_legacy(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_legacy_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtxParams_getParameter(ZSTD_CCtx_params const * x0, ZSTD_cParameter x1, int * x2)
{
  return ZSTD_CCtxParams_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params const * x0;
  ZSTD_cParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(296), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(296), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_getParameter _cffi_d_ZSTD_CCtxParams_getParameter
#endif

static size_t _cffi_d_ZSTD_CCtxParams_init(ZSTD_CCtx_params * x0, int x1)
{
  return ZSTD_CCtxParams_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_init(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_init _cffi_d_ZSTD_CCtxParams_init
#endif

static size_t _cffi_d_ZSTD_CCtxParams_init_advanced(ZSTD_CCtx_params * x0, ZSTD_parameters x1)
{
  return ZSTD_CCtxParams_init_advanced(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_init_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  ZSTD_parameters x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_init_advanced", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(169), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_init_advanced(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_CCtxParams_init_advanced(ZSTD_CCtx_params * x0, ZSTD_parameters *x1)
{
  size_t result;
  { result = ZSTD_CCtxParams_init_advanced(x0, *x1); }
  return result;
}
#endif

static void _cffi_d_ZSTD_CCtxParams_registerSequenceProducer(ZSTD_CCtx_params * x0, void * x1, size_t(* x2)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))
{
  ZSTD_CCtxParams_registerSequenceProducer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_registerSequenceProducer(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  void * x1;
  size_t(* x2)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_registerSequenceProducer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))_cffi_to_c_pointer(arg2, _cffi_type(598));
  if (x2 == (size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_CCtxParams_registerSequenceProducer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_registerSequenceProducer _cffi_d_ZSTD_CCtxParams_registerSequenceProducer
#endif

static size_t _cffi_d_ZSTD_CCtxParams_reset(ZSTD_CCtx_params * x0)
{
  return ZSTD_CCtxParams_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_reset(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_reset _cffi_d_ZSTD_CCtxParams_reset
#endif

static size_t _cffi_d_ZSTD_CCtxParams_setParameter(ZSTD_CCtx_params * x0, ZSTD_cParameter x1, int x2)
{
  return ZSTD_CCtxParams_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  ZSTD_cParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_setParameter _cffi_d_ZSTD_CCtxParams_setParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_getParameter(ZSTD_CCtx const * x0, ZSTD_cParameter x1, int * x2)
{
  return ZSTD_CCtx_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx const * x0;
  ZSTD_cParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(296), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(296), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_getParameter _cffi_d_ZSTD_CCtx_getParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_loadDictionary(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary _cffi_d_ZSTD_CCtx_loadDictionary
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_dictLoadMethod_e x3, ZSTD_dictContentType_e x4)
{
  return ZSTD_CCtx_loadDictionary_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictLoadMethod_e x3;
  ZSTD_dictContentType_e x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(14), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(15), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary_advanced _cffi_d_ZSTD_CCtx_loadDictionary_advanced
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary_byReference(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_loadDictionary_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary_byReference(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary_byReference _cffi_d_ZSTD_CCtx_loadDictionary_byReference
#endif

static size_t _cffi_d_ZSTD_CCtx_refCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_CCtx_refCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refCDict _cffi_d_ZSTD_CCtx_refCDict
#endif

static size_t _cffi_d_ZSTD_CCtx_refPrefix(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_refPrefix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refPrefix(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refPrefix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refPrefix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refPrefix _cffi_d_ZSTD_CCtx_refPrefix
#endif

static size_t _cffi_d_ZSTD_CCtx_refPrefix_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_dictContentType_e x3)
{
  return ZSTD_CCtx_refPrefix_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refPrefix_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictContentType_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refPrefix_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refPrefix_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refPrefix_advanced _cffi_d_ZSTD_CCtx_refPrefix_advanced
#endif

static size_t _cffi_d_ZSTD_CCtx_refThreadPool(ZSTD_CCtx * x0, ZSTD_threadPool * x1)
{
  return ZSTD_CCtx_refThreadPool(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refThreadPool(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_threadPool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refThreadPool", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(173), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_threadPool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(173), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refThreadPool(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refThreadPool _cffi_d_ZSTD_CCtx_refThreadPool
#endif

static size_t _cffi_d_ZSTD_CCtx_reset(ZSTD_CCtx * x0, ZSTD_ResetDirective x1)
{
  return ZSTD_CCtx_reset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_reset(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_ResetDirective x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_reset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(130), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_reset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_reset _cffi_d_ZSTD_CCtx_reset
#endif

static size_t _cffi_d_ZSTD_CCtx_setCParams(ZSTD_CCtx * x0, ZSTD_compressionParameters x1)
{
  return ZSTD_CCtx_setCParams(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setCParams(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_compressionParameters x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setCParams", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(24), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setCParams(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_CCtx_setCParams(ZSTD_CCtx * x0, ZSTD_compressionParameters *x1)
{
  size_t result;
  { result = ZSTD_CCtx_setCParams(x0, *x1); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtx_setFParams(ZSTD_CCtx * x0, ZSTD_frameParameters x1)
{
  return ZSTD_CCtx_setFParams(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setFParams(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_frameParameters x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setFParams", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(125), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setFParams(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_CCtx_setFParams(ZSTD_CCtx * x0, ZSTD_frameParameters *x1)
{
  size_t result;
  { result = ZSTD_CCtx_setFParams(x0, *x1); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtx_setParameter(ZSTD_CCtx * x0, ZSTD_cParameter x1, int x2)
{
  return ZSTD_CCtx_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_cParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setParameter _cffi_d_ZSTD_CCtx_setParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams(ZSTD_CCtx * x0, ZSTD_CCtx_params const * x1)
{
  return ZSTD_CCtx_setParametersUsingCCtxParams(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CCtx_params const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setParametersUsingCCtxParams", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setParametersUsingCCtxParams(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams _cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams
#endif

static size_t _cffi_d_ZSTD_CCtx_setParams(ZSTD_CCtx * x0, ZSTD_parameters x1)
{
  return ZSTD_CCtx_setParams(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setParams(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_parameters x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setParams", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(169), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setParams(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_CCtx_setParams(ZSTD_CCtx * x0, ZSTD_parameters *x1)
{
  size_t result;
  { result = ZSTD_CCtx_setParams(x0, *x1); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtx_setPledgedSrcSize(ZSTD_CCtx * x0, unsigned long long x1)
{
  return ZSTD_CCtx_setPledgedSrcSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setPledgedSrcSize(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setPledgedSrcSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setPledgedSrcSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setPledgedSrcSize _cffi_d_ZSTD_CCtx_setPledgedSrcSize
#endif

static size_t _cffi_d_ZSTD_CStreamInSize(void)
{
  return ZSTD_CStreamInSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CStreamInSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CStreamInSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CStreamInSize _cffi_d_ZSTD_CStreamInSize
#endif

static size_t _cffi_d_ZSTD_CStreamOutSize(void)
{
  return ZSTD_CStreamOutSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CStreamOutSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CStreamOutSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CStreamOutSize _cffi_d_ZSTD_CStreamOutSize
#endif

static size_t _cffi_d_ZSTD_DCtx_getParameter(ZSTD_DCtx * x0, ZSTD_dParameter x1, int * x2)
{
  return ZSTD_DCtx_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_dParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(73), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(296), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(296), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_getParameter _cffi_d_ZSTD_DCtx_getParameter
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_loadDictionary(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary _cffi_d_ZSTD_DCtx_loadDictionary
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary_advanced(ZSTD_DCtx * x0, void const * x1, size_t x2, ZSTD_dictLoadMethod_e x3, ZSTD_dictContentType_e x4)
{
  return ZSTD_DCtx_loadDictionary_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary_advanced(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictLoadMethod_e x3;
  ZSTD_dictContentType_e x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(14), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(15), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary_advanced _cffi_d_ZSTD_DCtx_loadDictionary_advanced
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary_byReference(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_loadDictionary_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary_byReference(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary_byReference _cffi_d_ZSTD_DCtx_loadDictionary_byReference
#endif

static size_t _cffi_d_ZSTD_DCtx_refDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_DCtx_refDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refDDict _cffi_d_ZSTD_DCtx_refDDict
#endif

static size_t _cffi_d_ZSTD_DCtx_refPrefix(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_refPrefix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refPrefix(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refPrefix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refPrefix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refPrefix _cffi_d_ZSTD_DCtx_refPrefix
#endif

static size_t _cffi_d_ZSTD_DCtx_refPrefix_advanced(ZSTD_DCtx * x0, void const * x1, size_t x2, ZSTD_dictContentType_e x3)
{
  return ZSTD_DCtx_refPrefix_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refPrefix_advanced(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictContentType_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refPrefix_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refPrefix_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refPrefix_advanced _cffi_d_ZSTD_DCtx_refPrefix_advanced
#endif

static size_t _cffi_d_ZSTD_DCtx_reset(ZSTD_DCtx * x0, ZSTD_ResetDirective x1)
{
  return ZSTD_DCtx_reset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_reset(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_ResetDirective x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_reset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(130), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_reset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_reset _cffi_d_ZSTD_DCtx_reset
#endif

static size_t _cffi_d_ZSTD_DCtx_setFormat(ZSTD_DCtx * x0, ZSTD_format_e x1)
{
  return ZSTD_DCtx_setFormat(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setFormat(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_format_e x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setFormat", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(351), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setFormat(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setFormat _cffi_d_ZSTD_DCtx_setFormat
#endif

static size_t _cffi_d_ZSTD_DCtx_setMaxWindowSize(ZSTD_DCtx * x0, size_t x1)
{
  return ZSTD_DCtx_setMaxWindowSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setMaxWindowSize(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setMaxWindowSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setMaxWindowSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setMaxWindowSize _cffi_d_ZSTD_DCtx_setMaxWindowSize
#endif

static size_t _cffi_d_ZSTD_DCtx_setParameter(ZSTD_DCtx * x0, ZSTD_dParameter x1, int x2)
{
  return ZSTD_DCtx_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_dParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(73), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setParameter _cffi_d_ZSTD_DCtx_setParameter
#endif

static size_t _cffi_d_ZSTD_DStreamInSize(void)
{
  return ZSTD_DStreamInSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DStreamInSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DStreamInSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DStreamInSize _cffi_d_ZSTD_DStreamInSize
#endif

static size_t _cffi_d_ZSTD_DStreamOutSize(void)
{
  return ZSTD_DStreamOutSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DStreamOutSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DStreamOutSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DStreamOutSize _cffi_d_ZSTD_DStreamOutSize
#endif

static ZSTD_compressionParameters _cffi_d_ZSTD_adjustCParams(ZSTD_compressionParameters x0, unsigned long long x1, size_t x2)
{
  return ZSTD_adjustCParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_adjustCParams(PyObject *self, PyObject *args)
{
  ZSTD_compressionParameters x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_compressionParameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_adjustCParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_adjustCParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(24));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_adjustCParams(ZSTD_compressionParameters *result, ZSTD_compressionParameters *x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_adjustCParams(*x0, x1, x2); }
}
#endif

static ZSTD_bounds _cffi_d_ZSTD_cParam_getBounds(ZSTD_cParameter x0)
{
  return ZSTD_cParam_getBounds(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_cParam_getBounds(PyObject *self, PyObject *arg0)
{
  ZSTD_cParameter x0;
  ZSTD_bounds result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(70), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_cParam_getBounds(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(622));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_cParam_getBounds(ZSTD_bounds *result, ZSTD_cParameter x0)
{
  { *result = ZSTD_cParam_getBounds(x0); }
}
#endif

static size_t _cffi_d_ZSTD_checkCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_checkCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_checkCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_checkCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_checkCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_checkCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress(void * x0, size_t x1, void const * x2, size_t x3, int x4)
{
  return ZSTD_compress(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress _cffi_d_ZSTD_compress
#endif

static size_t _cffi_d_ZSTD_compress2(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compress2(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress2(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress2", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress2(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress2 _cffi_d_ZSTD_compress2
#endif

static size_t _cffi_d_ZSTD_compressBegin(ZSTD_CCtx * x0, int x1)
{
  return ZSTD_compressBegin(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin _cffi_d_ZSTD_compressBegin
#endif

static size_t _cffi_d_ZSTD_compressBegin_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters x3, unsigned long long x4)
{
  return ZSTD_compressBegin_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_parameters x3;
  unsigned long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(169), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compressBegin_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters *x3, unsigned long long x4)
{
  size_t result;
  { result = ZSTD_compressBegin_advanced(x0, x1, x2, *x3, x4); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_compressBegin_usingCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin_usingCDict _cffi_d_ZSTD_compressBegin_usingCDict
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters x2, unsigned long long x3)
{
  return ZSTD_compressBegin_usingCDict_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  ZSTD_frameParameters x2;
  unsigned long long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingCDict_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(125), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingCDict_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compressBegin_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters *x2, unsigned long long x3)
{
  size_t result;
  { result = ZSTD_compressBegin_usingCDict_advanced(x0, x1, *x2, x3); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingDict(ZSTD_CCtx * x0, void const * x1, size_t x2, int x3)
{
  return ZSTD_compressBegin_usingDict(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingDict", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingDict(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin_usingDict _cffi_d_ZSTD_compressBegin_usingDict
#endif

static size_t _cffi_d_ZSTD_compressBlock(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressBlock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBlock(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBlock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBlock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBlock _cffi_d_ZSTD_compressBlock
#endif

static size_t _cffi_d_ZSTD_compressBound(size_t x0)
{
  return ZSTD_compressBound(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBound(PyObject *self, PyObject *arg0)
{
  size_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBound(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBound _cffi_d_ZSTD_compressBound
#endif

static size_t _cffi_d_ZSTD_compressCCtx(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, int x5)
{
  return ZSTD_compressCCtx(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressCCtx(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressCCtx", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressCCtx(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressCCtx _cffi_d_ZSTD_compressCCtx
#endif

static size_t _cffi_d_ZSTD_compressContinue(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressContinue(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressContinue(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressContinue", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressContinue(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressContinue _cffi_d_ZSTD_compressContinue
#endif

static size_t _cffi_d_ZSTD_compressEnd(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressEnd(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressEnd(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressEnd", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressEnd(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressEnd _cffi_d_ZSTD_compressEnd
#endif

static size_t _cffi_d_ZSTD_compressSequences(ZSTD_CCtx * x0, void * x1, size_t x2, ZSTD_Sequence const * x3, size_t x4, void const * x5, size_t x6)
{
  return ZSTD_compressSequences(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressSequences(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  ZSTD_Sequence const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressSequences", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressSequences(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressSequences _cffi_d_ZSTD_compressSequences
#endif

static size_t _cffi_d_ZSTD_compressStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2)
{
  return ZSTD_compressStream(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream _cffi_d_ZSTD_compressStream
#endif

static size_t _cffi_d_ZSTD_compressStream2(ZSTD_CCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2, ZSTD_EndDirective x3)
{
  return ZSTD_compressStream2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream2(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  ZSTD_EndDirective x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x3, _cffi_type(165), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream2 _cffi_d_ZSTD_compressStream2
#endif

static size_t _cffi_d_ZSTD_compressStream2_simpleArgs(ZSTD_CCtx * x0, void * x1, size_t x2, size_t * x3, void const * x4, size_t x5, size_t * x6, ZSTD_EndDirective x7)
{
  return ZSTD_compressStream2_simpleArgs(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream2_simpleArgs(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  size_t * x3;
  void const * x4;
  size_t x5;
  size_t * x6;
  ZSTD_EndDirective x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream2_simpleArgs", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x7, _cffi_type(165), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream2_simpleArgs(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream2_simpleArgs _cffi_d_ZSTD_compressStream2_simpleArgs
#endif

static size_t _cffi_d_ZSTD_compress_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, ZSTD_parameters x7)
{
  return ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  ZSTD_parameters x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_advanced", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(169), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compress_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, ZSTD_parameters *x7)
{
  size_t result;
  { result = ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, *x7); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress_usingCDict(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5)
{
  return ZSTD_compress_usingCDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_CDict const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingCDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingCDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress_usingCDict _cffi_d_ZSTD_compress_usingCDict
#endif

static size_t _cffi_d_ZSTD_compress_usingCDict_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5, ZSTD_frameParameters x6)
{
  return ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_CDict const * x5;
  ZSTD_frameParameters x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingCDict_advanced", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x6, _cffi_type(125), arg6) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compress_usingCDict_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5, ZSTD_frameParameters *x6)
{
  size_t result;
  { result = ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, *x6); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress_usingDict(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, int x7)
{
  return ZSTD_compress_usingDict(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingDict", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingDict(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress_usingDict _cffi_d_ZSTD_compress_usingDict
#endif

static size_t _cffi_d_ZSTD_copyCCtx(ZSTD_CCtx * x0, ZSTD_CCtx const * x1, unsigned long long x2)
{
  return ZSTD_copyCCtx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_copyCCtx(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CCtx const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_copyCCtx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_copyCCtx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_copyCCtx _cffi_d_ZSTD_copyCCtx
#endif

static void _cffi_d_ZSTD_copyDCtx(ZSTD_DCtx * x0, ZSTD_DCtx const * x1)
{
  ZSTD_copyDCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_copyDCtx(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DCtx const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_copyDCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(414), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(414), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_copyDCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_copyDCtx _cffi_d_ZSTD_copyDCtx
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCCtx(void)
{
  return ZSTD_createCCtx();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtx(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtx(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCCtx _cffi_d_ZSTD_createCCtx
#endif

static ZSTD_CCtx_params * _cffi_d_ZSTD_createCCtxParams(void)
{
  return ZSTD_createCCtxParams();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtxParams(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx_params * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtxParams(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(299));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCCtxParams _cffi_d_ZSTD_createCCtxParams
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCCtx_advanced(ZSTD_customMem x0)
{
  return ZSTD_createCCtx_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtx_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_CCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtx_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
static ZSTD_CCtx * _cffi_f_ZSTD_createCCtx_advanced(ZSTD_customMem *x0)
{
  ZSTD_CCtx * result;
  { result = ZSTD_createCCtx_advanced(*x0); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict(void const * x0, size_t x1, int x2)
{
  return ZSTD_createCDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(323));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCDict _cffi_d_ZSTD_createCDict
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_compressionParameters x4, ZSTD_customMem x5)
{
  return ZSTD_createCDict_advanced(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_advanced(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_compressionParameters x4;
  ZSTD_customMem x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_advanced", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(24), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(1), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_advanced(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(323));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict * _cffi_f_ZSTD_createCDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_compressionParameters *x4, ZSTD_customMem *x5)
{
  ZSTD_CDict * result;
  { result = ZSTD_createCDict_advanced(x0, x1, x2, x3, *x4, *x5); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_advanced2(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_CCtx_params const * x4, ZSTD_customMem x5)
{
  return ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_advanced2(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_CCtx_params const * x4;
  ZSTD_customMem x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_advanced2", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x5, _cffi_type(1), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(323));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict * _cffi_f_ZSTD_createCDict_advanced2(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_CCtx_params const * x4, ZSTD_customMem *x5)
{
  ZSTD_CDict * result;
  { result = ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_byReference(void const * x0, size_t x1, int x2)
{
  return ZSTD_createCDict_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_byReference(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(323));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCDict_byReference _cffi_d_ZSTD_createCDict_byReference
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCStream(void)
{
  return ZSTD_createCStream();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCStream(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCStream(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCStream _cffi_d_ZSTD_createCStream
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCStream_advanced(ZSTD_customMem x0)
{
  return ZSTD_createCStream_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCStream_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_CCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCStream_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
static ZSTD_CCtx * _cffi_f_ZSTD_createCStream_advanced(ZSTD_customMem *x0)
{
  ZSTD_CCtx * result;
  { result = ZSTD_createCStream_advanced(*x0); }
  return result;
}
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDCtx(void)
{
  return ZSTD_createDCtx();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDCtx(PyObject *self, PyObject *noarg)
{
  ZSTD_DCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDCtx(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDCtx _cffi_d_ZSTD_createDCtx
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDCtx_advanced(ZSTD_customMem x0)
{
  return ZSTD_createDCtx_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDCtx_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_DCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDCtx_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
static ZSTD_DCtx * _cffi_f_ZSTD_createDCtx_advanced(ZSTD_customMem *x0)
{
  ZSTD_DCtx * result;
  { result = ZSTD_createDCtx_advanced(*x0); }
  return result;
}
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict(void const * x0, size_t x1)
{
  return ZSTD_createDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(417));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDDict _cffi_d_ZSTD_createDDict
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_customMem x4)
{
  return ZSTD_createDDict_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict_advanced(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_customMem x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(1), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(417));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_DDict * _cffi_f_ZSTD_createDDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_customMem *x4)
{
  ZSTD_DDict * result;
  { result = ZSTD_createDDict_advanced(x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict_byReference(void const * x0, size_t x1)
{
  return ZSTD_createDDict_byReference(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict_byReference(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict_byReference", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict_byReference(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(417));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDDict_byReference _cffi_d_ZSTD_createDDict_byReference
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDStream(void)
{
  return ZSTD_createDStream();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDStream(PyObject *self, PyObject *noarg)
{
  ZSTD_DCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDStream(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDStream _cffi_d_ZSTD_createDStream
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDStream_advanced(ZSTD_customMem x0)
{
  return ZSTD_createDStream_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDStream_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_DCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDStream_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
static ZSTD_DCtx * _cffi_f_ZSTD_createDStream_advanced(ZSTD_customMem *x0)
{
  ZSTD_DCtx * result;
  { result = ZSTD_createDStream_advanced(*x0); }
  return result;
}
#endif

static ZSTD_threadPool * _cffi_d_ZSTD_createThreadPool(size_t x0)
{
  return ZSTD_createThreadPool(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createThreadPool(PyObject *self, PyObject *arg0)
{
  size_t x0;
  ZSTD_threadPool * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createThreadPool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(173));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createThreadPool _cffi_d_ZSTD_createThreadPool
#endif

static ZSTD_bounds _cffi_d_ZSTD_dParam_getBounds(ZSTD_dParameter x0)
{
  return ZSTD_dParam_getBounds(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_dParam_getBounds(PyObject *self, PyObject *arg0)
{
  ZSTD_dParameter x0;
  ZSTD_bounds result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(73), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_dParam_getBounds(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(622));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_dParam_getBounds(ZSTD_bounds *result, ZSTD_dParameter x0)
{
  { *result = ZSTD_dParam_getBounds(x0); }
}
#endif

static size_t _cffi_d_ZSTD_decodingBufferSize_min(unsigned long long x0, unsigned long long x1)
{
  return ZSTD_decodingBufferSize_min(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decodingBufferSize_min(PyObject *self, PyObject *args)
{
  unsigned long long x0;
  unsigned long long x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decodingBufferSize_min", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned long long);
  if (x0 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decodingBufferSize_min(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decodingBufferSize_min _cffi_d_ZSTD_decodingBufferSize_min
#endif

static size_t _cffi_d_ZSTD_decompress(void * x0, size_t x1, void const * x2, size_t x3)
{
  return ZSTD_decompress(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress _cffi_d_ZSTD_decompress
#endif

static size_t _cffi_d_ZSTD_decompressBegin(ZSTD_DCtx * x0)
{
  return ZSTD_decompressBegin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin _cffi_d_ZSTD_decompressBegin
#endif

static size_t _cffi_d_ZSTD_decompressBegin_usingDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_decompressBegin_usingDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBegin_usingDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin_usingDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin_usingDDict _cffi_d_ZSTD_decompressBegin_usingDDict
#endif

static size_t _cffi_d_ZSTD_decompressBegin_usingDict(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_decompressBegin_usingDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBegin_usingDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin_usingDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin_usingDict _cffi_d_ZSTD_decompressBegin_usingDict
#endif

static size_t _cffi_d_ZSTD_decompressBlock(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressBlock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBlock(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBlock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBlock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBlock _cffi_d_ZSTD_decompressBlock
#endif

static unsigned long long _cffi_d_ZSTD_decompressBound(void const * x0, size_t x1)
{
  return ZSTD_decompressBound(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBound(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBound", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBound(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBound _cffi_d_ZSTD_decompressBound
#endif

static size_t _cffi_d_ZSTD_decompressContinue(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressContinue(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressContinue(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressContinue", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressContinue(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressContinue _cffi_d_ZSTD_decompressContinue
#endif

static size_t _cffi_d_ZSTD_decompressDCtx(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressDCtx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressDCtx(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressDCtx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressDCtx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressDCtx _cffi_d_ZSTD_decompressDCtx
#endif

static size_t _cffi_d_ZSTD_decompressStream(ZSTD_DCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2)
{
  return ZSTD_decompressStream(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressStream(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressStream", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressStream(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressStream _cffi_d_ZSTD_decompressStream
#endif

static size_t _cffi_d_ZSTD_decompressStream_simpleArgs(ZSTD_DCtx * x0, void * x1, size_t x2, size_t * x3, void const * x4, size_t x5, size_t * x6)
{
  return ZSTD_decompressStream_simpleArgs(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressStream_simpleArgs(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  size_t * x3;
  void const * x4;
  size_t x5;
  size_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressStream_simpleArgs", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressStream_simpleArgs(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressStream_simpleArgs _cffi_d_ZSTD_decompressStream_simpleArgs
#endif

static size_t _cffi_d_ZSTD_decompress_usingDDict(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_DDict const * x5)
{
  return ZSTD_decompress_usingDDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_DDict const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress_usingDDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress_usingDDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress_usingDDict _cffi_d_ZSTD_decompress_usingDDict
#endif

static size_t _cffi_d_ZSTD_decompress_usingDict(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6)
{
  return ZSTD_decompress_usingDict(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress_usingDict", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress_usingDict(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress_usingDict _cffi_d_ZSTD_decompress_usingDict
#endif

static size_t _cffi_d_ZSTD_decompressionMargin(void const * x0, size_t x1)
{
  return ZSTD_decompressionMargin(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressionMargin(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressionMargin", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressionMargin(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressionMargin _cffi_d_ZSTD_decompressionMargin
#endif

static int _cffi_d_ZSTD_defaultCLevel(void)
{
  return ZSTD_defaultCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_defaultCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_defaultCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_defaultCLevel _cffi_d_ZSTD_defaultCLevel
#endif

static size_t _cffi_d_ZSTD_endStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1)
{
  return ZSTD_endStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_endStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_endStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_endStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_endStream _cffi_d_ZSTD_endStream
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize(int x0)
{
  return ZSTD_estimateCCtxSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize(PyObject *self, PyObject *arg0)
{
  int x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCCtxSize _cffi_d_ZSTD_estimateCCtxSize
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams(ZSTD_CCtx_params const * x0)
{
  return ZSTD_estimateCCtxSize_usingCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize_usingCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams _cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize_usingCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_estimateCCtxSize_usingCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize_usingCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize_usingCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCCtxSize_usingCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_estimateCCtxSize_usingCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateCDictSize(size_t x0, int x1)
{
  return ZSTD_estimateCDictSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCDictSize(PyObject *self, PyObject *args)
{
  size_t x0;
  int x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateCDictSize", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCDictSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCDictSize _cffi_d_ZSTD_estimateCDictSize
#endif

static size_t _cffi_d_ZSTD_estimateCDictSize_advanced(size_t x0, ZSTD_compressionParameters x1, ZSTD_dictLoadMethod_e x2)
{
  return ZSTD_estimateCDictSize_advanced(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCDictSize_advanced(PyObject *self, PyObject *args)
{
  size_t x0;
  ZSTD_compressionParameters x1;
  ZSTD_dictLoadMethod_e x2;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateCDictSize_advanced", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(24), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCDictSize_advanced(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCDictSize_advanced(size_t x0, ZSTD_compressionParameters *x1, ZSTD_dictLoadMethod_e x2)
{
  size_t result;
  { result = ZSTD_estimateCDictSize_advanced(x0, *x1, x2); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize(int x0)
{
  return ZSTD_estimateCStreamSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize(PyObject *self, PyObject *arg0)
{
  int x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCStreamSize _cffi_d_ZSTD_estimateCStreamSize
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams(ZSTD_CCtx_params const * x0)
{
  return ZSTD_estimateCStreamSize_usingCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize_usingCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams _cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize_usingCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_estimateCStreamSize_usingCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize_usingCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize_usingCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCStreamSize_usingCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_estimateCStreamSize_usingCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateDCtxSize(void)
{
  return ZSTD_estimateDCtxSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDCtxSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDCtxSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDCtxSize _cffi_d_ZSTD_estimateDCtxSize
#endif

static size_t _cffi_d_ZSTD_estimateDDictSize(size_t x0, ZSTD_dictLoadMethod_e x1)
{
  return ZSTD_estimateDDictSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDDictSize(PyObject *self, PyObject *args)
{
  size_t x0;
  ZSTD_dictLoadMethod_e x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateDDictSize", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(14), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDDictSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDDictSize _cffi_d_ZSTD_estimateDDictSize
#endif

static size_t _cffi_d_ZSTD_estimateDStreamSize(size_t x0)
{
  return ZSTD_estimateDStreamSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDStreamSize(PyObject *self, PyObject *arg0)
{
  size_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDStreamSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDStreamSize _cffi_d_ZSTD_estimateDStreamSize
#endif

static size_t _cffi_d_ZSTD_estimateDStreamSize_fromFrame(void const * x0, size_t x1)
{
  return ZSTD_estimateDStreamSize_fromFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDStreamSize_fromFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateDStreamSize_fromFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDStreamSize_fromFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDStreamSize_fromFrame _cffi_d_ZSTD_estimateDStreamSize_fromFrame
#endif

static unsigned long long _cffi_d_ZSTD_findDecompressedSize(void const * x0, size_t x1)
{
  return ZSTD_findDecompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_findDecompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_findDecompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_findDecompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_findDecompressedSize _cffi_d_ZSTD_findDecompressedSize
#endif

static size_t _cffi_d_ZSTD_findFrameCompressedSize(void const * x0, size_t x1)
{
  return ZSTD_findFrameCompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_findFrameCompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_findFrameCompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_findFrameCompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_findFrameCompressedSize _cffi_d_ZSTD_findFrameCompressedSize
#endif

static size_t _cffi_d_ZSTD_flushStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1)
{
  return ZSTD_flushStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_flushStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_flushStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_flushStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_flushStream _cffi_d_ZSTD_flushStream
#endif

static size_t _cffi_d_ZSTD_frameHeaderSize(void const * x0, size_t x1)
{
  return ZSTD_frameHeaderSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_frameHeaderSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_frameHeaderSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_frameHeaderSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_frameHeaderSize _cffi_d_ZSTD_frameHeaderSize
#endif

static size_t _cffi_d_ZSTD_freeCCtx(ZSTD_CCtx * x0)
{
  return ZSTD_freeCCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCCtx _cffi_d_ZSTD_freeCCtx
#endif

static size_t _cffi_d_ZSTD_freeCCtxParams(ZSTD_CCtx_params * x0)
{
  return ZSTD_freeCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(299), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(299), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCCtxParams _cffi_d_ZSTD_freeCCtxParams
#endif

static size_t _cffi_d_ZSTD_freeCDict(ZSTD_CDict * x0)
{
  return ZSTD_freeCDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(323), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(323), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCDict _cffi_d_ZSTD_freeCDict
#endif

static size_t _cffi_d_ZSTD_freeCStream(ZSTD_CCtx * x0)
{
  return ZSTD_freeCStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCStream(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCStream _cffi_d_ZSTD_freeCStream
#endif

static size_t _cffi_d_ZSTD_freeDCtx(ZSTD_DCtx * x0)
{
  return ZSTD_freeDCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDCtx _cffi_d_ZSTD_freeDCtx
#endif

static size_t _cffi_d_ZSTD_freeDDict(ZSTD_DDict * x0)
{
  return ZSTD_freeDDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(417), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(417), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDDict _cffi_d_ZSTD_freeDDict
#endif

static size_t _cffi_d_ZSTD_freeDStream(ZSTD_DCtx * x0)
{
  return ZSTD_freeDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDStream _cffi_d_ZSTD_freeDStream
#endif

static void _cffi_d_ZSTD_freeThreadPool(ZSTD_threadPool * x0)
{
  ZSTD_freeThreadPool(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeThreadPool(PyObject *self, PyObject *arg0)
{
  ZSTD_threadPool * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(173), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_threadPool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(173), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_freeThreadPool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_freeThreadPool _cffi_d_ZSTD_freeThreadPool
#endif

static size_t _cffi_d_ZSTD_generateSequences(ZSTD_CCtx * x0, ZSTD_Sequence * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_generateSequences(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_generateSequences(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_Sequence * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_generateSequences", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_generateSequences(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_generateSequences _cffi_d_ZSTD_generateSequences
#endif

static size_t _cffi_d_ZSTD_getBlockSize(ZSTD_CCtx const * x0)
{
  return ZSTD_getBlockSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getBlockSize(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getBlockSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getBlockSize _cffi_d_ZSTD_getBlockSize
#endif

static ZSTD_compressionParameters _cffi_d_ZSTD_getCParams(int x0, unsigned long long x1, size_t x2)
{
  return ZSTD_getCParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getCParams(PyObject *self, PyObject *args)
{
  int x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_compressionParameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getCParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getCParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(24));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getCParams(ZSTD_compressionParameters *result, int x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_getCParams(x0, x1, x2); }
}
#endif

static unsigned long long _cffi_d_ZSTD_getDecompressedSize(void const * x0, size_t x1)
{
  return ZSTD_getDecompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDecompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDecompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDecompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDecompressedSize _cffi_d_ZSTD_getDecompressedSize
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromCDict(ZSTD_CDict const * x0)
{
  return ZSTD_getDictID_fromCDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromCDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromCDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromCDict _cffi_d_ZSTD_getDictID_fromCDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromDDict(ZSTD_DDict const * x0)
{
  return ZSTD_getDictID_fromDDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromDDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromDDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromDDict _cffi_d_ZSTD_getDictID_fromDDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromDict(void const * x0, size_t x1)
{
  return ZSTD_getDictID_fromDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDictID_fromDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromDict _cffi_d_ZSTD_getDictID_fromDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromFrame(void const * x0, size_t x1)
{
  return ZSTD_getDictID_fromFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDictID_fromFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromFrame _cffi_d_ZSTD_getDictID_fromFrame
#endif

static char const * _cffi_d_ZSTD_getErrorName(size_t x0)
{
  return ZSTD_getErrorName(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getErrorName(PyObject *self, PyObject *arg0)
{
  size_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getErrorName(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(637));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getErrorName _cffi_d_ZSTD_getErrorName
#endif

static unsigned long long _cffi_d_ZSTD_getFrameContentSize(void const * x0, size_t x1)
{
  return ZSTD_getFrameContentSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameContentSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameContentSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameContentSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameContentSize _cffi_d_ZSTD_getFrameContentSize
#endif

static size_t _cffi_d_ZSTD_getFrameHeader(ZSTD_frameHeader * x0, void const * x1, size_t x2)
{
  return ZSTD_getFrameHeader(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameHeader(PyObject *self, PyObject *args)
{
  ZSTD_frameHeader * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameHeader", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(430), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_frameHeader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(430), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameHeader(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameHeader _cffi_d_ZSTD_getFrameHeader
#endif

static size_t _cffi_d_ZSTD_getFrameHeader_advanced(ZSTD_frameHeader * x0, void const * x1, size_t x2, ZSTD_format_e x3)
{
  return ZSTD_getFrameHeader_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameHeader_advanced(PyObject *self, PyObject *args)
{
  ZSTD_frameHeader * x0;
  void const * x1;
  size_t x2;
  ZSTD_format_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameHeader_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(430), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_frameHeader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(430), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(351), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameHeader_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameHeader_advanced _cffi_d_ZSTD_getFrameHeader_advanced
#endif

static ZSTD_frameProgression _cffi_d_ZSTD_getFrameProgression(ZSTD_CCtx const * x0)
{
  return ZSTD_getFrameProgression(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameProgression(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_frameProgression result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameProgression(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(626));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getFrameProgression(ZSTD_frameProgression *result, ZSTD_CCtx const * x0)
{
  { *result = ZSTD_getFrameProgression(x0); }
}
#endif

static ZSTD_parameters _cffi_d_ZSTD_getParams(int x0, unsigned long long x1, size_t x2)
{
  return ZSTD_getParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getParams(PyObject *self, PyObject *args)
{
  int x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_parameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(169));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getParams(ZSTD_parameters *result, int x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_getParams(x0, x1, x2); }
}
#endif

static size_t _cffi_d_ZSTD_initCStream(ZSTD_CCtx * x0, int x1)
{
  return ZSTD_initCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream _cffi_d_ZSTD_initCStream
#endif

static size_t _cffi_d_ZSTD_initCStream_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters x3, unsigned long long x4)
{
  return ZSTD_initCStream_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_parameters x3;
  unsigned long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(169), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_initCStream_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters *x3, unsigned long long x4)
{
  size_t result;
  { result = ZSTD_initCStream_advanced(x0, x1, x2, *x3, x4); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_initCStream_srcSize(ZSTD_CCtx * x0, int x1, unsigned long long x2)
{
  return ZSTD_initCStream_srcSize(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_srcSize(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_srcSize", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_srcSize(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_srcSize _cffi_d_ZSTD_initCStream_srcSize
#endif

static size_t _cffi_d_ZSTD_initCStream_usingCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_initCStream_usingCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_usingCDict _cffi_d_ZSTD_initCStream_usingCDict
#endif

static size_t _cffi_d_ZSTD_initCStream_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters x2, unsigned long long x3)
{
  return ZSTD_initCStream_usingCDict_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  ZSTD_frameParameters x2;
  unsigned long long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingCDict_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(125), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingCDict_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_initCStream_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters *x2, unsigned long long x3)
{
  size_t result;
  { result = ZSTD_initCStream_usingCDict_advanced(x0, x1, *x2, x3); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_initCStream_usingDict(ZSTD_CCtx * x0, void const * x1, size_t x2, int x3)
{
  return ZSTD_initCStream_usingDict(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingDict", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingDict(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_usingDict _cffi_d_ZSTD_initCStream_usingDict
#endif

static size_t _cffi_d_ZSTD_initDStream(ZSTD_DCtx * x0)
{
  return ZSTD_initDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream _cffi_d_ZSTD_initDStream
#endif

static size_t _cffi_d_ZSTD_initDStream_usingDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_initDStream_usingDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initDStream_usingDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream_usingDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream_usingDDict _cffi_d_ZSTD_initDStream_usingDDict
#endif

static size_t _cffi_d_ZSTD_initDStream_usingDict(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_initDStream_usingDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_initDStream_usingDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream_usingDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream_usingDict _cffi_d_ZSTD_initDStream_usingDict
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_initStaticCCtx(void * x0, size_t x1)
{
  return ZSTD_initStaticCCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCCtx(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticCCtx _cffi_d_ZSTD_initStaticCCtx
#endif

static ZSTD_CDict const * _cffi_d_ZSTD_initStaticCDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5, ZSTD_compressionParameters x6)
{
  return ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCDict(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  ZSTD_dictLoadMethod_e x4;
  ZSTD_dictContentType_e x5;
  ZSTD_compressionParameters x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCDict", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(14), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(15), arg5) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x6, _cffi_type(24), arg6) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(120));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict const * _cffi_f_ZSTD_initStaticCDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5, ZSTD_compressionParameters *x6)
{
  ZSTD_CDict const * result;
  { result = ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, *x6); }
  return result;
}
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_initStaticCStream(void * x0, size_t x1)
{
  return ZSTD_initStaticCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCStream(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticCStream _cffi_d_ZSTD_initStaticCStream
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_initStaticDCtx(void * x0, size_t x1)
{
  return ZSTD_initStaticDCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDCtx(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDCtx _cffi_d_ZSTD_initStaticDCtx
#endif

static ZSTD_DDict const * _cffi_d_ZSTD_initStaticDDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5)
{
  return ZSTD_initStaticDDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDDict(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  ZSTD_dictLoadMethod_e x4;
  ZSTD_dictContentType_e x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(14), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(15), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(333));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDDict _cffi_d_ZSTD_initStaticDDict
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_initStaticDStream(void * x0, size_t x1)
{
  return ZSTD_initStaticDStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDStream(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDStream _cffi_d_ZSTD_initStaticDStream
#endif

static size_t _cffi_d_ZSTD_insertBlock(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_insertBlock(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_insertBlock(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_insertBlock", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_insertBlock(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_insertBlock _cffi_d_ZSTD_insertBlock
#endif

static unsigned int _cffi_d_ZSTD_isError(size_t x0)
{
  return ZSTD_isError(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_isError(PyObject *self, PyObject *arg0)
{
  size_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_isError(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_isError _cffi_d_ZSTD_isError
#endif

static unsigned int _cffi_d_ZSTD_isFrame(void const * x0, size_t x1)
{
  return ZSTD_isFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_isFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_isFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_isFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_isFrame _cffi_d_ZSTD_isFrame
#endif

static unsigned int _cffi_d_ZSTD_isSkippableFrame(void const * x0, size_t x1)
{
  return ZSTD_isSkippableFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_isSkippableFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_isSkippableFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_isSkippableFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_isSkippableFrame _cffi_d_ZSTD_isSkippableFrame
#endif

static int _cffi_d_ZSTD_maxCLevel(void)
{
  return ZSTD_maxCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_maxCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_maxCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_maxCLevel _cffi_d_ZSTD_maxCLevel
#endif

static size_t _cffi_d_ZSTD_mergeBlockDelimiters(ZSTD_Sequence * x0, size_t x1)
{
  return ZSTD_mergeBlockDelimiters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_mergeBlockDelimiters(PyObject *self, PyObject *args)
{
  ZSTD_Sequence * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_mergeBlockDelimiters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_mergeBlockDelimiters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_mergeBlockDelimiters _cffi_d_ZSTD_mergeBlockDelimiters
#endif

static int _cffi_d_ZSTD_minCLevel(void)
{
  return ZSTD_minCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_minCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_minCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_minCLevel _cffi_d_ZSTD_minCLevel
#endif

static ZSTD_nextInputType_e _cffi_d_ZSTD_nextInputType(ZSTD_DCtx * x0)
{
  return ZSTD_nextInputType(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_nextInputType(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_nextInputType_e result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_nextInputType(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(630));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_nextInputType _cffi_d_ZSTD_nextInputType
#endif

static size_t _cffi_d_ZSTD_nextSrcSizeToDecompress(ZSTD_DCtx * x0)
{
  return ZSTD_nextSrcSizeToDecompress(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_nextSrcSizeToDecompress(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_nextSrcSizeToDecompress(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_nextSrcSizeToDecompress _cffi_d_ZSTD_nextSrcSizeToDecompress
#endif

static size_t _cffi_d_ZSTD_readSkippableFrame(void * x0, size_t x1, unsigned int * x2, void const * x3, size_t x4)
{
  return ZSTD_readSkippableFrame(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_readSkippableFrame(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  unsigned int * x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_readSkippableFrame", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(485), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(485), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_readSkippableFrame(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_readSkippableFrame _cffi_d_ZSTD_readSkippableFrame
#endif

static void _cffi_d_ZSTD_registerSequenceProducer(ZSTD_CCtx * x0, void * x1, size_t(* x2)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))
{
  ZSTD_registerSequenceProducer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_registerSequenceProducer(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t(* x2)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_registerSequenceProducer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))_cffi_to_c_pointer(arg2, _cffi_type(598));
  if (x2 == (size_t(*)(void *, ZSTD_Sequence *, size_t, void const *, size_t, void const *, size_t, int, size_t))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_registerSequenceProducer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_registerSequenceProducer _cffi_d_ZSTD_registerSequenceProducer
#endif

static size_t _cffi_d_ZSTD_resetCStream(ZSTD_CCtx * x0, unsigned long long x1)
{
  return ZSTD_resetCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_resetCStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_resetCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_resetCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_resetCStream _cffi_d_ZSTD_resetCStream
#endif

static size_t _cffi_d_ZSTD_resetDStream(ZSTD_DCtx * x0)
{
  return ZSTD_resetDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_resetDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_resetDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_resetDStream _cffi_d_ZSTD_resetDStream
#endif

static size_t _cffi_d_ZSTD_sequenceBound(size_t x0)
{
  return ZSTD_sequenceBound(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sequenceBound(PyObject *self, PyObject *arg0)
{
  size_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sequenceBound(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sequenceBound _cffi_d_ZSTD_sequenceBound
#endif

static size_t _cffi_d_ZSTD_sizeof_CCtx(ZSTD_CCtx const * x0)
{
  return ZSTD_sizeof_CCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CCtx _cffi_d_ZSTD_sizeof_CCtx
#endif

static size_t _cffi_d_ZSTD_sizeof_CDict(ZSTD_CDict const * x0)
{
  return ZSTD_sizeof_CDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CDict _cffi_d_ZSTD_sizeof_CDict
#endif

static size_t _cffi_d_ZSTD_sizeof_CStream(ZSTD_CCtx const * x0)
{
  return ZSTD_sizeof_CStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CStream(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CStream _cffi_d_ZSTD_sizeof_CStream
#endif

static size_t _cffi_d_ZSTD_sizeof_DCtx(ZSTD_DCtx const * x0)
{
  return ZSTD_sizeof_DCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(414), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(414), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DCtx _cffi_d_ZSTD_sizeof_DCtx
#endif

static size_t _cffi_d_ZSTD_sizeof_DDict(ZSTD_DDict const * x0)
{
  return ZSTD_sizeof_DDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(333), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(333), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DDict _cffi_d_ZSTD_sizeof_DDict
#endif

static size_t _cffi_d_ZSTD_sizeof_DStream(ZSTD_DCtx const * x0)
{
  return ZSTD_sizeof_DStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(414), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(414), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DStream _cffi_d_ZSTD_sizeof_DStream
#endif

static size_t _cffi_d_ZSTD_toFlushNow(ZSTD_CCtx * x0)
{
  return ZSTD_toFlushNow(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_toFlushNow(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_toFlushNow(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_toFlushNow _cffi_d_ZSTD_toFlushNow
#endif

static unsigned int _cffi_d_ZSTD_versionNumber(void)
{
  return ZSTD_versionNumber();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_versionNumber(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_versionNumber(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_versionNumber _cffi_d_ZSTD_versionNumber
#endif

static char const * _cffi_d_ZSTD_versionString(void)
{
  return ZSTD_versionString();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_versionString(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_versionString(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(637));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_versionString _cffi_d_ZSTD_versionString
#endif

static size_t _cffi_d_ZSTD_writeSkippableFrame(void * x0, size_t x1, void const * x2, size_t x3, unsigned int x4)
{
  return ZSTD_writeSkippableFrame(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_writeSkippableFrame(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_writeSkippableFrame", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_writeSkippableFrame(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_writeSkippableFrame _cffi_d_ZSTD_writeSkippableFrame
#endif

static int _cffi_const_ZDICT_CONTENTSIZE_MIN(unsigned long long *o)
{
  int n = (ZDICT_CONTENTSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZDICT_CONTENTSIZE_MIN) | 0);  /* check that ZDICT_CONTENTSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZDICT_DICTSIZE_MIN(unsigned long long *o)
{
  int n = (ZDICT_DICTSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZDICT_DICTSIZE_MIN) | 0);  /* check that ZDICT_DICTSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_BLOCKSIZELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_BLOCKSIZELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_BLOCKSIZELOG_MAX) | 0);  /* check that ZSTD_BLOCKSIZELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_BLOCKSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_BLOCKSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_BLOCKSIZE_MAX) | 0);  /* check that ZSTD_BLOCKSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_BLOCKSIZE_MAX_MIN(unsigned long long *o)
{
  int n = (ZSTD_BLOCKSIZE_MAX_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_BLOCKSIZE_MAX_MIN) | 0);  /* check that ZSTD_BLOCKSIZE_MAX_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX) | 0);  /* check that ZSTD_CHAINLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX_32(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX_32) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX_32) | 0);  /* check that ZSTD_CHAINLOG_MAX_32 is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX_64(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX_64) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX_64) | 0);  /* check that ZSTD_CHAINLOG_MAX_64 is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MIN) | 0);  /* check that ZSTD_CHAINLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_CONTENTSIZE_ERROR(unsigned long long *o)
{
  int n = (ZSTD_CONTENTSIZE_ERROR) <= 0;
  *o = (unsigned long long)((ZSTD_CONTENTSIZE_ERROR) | 0);  /* check that ZSTD_CONTENTSIZE_ERROR is an integer */
  return n;
}

static int _cffi_const_ZSTD_CONTENTSIZE_UNKNOWN(unsigned long long *o)
{
  int n = (ZSTD_CONTENTSIZE_UNKNOWN) <= 0;
  *o = (unsigned long long)((ZSTD_CONTENTSIZE_UNKNOWN) | 0);  /* check that ZSTD_CONTENTSIZE_UNKNOWN is an integer */
  return n;
}

static int _cffi_const_ZSTD_FRAMEHEADERSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_FRAMEHEADERSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_FRAMEHEADERSIZE_MAX) | 0);  /* check that ZSTD_FRAMEHEADERSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_HASHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_HASHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_HASHLOG_MAX) | 0);  /* check that ZSTD_HASHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_HASHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_HASHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_HASHLOG_MIN) | 0);  /* check that ZSTD_HASHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_BUCKETSIZELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_BUCKETSIZELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_BUCKETSIZELOG_MAX) | 0);  /* check that ZSTD_LDM_BUCKETSIZELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_BUCKETSIZELOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_BUCKETSIZELOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_BUCKETSIZELOG_MIN) | 0);  /* check that ZSTD_LDM_BUCKETSIZELOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHLOG_MAX) | 0);  /* check that ZSTD_LDM_HASHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHLOG_MIN) | 0);  /* check that ZSTD_LDM_HASHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHRATELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHRATELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHRATELOG_MAX) | 0);  /* check that ZSTD_LDM_HASHRATELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHRATELOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHRATELOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHRATELOG_MIN) | 0);  /* check that ZSTD_LDM_HASHRATELOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_MINMATCH_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_MINMATCH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_MINMATCH_MAX) | 0);  /* check that ZSTD_LDM_MINMATCH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_MINMATCH_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_MINMATCH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_MINMATCH_MIN) | 0);  /* check that ZSTD_LDM_MINMATCH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGICNUMBER(unsigned long long *o)
{
  int n = (ZSTD_MAGICNUMBER) <= 0;
  *o = (unsigned long long)((ZSTD_MAGICNUMBER) | 0);  /* check that ZSTD_MAGICNUMBER is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_DICTIONARY(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_DICTIONARY) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_DICTIONARY) | 0);  /* check that ZSTD_MAGIC_DICTIONARY is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_SKIPPABLE_MASK(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_SKIPPABLE_MASK) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_SKIPPABLE_MASK) | 0);  /* check that ZSTD_MAGIC_SKIPPABLE_MASK is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_SKIPPABLE_START(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_SKIPPABLE_START) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_SKIPPABLE_START) | 0);  /* check that ZSTD_MAGIC_SKIPPABLE_START is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAX_INPUT_SIZE(unsigned long long *o)
{
  int n = (ZSTD_MAX_INPUT_SIZE) <= 0;
  *o = (unsigned long long)((ZSTD_MAX_INPUT_SIZE) | 0);  /* check that ZSTD_MAX_INPUT_SIZE is an integer */
  return n;
}

static int _cffi_const_ZSTD_MINMATCH_MAX(unsigned long long *o)
{
  int n = (ZSTD_MINMATCH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_MINMATCH_MAX) | 0);  /* check that ZSTD_MINMATCH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_MINMATCH_MIN(unsigned long long *o)
{
  int n = (ZSTD_MINMATCH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_MINMATCH_MIN) | 0);  /* check that ZSTD_MINMATCH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_OVERLAPLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_OVERLAPLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_OVERLAPLOG_MAX) | 0);  /* check that ZSTD_OVERLAPLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_OVERLAPLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_OVERLAPLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_OVERLAPLOG_MIN) | 0);  /* check that ZSTD_OVERLAPLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_SEARCHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_SEARCHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_SEARCHLOG_MAX) | 0);  /* check that ZSTD_SEARCHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_SEARCHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_SEARCHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_SEARCHLOG_MIN) | 0);  /* check that ZSTD_SEARCHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_SEQUENCE_PRODUCER_ERROR(unsigned long long *o)
{
  int n = (ZSTD_SEQUENCE_PRODUCER_ERROR) <= 0;
  *o = (unsigned long long)((ZSTD_SEQUENCE_PRODUCER_ERROR) | 0);  /* check that ZSTD_SEQUENCE_PRODUCER_ERROR is an integer */
  return n;
}

static int _cffi_const_ZSTD_SKIPPABLEHEADERSIZE(unsigned long long *o)
{
  int n = (ZSTD_SKIPPABLEHEADERSIZE) <= 0;
  *o = (unsigned long long)((ZSTD_SKIPPABLEHEADERSIZE) | 0);  /* check that ZSTD_SKIPPABLEHEADERSIZE is an integer */
  return n;
}

static int _cffi_const_ZSTD_SRCSIZEHINT_MAX(unsigned long long *o)
{
  int n = (ZSTD_SRCSIZEHINT_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_SRCSIZEHINT_MAX) | 0);  /* check that ZSTD_SRCSIZEHINT_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_SRCSIZEHINT_MIN(unsigned long long *o)
{
  int n = (ZSTD_SRCSIZEHINT_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_SRCSIZEHINT_MIN) | 0);  /* check that ZSTD_SRCSIZEHINT_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_STRATEGY_MAX(unsigned long long *o)
{
  int n = (ZSTD_STRATEGY_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_STRATEGY_MAX) | 0);  /* check that ZSTD_STRATEGY_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_STRATEGY_MIN(unsigned long long *o)
{
  int n = (ZSTD_STRATEGY_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_STRATEGY_MIN) | 0);  /* check that ZSTD_STRATEGY_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETCBLOCKSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_TARGETCBLOCKSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETCBLOCKSIZE_MAX) | 0);  /* check that ZSTD_TARGETCBLOCKSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETCBLOCKSIZE_MIN(unsigned long long *o)
{
  int n = (ZSTD_TARGETCBLOCKSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETCBLOCKSIZE_MIN) | 0);  /* check that ZSTD_TARGETCBLOCKSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETLENGTH_MAX(unsigned long long *o)
{
  int n = (ZSTD_TARGETLENGTH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETLENGTH_MAX) | 0);  /* check that ZSTD_TARGETLENGTH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETLENGTH_MIN(unsigned long long *o)
{
  int n = (ZSTD_TARGETLENGTH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETLENGTH_MIN) | 0);  /* check that ZSTD_TARGETLENGTH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_MAJOR(unsigned long long *o)
{
  int n = (ZSTD_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_MAJOR) | 0);  /* check that ZSTD_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_MINOR(unsigned long long *o)
{
  int n = (ZSTD_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_MINOR) | 0);  /* check that ZSTD_VERSION_MINOR is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_NUMBER(unsigned long long *o)
{
  int n = (ZSTD_VERSION_NUMBER) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_NUMBER) | 0);  /* check that ZSTD_VERSION_NUMBER is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_RELEASE(unsigned long long *o)
{
  int n = (ZSTD_VERSION_RELEASE) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_RELEASE) | 0);  /* check that ZSTD_VERSION_RELEASE is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_LIMIT_DEFAULT(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_LIMIT_DEFAULT) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_LIMIT_DEFAULT) | 0);  /* check that ZSTD_WINDOWLOG_LIMIT_DEFAULT is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX) | 0);  /* check that ZSTD_WINDOWLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX_32(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX_32) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX_32) | 0);  /* check that ZSTD_WINDOWLOG_MAX_32 is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX_64(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX_64) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX_64) | 0);  /* check that ZSTD_WINDOWLOG_MAX_64 is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MIN) | 0);  /* check that ZSTD_WINDOWLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_blockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_c_blockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_c_blockDelimiters) | 0);  /* check that ZSTD_c_blockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_deterministicRefPrefix(unsigned long long *o)
{
  int n = (ZSTD_c_deterministicRefPrefix) <= 0;
  *o = (unsigned long long)((ZSTD_c_deterministicRefPrefix) | 0);  /* check that ZSTD_c_deterministicRefPrefix is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_enableDedicatedDictSearch(unsigned long long *o)
{
  int n = (ZSTD_c_enableDedicatedDictSearch) <= 0;
  *o = (unsigned long long)((ZSTD_c_enableDedicatedDictSearch) | 0);  /* check that ZSTD_c_enableDedicatedDictSearch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_enableSeqProducerFallback(unsigned long long *o)
{
  int n = (ZSTD_c_enableSeqProducerFallback) <= 0;
  *o = (unsigned long long)((ZSTD_c_enableSeqProducerFallback) | 0);  /* check that ZSTD_c_enableSeqProducerFallback is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_forceAttachDict(unsigned long long *o)
{
  int n = (ZSTD_c_forceAttachDict) <= 0;
  *o = (unsigned long long)((ZSTD_c_forceAttachDict) | 0);  /* check that ZSTD_c_forceAttachDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_forceMaxWindow(unsigned long long *o)
{
  int n = (ZSTD_c_forceMaxWindow) <= 0;
  *o = (unsigned long long)((ZSTD_c_forceMaxWindow) | 0);  /* check that ZSTD_c_forceMaxWindow is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_format(unsigned long long *o)
{
  int n = (ZSTD_c_format) <= 0;
  *o = (unsigned long long)((ZSTD_c_format) | 0);  /* check that ZSTD_c_format is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_literalCompressionMode(unsigned long long *o)
{
  int n = (ZSTD_c_literalCompressionMode) <= 0;
  *o = (unsigned long long)((ZSTD_c_literalCompressionMode) | 0);  /* check that ZSTD_c_literalCompressionMode is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_maxBlockSize(unsigned long long *o)
{
  int n = (ZSTD_c_maxBlockSize) <= 0;
  *o = (unsigned long long)((ZSTD_c_maxBlockSize) | 0);  /* check that ZSTD_c_maxBlockSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_prefetchCDictTables(unsigned long long *o)
{
  int n = (ZSTD_c_prefetchCDictTables) <= 0;
  *o = (unsigned long long)((ZSTD_c_prefetchCDictTables) | 0);  /* check that ZSTD_c_prefetchCDictTables is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_rsyncable(unsigned long long *o)
{
  int n = (ZSTD_c_rsyncable) <= 0;
  *o = (unsigned long long)((ZSTD_c_rsyncable) | 0);  /* check that ZSTD_c_rsyncable is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_searchForExternalRepcodes(unsigned long long *o)
{
  int n = (ZSTD_c_searchForExternalRepcodes) <= 0;
  *o = (unsigned long long)((ZSTD_c_searchForExternalRepcodes) | 0);  /* check that ZSTD_c_searchForExternalRepcodes is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_srcSizeHint(unsigned long long *o)
{
  int n = (ZSTD_c_srcSizeHint) <= 0;
  *o = (unsigned long long)((ZSTD_c_srcSizeHint) | 0);  /* check that ZSTD_c_srcSizeHint is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_stableInBuffer(unsigned long long *o)
{
  int n = (ZSTD_c_stableInBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_c_stableInBuffer) | 0);  /* check that ZSTD_c_stableInBuffer is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_stableOutBuffer(unsigned long long *o)
{
  int n = (ZSTD_c_stableOutBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_c_stableOutBuffer) | 0);  /* check that ZSTD_c_stableOutBuffer is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_useBlockSplitter(unsigned long long *o)
{
  int n = (ZSTD_c_useBlockSplitter) <= 0;
  *o = (unsigned long long)((ZSTD_c_useBlockSplitter) | 0);  /* check that ZSTD_c_useBlockSplitter is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_useRowMatchFinder(unsigned long long *o)
{
  int n = (ZSTD_c_useRowMatchFinder) <= 0;
  *o = (unsigned long long)((ZSTD_c_useRowMatchFinder) | 0);  /* check that ZSTD_c_useRowMatchFinder is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_validateSequences(unsigned long long *o)
{
  int n = (ZSTD_c_validateSequences) <= 0;
  *o = (unsigned long long)((ZSTD_c_validateSequences) | 0);  /* check that ZSTD_c_validateSequences is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_disableHuffmanAssembly(unsigned long long *o)
{
  int n = (ZSTD_d_disableHuffmanAssembly) <= 0;
  *o = (unsigned long long)((ZSTD_d_disableHuffmanAssembly) | 0);  /* check that ZSTD_d_disableHuffmanAssembly is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_forceIgnoreChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_forceIgnoreChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_forceIgnoreChecksum) | 0);  /* check that ZSTD_d_forceIgnoreChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_format(unsigned long long *o)
{
  int n = (ZSTD_d_format) <= 0;
  *o = (unsigned long long)((ZSTD_d_format) | 0);  /* check that ZSTD_d_format is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_maxBlockSize(unsigned long long *o)
{
  int n = (ZSTD_d_maxBlockSize) <= 0;
  *o = (unsigned long long)((ZSTD_d_maxBlockSize) | 0);  /* check that ZSTD_d_maxBlockSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_refMultipleDDicts(unsigned long long *o)
{
  int n = (ZSTD_d_refMultipleDDicts) <= 0;
  *o = (unsigned long long)((ZSTD_d_refMultipleDDicts) | 0);  /* check that ZSTD_d_refMultipleDDicts is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_stableOutBuffer(unsigned long long *o)
{
  int n = (ZSTD_d_stableOutBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_d_stableOutBuffer) | 0);  /* check that ZSTD_d_stableOutBuffer is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__ZSTD_inBuffer(ZSTD_inBuffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void const * *tmp = &p->src; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'ZSTD_inBuffer.size' is an integer */
  (void)((p->pos) | 0);  /* check that 'ZSTD_inBuffer.pos' is an integer */
}
struct _cffi_align__ZSTD_inBuffer { char x; ZSTD_inBuffer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ZSTD_outBuffer(ZSTD_outBuffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->dst; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'ZSTD_outBuffer.size' is an integer */
  (void)((p->pos) | 0);  /* check that 'ZSTD_outBuffer.pos' is an integer */
}
struct _cffi_align__ZSTD_outBuffer { char x; ZSTD_outBuffer y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ZDICT_CONTENTSIZE_MIN", (void *)_cffi_const_ZDICT_CONTENTSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZDICT_DICTSIZE_MIN", (void *)_cffi_const_ZDICT_DICTSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZDICT_addEntropyTablesFromBuffer", (void *)_cffi_f_ZDICT_addEntropyTablesFromBuffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 474), (void *)_cffi_d_ZDICT_addEntropyTablesFromBuffer },
  { "ZDICT_finalizeDictionary", (void *)_cffi_f_ZDICT_finalizeDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 556), (void *)_cffi_d_ZDICT_finalizeDictionary },
  { "ZDICT_getDictHeaderSize", (void *)_cffi_f_ZDICT_getDictHeaderSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 566), (void *)_cffi_d_ZDICT_getDictHeaderSize },
  { "ZDICT_getDictID", (void *)_cffi_f_ZDICT_getDictID, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_ZDICT_getDictID },
  { "ZDICT_getErrorName", (void *)_cffi_f_ZDICT_getErrorName, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 99), (void *)_cffi_d_ZDICT_getErrorName },
  { "ZDICT_isError", (void *)_cffi_f_ZDICT_isError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_ZDICT_isError },
  { "ZDICT_optimizeTrainFromBuffer_cover", (void *)_cffi_f_ZDICT_optimizeTrainFromBuffer_cover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 496), (void *)_cffi_d_ZDICT_optimizeTrainFromBuffer_cover },
  { "ZDICT_optimizeTrainFromBuffer_fastCover", (void *)_cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 512), (void *)_cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover },
  { "ZDICT_trainFromBuffer", (void *)_cffi_f_ZDICT_trainFromBuffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 489), (void *)_cffi_d_ZDICT_trainFromBuffer },
  { "ZDICT_trainFromBuffer_cover", (void *)_cffi_f_ZDICT_trainFromBuffer_cover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 504), (void *)_cffi_d_ZDICT_trainFromBuffer_cover },
  { "ZDICT_trainFromBuffer_fastCover", (void *)_cffi_f_ZDICT_trainFromBuffer_fastCover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 520), (void *)_cffi_d_ZDICT_trainFromBuffer_fastCover },
  { "ZDICT_trainFromBuffer_legacy", (void *)_cffi_f_ZDICT_trainFromBuffer_legacy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 528), (void *)_cffi_d_ZDICT_trainFromBuffer_legacy },
  { "ZSTD_BLOCKSIZELOG_MAX", (void *)_cffi_const_ZSTD_BLOCKSIZELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_BLOCKSIZE_MAX", (void *)_cffi_const_ZSTD_BLOCKSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_BLOCKSIZE_MAX_MIN", (void *)_cffi_const_ZSTD_BLOCKSIZE_MAX_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CCtxParams_getParameter", (void *)_cffi_f_ZSTD_CCtxParams_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 317), (void *)_cffi_d_ZSTD_CCtxParams_getParameter },
  { "ZSTD_CCtxParams_init", (void *)_cffi_f_ZSTD_CCtxParams_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 310), (void *)_cffi_d_ZSTD_CCtxParams_init },
  { "ZSTD_CCtxParams_init_advanced", (void *)_cffi_f_ZSTD_CCtxParams_init_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 306), (void *)_cffi_d_ZSTD_CCtxParams_init_advanced },
  { "ZSTD_CCtxParams_registerSequenceProducer", (void *)_cffi_f_ZSTD_CCtxParams_registerSequenceProducer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 600), (void *)_cffi_d_ZSTD_CCtxParams_registerSequenceProducer },
  { "ZSTD_CCtxParams_reset", (void *)_cffi_f_ZSTD_CCtxParams_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 298), (void *)_cffi_d_ZSTD_CCtxParams_reset },
  { "ZSTD_CCtxParams_setParameter", (void *)_cffi_f_ZSTD_CCtxParams_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 301), (void *)_cffi_d_ZSTD_CCtxParams_setParameter },
  { "ZSTD_CCtx_getParameter", (void *)_cffi_f_ZSTD_CCtx_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 293), (void *)_cffi_d_ZSTD_CCtx_getParameter },
  { "ZSTD_CCtx_loadDictionary", (void *)_cffi_f_ZSTD_CCtx_loadDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 259), (void *)_cffi_d_ZSTD_CCtx_loadDictionary },
  { "ZSTD_CCtx_loadDictionary_advanced", (void *)_cffi_f_ZSTD_CCtx_loadDictionary_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 270), (void *)_cffi_d_ZSTD_CCtx_loadDictionary_advanced },
  { "ZSTD_CCtx_loadDictionary_byReference", (void *)_cffi_f_ZSTD_CCtx_loadDictionary_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 259), (void *)_cffi_d_ZSTD_CCtx_loadDictionary_byReference },
  { "ZSTD_CCtx_refCDict", (void *)_cffi_f_ZSTD_CCtx_refCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_CCtx_refCDict },
  { "ZSTD_CCtx_refPrefix", (void *)_cffi_f_ZSTD_CCtx_refPrefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 259), (void *)_cffi_d_ZSTD_CCtx_refPrefix },
  { "ZSTD_CCtx_refPrefix_advanced", (void *)_cffi_f_ZSTD_CCtx_refPrefix_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 264), (void *)_cffi_d_ZSTD_CCtx_refPrefix_advanced },
  { "ZSTD_CCtx_refThreadPool", (void *)_cffi_f_ZSTD_CCtx_refThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_ZSTD_CCtx_refThreadPool },
  { "ZSTD_CCtx_reset", (void *)_cffi_f_ZSTD_CCtx_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_ZSTD_CCtx_reset },
  { "ZSTD_CCtx_setCParams", (void *)_cffi_f_ZSTD_CCtx_setCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_ZSTD_CCtx_setCParams },
  { "ZSTD_CCtx_setFParams", (void *)_cffi_f_ZSTD_CCtx_setFParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_ZSTD_CCtx_setFParams },
  { "ZSTD_CCtx_setParameter", (void *)_cffi_f_ZSTD_CCtx_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 139), (void *)_cffi_d_ZSTD_CCtx_setParameter },
  { "ZSTD_CCtx_setParametersUsingCCtxParams", (void *)_cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams },
  { "ZSTD_CCtx_setParams", (void *)_cffi_f_ZSTD_CCtx_setParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_ZSTD_CCtx_setParams },
  { "ZSTD_CCtx_setPledgedSrcSize", (void *)_cffi_f_ZSTD_CCtx_setPledgedSrcSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 184), (void *)_cffi_d_ZSTD_CCtx_setPledgedSrcSize },
  { "ZSTD_CHAINLOG_MAX", (void *)_cffi_const_ZSTD_CHAINLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MAX_32", (void *)_cffi_const_ZSTD_CHAINLOG_MAX_32, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MAX_64", (void *)_cffi_const_ZSTD_CHAINLOG_MAX_64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MIN", (void *)_cffi_const_ZSTD_CHAINLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CONTENTSIZE_ERROR", (void *)_cffi_const_ZSTD_CONTENTSIZE_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CONTENTSIZE_UNKNOWN", (void *)_cffi_const_ZSTD_CONTENTSIZE_UNKNOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CStreamInSize", (void *)_cffi_f_ZSTD_CStreamInSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 570), (void *)_cffi_d_ZSTD_CStreamInSize },
  { "ZSTD_CStreamOutSize", (void *)_cffi_f_ZSTD_CStreamOutSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 570), (void *)_cffi_d_ZSTD_CStreamOutSize },
  { "ZSTD_DCtx_getParameter", (void *)_cffi_f_ZSTD_DCtx_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_ZSTD_DCtx_getParameter },
  { "ZSTD_DCtx_loadDictionary", (void *)_cffi_f_ZSTD_DCtx_loadDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_DCtx_loadDictionary },
  { "ZSTD_DCtx_loadDictionary_advanced", (void *)_cffi_f_ZSTD_DCtx_loadDictionary_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 406), (void *)_cffi_d_ZSTD_DCtx_loadDictionary_advanced },
  { "ZSTD_DCtx_loadDictionary_byReference", (void *)_cffi_f_ZSTD_DCtx_loadDictionary_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_DCtx_loadDictionary_byReference },
  { "ZSTD_DCtx_refDDict", (void *)_cffi_f_ZSTD_DCtx_refDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 331), (void *)_cffi_d_ZSTD_DCtx_refDDict },
  { "ZSTD_DCtx_refPrefix", (void *)_cffi_f_ZSTD_DCtx_refPrefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_DCtx_refPrefix },
  { "ZSTD_DCtx_refPrefix_advanced", (void *)_cffi_f_ZSTD_DCtx_refPrefix_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 400), (void *)_cffi_d_ZSTD_DCtx_refPrefix_advanced },
  { "ZSTD_DCtx_reset", (void *)_cffi_f_ZSTD_DCtx_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 335), (void *)_cffi_d_ZSTD_DCtx_reset },
  { "ZSTD_DCtx_setFormat", (void *)_cffi_f_ZSTD_DCtx_setFormat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 349), (void *)_cffi_d_ZSTD_DCtx_setFormat },
  { "ZSTD_DCtx_setMaxWindowSize", (void *)_cffi_f_ZSTD_DCtx_setMaxWindowSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 358), (void *)_cffi_d_ZSTD_DCtx_setMaxWindowSize },
  { "ZSTD_DCtx_setParameter", (void *)_cffi_f_ZSTD_DCtx_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 344), (void *)_cffi_d_ZSTD_DCtx_setParameter },
  { "ZSTD_DStreamInSize", (void *)_cffi_f_ZSTD_DStreamInSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 570), (void *)_cffi_d_ZSTD_DStreamInSize },
  { "ZSTD_DStreamOutSize", (void *)_cffi_f_ZSTD_DStreamOutSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 570), (void *)_cffi_d_ZSTD_DStreamOutSize },
  { "ZSTD_FRAMEHEADERSIZE_MAX", (void *)_cffi_const_ZSTD_FRAMEHEADERSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_HASHLOG_MAX", (void *)_cffi_const_ZSTD_HASHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_HASHLOG_MIN", (void *)_cffi_const_ZSTD_HASHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_BUCKETSIZELOG_MAX", (void *)_cffi_const_ZSTD_LDM_BUCKETSIZELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_BUCKETSIZELOG_MIN", (void *)_cffi_const_ZSTD_LDM_BUCKETSIZELOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHLOG_MAX", (void *)_cffi_const_ZSTD_LDM_HASHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHLOG_MIN", (void *)_cffi_const_ZSTD_LDM_HASHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHRATELOG_MAX", (void *)_cffi_const_ZSTD_LDM_HASHRATELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHRATELOG_MIN", (void *)_cffi_const_ZSTD_LDM_HASHRATELOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_MINMATCH_MAX", (void *)_cffi_const_ZSTD_LDM_MINMATCH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_MINMATCH_MIN", (void *)_cffi_const_ZSTD_LDM_MINMATCH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGICNUMBER", (void *)_cffi_const_ZSTD_MAGICNUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_DICTIONARY", (void *)_cffi_const_ZSTD_MAGIC_DICTIONARY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_SKIPPABLE_MASK", (void *)_cffi_const_ZSTD_MAGIC_SKIPPABLE_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_SKIPPABLE_START", (void *)_cffi_const_ZSTD_MAGIC_SKIPPABLE_START, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAX_INPUT_SIZE", (void *)_cffi_const_ZSTD_MAX_INPUT_SIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MINMATCH_MAX", (void *)_cffi_const_ZSTD_MINMATCH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MINMATCH_MIN", (void *)_cffi_const_ZSTD_MINMATCH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_OVERLAPLOG_MAX", (void *)_cffi_const_ZSTD_OVERLAPLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_OVERLAPLOG_MIN", (void *)_cffi_const_ZSTD_OVERLAPLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SEARCHLOG_MAX", (void *)_cffi_const_ZSTD_SEARCHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SEARCHLOG_MIN", (void *)_cffi_const_ZSTD_SEARCHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SEQUENCE_PRODUCER_ERROR", (void *)_cffi_const_ZSTD_SEQUENCE_PRODUCER_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SKIPPABLEHEADERSIZE", (void *)_cffi_const_ZSTD_SKIPPABLEHEADERSIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SRCSIZEHINT_MAX", (void *)_cffi_const_ZSTD_SRCSIZEHINT_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SRCSIZEHINT_MIN", (void *)_cffi_const_ZSTD_SRCSIZEHINT_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_STRATEGY_MAX", (void *)_cffi_const_ZSTD_STRATEGY_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_STRATEGY_MIN", (void *)_cffi_const_ZSTD_STRATEGY_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETCBLOCKSIZE_MAX", (void *)_cffi_const_ZSTD_TARGETCBLOCKSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETCBLOCKSIZE_MIN", (void *)_cffi_const_ZSTD_TARGETCBLOCKSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETLENGTH_MAX", (void *)_cffi_const_ZSTD_TARGETLENGTH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETLENGTH_MIN", (void *)_cffi_const_ZSTD_TARGETLENGTH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_MAJOR", (void *)_cffi_const_ZSTD_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_MINOR", (void *)_cffi_const_ZSTD_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_NUMBER", (void *)_cffi_const_ZSTD_VERSION_NUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_RELEASE", (void *)_cffi_const_ZSTD_VERSION_RELEASE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_LIMIT_DEFAULT", (void *)_cffi_const_ZSTD_WINDOWLOG_LIMIT_DEFAULT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX_32", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX_32, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX_64", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX_64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MIN", (void *)_cffi_const_ZSTD_WINDOWLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_adjustCParams", (void *)_cffi_f_ZSTD_adjustCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_ZSTD_adjustCParams },
  { "ZSTD_btlazy2", (void *)_cffi_const_ZSTD_btlazy2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btopt", (void *)_cffi_const_ZSTD_btopt, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btultra", (void *)_cffi_const_ZSTD_btultra, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btultra2", (void *)_cffi_const_ZSTD_btultra2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_cParam_getBounds", (void *)_cffi_f_ZSTD_cParam_getBounds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_ZSTD_cParam_getBounds },
  { "ZSTD_c_blockDelimiters", (void *)_cffi_const_ZSTD_c_blockDelimiters, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_chainLog", (void *)_cffi_const_ZSTD_c_chainLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_checksumFlag", (void *)_cffi_const_ZSTD_c_checksumFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_compressionLevel", (void *)_cffi_const_ZSTD_c_compressionLevel, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_contentSizeFlag", (void *)_cffi_const_ZSTD_c_contentSizeFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_deterministicRefPrefix", (void *)_cffi_const_ZSTD_c_deterministicRefPrefix, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_dictIDFlag", (void *)_cffi_const_ZSTD_c_dictIDFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_enableDedicatedDictSearch", (void *)_cffi_const_ZSTD_c_enableDedicatedDictSearch, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_enableLongDistanceMatching", (void *)_cffi_const_ZSTD_c_enableLongDistanceMatching, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_enableSeqProducerFallback", (void *)_cffi_const_ZSTD_c_enableSeqProducerFallback, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_experimentalParam1", (void *)_cffi_const_ZSTD_c_experimentalParam1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam10", (void *)_cffi_const_ZSTD_c_experimentalParam10, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam11", (void *)_cffi_const_ZSTD_c_experimentalParam11, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam12", (void *)_cffi_const_ZSTD_c_experimentalParam12, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam13", (void *)_cffi_const_ZSTD_c_experimentalParam13, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam14", (void *)_cffi_const_ZSTD_c_experimentalParam14, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam15", (void *)_cffi_const_ZSTD_c_experimentalParam15, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam16", (void *)_cffi_const_ZSTD_c_experimentalParam16, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam17", (void *)_cffi_const_ZSTD_c_experimentalParam17, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam18", (void *)_cffi_const_ZSTD_c_experimentalParam18, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam19", (void *)_cffi_const_ZSTD_c_experimentalParam19, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam2", (void *)_cffi_const_ZSTD_c_experimentalParam2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam3", (void *)_cffi_const_ZSTD_c_experimentalParam3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam4", (void *)_cffi_const_ZSTD_c_experimentalParam4, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam5", (void *)_cffi_const_ZSTD_c_experimentalParam5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam7", (void *)_cffi_const_ZSTD_c_experimentalParam7, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam8", (void *)_cffi_const_ZSTD_c_experimentalParam8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam9", (void *)_cffi_const_ZSTD_c_experimentalParam9, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_forceAttachDict", (void *)_cffi_const_ZSTD_c_forceAttachDict, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_forceMaxWindow", (void *)_cffi_const_ZSTD_c_forceMaxWindow, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_format", (void *)_cffi_const_ZSTD_c_format, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_hashLog", (void *)_cffi_const_ZSTD_c_hashLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_jobSize", (void *)_cffi_const_ZSTD_c_jobSize, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmBucketSizeLog", (void *)_cffi_const_ZSTD_c_ldmBucketSizeLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmHashLog", (void *)_cffi_const_ZSTD_c_ldmHashLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmHashRateLog", (void *)_cffi_const_ZSTD_c_ldmHashRateLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmMinMatch", (void *)_cffi_const_ZSTD_c_ldmMinMatch, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_literalCompressionMode", (void *)_cffi_const_ZSTD_c_literalCompressionMode, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_maxBlockSize", (void *)_cffi_const_ZSTD_c_maxBlockSize, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_minMatch", (void *)_cffi_const_ZSTD_c_minMatch, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_nbWorkers", (void *)_cffi_const_ZSTD_c_nbWorkers, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_overlapLog", (void *)_cffi_const_ZSTD_c_overlapLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_prefetchCDictTables", (void *)_cffi_const_ZSTD_c_prefetchCDictTables, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_rsyncable", (void *)_cffi_const_ZSTD_c_rsyncable, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_searchForExternalRepcodes", (void *)_cffi_const_ZSTD_c_searchForExternalRepcodes, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_searchLog", (void *)_cffi_const_ZSTD_c_searchLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_srcSizeHint", (void *)_cffi_const_ZSTD_c_srcSizeHint, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_stableInBuffer", (void *)_cffi_const_ZSTD_c_stableInBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_stableOutBuffer", (void *)_cffi_const_ZSTD_c_stableOutBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_strategy", (void *)_cffi_const_ZSTD_c_strategy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_targetCBlockSize", (void *)_cffi_const_ZSTD_c_targetCBlockSize, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_targetLength", (void *)_cffi_const_ZSTD_c_targetLength, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_useBlockSplitter", (void *)_cffi_const_ZSTD_c_useBlockSplitter, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_useRowMatchFinder", (void *)_cffi_const_ZSTD_c_useRowMatchFinder, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_validateSequences", (void *)_cffi_const_ZSTD_c_validateSequences, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_windowLog", (void *)_cffi_const_ZSTD_c_windowLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_checkCParams", (void *)_cffi_f_ZSTD_checkCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 426), (void *)_cffi_d_ZSTD_checkCParams },
  { "ZSTD_compress", (void *)_cffi_f_ZSTD_compress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 542), (void *)_cffi_d_ZSTD_compress },
  { "ZSTD_compress2", (void *)_cffi_f_ZSTD_compress2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_ZSTD_compress2 },
  { "ZSTD_compressBegin", (void *)_cffi_f_ZSTD_compressBegin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_ZSTD_compressBegin },
  { "ZSTD_compressBegin_advanced", (void *)_cffi_f_ZSTD_compressBegin_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_ZSTD_compressBegin_advanced },
  { "ZSTD_compressBegin_usingCDict", (void *)_cffi_f_ZSTD_compressBegin_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_compressBegin_usingCDict },
  { "ZSTD_compressBegin_usingCDict_advanced", (void *)_cffi_f_ZSTD_compressBegin_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_ZSTD_compressBegin_usingCDict_advanced },
  { "ZSTD_compressBegin_usingDict", (void *)_cffi_f_ZSTD_compressBegin_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_ZSTD_compressBegin_usingDict },
  { "ZSTD_compressBlock", (void *)_cffi_f_ZSTD_compressBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_ZSTD_compressBlock },
  { "ZSTD_compressBound", (void *)_cffi_f_ZSTD_compressBound, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 443), (void *)_cffi_d_ZSTD_compressBound },
  { "ZSTD_compressCCtx", (void *)_cffi_f_ZSTD_compressCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 231), (void *)_cffi_d_ZSTD_compressCCtx },
  { "ZSTD_compressContinue", (void *)_cffi_f_ZSTD_compressContinue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_ZSTD_compressContinue },
  { "ZSTD_compressEnd", (void *)_cffi_f_ZSTD_compressEnd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_ZSTD_compressEnd },
  { "ZSTD_compressSequences", (void *)_cffi_f_ZSTD_compressSequences, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 188), (void *)_cffi_d_ZSTD_compressSequences },
  { "ZSTD_compressStream", (void *)_cffi_f_ZSTD_compressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_ZSTD_compressStream },
  { "ZSTD_compressStream2", (void *)_cffi_f_ZSTD_compressStream2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_ZSTD_compressStream2 },
  { "ZSTD_compressStream2_simpleArgs", (void *)_cffi_f_ZSTD_compressStream2_simpleArgs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_ZSTD_compressStream2_simpleArgs },
  { "ZSTD_compress_advanced", (void *)_cffi_f_ZSTD_compress_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 239), (void *)_cffi_d_ZSTD_compress_advanced },
  { "ZSTD_compress_usingCDict", (void *)_cffi_f_ZSTD_compress_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 214), (void *)_cffi_d_ZSTD_compress_usingCDict },
  { "ZSTD_compress_usingCDict_advanced", (void *)_cffi_f_ZSTD_compress_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 222), (void *)_cffi_d_ZSTD_compress_usingCDict_advanced },
  { "ZSTD_compress_usingDict", (void *)_cffi_f_ZSTD_compress_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 249), (void *)_cffi_d_ZSTD_compress_usingDict },
  { "ZSTD_copyCCtx", (void *)_cffi_f_ZSTD_copyCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_ZSTD_copyCCtx },
  { "ZSTD_copyDCtx", (void *)_cffi_f_ZSTD_copyDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 605), (void *)_cffi_d_ZSTD_copyDCtx },
  { "ZSTD_createCCtx", (void *)_cffi_f_ZSTD_createCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 7), (void *)_cffi_d_ZSTD_createCCtx },
  { "ZSTD_createCCtxParams", (void *)_cffi_f_ZSTD_createCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 9), (void *)_cffi_d_ZSTD_createCCtxParams },
  { "ZSTD_createCCtx_advanced", (void *)_cffi_f_ZSTD_createCCtx_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_ZSTD_createCCtx_advanced },
  { "ZSTD_createCDict", (void *)_cffi_f_ZSTD_createCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_ZSTD_createCDict },
  { "ZSTD_createCDict_advanced", (void *)_cffi_f_ZSTD_createCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_ZSTD_createCDict_advanced },
  { "ZSTD_createCDict_advanced2", (void *)_cffi_f_ZSTD_createCDict_advanced2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 11), (void *)_cffi_d_ZSTD_createCDict_advanced2 },
  { "ZSTD_createCDict_byReference", (void *)_cffi_f_ZSTD_createCDict_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_ZSTD_createCDict_byReference },
  { "ZSTD_createCStream", (void *)_cffi_f_ZSTD_createCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 7), (void *)_cffi_d_ZSTD_createCStream },
  { "ZSTD_createCStream_advanced", (void *)_cffi_f_ZSTD_createCStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_ZSTD_createCStream_advanced },
  { "ZSTD_createDCtx", (void *)_cffi_f_ZSTD_createDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 48), (void *)_cffi_d_ZSTD_createDCtx },
  { "ZSTD_createDCtx_advanced", (void *)_cffi_f_ZSTD_createDCtx_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_ZSTD_createDCtx_advanced },
  { "ZSTD_createDDict", (void *)_cffi_f_ZSTD_createDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ZSTD_createDDict },
  { "ZSTD_createDDict_advanced", (void *)_cffi_f_ZSTD_createDDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 54), (void *)_cffi_d_ZSTD_createDDict_advanced },
  { "ZSTD_createDDict_byReference", (void *)_cffi_f_ZSTD_createDDict_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ZSTD_createDDict_byReference },
  { "ZSTD_createDStream", (void *)_cffi_f_ZSTD_createDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 48), (void *)_cffi_d_ZSTD_createDStream },
  { "ZSTD_createDStream_advanced", (void *)_cffi_f_ZSTD_createDStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_ZSTD_createDStream_advanced },
  { "ZSTD_createThreadPool", (void *)_cffi_f_ZSTD_createThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 96), (void *)_cffi_d_ZSTD_createThreadPool },
  { "ZSTD_dParam_getBounds", (void *)_cffi_f_ZSTD_dParam_getBounds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_ZSTD_dParam_getBounds },
  { "ZSTD_d_disableHuffmanAssembly", (void *)_cffi_const_ZSTD_d_disableHuffmanAssembly, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_experimentalParam1", (void *)_cffi_const_ZSTD_d_experimentalParam1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam2", (void *)_cffi_const_ZSTD_d_experimentalParam2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam3", (void *)_cffi_const_ZSTD_d_experimentalParam3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam4", (void *)_cffi_const_ZSTD_d_experimentalParam4, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam5", (void *)_cffi_const_ZSTD_d_experimentalParam5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam6", (void *)_cffi_const_ZSTD_d_experimentalParam6, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_forceIgnoreChecksum", (void *)_cffi_const_ZSTD_d_forceIgnoreChecksum, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_format", (void *)_cffi_const_ZSTD_d_format, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_ignoreChecksum", (void *)_cffi_const_ZSTD_d_ignoreChecksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_maxBlockSize", (void *)_cffi_const_ZSTD_d_maxBlockSize, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_refMultipleDDicts", (void *)_cffi_const_ZSTD_d_refMultipleDDicts, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_stableOutBuffer", (void *)_cffi_const_ZSTD_d_stableOutBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_validateChecksum", (void *)_cffi_const_ZSTD_d_validateChecksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_windowLogMax", (void *)_cffi_const_ZSTD_d_windowLogMax, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_auto", (void *)_cffi_const_ZSTD_dct_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_fullDict", (void *)_cffi_const_ZSTD_dct_fullDict, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_rawContent", (void *)_cffi_const_ZSTD_dct_rawContent, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_decodingBufferSize_min", (void *)_cffi_f_ZSTD_decodingBufferSize_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 459), (void *)_cffi_d_ZSTD_decodingBufferSize_min },
  { "ZSTD_decompress", (void *)_cffi_f_ZSTD_decompress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_ZSTD_decompress },
  { "ZSTD_decompressBegin", (void *)_cffi_f_ZSTD_decompressBegin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_decompressBegin },
  { "ZSTD_decompressBegin_usingDDict", (void *)_cffi_f_ZSTD_decompressBegin_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 331), (void *)_cffi_d_ZSTD_decompressBegin_usingDDict },
  { "ZSTD_decompressBegin_usingDict", (void *)_cffi_f_ZSTD_decompressBegin_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_decompressBegin_usingDict },
  { "ZSTD_decompressBlock", (void *)_cffi_f_ZSTD_decompressBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 371), (void *)_cffi_d_ZSTD_decompressBlock },
  { "ZSTD_decompressBound", (void *)_cffi_f_ZSTD_decompressBound, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 587), (void *)_cffi_d_ZSTD_decompressBound },
  { "ZSTD_decompressContinue", (void *)_cffi_f_ZSTD_decompressContinue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 371), (void *)_cffi_d_ZSTD_decompressContinue },
  { "ZSTD_decompressDCtx", (void *)_cffi_f_ZSTD_decompressDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 371), (void *)_cffi_d_ZSTD_decompressDCtx },
  { "ZSTD_decompressStream", (void *)_cffi_f_ZSTD_decompressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 353), (void *)_cffi_d_ZSTD_decompressStream },
  { "ZSTD_decompressStream_simpleArgs", (void *)_cffi_f_ZSTD_decompressStream_simpleArgs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 362), (void *)_cffi_d_ZSTD_decompressStream_simpleArgs },
  { "ZSTD_decompress_usingDDict", (void *)_cffi_f_ZSTD_decompress_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 378), (void *)_cffi_d_ZSTD_decompress_usingDDict },
  { "ZSTD_decompress_usingDict", (void *)_cffi_f_ZSTD_decompress_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 386), (void *)_cffi_d_ZSTD_decompress_usingDict },
  { "ZSTD_decompressionMargin", (void *)_cffi_f_ZSTD_decompressionMargin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 566), (void *)_cffi_d_ZSTD_decompressionMargin },
  { "ZSTD_defaultCLevel", (void *)_cffi_f_ZSTD_defaultCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_defaultCLevel },
  { "ZSTD_defaultCMem", (void *)_cffi_const_ZSTD_defaultCMem, _CFFI_OP(_CFFI_OP_CONSTANT, 1), (void *)0 },
  { "ZSTD_dfast", (void *)_cffi_const_ZSTD_dfast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictDefaultAttach", (void *)_cffi_const_ZSTD_dictDefaultAttach, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceAttach", (void *)_cffi_const_ZSTD_dictForceAttach, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceCopy", (void *)_cffi_const_ZSTD_dictForceCopy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceLoad", (void *)_cffi_const_ZSTD_dictForceLoad, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dlm_byCopy", (void *)_cffi_const_ZSTD_dlm_byCopy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dlm_byRef", (void *)_cffi_const_ZSTD_dlm_byRef, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_continue", (void *)_cffi_const_ZSTD_e_continue, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_end", (void *)_cffi_const_ZSTD_e_end, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_flush", (void *)_cffi_const_ZSTD_e_flush, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_endStream", (void *)_cffi_f_ZSTD_endStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_ZSTD_endStream },
  { "ZSTD_estimateCCtxSize", (void *)_cffi_f_ZSTD_estimateCCtxSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 440), (void *)_cffi_d_ZSTD_estimateCCtxSize },
  { "ZSTD_estimateCCtxSize_usingCCtxParams", (void *)_cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 314), (void *)_cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams },
  { "ZSTD_estimateCCtxSize_usingCParams", (void *)_cffi_f_ZSTD_estimateCCtxSize_usingCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 426), (void *)_cffi_d_ZSTD_estimateCCtxSize_usingCParams },
  { "ZSTD_estimateCDictSize", (void *)_cffi_f_ZSTD_estimateCDictSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 455), (void *)_cffi_d_ZSTD_estimateCDictSize },
  { "ZSTD_estimateCDictSize_advanced", (void *)_cffi_f_ZSTD_estimateCDictSize_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 446), (void *)_cffi_d_ZSTD_estimateCDictSize_advanced },
  { "ZSTD_estimateCStreamSize", (void *)_cffi_f_ZSTD_estimateCStreamSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 440), (void *)_cffi_d_ZSTD_estimateCStreamSize },
  { "ZSTD_estimateCStreamSize_usingCCtxParams", (void *)_cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 314), (void *)_cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams },
  { "ZSTD_estimateCStreamSize_usingCParams", (void *)_cffi_f_ZSTD_estimateCStreamSize_usingCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 426), (void *)_cffi_d_ZSTD_estimateCStreamSize_usingCParams },
  { "ZSTD_estimateDCtxSize", (void *)_cffi_f_ZSTD_estimateDCtxSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 570), (void *)_cffi_d_ZSTD_estimateDCtxSize },
  { "ZSTD_estimateDDictSize", (void *)_cffi_f_ZSTD_estimateDDictSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 451), (void *)_cffi_d_ZSTD_estimateDDictSize },
  { "ZSTD_estimateDStreamSize", (void *)_cffi_f_ZSTD_estimateDStreamSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 443), (void *)_cffi_d_ZSTD_estimateDStreamSize },
  { "ZSTD_estimateDStreamSize_fromFrame", (void *)_cffi_f_ZSTD_estimateDStreamSize_fromFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 566), (void *)_cffi_d_ZSTD_estimateDStreamSize_fromFrame },
  { "ZSTD_f_zstd1", (void *)_cffi_const_ZSTD_f_zstd1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_f_zstd1_magicless", (void *)_cffi_const_ZSTD_f_zstd1_magicless, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_fast", (void *)_cffi_const_ZSTD_fast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_findDecompressedSize", (void *)_cffi_f_ZSTD_findDecompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 587), (void *)_cffi_d_ZSTD_findDecompressedSize },
  { "ZSTD_findFrameCompressedSize", (void *)_cffi_f_ZSTD_findFrameCompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 566), (void *)_cffi_d_ZSTD_findFrameCompressedSize },
  { "ZSTD_flushStream", (void *)_cffi_f_ZSTD_flushStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_ZSTD_flushStream },
  { "ZSTD_frame", (void *)_cffi_const_ZSTD_frame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_frameHeaderSize", (void *)_cffi_f_ZSTD_frameHeaderSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 566), (void *)_cffi_d_ZSTD_frameHeaderSize },
  { "ZSTD_freeCCtx", (void *)_cffi_f_ZSTD_freeCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_freeCCtx },
  { "ZSTD_freeCCtxParams", (void *)_cffi_f_ZSTD_freeCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 298), (void *)_cffi_d_ZSTD_freeCCtxParams },
  { "ZSTD_freeCDict", (void *)_cffi_f_ZSTD_freeCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 322), (void *)_cffi_d_ZSTD_freeCDict },
  { "ZSTD_freeCStream", (void *)_cffi_f_ZSTD_freeCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_freeCStream },
  { "ZSTD_freeDCtx", (void *)_cffi_f_ZSTD_freeDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_freeDCtx },
  { "ZSTD_freeDDict", (void *)_cffi_f_ZSTD_freeDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 416), (void *)_cffi_d_ZSTD_freeDDict },
  { "ZSTD_freeDStream", (void *)_cffi_f_ZSTD_freeDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_freeDStream },
  { "ZSTD_freeThreadPool", (void *)_cffi_f_ZSTD_freeThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 609), (void *)_cffi_d_ZSTD_freeThreadPool },
  { "ZSTD_generateSequences", (void *)_cffi_f_ZSTD_generateSequences, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 132), (void *)_cffi_d_ZSTD_generateSequences },
  { "ZSTD_getBlockSize", (void *)_cffi_f_ZSTD_getBlockSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_ZSTD_getBlockSize },
  { "ZSTD_getCParams", (void *)_cffi_f_ZSTD_getCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 80), (void *)_cffi_d_ZSTD_getCParams },
  { "ZSTD_getDecompressedSize", (void *)_cffi_f_ZSTD_getDecompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 587), (void *)_cffi_d_ZSTD_getDecompressedSize },
  { "ZSTD_getDictID_fromCDict", (void *)_cffi_f_ZSTD_getDictID_fromCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 572), (void *)_cffi_d_ZSTD_getDictID_fromCDict },
  { "ZSTD_getDictID_fromDDict", (void *)_cffi_f_ZSTD_getDictID_fromDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 575), (void *)_cffi_d_ZSTD_getDictID_fromDDict },
  { "ZSTD_getDictID_fromDict", (void *)_cffi_f_ZSTD_getDictID_fromDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_ZSTD_getDictID_fromDict },
  { "ZSTD_getDictID_fromFrame", (void *)_cffi_f_ZSTD_getDictID_fromFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_ZSTD_getDictID_fromFrame },
  { "ZSTD_getErrorName", (void *)_cffi_f_ZSTD_getErrorName, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 99), (void *)_cffi_d_ZSTD_getErrorName },
  { "ZSTD_getFrameContentSize", (void *)_cffi_f_ZSTD_getFrameContentSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 587), (void *)_cffi_d_ZSTD_getFrameContentSize },
  { "ZSTD_getFrameHeader", (void *)_cffi_f_ZSTD_getFrameHeader, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 429), (void *)_cffi_d_ZSTD_getFrameHeader },
  { "ZSTD_getFrameHeader_advanced", (void *)_cffi_f_ZSTD_getFrameHeader_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 434), (void *)_cffi_d_ZSTD_getFrameHeader_advanced },
  { "ZSTD_getFrameProgression", (void *)_cffi_f_ZSTD_getFrameProgression, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_ZSTD_getFrameProgression },
  { "ZSTD_getParams", (void *)_cffi_f_ZSTD_getParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_ZSTD_getParams },
  { "ZSTD_greedy", (void *)_cffi_const_ZSTD_greedy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_initCStream", (void *)_cffi_f_ZSTD_initCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_ZSTD_initCStream },
  { "ZSTD_initCStream_advanced", (void *)_cffi_f_ZSTD_initCStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_ZSTD_initCStream_advanced },
  { "ZSTD_initCStream_srcSize", (void *)_cffi_f_ZSTD_initCStream_srcSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 179), (void *)_cffi_d_ZSTD_initCStream_srcSize },
  { "ZSTD_initCStream_usingCDict", (void *)_cffi_f_ZSTD_initCStream_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_initCStream_usingCDict },
  { "ZSTD_initCStream_usingCDict_advanced", (void *)_cffi_f_ZSTD_initCStream_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_ZSTD_initCStream_usingCDict_advanced },
  { "ZSTD_initCStream_usingDict", (void *)_cffi_f_ZSTD_initCStream_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_ZSTD_initCStream_usingDict },
  { "ZSTD_initDStream", (void *)_cffi_f_ZSTD_initDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_initDStream },
  { "ZSTD_initDStream_usingDDict", (void *)_cffi_f_ZSTD_initDStream_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 331), (void *)_cffi_d_ZSTD_initDStream_usingDDict },
  { "ZSTD_initDStream_usingDict", (void *)_cffi_f_ZSTD_initDStream_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_initDStream_usingDict },
  { "ZSTD_initStaticCCtx", (void *)_cffi_f_ZSTD_initStaticCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_ZSTD_initStaticCCtx },
  { "ZSTD_initStaticCDict", (void *)_cffi_f_ZSTD_initStaticCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_ZSTD_initStaticCDict },
  { "ZSTD_initStaticCStream", (void *)_cffi_f_ZSTD_initStaticCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_ZSTD_initStaticCStream },
  { "ZSTD_initStaticDCtx", (void *)_cffi_f_ZSTD_initStaticDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_ZSTD_initStaticDCtx },
  { "ZSTD_initStaticDDict", (void *)_cffi_f_ZSTD_initStaticDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_ZSTD_initStaticDDict },
  { "ZSTD_initStaticDStream", (void *)_cffi_f_ZSTD_initStaticDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_ZSTD_initStaticDStream },
  { "ZSTD_insertBlock", (void *)_cffi_f_ZSTD_insertBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 395), (void *)_cffi_d_ZSTD_insertBlock },
  { "ZSTD_isError", (void *)_cffi_f_ZSTD_isError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_ZSTD_isError },
  { "ZSTD_isFrame", (void *)_cffi_f_ZSTD_isFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_ZSTD_isFrame },
  { "ZSTD_isSkippableFrame", (void *)_cffi_f_ZSTD_isSkippableFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_ZSTD_isSkippableFrame },
  { "ZSTD_lazy", (void *)_cffi_const_ZSTD_lazy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lazy2", (void *)_cffi_const_ZSTD_lazy2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_auto", (void *)_cffi_const_ZSTD_lcm_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_huffman", (void *)_cffi_const_ZSTD_lcm_huffman, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_uncompressed", (void *)_cffi_const_ZSTD_lcm_uncompressed, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_maxCLevel", (void *)_cffi_f_ZSTD_maxCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_maxCLevel },
  { "ZSTD_mergeBlockDelimiters", (void *)_cffi_f_ZSTD_mergeBlockDelimiters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 422), (void *)_cffi_d_ZSTD_mergeBlockDelimiters },
  { "ZSTD_minCLevel", (void *)_cffi_f_ZSTD_minCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_minCLevel },
  { "ZSTD_nextInputType", (void *)_cffi_f_ZSTD_nextInputType, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_ZSTD_nextInputType },
  { "ZSTD_nextSrcSizeToDecompress", (void *)_cffi_f_ZSTD_nextSrcSizeToDecompress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_nextSrcSizeToDecompress },
  { "ZSTD_ps_auto", (void *)_cffi_const_ZSTD_ps_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_ps_disable", (void *)_cffi_const_ZSTD_ps_disable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_ps_enable", (void *)_cffi_const_ZSTD_ps_enable, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_readSkippableFrame", (void *)_cffi_f_ZSTD_readSkippableFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 482), (void *)_cffi_d_ZSTD_readSkippableFrame },
  { "ZSTD_registerSequenceProducer", (void *)_cffi_f_ZSTD_registerSequenceProducer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 595), (void *)_cffi_d_ZSTD_registerSequenceProducer },
  { "ZSTD_resetCStream", (void *)_cffi_f_ZSTD_resetCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 184), (void *)_cffi_d_ZSTD_resetCStream },
  { "ZSTD_resetDStream", (void *)_cffi_f_ZSTD_resetDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_ZSTD_resetDStream },
  { "ZSTD_reset_parameters", (void *)_cffi_const_ZSTD_reset_parameters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_reset_session_and_parameters", (void *)_cffi_const_ZSTD_reset_session_and_parameters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_reset_session_only", (void *)_cffi_const_ZSTD_reset_session_only, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_rmd_refMultipleDDicts", (void *)_cffi_const_ZSTD_rmd_refMultipleDDicts, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_rmd_refSingleDDict", (void *)_cffi_const_ZSTD_rmd_refSingleDDict, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sequenceBound", (void *)_cffi_f_ZSTD_sequenceBound, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 443), (void *)_cffi_d_ZSTD_sequenceBound },
  { "ZSTD_sf_explicitBlockDelimiters", (void *)_cffi_const_ZSTD_sf_explicitBlockDelimiters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sf_noBlockDelimiters", (void *)_cffi_const_ZSTD_sf_noBlockDelimiters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sizeof_CCtx", (void *)_cffi_f_ZSTD_sizeof_CCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_ZSTD_sizeof_CCtx },
  { "ZSTD_sizeof_CDict", (void *)_cffi_f_ZSTD_sizeof_CDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 325), (void *)_cffi_d_ZSTD_sizeof_CDict },
  { "ZSTD_sizeof_CStream", (void *)_cffi_f_ZSTD_sizeof_CStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_ZSTD_sizeof_CStream },
  { "ZSTD_sizeof_DCtx", (void *)_cffi_f_ZSTD_sizeof_DCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 413), (void *)_cffi_d_ZSTD_sizeof_DCtx },
  { "ZSTD_sizeof_DDict", (void *)_cffi_f_ZSTD_sizeof_DDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 419), (void *)_cffi_d_ZSTD_sizeof_DDict },
  { "ZSTD_sizeof_DStream", (void *)_cffi_f_ZSTD_sizeof_DStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 413), (void *)_cffi_d_ZSTD_sizeof_DStream },
  { "ZSTD_skippableFrame", (void *)_cffi_const_ZSTD_skippableFrame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_toFlushNow", (void *)_cffi_f_ZSTD_toFlushNow, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_toFlushNow },
  { "ZSTD_versionNumber", (void *)_cffi_f_ZSTD_versionNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 585), (void *)_cffi_d_ZSTD_versionNumber },
  { "ZSTD_versionString", (void *)_cffi_f_ZSTD_versionString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 102), (void *)_cffi_d_ZSTD_versionString },
  { "ZSTD_writeSkippableFrame", (void *)_cffi_f_ZSTD_writeSkippableFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 549), (void *)_cffi_d_ZSTD_writeSkippableFrame },
  { "ZSTDnit_block", (void *)_cffi_const_ZSTDnit_block, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_blockHeader", (void *)_cffi_const_ZSTDnit_blockHeader, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_checksum", (void *)_cffi_const_ZSTDnit_checksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_frameHeader", (void *)_cffi_const_ZSTDnit_frameHeader, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_lastBlock", (void *)_cffi_const_ZSTDnit_lastBlock, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_skippableFrame", (void *)_cffi_const_ZSTDnit_skippableFrame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "k", offsetof(ZDICT_cover_params_t, k),
         sizeof(((ZDICT_cover_params_t *)0)->k),
         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "d", offsetof(ZDICT_cover_params_t, d),
         sizeof(((ZDICT_cover_params_t *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "steps", offsetof(ZDICT_cover_params_t, steps),
             sizeof(((ZDICT_cover_params_t *)0)->steps),
             _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "nbThreads", offsetof(ZDICT_cover_params_t, nbThreads),
                 sizeof(((ZDICT_cover_params_t *)0)->nbThreads),
                 _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "splitPoint", offsetof(ZDICT_cover_params_t, splitPoint),
                  sizeof(((ZDICT_cover_params_t *)0)->splitPoint),
                  _CFFI_OP(_CFFI_OP_NOOP, 639) },
  { "shrinkDict", offsetof(ZDICT_cover_params_t, shrinkDict),
                  sizeof(((ZDICT_cover_params_t *)0)->shrinkDict),
                  _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "shrinkDictMaxRegression", offsetof(ZDICT_cover_params_t, shrinkDictMaxRegression),
                               sizeof(((ZDICT_cover_params_t *)0)->shrinkDictMaxRegression),
                               _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "zParams", offsetof(ZDICT_cover_params_t, zParams),
               sizeof(((ZDICT_cover_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 564) },
  { "k", offsetof(ZDICT_fastCover_params_t, k),
         sizeof(((ZDICT_fastCover_params_t *)0)->k),
         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "d", offsetof(ZDICT_fastCover_params_t, d),
         sizeof(((ZDICT_fastCover_params_t *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "f", offsetof(ZDICT_fastCover_params_t, f),
         sizeof(((ZDICT_fastCover_params_t *)0)->f),
         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "steps", offsetof(ZDICT_fastCover_params_t, steps),
             sizeof(((ZDICT_fastCover_params_t *)0)->steps),
             _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "nbThreads", offsetof(ZDICT_fastCover_params_t, nbThreads),
                 sizeof(((ZDICT_fastCover_params_t *)0)->nbThreads),
                 _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "splitPoint", offsetof(ZDICT_fastCover_params_t, splitPoint),
                  sizeof(((ZDICT_fastCover_params_t *)0)->splitPoint),
                  _CFFI_OP(_CFFI_OP_NOOP, 639) },
  { "accel", offsetof(ZDICT_fastCover_params_t, accel),
             sizeof(((ZDICT_fastCover_params_t *)0)->accel),
             _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "shrinkDict", offsetof(ZDICT_fastCover_params_t, shrinkDict),
                  sizeof(((ZDICT_fastCover_params_t *)0)->shrinkDict),
                  _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "shrinkDictMaxRegression", offsetof(ZDICT_fastCover_params_t, shrinkDictMaxRegression),
                               sizeof(((ZDICT_fastCover_params_t *)0)->shrinkDictMaxRegression),
                               _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "zParams", offsetof(ZDICT_fastCover_params_t, zParams),
               sizeof(((ZDICT_fastCover_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 564) },
  { "selectivityLevel", offsetof(ZDICT_legacy_params_t, selectivityLevel),
                        sizeof(((ZDICT_legacy_params_t *)0)->selectivityLevel),
                        _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "zParams", offsetof(ZDICT_legacy_params_t, zParams),
               sizeof(((ZDICT_legacy_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 564) },
  { "compressionLevel", offsetof(ZDICT_params_t, compressionLevel),
                        sizeof(((ZDICT_params_t *)0)->compressionLevel),
                        _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "notificationLevel", offsetof(ZDICT_params_t, notificationLevel),
                         sizeof(((ZDICT_params_t *)0)->notificationLevel),
                         _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "dictID", offsetof(ZDICT_params_t, dictID),
              sizeof(((ZDICT_params_t *)0)->dictID),
              _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "offset", offsetof(ZSTD_Sequence, offset),
              sizeof(((ZSTD_Sequence *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "litLength", offsetof(ZSTD_Sequence, litLength),
                 sizeof(((ZSTD_Sequence *)0)->litLength),
                 _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "matchLength", offsetof(ZSTD_Sequence, matchLength),
                   sizeof(((ZSTD_Sequence *)0)->matchLength),
                   _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "rep", offsetof(ZSTD_Sequence, rep),
           sizeof(((ZSTD_Sequence *)0)->rep),
           _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "error", offsetof(ZSTD_bounds, error),
             sizeof(((ZSTD_bounds *)0)->error),
             _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "lowerBound", offsetof(ZSTD_bounds, lowerBound),
                  sizeof(((ZSTD_bounds *)0)->lowerBound),
                  _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "upperBound", offsetof(ZSTD_bounds, upperBound),
                  sizeof(((ZSTD_bounds *)0)->upperBound),
                  _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "windowLog", offsetof(ZSTD_compressionParameters, windowLog),
                 sizeof(((ZSTD_compressionParameters *)0)->windowLog),
                 _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "chainLog", offsetof(ZSTD_compressionParameters, chainLog),
                sizeof(((ZSTD_compressionParameters *)0)->chainLog),
                _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "hashLog", offsetof(ZSTD_compressionParameters, hashLog),
               sizeof(((ZSTD_compressionParameters *)0)->hashLog),
               _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "searchLog", offsetof(ZSTD_compressionParameters, searchLog),
                 sizeof(((ZSTD_compressionParameters *)0)->searchLog),
                 _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "minMatch", offsetof(ZSTD_compressionParameters, minMatch),
                sizeof(((ZSTD_compressionParameters *)0)->minMatch),
                _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "targetLength", offsetof(ZSTD_compressionParameters, targetLength),
                    sizeof(((ZSTD_compressionParameters *)0)->targetLength),
                    _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "strategy", offsetof(ZSTD_compressionParameters, strategy),
                sizeof(((ZSTD_compressionParameters *)0)->strategy),
                _CFFI_OP(_CFFI_OP_NOOP, 635) },
  { "customAlloc", offsetof(ZSTD_customMem, customAlloc),
                   sizeof(((ZSTD_customMem *)0)->customAlloc),
                   _CFFI_OP(_CFFI_OP_NOOP, 640) },
  { "customFree", offsetof(ZSTD_customMem, customFree),
                  sizeof(((ZSTD_customMem *)0)->customFree),
                  _CFFI_OP(_CFFI_OP_NOOP, 641) },
  { "opaque", offsetof(ZSTD_customMem, opaque),
              sizeof(((ZSTD_customMem *)0)->opaque),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "frameContentSize", offsetof(ZSTD_frameHeader, frameContentSize),
                        sizeof(((ZSTD_frameHeader *)0)->frameContentSize),
                        _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "windowSize", offsetof(ZSTD_frameHeader, windowSize),
                  sizeof(((ZSTD_frameHeader *)0)->windowSize),
                  _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "blockSizeMax", offsetof(ZSTD_frameHeader, blockSizeMax),
                    sizeof(((ZSTD_frameHeader *)0)->blockSizeMax),
                    _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "frameType", offsetof(ZSTD_frameHeader, frameType),
                 sizeof(((ZSTD_frameHeader *)0)->frameType),
                 _CFFI_OP(_CFFI_OP_NOOP, 627) },
  { "headerSize", offsetof(ZSTD_frameHeader, headerSize),
                  sizeof(((ZSTD_frameHeader *)0)->headerSize),
                  _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "dictID", offsetof(ZSTD_frameHeader, dictID),
              sizeof(((ZSTD_frameHeader *)0)->dictID),
              _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "checksumFlag", offsetof(ZSTD_frameHeader, checksumFlag),
                    sizeof(((ZSTD_frameHeader *)0)->checksumFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "_reserved1", offsetof(ZSTD_frameHeader, _reserved1),
                  sizeof(((ZSTD_frameHeader *)0)->_reserved1),
                  _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "_reserved2", offsetof(ZSTD_frameHeader, _reserved2),
                  sizeof(((ZSTD_frameHeader *)0)->_reserved2),
                  _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "contentSizeFlag", offsetof(ZSTD_frameParameters, contentSizeFlag),
                       sizeof(((ZSTD_frameParameters *)0)->contentSizeFlag),
                       _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "checksumFlag", offsetof(ZSTD_frameParameters, checksumFlag),
                    sizeof(((ZSTD_frameParameters *)0)->checksumFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "noDictIDFlag", offsetof(ZSTD_frameParameters, noDictIDFlag),
                    sizeof(((ZSTD_frameParameters *)0)->noDictIDFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "ingested", offsetof(ZSTD_frameProgression, ingested),
                sizeof(((ZSTD_frameProgression *)0)->ingested),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "consumed", offsetof(ZSTD_frameProgression, consumed),
                sizeof(((ZSTD_frameProgression *)0)->consumed),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "produced", offsetof(ZSTD_frameProgression, produced),
                sizeof(((ZSTD_frameProgression *)0)->produced),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "flushed", offsetof(ZSTD_frameProgression, flushed),
               sizeof(((ZSTD_frameProgression *)0)->flushed),
               _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "currentJobID", offsetof(ZSTD_frameProgression, currentJobID),
                    sizeof(((ZSTD_frameProgression *)0)->currentJobID),
                    _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "nbActiveWorkers", offsetof(ZSTD_frameProgression, nbActiveWorkers),
                       sizeof(((ZSTD_frameProgression *)0)->nbActiveWorkers),
                       _CFFI_OP(_CFFI_OP_NOOP, 480) },
  { "cParams", offsetof(ZSTD_parameters, cParams),
               sizeof(((ZSTD_parameters *)0)->cParams),
               _CFFI_OP(_CFFI_OP_NOOP, 24) },
  { "fParams", offsetof(ZSTD_parameters, fParams),
               sizeof(((ZSTD_parameters *)0)->fParams),
               _CFFI_OP(_CFFI_OP_NOOP, 125) },
  { "src", offsetof(ZSTD_inBuffer, src),
           sizeof(((ZSTD_inBuffer *)0)->src),
           _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "size", offsetof(ZSTD_inBuffer, size),
            sizeof(((ZSTD_inBuffer *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "pos", offsetof(ZSTD_inBuffer, pos),
           sizeof(((ZSTD_inBuffer *)0)->pos),
           _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "dst", offsetof(ZSTD_outBuffer, dst),
           sizeof(((ZSTD_outBuffer *)0)->dst),
           _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "size", offsetof(ZSTD_outBuffer, size),
            sizeof(((ZSTD_outBuffer *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "pos", offsetof(ZSTD_outBuffer, pos),
           sizeof(((ZSTD_outBuffer *)0)->pos),
           _CFFI_OP(_CFFI_OP_NOOP, 5) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$ZDICT_cover_params_t", 510, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_cover_params_t), offsetof(struct _cffi_align_typedef_ZDICT_cover_params_t, y), 0, 8 },
  { "$ZDICT_fastCover_params_t", 526, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_fastCover_params_t), offsetof(struct _cffi_align_typedef_ZDICT_fastCover_params_t, y), 8, 10 },
  { "$ZDICT_legacy_params_t", 534, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_legacy_params_t), offsetof(struct _cffi_align_typedef_ZDICT_legacy_params_t, y), 18, 2 },
  { "$ZDICT_params_t", 564, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_params_t), offsetof(struct _cffi_align_typedef_ZDICT_params_t, y), 20, 3 },
  { "$ZSTD_Sequence", 621, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_Sequence), offsetof(struct _cffi_align_typedef_ZSTD_Sequence, y), 23, 4 },
  { "$ZSTD_bounds", 622, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_bounds), offsetof(struct _cffi_align_typedef_ZSTD_bounds, y), 27, 3 },
  { "$ZSTD_compressionParameters", 24, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_compressionParameters), offsetof(struct _cffi_align_typedef_ZSTD_compressionParameters, y), 30, 7 },
  { "$ZSTD_customMem", 1, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_customMem), offsetof(struct _cffi_align_typedef_ZSTD_customMem, y), 37, 3 },
  { "$ZSTD_frameHeader", 625, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameHeader), offsetof(struct _cffi_align_typedef_ZSTD_frameHeader, y), 40, 9 },
  { "$ZSTD_frameParameters", 125, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameParameters), offsetof(struct _cffi_align_typedef_ZSTD_frameParameters, y), 49, 3 },
  { "$ZSTD_frameProgression", 626, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameProgression), offsetof(struct _cffi_align_typedef_ZSTD_frameProgression, y), 52, 6 },
  { "$ZSTD_parameters", 169, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_parameters), offsetof(struct _cffi_align_typedef_ZSTD_parameters, y), 58, 2 },
  { "POOL_ctx_s", 636, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CCtx_params_s", 617, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CCtx_s", 616, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CDict_s", 618, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_DCtx_s", 619, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_DDict_s", 620, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_inBuffer_s", 628, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_inBuffer), offsetof(struct _cffi_align__ZSTD_inBuffer, y), 60, 3 },
  { "ZSTD_outBuffer_s", 631, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_outBuffer), offsetof(struct _cffi_align__ZSTD_outBuffer, y), 63, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ZSTD_EndDirective", 165, _cffi_prim_int(sizeof(ZSTD_EndDirective), ((ZSTD_EndDirective)-1) <= 0),
    "ZSTD_e_continue,ZSTD_e_flush,ZSTD_e_end" },
  { "$ZSTD_ResetDirective", 130, _cffi_prim_int(sizeof(ZSTD_ResetDirective), ((ZSTD_ResetDirective)-1) <= 0),
    "ZSTD_reset_session_only,ZSTD_reset_parameters,ZSTD_reset_session_and_parameters" },
  { "$ZSTD_cParameter", 70, _cffi_prim_int(sizeof(ZSTD_cParameter), ((ZSTD_cParameter)-1) <= 0),
    "ZSTD_c_compressionLevel,ZSTD_c_windowLog,ZSTD_c_hashLog,ZSTD_c_chainLog,ZSTD_c_searchLog,ZSTD_c_minMatch,ZSTD_c_targetLength,ZSTD_c_strategy,ZSTD_c_targetCBlockSize,ZSTD_c_enableLongDistanceMatching,ZSTD_c_ldmHashLog,ZSTD_c_ldmMinMatch,ZSTD_c_ldmBucketSizeLog,ZSTD_c_ldmHashRateLog,ZSTD_c_contentSizeFlag,ZSTD_c_checksumFlag,ZSTD_c_dictIDFlag,ZSTD_c_nbWorkers,ZSTD_c_jobSize,ZSTD_c_overlapLog,ZSTD_c_experimentalParam1,ZSTD_c_experimentalParam2,ZSTD_c_experimentalParam3,ZSTD_c_experimentalParam4,ZSTD_c_experimentalParam5,ZSTD_c_experimentalParam7,ZSTD_c_experimentalParam8,ZSTD_c_experimentalParam9,ZSTD_c_experimentalParam10,ZSTD_c_experimentalParam11,ZSTD_c_experimentalParam12,ZSTD_c_experimentalParam13,ZSTD_c_experimentalParam14,ZSTD_c_experimentalParam15,ZSTD_c_experimentalParam16,ZSTD_c_experimentalParam17,ZSTD_c_experimentalParam18,ZSTD_c_experimentalParam19" },
  { "$ZSTD_dParameter", 73, _cffi_prim_int(sizeof(ZSTD_dParameter), ((ZSTD_dParameter)-1) <= 0),
    "ZSTD_d_windowLogMax,ZSTD_d_experimentalParam1,ZSTD_d_experimentalParam2,ZSTD_d_experimentalParam3,ZSTD_d_experimentalParam4,ZSTD_d_experimentalParam5,ZSTD_d_experimentalParam6" },
  { "$ZSTD_dictAttachPref_e", 623, _cffi_prim_int(sizeof(ZSTD_dictAttachPref_e), ((ZSTD_dictAttachPref_e)-1) <= 0),
    "ZSTD_dictDefaultAttach,ZSTD_dictForceAttach,ZSTD_dictForceCopy,ZSTD_dictForceLoad" },
  { "$ZSTD_dictContentType_e", 15, _cffi_prim_int(sizeof(ZSTD_dictContentType_e), ((ZSTD_dictContentType_e)-1) <= 0),
    "ZSTD_dct_auto,ZSTD_dct_rawContent,ZSTD_dct_fullDict" },
  { "$ZSTD_dictLoadMethod_e", 14, _cffi_prim_int(sizeof(ZSTD_dictLoadMethod_e), ((ZSTD_dictLoadMethod_e)-1) <= 0),
    "ZSTD_dlm_byCopy,ZSTD_dlm_byRef" },
  { "$ZSTD_forceIgnoreChecksum_e", 624, _cffi_prim_int(sizeof(ZSTD_forceIgnoreChecksum_e), ((ZSTD_forceIgnoreChecksum_e)-1) <= 0),
    "ZSTD_d_validateChecksum,ZSTD_d_ignoreChecksum" },
  { "$ZSTD_format_e", 351, _cffi_prim_int(sizeof(ZSTD_format_e), ((ZSTD_format_e)-1) <= 0),
    "ZSTD_f_zstd1,ZSTD_f_zstd1_magicless" },
  { "$ZSTD_frameType_e", 627, _cffi_prim_int(sizeof(ZSTD_frameType_e), ((ZSTD_frameType_e)-1) <= 0),
    "ZSTD_frame,ZSTD_skippableFrame" },
  { "$ZSTD_literalCompressionMode_e", 629, _cffi_prim_int(sizeof(ZSTD_literalCompressionMode_e), ((ZSTD_literalCompressionMode_e)-1) <= 0),
    "ZSTD_lcm_auto,ZSTD_lcm_huffman,ZSTD_lcm_uncompressed" },
  { "$ZSTD_nextInputType_e", 630, _cffi_prim_int(sizeof(ZSTD_nextInputType_e), ((ZSTD_nextInputType_e)-1) <= 0),
    "ZSTDnit_frameHeader,ZSTDnit_blockHeader,ZSTDnit_block,ZSTDnit_lastBlock,ZSTDnit_checksum,ZSTDnit_skippableFrame" },
  { "$ZSTD_paramSwitch_e", 632, _cffi_prim_int(sizeof(ZSTD_paramSwitch_e), ((ZSTD_paramSwitch_e)-1) <= 0),
    "ZSTD_ps_auto,ZSTD_ps_enable,ZSTD_ps_disable" },
  { "$ZSTD_refMultipleDDicts_e", 633, _cffi_prim_int(sizeof(ZSTD_refMultipleDDicts_e), ((ZSTD_refMultipleDDicts_e)-1) <= 0),
    "ZSTD_rmd_refSingleDDict,ZSTD_rmd_refMultipleDDicts" },
  { "$ZSTD_sequenceFormat_e", 634, _cffi_prim_int(sizeof(ZSTD_sequenceFormat_e), ((ZSTD_sequenceFormat_e)-1) <= 0),
    "ZSTD_sf_noBlockDelimiters,ZSTD_sf_explicitBlockDelimiters" },
  { "$ZSTD_strategy", 635, _cffi_prim_int(sizeof(ZSTD_strategy), ((ZSTD_strategy)-1) <= 0),
    "ZSTD_fast,ZSTD_dfast,ZSTD_greedy,ZSTD_lazy,ZSTD_lazy2,ZSTD_btlazy2,ZSTD_btopt,ZSTD_btultra,ZSTD_btultra2" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ZDICT_cover_params_t", 510 },
  { "ZDICT_fastCover_params_t", 526 },
  { "ZDICT_legacy_params_t", 534 },
  { "ZDICT_params_t", 564 },
  { "ZSTD_CCtx", 616 },
  { "ZSTD_CCtx_params", 617 },
  { "ZSTD_CDict", 618 },
  { "ZSTD_CStream", 616 },
  { "ZSTD_DCtx", 619 },
  { "ZSTD_DDict", 620 },
  { "ZSTD_DStream", 619 },
  { "ZSTD_EndDirective", 165 },
  { "ZSTD_ResetDirective", 130 },
  { "ZSTD_Sequence", 621 },
  { "ZSTD_allocFunction", 640 },
  { "ZSTD_bounds", 622 },
  { "ZSTD_cParameter", 70 },
  { "ZSTD_compressionParameters", 24 },
  { "ZSTD_customMem", 1 },
  { "ZSTD_dParameter", 73 },
  { "ZSTD_dictAttachPref_e", 623 },
  { "ZSTD_dictContentType_e", 15 },
  { "ZSTD_dictLoadMethod_e", 14 },
  { "ZSTD_forceIgnoreChecksum_e", 624 },
  { "ZSTD_format_e", 351 },
  { "ZSTD_frameHeader", 625 },
  { "ZSTD_frameParameters", 125 },
  { "ZSTD_frameProgression", 626 },
  { "ZSTD_frameType_e", 627 },
  { "ZSTD_freeFunction", 641 },
  { "ZSTD_inBuffer", 628 },
  { "ZSTD_literalCompressionMode_e", 629 },
  { "ZSTD_nextInputType_e", 630 },
  { "ZSTD_outBuffer", 631 },
  { "ZSTD_paramSwitch_e", 632 },
  { "ZSTD_parameters", 169 },
  { "ZSTD_refMultipleDDicts_e", 633 },
  { "ZSTD_sequenceFormat_e", 634 },
  { "ZSTD_sequenceProducer_F", 598 },
  { "ZSTD_strategy", 635 },
  { "ZSTD_threadPool", 636 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  352,  /* num_globals */
  20,  /* num_struct_unions */
  16,  /* num_enums */
  41,  /* num_typenames */
  NULL,  /* no includes */
  643,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cffi(void) { return NULL; }
#  else
     init_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cffi(void)
{
  return _cffi_init("zstandard._cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cffi(void)
{
  _cffi_init("zstandard._cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
