// This file is generated by kconfig_compiler_kf5 from okular.kcfg.
// All changes you do to this file will be lost.

#include "settings.h"

#include <qdom.h>
#include <QStandardPaths>

#include <qglobal.h>
#include <QtCore/QFile>

#include <QDebug>

using namespace Okular;

namespace Okular {

class SettingsPrivate
{
  public:

    // Dlg Performance
    bool enableCompositing;

    // Debugging Options
    bool debugDrawBoundaries;
    bool debugDrawAnnotationRect;

    // Contents
    bool contentsSearchCaseSensitive;
    bool contentsSearchRegularExpression;

    // Layers
    bool layersSearchCaseSensitive;
    bool layersSearchRegularExpression;

    // Reviews
    bool reviewsSearchCaseSensitive;
    bool reviewsSearchRegularExpression;
    QStringList drawingTools;
    QStringList annotationTools;

    // Zoom
    uint zoomMode;

    // General
    bool shellOpenFileInTabs;
    bool showOSD;
    bool displayDocumentTitle;
    bool rtlReadingDirection;
    int displayDocumentNameOrPath;
    bool useTTS;
    bool watchFile;

    // Dlg Presentation
    QColor slidesBackgroundColor;
    int slidesTransition;
    int slidesCursor;
    bool slidesShowProgress;
    bool slidesShowSummary;
    bool slidesTransitionsEnabled;
    int slidesScreen;

    // Main View
    bool showLeftPanel;
    QList<int> splitterSizes;
    bool showBottomBar;

    // Nav Panel
    bool currentPageOnly;
    bool groupByAuthor;
    bool groupByPage;
    bool filterBookmarks;
    bool syncThumbnailsViewport;
    bool tocPageColumn;
    bool sidebarShowText;
    uint sidebarIconSize;

    // PageView
    int editToolBarPlacement;
    bool showScrollBars;
    uint scrollOverlap;
    uint viewColumns;
    bool trimMargins;
    bool viewContinuous;
    int viewMode;
    int trimMode;
    int mouseMode;
    bool showSourceLocationsGraphically;
    bool useCustomBackgroundColor;
    QColor backgroundColor;

    // Search
    bool searchCaseSensitive;
    bool searchFromCurrentPage;
    bool findAsYouType;

    // Dlg Accessibility
    bool highlightImages;
    bool highlightLinks;
    QColor recolorForeground;
    QColor recolorBackground;
    uint bWThreshold;
    uint bWContrast;

    // Identity
    QString identityAuthor;

    // items
    SettingsCore::ItemBool *itemEnableCompositing;
    SettingsCore::ItemBool *itemDebugDrawBoundaries;
    SettingsCore::ItemBool *itemDebugDrawAnnotationRect;
    SettingsCore::ItemBool *itemContentsSearchCaseSensitive;
    SettingsCore::ItemBool *itemContentsSearchRegularExpression;
    SettingsCore::ItemBool *itemLayersSearchCaseSensitive;
    SettingsCore::ItemBool *itemLayersSearchRegularExpression;
    SettingsCore::ItemBool *itemReviewsSearchCaseSensitive;
    SettingsCore::ItemBool *itemReviewsSearchRegularExpression;
    SettingsCore::ItemStringList *itemDrawingTools;
    SettingsCore::ItemStringList *itemAnnotationTools;
    SettingsCore::ItemUInt *itemZoomMode;
    SettingsCore::ItemBool *itemShellOpenFileInTabs;
    SettingsCore::ItemBool *itemShowOSD;
    SettingsCore::ItemBool *itemDisplayDocumentTitle;
    SettingsCore::ItemBool *itemRtlReadingDirection;
    SettingsCore::ItemEnum *itemDisplayDocumentNameOrPath;
    SettingsCore::ItemBool *itemUseTTS;
    SettingsCore::ItemBool *itemWatchFile;
    SettingsCore::ItemColor *itemSlidesBackgroundColor;
    SettingsCore::ItemEnum *itemSlidesTransition;
    SettingsCore::ItemEnum *itemSlidesCursor;
    SettingsCore::ItemBool *itemSlidesShowProgress;
    SettingsCore::ItemBool *itemSlidesShowSummary;
    SettingsCore::ItemBool *itemSlidesTransitionsEnabled;
    SettingsCore::ItemInt *itemSlidesScreen;
    SettingsCore::ItemBool *itemShowLeftPanel;
    SettingsCore::ItemIntList *itemSplitterSizes;
    SettingsCore::ItemBool *itemShowBottomBar;
    SettingsCore::ItemBool *itemCurrentPageOnly;
    SettingsCore::ItemBool *itemGroupByAuthor;
    SettingsCore::ItemBool *itemGroupByPage;
    SettingsCore::ItemBool *itemFilterBookmarks;
    SettingsCore::ItemBool *itemSyncThumbnailsViewport;
    SettingsCore::ItemBool *itemTocPageColumn;
    SettingsCore::ItemBool *itemSidebarShowText;
    SettingsCore::ItemUInt *itemSidebarIconSize;
    SettingsCore::ItemInt *itemEditToolBarPlacement;
    SettingsCore::ItemBool *itemShowScrollBars;
    SettingsCore::ItemUInt *itemScrollOverlap;
    SettingsCore::ItemUInt *itemViewColumns;
    SettingsCore::ItemBool *itemTrimMargins;
    SettingsCore::ItemBool *itemViewContinuous;
    SettingsCore::ItemEnum *itemViewMode;
    SettingsCore::ItemEnum *itemTrimMode;
    SettingsCore::ItemEnum *itemMouseMode;
    SettingsCore::ItemBool *itemShowSourceLocationsGraphically;
    SettingsCore::ItemBool *itemUseCustomBackgroundColor;
    SettingsCore::ItemColor *itemBackgroundColor;
    SettingsCore::ItemBool *itemSearchCaseSensitive;
    SettingsCore::ItemBool *itemSearchFromCurrentPage;
    SettingsCore::ItemBool *itemFindAsYouType;
    SettingsCore::ItemBool *itemHighlightImages;
    SettingsCore::ItemBool *itemHighlightLinks;
    SettingsCore::ItemColor *itemRecolorForeground;
    SettingsCore::ItemColor *itemRecolorBackground;
    SettingsCore::ItemUInt *itemBWThreshold;
    SettingsCore::ItemUInt *itemBWContrast;
    SettingsCore::ItemString *itemIdentityAuthor;
};

}

namespace Okular {

class SettingsHelper
{
  public:
    SettingsHelper() : q(nullptr) {}
    ~SettingsHelper() { delete q; }
    Settings *q;
};
}

Q_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings()->q)
     qFatal("you need to call Settings::instance before using");
  return s_globalSettings()->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(KSharedConfig::openConfig(cfgfilename));
  s_globalSettings()->q->read();
}

void Settings::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(config);
  s_globalSettings()->q->read();
}

Settings::Settings(  KSharedConfig::Ptr config  )
  : SettingsCore( config )
{
  d = new SettingsPrivate;
  Q_ASSERT(!s_globalSettings()->q);
  s_globalSettings()->q = this;
  setCurrentGroup( QStringLiteral( "Dlg Performance" ) );

  d->itemEnableCompositing = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "EnableCompositing" ), d->enableCompositing, true );
  addItem( d->itemEnableCompositing, QStringLiteral( "EnableCompositing" ) );

  setCurrentGroup( QStringLiteral( "Debugging Options" ) );

  d->itemDebugDrawBoundaries = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DebugDrawBoundaries" ), d->debugDrawBoundaries, false );
  addItem( d->itemDebugDrawBoundaries, QStringLiteral( "DebugDrawBoundaries" ) );
  d->itemDebugDrawAnnotationRect = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DebugDrawAnnotationRect" ), d->debugDrawAnnotationRect, false );
  addItem( d->itemDebugDrawAnnotationRect, QStringLiteral( "DebugDrawAnnotationRect" ) );

  setCurrentGroup( QStringLiteral( "Contents" ) );

  d->itemContentsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ContentsSearchCaseSensitive" ), d->contentsSearchCaseSensitive, false );
  addItem( d->itemContentsSearchCaseSensitive, QStringLiteral( "ContentsSearchCaseSensitive" ) );
  d->itemContentsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ContentsSearchRegularExpression" ), d->contentsSearchRegularExpression, false );
  addItem( d->itemContentsSearchRegularExpression, QStringLiteral( "ContentsSearchRegularExpression" ) );

  setCurrentGroup( QStringLiteral( "Layers" ) );

  d->itemLayersSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "LayersSearchCaseSensitive" ), d->layersSearchCaseSensitive, false );
  addItem( d->itemLayersSearchCaseSensitive, QStringLiteral( "LayersSearchCaseSensitive" ) );
  d->itemLayersSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "LayersSearchRegularExpression" ), d->layersSearchRegularExpression, false );
  addItem( d->itemLayersSearchRegularExpression, QStringLiteral( "LayersSearchRegularExpression" ) );

  setCurrentGroup( QStringLiteral( "Reviews" ) );

  d->itemReviewsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ReviewsSearchCaseSensitive" ), d->reviewsSearchCaseSensitive, false );
  addItem( d->itemReviewsSearchCaseSensitive, QStringLiteral( "ReviewsSearchCaseSensitive" ) );
  d->itemReviewsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ReviewsSearchRegularExpression" ), d->reviewsSearchRegularExpression, false );
  addItem( d->itemReviewsSearchRegularExpression, QStringLiteral( "ReviewsSearchRegularExpression" ) );

      QStringList drawingTools;
      // load the default tool list from the 'xml tools definition' file
      QFile infoDrawingFile( QStandardPaths::locate(QStandardPaths::GenericDataLocation, "okular/drawingtools.xml") );
      if ( infoDrawingFile.exists() && infoDrawingFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &infoDrawingFile ) )
          {
              const QDomElement toolsDefinition = doc.elementsByTagName("drawingTools").item( 0 ).toElement();
               // create the annotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  const QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      drawingTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              qWarning() << "DrawingTools XML file seems to be damaged";
          }
      }
      else
      {
          qWarning() << "Unable to open DrawingTools XML definition";
      }
    
  d->itemDrawingTools = new SettingsCore::ItemStringList( currentGroup(), QStringLiteral( "DrawingTools" ), d->drawingTools, drawingTools );
  addItem( d->itemDrawingTools, QStringLiteral( "DrawingTools" ) );

      QStringList annotationTools;
      // load the default tool list from the 'xml tools definition' file
      QFile infoFile( QStandardPaths::locate(QStandardPaths::GenericDataLocation, "okular/tools.xml") );
      if ( infoFile.exists() && infoFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &infoFile ) )
          {
              QDomElement toolsDefinition = doc.elementsByTagName("annotatingTools").item( 0 ).toElement();
               // create the annotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      annotationTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              qWarning() << "AnnotatingTools XML file seems to be damaged";
          }
      }
      else
      {
          qWarning() << "Unable to open AnnotatingTools XML definition";
      }
    
  d->itemAnnotationTools = new SettingsCore::ItemStringList( currentGroup(), QStringLiteral( "AnnotationTools" ), d->annotationTools, annotationTools );
  addItem( d->itemAnnotationTools, QStringLiteral( "AnnotationTools" ) );

  setCurrentGroup( QStringLiteral( "Zoom" ) );

  d->itemZoomMode = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ZoomMode" ), d->zoomMode, 1 );
  d->itemZoomMode->setMaxValue(3);
  addItem( d->itemZoomMode, QStringLiteral( "ZoomMode" ) );

  setCurrentGroup( QStringLiteral( "General" ) );

  d->itemShellOpenFileInTabs = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShellOpenFileInTabs" ), d->shellOpenFileInTabs, false );
  addItem( d->itemShellOpenFileInTabs, QStringLiteral( "ShellOpenFileInTabs" ) );
  d->itemShowOSD = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowOSD" ), d->showOSD, true );
  addItem( d->itemShowOSD, QStringLiteral( "ShowOSD" ) );
  d->itemDisplayDocumentTitle = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DisplayDocumentTitle" ), d->displayDocumentTitle, true );
  addItem( d->itemDisplayDocumentTitle, QStringLiteral( "DisplayDocumentTitle" ) );
  d->itemRtlReadingDirection = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "rtlReadingDirection" ), d->rtlReadingDirection, false );
  addItem( d->itemRtlReadingDirection, QStringLiteral( "rtlReadingDirection" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesDisplayDocumentNameOrPath;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Name");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Path");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  d->itemDisplayDocumentNameOrPath = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "DisplayDocumentNameOrPath" ), d->displayDocumentNameOrPath, valuesDisplayDocumentNameOrPath, EnumDisplayDocumentNameOrPath::Name );
  addItem( d->itemDisplayDocumentNameOrPath, QStringLiteral( "DisplayDocumentNameOrPath" ) );
  d->itemUseTTS = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "UseTTS" ), d->useTTS );
  addItem( d->itemUseTTS, QStringLiteral( "UseTTS" ) );
  d->itemWatchFile = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "WatchFile" ), d->watchFile, true );
  addItem( d->itemWatchFile, QStringLiteral( "WatchFile" ) );

  setCurrentGroup( QStringLiteral( "Dlg Presentation" ) );

  d->itemSlidesBackgroundColor = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "SlidesBackgroundColor" ), d->slidesBackgroundColor, Qt::black );
  addItem( d->itemSlidesBackgroundColor, QStringLiteral( "SlidesBackgroundColor" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesSlidesTransition;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlindsHorizontal");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlindsVertical");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BoxIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BoxOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Dissolve");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Fade");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterRightDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Random");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Replace");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitHorizontalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitHorizontalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitVerticalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitVerticalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeLeft");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeUp");
    valuesSlidesTransition.append( choice );
  }
  d->itemSlidesTransition = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "SlidesTransition" ), d->slidesTransition, valuesSlidesTransition, EnumSlidesTransition::Replace );
  addItem( d->itemSlidesTransition, QStringLiteral( "SlidesTransition" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesSlidesCursor;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HiddenDelay");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Visible");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Hidden");
    valuesSlidesCursor.append( choice );
  }
  d->itemSlidesCursor = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "SlidesCursor" ), d->slidesCursor, valuesSlidesCursor, EnumSlidesCursor::HiddenDelay );
  addItem( d->itemSlidesCursor, QStringLiteral( "SlidesCursor" ) );
  d->itemSlidesShowProgress = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SlidesShowProgress" ), d->slidesShowProgress, true );
  addItem( d->itemSlidesShowProgress, QStringLiteral( "SlidesShowProgress" ) );
  d->itemSlidesShowSummary = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SlidesShowSummary" ), d->slidesShowSummary, false );
  addItem( d->itemSlidesShowSummary, QStringLiteral( "SlidesShowSummary" ) );
  d->itemSlidesTransitionsEnabled = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SlidesTransitionsEnabled" ), d->slidesTransitionsEnabled, true );
  addItem( d->itemSlidesTransitionsEnabled, QStringLiteral( "SlidesTransitionsEnabled" ) );
  d->itemSlidesScreen = new SettingsCore::ItemInt( currentGroup(), QStringLiteral( "SlidesScreen" ), d->slidesScreen, -2 );
  d->itemSlidesScreen->setMinValue(-2);
  d->itemSlidesScreen->setMaxValue(20);
  addItem( d->itemSlidesScreen, QStringLiteral( "SlidesScreen" ) );

  setCurrentGroup( QStringLiteral( "Main View" ) );

  d->itemShowLeftPanel = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowLeftPanel" ), d->showLeftPanel, true );
  addItem( d->itemShowLeftPanel, QStringLiteral( "ShowLeftPanel" ) );
  QList<int> defaultSplitterSizes;

  d->itemSplitterSizes = new SettingsCore::ItemIntList( currentGroup(), QStringLiteral( "SplitterSizes" ), d->splitterSizes, defaultSplitterSizes );
  addItem( d->itemSplitterSizes, QStringLiteral( "SplitterSizes" ) );
  d->itemShowBottomBar = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowBottomBar" ), d->showBottomBar, true );
  addItem( d->itemShowBottomBar, QStringLiteral( "ShowBottomBar" ) );

  setCurrentGroup( QStringLiteral( "Nav Panel" ) );

  d->itemCurrentPageOnly = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "CurrentPageOnly" ), d->currentPageOnly, false );
  addItem( d->itemCurrentPageOnly, QStringLiteral( "CurrentPageOnly" ) );
  d->itemGroupByAuthor = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "GroupByAuthor" ), d->groupByAuthor, true );
  addItem( d->itemGroupByAuthor, QStringLiteral( "GroupByAuthor" ) );
  d->itemGroupByPage = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "GroupByPage" ), d->groupByPage, true );
  addItem( d->itemGroupByPage, QStringLiteral( "GroupByPage" ) );
  d->itemFilterBookmarks = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "FilterBookmarks" ), d->filterBookmarks, false );
  addItem( d->itemFilterBookmarks, QStringLiteral( "FilterBookmarks" ) );
  d->itemSyncThumbnailsViewport = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SyncThumbnailsViewport" ), d->syncThumbnailsViewport, true );
  addItem( d->itemSyncThumbnailsViewport, QStringLiteral( "SyncThumbnailsViewport" ) );
  d->itemTocPageColumn = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "TocPageColumn" ), d->tocPageColumn, true );
  addItem( d->itemTocPageColumn, QStringLiteral( "TocPageColumn" ) );
  d->itemSidebarShowText = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SidebarShowText" ), d->sidebarShowText, true );
  addItem( d->itemSidebarShowText, QStringLiteral( "SidebarShowText" ) );
  d->itemSidebarIconSize = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "SidebarIconSize" ), d->sidebarIconSize, 48 );
  addItem( d->itemSidebarIconSize, QStringLiteral( "SidebarIconSize" ) );

  setCurrentGroup( QStringLiteral( "PageView" ) );

  d->itemEditToolBarPlacement = new SettingsCore::ItemInt( currentGroup(), QStringLiteral( "EditToolBarPlacement" ), d->editToolBarPlacement, 0 );
  addItem( d->itemEditToolBarPlacement, QStringLiteral( "EditToolBarPlacement" ) );
  d->itemShowScrollBars = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowScrollBars" ), d->showScrollBars, true );
  addItem( d->itemShowScrollBars, QStringLiteral( "ShowScrollBars" ) );
  d->itemScrollOverlap = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ScrollOverlap" ), d->scrollOverlap, 0 );
  d->itemScrollOverlap->setMinValue(0);
  d->itemScrollOverlap->setMaxValue(50);
  addItem( d->itemScrollOverlap, QStringLiteral( "ScrollOverlap" ) );
  d->itemViewColumns = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ViewColumns" ), d->viewColumns, 3 );
  d->itemViewColumns->setMinValue(1);
  d->itemViewColumns->setMaxValue(8);
  addItem( d->itemViewColumns, QStringLiteral( "ViewColumns" ) );
  d->itemTrimMargins = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "TrimMargins" ), d->trimMargins, false );
  addItem( d->itemTrimMargins, QStringLiteral( "TrimMargins" ) );
  d->itemViewContinuous = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ViewContinuous" ), d->viewContinuous, true );
  addItem( d->itemViewContinuous, QStringLiteral( "ViewContinuous" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesViewMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Single");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Facing");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("FacingFirstCentered");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Summary");
    valuesViewMode.append( choice );
  }
  d->itemViewMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "ViewMode" ), d->viewMode, valuesViewMode, EnumViewMode::Single );
  addItem( d->itemViewMode, QStringLiteral( "ViewMode" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesTrimMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    valuesTrimMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Margins");
    valuesTrimMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Selection");
    valuesTrimMode.append( choice );
  }
  d->itemTrimMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "TrimMode" ), d->trimMode, valuesTrimMode, EnumTrimMode::None );
  addItem( d->itemTrimMode, QStringLiteral( "TrimMode" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesMouseMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Browse");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Zoom");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RectSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TextSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TableSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Magnifier");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TrimSelect");
    valuesMouseMode.append( choice );
  }
  d->itemMouseMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "MouseMode" ), d->mouseMode, valuesMouseMode, EnumMouseMode::Browse );
  addItem( d->itemMouseMode, QStringLiteral( "MouseMode" ) );
  d->itemShowSourceLocationsGraphically = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowSourceLocationsGraphically" ), d->showSourceLocationsGraphically, false );
  addItem( d->itemShowSourceLocationsGraphically, QStringLiteral( "ShowSourceLocationsGraphically" ) );
  d->itemUseCustomBackgroundColor = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "UseCustomBackgroundColor" ), d->useCustomBackgroundColor, false );
  addItem( d->itemUseCustomBackgroundColor, QStringLiteral( "UseCustomBackgroundColor" ) );
  d->itemBackgroundColor = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "BackgroundColor" ), d->backgroundColor );
  addItem( d->itemBackgroundColor, QStringLiteral( "BackgroundColor" ) );

  setCurrentGroup( QStringLiteral( "Search" ) );

  d->itemSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SearchCaseSensitive" ), d->searchCaseSensitive, false );
  addItem( d->itemSearchCaseSensitive, QStringLiteral( "SearchCaseSensitive" ) );
  d->itemSearchFromCurrentPage = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SearchFromCurrentPage" ), d->searchFromCurrentPage, true );
  addItem( d->itemSearchFromCurrentPage, QStringLiteral( "SearchFromCurrentPage" ) );
  d->itemFindAsYouType = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "FindAsYouType" ), d->findAsYouType, true );
  addItem( d->itemFindAsYouType, QStringLiteral( "FindAsYouType" ) );

  setCurrentGroup( QStringLiteral( "Dlg Accessibility" ) );

  d->itemHighlightImages = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "HighlightImages" ), d->highlightImages, false );
  addItem( d->itemHighlightImages, QStringLiteral( "HighlightImages" ) );
  d->itemHighlightLinks = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "HighlightLinks" ), d->highlightLinks, false );
  addItem( d->itemHighlightLinks, QStringLiteral( "HighlightLinks" ) );
  d->itemRecolorForeground = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "RecolorForeground" ), d->recolorForeground, 0x600000 );
  addItem( d->itemRecolorForeground, QStringLiteral( "RecolorForeground" ) );
  d->itemRecolorBackground = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "RecolorBackground" ), d->recolorBackground, 0xF0F0F0 );
  addItem( d->itemRecolorBackground, QStringLiteral( "RecolorBackground" ) );
  d->itemBWThreshold = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "BWThreshold" ), d->bWThreshold, 127 );
  d->itemBWThreshold->setMinValue(2);
  d->itemBWThreshold->setMaxValue(253);
  addItem( d->itemBWThreshold, QStringLiteral( "BWThreshold" ) );
  d->itemBWContrast = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "BWContrast" ), d->bWContrast, 2 );
  d->itemBWContrast->setMinValue(2);
  d->itemBWContrast->setMaxValue(6);
  addItem( d->itemBWContrast, QStringLiteral( "BWContrast" ) );

  setCurrentGroup( QStringLiteral( "Identity" ) );


      KUser currentUser;
      QString userString = currentUser.property( KUser::FullName ).toString();
      if ( userString.isEmpty() )
      {
        userString = currentUser.loginName();
      }
    
  d->itemIdentityAuthor = new SettingsCore::ItemString( currentGroup(), QStringLiteral( "IdentityAuthor" ), d->identityAuthor, userString );
  addItem( d->itemIdentityAuthor, QStringLiteral( "IdentityAuthor" ) );
}

void Settings::setEnableCompositing( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "EnableCompositing" ) ))
        self()->d->enableCompositing = v;
}

bool Settings::enableCompositing()
{
  return self()->d->enableCompositing;
}


void Settings::setDebugDrawBoundaries( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "DebugDrawBoundaries" ) ))
        self()->d->debugDrawBoundaries = v;
}

bool Settings::debugDrawBoundaries()
{
  return self()->d->debugDrawBoundaries;
}


void Settings::setDebugDrawAnnotationRect( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "DebugDrawAnnotationRect" ) ))
        self()->d->debugDrawAnnotationRect = v;
}

bool Settings::debugDrawAnnotationRect()
{
  return self()->d->debugDrawAnnotationRect;
}


void Settings::setContentsSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ContentsSearchCaseSensitive" ) ))
        self()->d->contentsSearchCaseSensitive = v;
}

bool Settings::contentsSearchCaseSensitive()
{
  return self()->d->contentsSearchCaseSensitive;
}


void Settings::setContentsSearchRegularExpression( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ContentsSearchRegularExpression" ) ))
        self()->d->contentsSearchRegularExpression = v;
}

bool Settings::contentsSearchRegularExpression()
{
  return self()->d->contentsSearchRegularExpression;
}


void Settings::setLayersSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "LayersSearchCaseSensitive" ) ))
        self()->d->layersSearchCaseSensitive = v;
}

bool Settings::layersSearchCaseSensitive()
{
  return self()->d->layersSearchCaseSensitive;
}


void Settings::setLayersSearchRegularExpression( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "LayersSearchRegularExpression" ) ))
        self()->d->layersSearchRegularExpression = v;
}

bool Settings::layersSearchRegularExpression()
{
  return self()->d->layersSearchRegularExpression;
}


void Settings::setReviewsSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ReviewsSearchCaseSensitive" ) ))
        self()->d->reviewsSearchCaseSensitive = v;
}

bool Settings::reviewsSearchCaseSensitive()
{
  return self()->d->reviewsSearchCaseSensitive;
}


void Settings::setReviewsSearchRegularExpression( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ReviewsSearchRegularExpression" ) ))
        self()->d->reviewsSearchRegularExpression = v;
}

bool Settings::reviewsSearchRegularExpression()
{
  return self()->d->reviewsSearchRegularExpression;
}


void Settings::setDrawingTools( const QStringList & v )
{
      if (!self()->isImmutable( QStringLiteral( "DrawingTools" ) ))
        self()->d->drawingTools = v;
}

QStringList Settings::drawingTools()
{
  return self()->d->drawingTools;
}


void Settings::setAnnotationTools( const QStringList & v )
{
      if (!self()->isImmutable( QStringLiteral( "AnnotationTools" ) ))
        self()->d->annotationTools = v;
}

QStringList Settings::annotationTools()
{
  return self()->d->annotationTools;
}


void Settings::setZoomMode( uint v )
{

      if (v > 3)
      {
        qDebug() << "setZoomMode: value " << v << " is greater than the maximum value of 3";
        v = 3;
      }

      if (!self()->isImmutable( QStringLiteral( "ZoomMode" ) ))
        self()->d->zoomMode = v;
}

uint Settings::zoomMode()
{
  return self()->d->zoomMode;
}


void Settings::setShellOpenFileInTabs( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShellOpenFileInTabs" ) ))
        self()->d->shellOpenFileInTabs = v;
}

bool Settings::shellOpenFileInTabs()
{
  return self()->d->shellOpenFileInTabs;
}


void Settings::setShowOSD( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShowOSD" ) ))
        self()->d->showOSD = v;
}

bool Settings::showOSD()
{
  return self()->d->showOSD;
}


void Settings::setDisplayDocumentTitle( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "DisplayDocumentTitle" ) ))
        self()->d->displayDocumentTitle = v;
}

bool Settings::displayDocumentTitle()
{
  return self()->d->displayDocumentTitle;
}


void Settings::setRtlReadingDirection( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "rtlReadingDirection" ) ))
        self()->d->rtlReadingDirection = v;
}

bool Settings::rtlReadingDirection()
{
  return self()->d->rtlReadingDirection;
}


void Settings::setDisplayDocumentNameOrPath( int v )
{
      if (!self()->isImmutable( QStringLiteral( "DisplayDocumentNameOrPath" ) ))
        self()->d->displayDocumentNameOrPath = v;
}

int Settings::displayDocumentNameOrPath()
{
  return self()->d->displayDocumentNameOrPath;
}


void Settings::setUseTTS( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "UseTTS" ) ))
        self()->d->useTTS = v;
}

bool Settings::useTTS()
{
  return self()->d->useTTS;
}


void Settings::setWatchFile( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "WatchFile" ) ))
        self()->d->watchFile = v;
}

bool Settings::watchFile()
{
  return self()->d->watchFile;
}


void Settings::setSlidesBackgroundColor( const QColor & v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesBackgroundColor" ) ))
        self()->d->slidesBackgroundColor = v;
}

QColor Settings::slidesBackgroundColor()
{
  return self()->d->slidesBackgroundColor;
}


void Settings::setSlidesTransition( int v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesTransition" ) ))
        self()->d->slidesTransition = v;
}

int Settings::slidesTransition()
{
  return self()->d->slidesTransition;
}


void Settings::setSlidesCursor( int v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesCursor" ) ))
        self()->d->slidesCursor = v;
}

int Settings::slidesCursor()
{
  return self()->d->slidesCursor;
}


void Settings::setSlidesShowProgress( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesShowProgress" ) ))
        self()->d->slidesShowProgress = v;
}

bool Settings::slidesShowProgress()
{
  return self()->d->slidesShowProgress;
}


void Settings::setSlidesShowSummary( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesShowSummary" ) ))
        self()->d->slidesShowSummary = v;
}

bool Settings::slidesShowSummary()
{
  return self()->d->slidesShowSummary;
}


void Settings::setSlidesTransitionsEnabled( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesTransitionsEnabled" ) ))
        self()->d->slidesTransitionsEnabled = v;
}

bool Settings::slidesTransitionsEnabled()
{
  return self()->d->slidesTransitionsEnabled;
}


void Settings::setSlidesScreen( int v )
{
      if (v < -2)
      {
        qDebug() << "setSlidesScreen: value " << v << " is less than the minimum value of -2";
        v = -2;
      }

      if (v > 20)
      {
        qDebug() << "setSlidesScreen: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (!self()->isImmutable( QStringLiteral( "SlidesScreen" ) ))
        self()->d->slidesScreen = v;
}

int Settings::slidesScreen()
{
  return self()->d->slidesScreen;
}


void Settings::setShowLeftPanel( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShowLeftPanel" ) ))
        self()->d->showLeftPanel = v;
}

bool Settings::showLeftPanel()
{
  return self()->d->showLeftPanel;
}


void Settings::setSplitterSizes( const QList<int> & v )
{
      if (!self()->isImmutable( QStringLiteral( "SplitterSizes" ) ))
        self()->d->splitterSizes = v;
}

QList<int> Settings::splitterSizes()
{
  return self()->d->splitterSizes;
}


void Settings::setShowBottomBar( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShowBottomBar" ) ))
        self()->d->showBottomBar = v;
}

bool Settings::showBottomBar()
{
  return self()->d->showBottomBar;
}


void Settings::setCurrentPageOnly( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "CurrentPageOnly" ) ))
        self()->d->currentPageOnly = v;
}

bool Settings::currentPageOnly()
{
  return self()->d->currentPageOnly;
}


void Settings::setGroupByAuthor( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "GroupByAuthor" ) ))
        self()->d->groupByAuthor = v;
}

bool Settings::groupByAuthor()
{
  return self()->d->groupByAuthor;
}


void Settings::setGroupByPage( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "GroupByPage" ) ))
        self()->d->groupByPage = v;
}

bool Settings::groupByPage()
{
  return self()->d->groupByPage;
}


void Settings::setFilterBookmarks( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "FilterBookmarks" ) ))
        self()->d->filterBookmarks = v;
}

bool Settings::filterBookmarks()
{
  return self()->d->filterBookmarks;
}


void Settings::setSyncThumbnailsViewport( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SyncThumbnailsViewport" ) ))
        self()->d->syncThumbnailsViewport = v;
}

bool Settings::syncThumbnailsViewport()
{
  return self()->d->syncThumbnailsViewport;
}


void Settings::setTocPageColumn( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "TocPageColumn" ) ))
        self()->d->tocPageColumn = v;
}

bool Settings::tocPageColumn()
{
  return self()->d->tocPageColumn;
}


void Settings::setSidebarShowText( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SidebarShowText" ) ))
        self()->d->sidebarShowText = v;
}

bool Settings::sidebarShowText()
{
  return self()->d->sidebarShowText;
}


void Settings::setSidebarIconSize( uint v )
{
      if (!self()->isImmutable( QStringLiteral( "SidebarIconSize" ) ))
        self()->d->sidebarIconSize = v;
}

uint Settings::sidebarIconSize()
{
  return self()->d->sidebarIconSize;
}


void Settings::setEditToolBarPlacement( int v )
{
      if (!self()->isImmutable( QStringLiteral( "EditToolBarPlacement" ) ))
        self()->d->editToolBarPlacement = v;
}

int Settings::editToolBarPlacement()
{
  return self()->d->editToolBarPlacement;
}


void Settings::setShowScrollBars( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShowScrollBars" ) ))
        self()->d->showScrollBars = v;
}

bool Settings::showScrollBars()
{
  return self()->d->showScrollBars;
}


void Settings::setScrollOverlap( uint v )
{

      if (v > 50)
      {
        qDebug() << "setScrollOverlap: value " << v << " is greater than the maximum value of 50";
        v = 50;
      }

      if (!self()->isImmutable( QStringLiteral( "ScrollOverlap" ) ))
        self()->d->scrollOverlap = v;
}

uint Settings::scrollOverlap()
{
  return self()->d->scrollOverlap;
}


void Settings::setViewColumns( uint v )
{
      if (v < 1)
      {
        qDebug() << "setViewColumns: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 8)
      {
        qDebug() << "setViewColumns: value " << v << " is greater than the maximum value of 8";
        v = 8;
      }

      if (!self()->isImmutable( QStringLiteral( "ViewColumns" ) ))
        self()->d->viewColumns = v;
}

uint Settings::viewColumns()
{
  return self()->d->viewColumns;
}


void Settings::setTrimMargins( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "TrimMargins" ) ))
        self()->d->trimMargins = v;
}

bool Settings::trimMargins()
{
  return self()->d->trimMargins;
}


void Settings::setViewContinuous( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ViewContinuous" ) ))
        self()->d->viewContinuous = v;
}

bool Settings::viewContinuous()
{
  return self()->d->viewContinuous;
}


void Settings::setViewMode( int v )
{
      if (!self()->isImmutable( QStringLiteral( "ViewMode" ) ))
        self()->d->viewMode = v;
}

int Settings::viewMode()
{
  return self()->d->viewMode;
}


void Settings::setTrimMode( int v )
{
      if (!self()->isImmutable( QStringLiteral( "TrimMode" ) ))
        self()->d->trimMode = v;
}

int Settings::trimMode()
{
  return self()->d->trimMode;
}


void Settings::setMouseMode( int v )
{
      if (!self()->isImmutable( QStringLiteral( "MouseMode" ) ))
        self()->d->mouseMode = v;
}

int Settings::mouseMode()
{
  return self()->d->mouseMode;
}


void Settings::setShowSourceLocationsGraphically( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ShowSourceLocationsGraphically" ) ))
        self()->d->showSourceLocationsGraphically = v;
}

bool Settings::showSourceLocationsGraphically()
{
  return self()->d->showSourceLocationsGraphically;
}


void Settings::setUseCustomBackgroundColor( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "UseCustomBackgroundColor" ) ))
        self()->d->useCustomBackgroundColor = v;
}

bool Settings::useCustomBackgroundColor()
{
  return self()->d->useCustomBackgroundColor;
}


void Settings::setBackgroundColor( const QColor & v )
{
      if (!self()->isImmutable( QStringLiteral( "BackgroundColor" ) ))
        self()->d->backgroundColor = v;
}

QColor Settings::backgroundColor()
{
  return self()->d->backgroundColor;
}


void Settings::setSearchCaseSensitive( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SearchCaseSensitive" ) ))
        self()->d->searchCaseSensitive = v;
}

bool Settings::searchCaseSensitive()
{
  return self()->d->searchCaseSensitive;
}


void Settings::setSearchFromCurrentPage( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SearchFromCurrentPage" ) ))
        self()->d->searchFromCurrentPage = v;
}

bool Settings::searchFromCurrentPage()
{
  return self()->d->searchFromCurrentPage;
}


void Settings::setFindAsYouType( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "FindAsYouType" ) ))
        self()->d->findAsYouType = v;
}

bool Settings::findAsYouType()
{
  return self()->d->findAsYouType;
}


void Settings::setHighlightImages( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "HighlightImages" ) ))
        self()->d->highlightImages = v;
}

bool Settings::highlightImages()
{
  return self()->d->highlightImages;
}


void Settings::setHighlightLinks( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "HighlightLinks" ) ))
        self()->d->highlightLinks = v;
}

bool Settings::highlightLinks()
{
  return self()->d->highlightLinks;
}


void Settings::setRecolorForeground( const QColor & v )
{
      if (!self()->isImmutable( QStringLiteral( "RecolorForeground" ) ))
        self()->d->recolorForeground = v;
}

QColor Settings::recolorForeground()
{
  return self()->d->recolorForeground;
}


void Settings::setRecolorBackground( const QColor & v )
{
      if (!self()->isImmutable( QStringLiteral( "RecolorBackground" ) ))
        self()->d->recolorBackground = v;
}

QColor Settings::recolorBackground()
{
  return self()->d->recolorBackground;
}


void Settings::setBWThreshold( uint v )
{
      if (v < 2)
      {
        qDebug() << "setBWThreshold: value " << v << " is less than the minimum value of 2";
        v = 2;
      }

      if (v > 253)
      {
        qDebug() << "setBWThreshold: value " << v << " is greater than the maximum value of 253";
        v = 253;
      }

      if (!self()->isImmutable( QStringLiteral( "BWThreshold" ) ))
        self()->d->bWThreshold = v;
}

uint Settings::bWThreshold()
{
  return self()->d->bWThreshold;
}


void Settings::setBWContrast( uint v )
{
      if (v < 2)
      {
        qDebug() << "setBWContrast: value " << v << " is less than the minimum value of 2";
        v = 2;
      }

      if (v > 6)
      {
        qDebug() << "setBWContrast: value " << v << " is greater than the maximum value of 6";
        v = 6;
      }

      if (!self()->isImmutable( QStringLiteral( "BWContrast" ) ))
        self()->d->bWContrast = v;
}

uint Settings::bWContrast()
{
  return self()->d->bWContrast;
}


void Settings::setIdentityAuthor( const QString & v )
{
      if (!self()->isImmutable( QStringLiteral( "IdentityAuthor" ) ))
        self()->d->identityAuthor = v;
}

QString Settings::identityAuthor()
{
  return self()->d->identityAuthor;
}


Settings::~Settings()
{
  delete d;
  s_globalSettings()->q = nullptr;
}

