#ifndef PERMUTE_RANDOM_FCN_H
#define PERMUTE_RANDOM_FCN_H

#include <octave/oct.h>
#include <octave/oct-map.h>
#include <octave/parse.h>

#include <ctime>

#include "Permute_fcn.h"

class Permute_random_fcn : public Permute_fcn
{
protected:
  Array <octave_idx_type> exclude;
public:

  Permute_random_fcn (Matrix *input = NULL, const Matrix &_exclude = Matrix ())
    : exclude (_exclude) 
  {
    this->series = input;

    if ((this->series != NULL) && (this->exclude.numel () > 0))
      this->prepare_exclude ();

//    srand (time (NULL));
  }

  Permute_random_fcn (Matrix *input, const octave_scalar_map &params)
  {
    if (params.isfield (std::string ("exclude")) && input != NULL)
      {
        this->series = input;

        this->exclude = params.getfield (std::string ("exclude"))
                         .octave_idx_type_vector_value (); 
        // Change exclude from Octave style indexing to C-style
        for (octave_idx_type i = 0; i < exclude.numel (); i++)
          this->exclude(i) = this->exclude(i) - 1;

        this->prepare_exclude ();

//        srand (time (NULL));
      }
    else
      {
        error_with_id ("Octave:tisean", "Permute function constructor did not "
                                        "receive correct parameters");
      }
  }


  void permute (octave_idx_type &n1, octave_idx_type &n2)
  {
    n1 = rand () % this->series->rows ();
      while (exclude_contains (n1))
        n1 = rand () % this->series->rows ();

    n2 = rand () % this->series->rows ();
      while (exclude_contains (n2) || n2 == n1)
        n2 = rand () % this->series->rows ();
  }

  void exch (octave_idx_type n1, octave_idx_type n2)
  {
    double tmp = (*series)(n1);
    (*series)(n1) = (*series)(n2);
    (*series)(n2) = tmp;
  }

  void scramble ()
  {
    for (octave_idx_type i = 0; i < this->series->rows (); i++)
      {
        octave_idx_type n1, n2;
        this->permute (n1, n2);
        this->exch (n1, n2);
      }
  }

private:
  bool prepare_exclude ();

  // Helper functions
  bool exclude_contains (octave_idx_type n) const
  {
    bool flag_contains = false;
    const octave_idx_type *exclude_ptr = exclude.fortran_vec ();
    for (octave_idx_type i = 0; i < exclude.numel () && flag_contains == false;
         i++)
      if (n == exclude_ptr[i])
        flag_contains = true;

    return flag_contains;
  }

};

#endif
