/***************************************************
	mined keyboard mapping table
	* adapted from X keyboard mapping file
*/
struct keymap keymap_Thai [] = {
	{"!", "ๅ"},	/* U+0E45: THAI CHARACTER LAKKHANGYAO */
	{"\"", "."},	/* U+002E: FULL STOP */
	{"#", "๒"},	/* U+0E52: THAI DIGIT TWO */
	{"$", "๓"},	/* U+0E53: THAI DIGIT THREE */
	{"%", "๔"},	/* U+0E54: THAI DIGIT FOUR */
	{"&", "๎"},	/* U+0E4E: THAI CHARACTER YAMAKKAN */
	{"'", "ง"},	/* U+0E07: THAI CHARACTER NGO NGU */
	{"(", "๖"},	/* U+0E56: THAI DIGIT SIX */
	{")", "๗"},	/* U+0E57: THAI DIGIT SEVEN */
	{"*", "๕"},	/* U+0E55: THAI DIGIT FIVE */
	{"+", "๙"},	/* U+0E59: THAI DIGIT NINE */
	{",", "ม"},	/* U+0E21: THAI CHARACTER MO MA */
	{"-", "ข"},	/* U+0E02: THAI CHARACTER KHO KHAI */
	{".", "ใ"},	/* U+0E43: THAI CHARACTER SARA AI MAIMUAN */
	{"/", "ฝ"},	/* U+0E1D: THAI CHARACTER FO FA */
	{"0", "จ"},	/* U+0E08: THAI CHARACTER CHO CHAN */
	{"1", "฿"},	/* U+0E3F: THAI CURRENCY SYMBOL BAHT */
	{"2", "/"},	/* U+002F: SOLIDUS */
	{"3", "-"},	/* U+002D: HYPHEN-MINUS */
	{"4", "ภ"},	/* U+0E20: THAI CHARACTER PHO SAMPHAO */
	{"5", "ถ"},	/* U+0E16: THAI CHARACTER THO THUNG */
	{"6", "ุ"},	/* U+0E38: THAI CHARACTER SARA U */
	{"7", "ึ"},	/* U+0E36: THAI CHARACTER SARA UE */
	{"8", "ค"},	/* U+0E04: THAI CHARACTER KHO KHWAI */
	{"9", "ต"},	/* U+0E15: THAI CHARACTER TO TAO */
	{":", "ซ"},	/* U+0E0B: THAI CHARACTER SO SO */
	{";", "ว"},	/* U+0E27: THAI CHARACTER WO WAEN */
	{"<", "ฒ"},	/* U+0E12: THAI CHARACTER THO PHUTHAO */
	{"=", "ช"},	/* U+0E0A: THAI CHARACTER CHO CHANG */
	{">", "ฬ"},	/* U+0E2C: THAI CHARACTER LO CHULA */
	{"?", "ฦ"},	/* U+0E26: THAI CHARACTER LU */
	{"@", "๑"},	/* U+0E51: THAI DIGIT ONE */
	{"A", "ฤ"},	/* U+0E24: THAI CHARACTER RU */
	{"B", "ฺ"},	/* U+0E3A: THAI CHARACTER PHINTHU */
	{"C", "ฉ"},	/* U+0E09: THAI CHARACTER CHO CHING */
	{"D", "ฏ"},	/* U+0E0F: THAI CHARACTER TO PATAK */
	{"E", "ฎ"},	/* U+0E0E: THAI CHARACTER DO CHADA */
	{"F", "โ"},	/* U+0E42: THAI CHARACTER SARA O */
	{"G", "ฌ"},	/* U+0E0C: THAI CHARACTER CHO CHOE */
	{"H", "็"},	/* U+0E47: THAI CHARACTER MAITAIKHU */
	{"I", "ณ"},	/* U+0E13: THAI CHARACTER NO NEN */
	{"J", "๋"},	/* U+0E4B: THAI CHARACTER MAI CHATTAWA */
	{"K", "ษ"},	/* U+0E29: THAI CHARACTER SO RUSI */
	{"L", "ศ"},	/* U+0E28: THAI CHARACTER SO SALA */
	{"M", "?"},	/* U+003F: QUESTION MARK */
	{"N", "์"},	/* U+0E4C: THAI CHARACTER THANTHAKHAT */
	{"O", "ฯ"},	/* U+0E2F: THAI CHARACTER PAIYANNOI */
	{"P", "ญ"},	/* U+0E0D: THAI CHARACTER YO YING */
	{"Q", "๐"},	/* U+0E50: THAI DIGIT ZERO */
	{"R", "ฑ"},	/* U+0E11: THAI CHARACTER THO NANGMONTHO */
	{"S", "ฆ"},	/* U+0E06: THAI CHARACTER KHO RAKHANG */
	{"T", "ธ"},	/* U+0E18: THAI CHARACTER THO THONG */
	{"U", "๊"},	/* U+0E4A: THAI CHARACTER MAI TRI */
	{"V", "ฮ"},	/* U+0E2E: THAI CHARACTER HO NOKHUK */
	{"W", "\""},	/* U+0022: QUOTATION MARK */
	{"X", ")"},	/* U+0029: RIGHT PARENTHESIS */
	{"Y", "ํ"},	/* U+0E4D: THAI CHARACTER NIKHAHIT */
	{"Z", "("},	/* U+0028: LEFT PARENTHESIS */
	{"[", "บ"},	/* U+0E1A: THAI CHARACTER BO BAIMAI */
	{"\\", "ฅ"},	/* U+0E05: THAI CHARACTER KHO KHON */
	{"]", "ล"},	/* U+0E25: THAI CHARACTER LO LING */
	{"^", "ู"},	/* U+0E39: THAI CHARACTER SARA UU */
	{"_", "๘"},	/* U+0E58: THAI DIGIT EIGHT */
	{"`", "๏"},	/* U+0E4F: THAI CHARACTER FONGMAN */
	{"a", "ฟ"},	/* U+0E1F: THAI CHARACTER FO FAN */
	{"b", "ิ"},	/* U+0E34: THAI CHARACTER SARA I */
	{"c", "แ"},	/* U+0E41: THAI CHARACTER SARA AE */
	{"d", "ก"},	/* U+0E01: THAI CHARACTER KO KAI */
	{"e", "ำ"},	/* U+0E33: THAI CHARACTER SARA AM */
	{"f", "ด"},	/* U+0E14: THAI CHARACTER DO DEK */
	{"g", "เ"},	/* U+0E40: THAI CHARACTER SARA E */
	{"h", "้"},	/* U+0E49: THAI CHARACTER MAI THO */
	{"i", "ร"},	/* U+0E23: THAI CHARACTER RO RUA */
	{"j", "่"},	/* U+0E48: THAI CHARACTER MAI EK */
	{"k", "า"},	/* U+0E32: THAI CHARACTER SARA AA */
	{"l", "ส"},	/* U+0E2A: THAI CHARACTER SO SUA */
	{"m", "ท"},	/* U+0E17: THAI CHARACTER THO THAHAN */
	{"n", "ื"},	/* U+0E37: THAI CHARACTER SARA UEE */
	{"o", "น"},	/* U+0E19: THAI CHARACTER NO NU */
	{"p", "ย"},	/* U+0E22: THAI CHARACTER YO YAK */
	{"q", "ๆ"},	/* U+0E46: THAI CHARACTER MAIYAMOK */
	{"r", "พ"},	/* U+0E1E: THAI CHARACTER PHO PHAN */
	{"s", "ห"},	/* U+0E2B: THAI CHARACTER HO HIP */
	{"t", "ะ"},	/* U+0E30: THAI CHARACTER SARA A */
	{"u", "ี"},	/* U+0E35: THAI CHARACTER SARA II */
	{"v", "อ"},	/* U+0E2D: THAI CHARACTER O ANG */
	{"w", "ไ"},	/* U+0E44: THAI CHARACTER SARA AI MAIMALAI */
	{"x", "ป"},	/* U+0E1B: THAI CHARACTER PO PLA */
	{"y", "ั"},	/* U+0E31: THAI CHARACTER MAI HAN-AKAT */
	{"z", "ผ"},	/* U+0E1C: THAI CHARACTER PHO PHUNG */
	{"{", "ฐ"},	/* U+0E10: THAI CHARACTER THO THAN */
	{"|", "ฃ"},	/* U+0E03: THAI CHARACTER KHO KHUAT */
	{"}", ","},	/* U+002C: COMMA */
	{"~", "๛"},	/* U+0E5B: THAI CHARACTER KHOMUT */
	{NIL_PTR}
};
