; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zve64x,+xandesvsintload \
; RUN:   -verify-machineinstrs -target-abi=ilp32 | FileCheck %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zve64x,+xandesvsintload \
; RUN:   -verify-machineinstrs -target-abi=lp64 | FileCheck %s

define <vscale x 1 x i8> @intrinsic_nds_vlnu_v_nxv1i8_nxv1i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.nds.vlnu.nxv1i8(
    <vscale x 1 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 1 x i8> %a
}

define <vscale x 1 x i8> @intrinsic_nds_vlnu_mask_v_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.nds.vlnu.mask.nxv1i8(
    <vscale x 1 x i8> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 1 x i8> %a
}

define <vscale x 2 x i8> @intrinsic_nds_vlnu_v_nxv2i8_nxv2i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i8> @llvm.riscv.nds.vlnu.nxv2i8(
    <vscale x 2 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 2 x i8> %a
}

define <vscale x 2 x i8> @intrinsic_nds_vlnu_mask_v_nxv2i8_nxv2i8(<vscale x 2 x i8> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i8> @llvm.riscv.nds.vlnu.mask.nxv2i8(
    <vscale x 2 x i8> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 2 x i8> %a
}

define <vscale x 4 x i8> @intrinsic_nds_vlnu_v_nxv4i8_nxv4i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i8> @llvm.riscv.nds.vlnu.nxv4i8(
    <vscale x 4 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 4 x i8> %a
}

define <vscale x 4 x i8> @intrinsic_nds_vlnu_mask_v_nxv4i8_nxv4i8(<vscale x 4 x i8> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i8> @llvm.riscv.nds.vlnu.mask.nxv4i8(
    <vscale x 4 x i8> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 4 x i8> %a
}

define <vscale x 8 x i8> @intrinsic_nds_vlnu_v_nxv8i8_nxv8i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i8> @llvm.riscv.nds.vlnu.nxv8i8(
    <vscale x 8 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 8 x i8> %a
}

define <vscale x 8 x i8> @intrinsic_nds_vlnu_mask_v_nxv8i8_nxv8i8(<vscale x 8 x i8> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i8> @llvm.riscv.nds.vlnu.mask.nxv8i8(
    <vscale x 8 x i8> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 8 x i8> %a
}

define <vscale x 16 x i8> @intrinsic_nds_vlnu_v_nxv16i8_nxv16i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i8> @llvm.riscv.nds.vlnu.nxv16i8(
    <vscale x 16 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 16 x i8> %a
}

define <vscale x 16 x i8> @intrinsic_nds_vlnu_mask_v_nxv16i8_nxv16i8(<vscale x 16 x i8> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i8> @llvm.riscv.nds.vlnu.mask.nxv16i8(
    <vscale x 16 x i8> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 16 x i8> %a
}

define <vscale x 32 x i8> @intrinsic_nds_vlnu_v_nxv32i8_nxv32i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i8> @llvm.riscv.nds.vlnu.nxv32i8(
    <vscale x 32 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 32 x i8> %a
}

define <vscale x 32 x i8> @intrinsic_nds_vlnu_mask_v_nxv32i8_nxv32i8(<vscale x 32 x i8> %0, ptr %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i8> @llvm.riscv.nds.vlnu.mask.nxv32i8(
    <vscale x 32 x i8> %0,
    ptr %1,
    <vscale x 32 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 32 x i8> %a
}

define <vscale x 64 x i8> @intrinsic_nds_vlnu_v_nxv64i8_nxv64i8(ptr %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    nds.vlnu8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 64 x i8> @llvm.riscv.nds.vlnu.nxv64i8(
    <vscale x 64 x i8> poison,
    ptr %0,
    iXLen %1)

  ret <vscale x 64 x i8> %a
}

define <vscale x 64 x i8> @intrinsic_nds_vlnu_mask_v_nxv64i8_nxv64i8(<vscale x 64 x i8> %0, ptr %1, <vscale x 64 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_nds_vlnu_mask_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, mu
; CHECK-NEXT:    nds.vlnu8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 64 x i8> @llvm.riscv.nds.vlnu.mask.nxv64i8(
    <vscale x 64 x i8> %0,
    ptr %1,
    <vscale x 64 x i1> %2,
    iXLen %3, iXLen 1)

  ret <vscale x 64 x i8> %a
}
