; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -global-isel -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefix=CHECKIF %s
; RUN: llc -mtriple=riscv64 -global-isel -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefix=CHECKIF %s
; RUN: llc -mtriple=riscv32 -global-isel -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -global-isel -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

; These tests are each targeted at a particular RISC-V FPU instruction.
; Compares and conversions can be found in float-fcmp.ll and float-convert.ll
; respectively. Some other float-*.ll files in this folder exercise LLVM IR
; instructions that don't directly match a RISC-V instruction.

define float @fadd_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fadd_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fadd.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fadd_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fadd_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fadd float %a, %b
  ret float %1
}

define float @fsub_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fsub_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fsub.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fsub_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __subsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fsub_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __subsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fsub float %a, %b
  ret float %1
}

define float @fmul_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fmul_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmul.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmul_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmul_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fmul float %a, %b
  ret float %1
}

define float @fdiv_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fdiv_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fdiv.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fdiv_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __divsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fdiv_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __divsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fdiv float %a, %b
  ret float %1
}

declare float @llvm.sqrt.f32(float)

define float @fsqrt_s(float %a) nounwind {
; CHECKIF-LABEL: fsqrt_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fsqrt.s fa0, fa0
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fsqrt_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call sqrtf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fsqrt_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call sqrtf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call float @llvm.sqrt.f32(float %a)
  ret float %1
}

declare float @llvm.copysign.f32(float, float)

define float @fsgnj_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fsgnj_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fsgnj.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fsgnj_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 524288
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fsgnj_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 524288
; RV64I-NEXT:    slli a0, a0, 33
; RV64I-NEXT:    srli a0, a0, 33
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
  %1 = call float @llvm.copysign.f32(float %a, float %b)
  ret float %1
}

define i32 @fneg_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fneg_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fadd.s fa5, fa0, fa0
; CHECKIF-NEXT:    fneg.s fa4, fa5
; CHECKIF-NEXT:    feq.s a0, fa5, fa4
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fneg_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a1, a0, a1
; RV32I-NEXT:    call __eqsf2
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fneg_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a1, a0, a1
; RV64I-NEXT:    call __eqsf2
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fadd float %a, %a
  %2 = fneg float %1
  %3 = fcmp oeq float %1, %2
  %4 = zext i1 %3 to i32
  ret i32 %4
}

define float @fsgnjn_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fsgnjn_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fadd.s fa5, fa0, fa1
; CHECKIF-NEXT:    fsgnjn.s fa0, fa0, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fsgnjn_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    slli s0, s0, 1
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    srli s0, s0, 1
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    or a0, s0, a0
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fsgnjn_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    slli s0, s0, 33
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    srli s0, s0, 33
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    or a0, s0, a0
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fadd float %a, %b
  %2 = fneg float %1
  %3 = call float @llvm.copysign.f32(float %a, float %2)
  ret float %3
}

declare float @llvm.fabs.f32(float)

define float @fabs_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fabs_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fadd.s fa5, fa0, fa1
; CHECKIF-NEXT:    fabs.s fa4, fa5
; CHECKIF-NEXT:    fadd.s fa0, fa4, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fabs_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fabs_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    slli a0, a0, 33
; RV64I-NEXT:    srli a0, a0, 33
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fadd float %a, %b
  %2 = call float @llvm.fabs.f32(float %1)
  %3 = fadd float %2, %1
  ret float %3
}

declare float @llvm.minnum.f32(float, float)

define float @fmin_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fmin_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmin.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmin_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fminf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmin_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fminf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call float @llvm.minnum.f32(float %a, float %b)
  ret float %1
}

declare float @llvm.maxnum.f32(float, float)

define float @fmax_s(float %a, float %b) nounwind {
; CHECKIF-LABEL: fmax_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmax.s fa0, fa0, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmax_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmaxf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmax_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmaxf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call float @llvm.maxnum.f32(float %a, float %b)
  ret float %1
}

declare float @llvm.fma.f32(float, float, float)

define float @fmadd_s(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fmadd_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmadd.s fa0, fa0, fa1, fa2
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmadd_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmadd_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call float @llvm.fma.f32(float %a, float %b, float %c)
  ret float %1
}

define float @fmsub_s(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fmsub_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa5, fa2, fa5
; CHECKIF-NEXT:    fmsub.s fa0, fa0, fa1, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmsub_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    lui a0, %hi(.LCPI12_0)
; RV32I-NEXT:    lw a1, %lo(.LCPI12_0)(a0)
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a2, 524288
; RV32I-NEXT:    xor a2, a0, a2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmsub_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    lui a0, %hi(.LCPI12_0)
; RV64I-NEXT:    lw a1, %lo(.LCPI12_0)(a0)
; RV64I-NEXT:    mv a0, a2
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a2, 524288
; RV64I-NEXT:    xor a2, a0, a2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %negc = fneg float %c_
  %1 = call float @llvm.fma.f32(float %a, float %b, float %negc)
  ret float %1
}

define float @fnmadd_s(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmadd_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa4, fa0, fa5
; CHECKIF-NEXT:    fadd.s fa5, fa2, fa5
; CHECKIF-NEXT:    fnmadd.s fa0, fa4, fa1, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmadd_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI13_0)
; RV32I-NEXT:    lw s1, %lo(.LCPI13_0)(a1)
; RV32I-NEXT:    mv s2, a2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a2, 524288
; RV32I-NEXT:    xor a1, s3, a2
; RV32I-NEXT:    xor a2, a0, a2
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmadd_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI13_0)
; RV64I-NEXT:    lw s1, %lo(.LCPI13_0)(a1)
; RV64I-NEXT:    mv s2, a2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a2, 524288
; RV64I-NEXT:    xor a1, s3, a2
; RV64I-NEXT:    xor a2, a0, a2
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
  %a_ = fadd float 0.0, %a
  %c_ = fadd float 0.0, %c
  %nega = fneg float %a_
  %negc = fneg float %c_
  %1 = call float @llvm.fma.f32(float %nega, float %b, float %negc)
  ret float %1
}

define float @fnmadd_s_2(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmadd_s_2:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa4, fa1, fa5
; CHECKIF-NEXT:    fadd.s fa5, fa2, fa5
; CHECKIF-NEXT:    fnmadd.s fa0, fa4, fa0, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmadd_s_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI14_0)
; RV32I-NEXT:    lw s1, %lo(.LCPI14_0)(a1)
; RV32I-NEXT:    mv s2, a2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a2, 524288
; RV32I-NEXT:    xor a1, s3, a2
; RV32I-NEXT:    xor a2, a0, a2
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmadd_s_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI14_0)
; RV64I-NEXT:    lw s1, %lo(.LCPI14_0)(a1)
; RV64I-NEXT:    mv s2, a2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a2, 524288
; RV64I-NEXT:    xor a1, s3, a2
; RV64I-NEXT:    xor a2, a0, a2
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
  %b_ = fadd float 0.0, %b
  %c_ = fadd float 0.0, %c
  %negb = fneg float %b_
  %negc = fneg float %c_
  %1 = call float @llvm.fma.f32(float %a, float %negb, float %negc)
  ret float %1
}

define float @fnmadd_s_3(float %a, float %b, float %c) nounwind {
; RV32IF-LABEL: fnmadd_s_3:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmadd.s ft0, fa0, fa1, fa2
; RV32IF-NEXT:    fneg.s fa0, ft0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fnmadd_s_3:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmadd.s ft0, fa0, fa1, fa2
; RV64IF-NEXT:    fneg.s fa0, ft0
; RV64IF-NEXT:    ret
;
; CHECKIF-LABEL: fnmadd_s_3:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmadd.s fa5, fa0, fa1, fa2
; CHECKIF-NEXT:    fneg.s fa0, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmadd_s_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmadd_s_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call float @llvm.fma.f32(float %a, float %b, float %c)
  %neg = fneg float %1
  ret float %neg
}

define float @fnmadd_nsz(float %a, float %b, float %c) nounwind {
; RV32IF-LABEL: fnmadd_nsz:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fnmadd.s fa0, fa0, fa1, fa2
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: fnmadd_nsz:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fnmadd.s fa0, fa0, fa1, fa2
; RV64IF-NEXT:    ret
;
; CHECKIF-LABEL: fnmadd_nsz:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmadd.s fa5, fa0, fa1, fa2
; CHECKIF-NEXT:    fneg.s fa0, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmadd_nsz:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmadd_nsz:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call nsz float @llvm.fma.f32(float %a, float %b, float %c)
  %neg = fneg nsz float %1
  ret float %neg
}

define float @fnmsub_s(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmsub_s:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa5, fa0, fa5
; CHECKIF-NEXT:    fnmsub.s fa0, fa5, fa1, fa2
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmsub_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI17_0)
; RV32I-NEXT:    lw a1, %lo(.LCPI17_0)(a1)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmsub_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI17_0)
; RV64I-NEXT:    lw a1, %lo(.LCPI17_0)(a1)
; RV64I-NEXT:    mv s1, a2
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %a_ = fadd float 0.0, %a
  %nega = fneg float %a_
  %1 = call float @llvm.fma.f32(float %nega, float %b, float %c)
  ret float %1
}

define float @fnmsub_s_2(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmsub_s_2:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa5, fa1, fa5
; CHECKIF-NEXT:    fnmsub.s fa0, fa5, fa0, fa2
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmsub_s_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI18_0)
; RV32I-NEXT:    lw a1, %lo(.LCPI18_0)(a1)
; RV32I-NEXT:    mv s1, a2
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a1, a0, a1
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    call fmaf
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmsub_s_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI18_0)
; RV64I-NEXT:    lw a1, %lo(.LCPI18_0)(a1)
; RV64I-NEXT:    mv s1, a2
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a1, a0, a1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a2, s1
; RV64I-NEXT:    call fmaf
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %b_ = fadd float 0.0, %b
  %negb = fneg float %b_
  %1 = call float @llvm.fma.f32(float %a, float %negb, float %c)
  ret float %1
}

define float @fmadd_s_contract(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fmadd_s_contract:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmadd.s fa0, fa0, fa1, fa2
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmadd_s_contract:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a2
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmadd_s_contract:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fmul contract float %a, %b
  %2 = fadd contract float %1, %c
  ret float %2
}

define float @fmsub_s_contract(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fmsub_s_contract:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa5, fa2, fa5
; CHECKIF-NEXT:    fmul.s fa4, fa0, fa1
; CHECKIF-NEXT:    fsub.s fa0, fa4, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fmsub_s_contract:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    lui a0, %hi(.LCPI20_0)
; RV32I-NEXT:    lw a1, %lo(.LCPI20_0)(a0)
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    mv a1, s2
; RV32I-NEXT:    call __subsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmsub_s_contract:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv s1, a1
; RV64I-NEXT:    lui a0, %hi(.LCPI20_0)
; RV64I-NEXT:    lw a1, %lo(.LCPI20_0)(a0)
; RV64I-NEXT:    mv a0, a2
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    mv a1, s2
; RV64I-NEXT:    call __subsf3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %1 = fmul contract float %a, %b
  %2 = fsub contract float %1, %c_
  ret float %2
}

define float @fnmadd_s_contract(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmadd_s_contract:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa4, fa0, fa5
; CHECKIF-NEXT:    fadd.s fa3, fa1, fa5
; CHECKIF-NEXT:    fadd.s fa5, fa2, fa5
; CHECKIF-NEXT:    fmul.s fa4, fa4, fa3
; CHECKIF-NEXT:    fneg.s fa4, fa4
; CHECKIF-NEXT:    fsub.s fa0, fa4, fa5
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmadd_s_contract:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI21_0)
; RV32I-NEXT:    lw s1, %lo(.LCPI21_0)(a1)
; RV32I-NEXT:    mv s2, a2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __subsf3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmadd_s_contract:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI21_0)
; RV64I-NEXT:    lw s1, %lo(.LCPI21_0)(a1)
; RV64I-NEXT:    mv s2, a2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __subsf3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
  %a_ = fadd float 0.0, %a ; avoid negation using xor
  %b_ = fadd float 0.0, %b ; avoid negation using xor
  %c_ = fadd float 0.0, %c ; avoid negation using xor
  %1 = fmul contract float %a_, %b_
  %2 = fneg float %1
  %3 = fsub contract float %2, %c_
  ret float %3
}

define float @fnmsub_s_contract(float %a, float %b, float %c) nounwind {
; CHECKIF-LABEL: fnmsub_s_contract:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fmv.w.x fa5, zero
; CHECKIF-NEXT:    fadd.s fa4, fa0, fa5
; CHECKIF-NEXT:    fadd.s fa5, fa1, fa5
; CHECKIF-NEXT:    fnmsub.s fa0, fa4, fa5, fa2
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fnmsub_s_contract:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    lui a1, %hi(.LCPI22_0)
; RV32I-NEXT:    lw s1, %lo(.LCPI22_0)(a1)
; RV32I-NEXT:    mv s2, a2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s0
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __addsf3
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s3
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    call __subsf3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fnmsub_s_contract:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI22_0)
; RV64I-NEXT:    lw s1, %lo(.LCPI22_0)(a1)
; RV64I-NEXT:    mv s2, a2
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv s3, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s1
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s3
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __subsf3
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
  %a_ = fadd float 0.0, %a ; avoid negation using xor
  %b_ = fadd float 0.0, %b ; avoid negation using xor
  %1 = fmul contract float %a_, %b_
  %2 = fsub contract float %c, %1
  ret float %2
}

define float @fsgnjx_f32(float %x, float %y) nounwind {
; CHECKIF-LABEL: fsgnjx_f32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    lui a0, 260096
; CHECKIF-NEXT:    fmv.w.x fa5, a0
; CHECKIF-NEXT:    fsgnj.s fa5, fa5, fa0
; CHECKIF-NEXT:    fmul.s fa0, fa5, fa1
; CHECKIF-NEXT:    ret
;
; RV32I-LABEL: fsgnjx_f32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a2, 524288
; RV32I-NEXT:    lui a3, 260096
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    call __mulsf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fsgnjx_f32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a2, 524288
; RV64I-NEXT:    lui a3, 260096
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    call __mulsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %z = call float @llvm.copysign.f32(float 1.0, float %x)
  %mul = fmul float %z, %y
  ret float %mul
}
