; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple arm-eabi -mattr=+v6t2 | FileCheck %s
; RUN: llc < %s -mtriple arm-eabi -mattr=+v6t2 -mattr=+neon | FileCheck %s
; RUN: llc < %s -mtriple thumbv6m-none-eabi | FileCheck %s --check-prefix=CHECK-6M
; RUN: llc < %s -mtriple thumbv8m.base-none-eabi | FileCheck %s --check-prefix=CHECK-8MBASE

; This test checks the @llvm.cttz.* intrinsics for integers.

declare i8 @llvm.cttz.i8(i8, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i64 @llvm.cttz.i64(i64, i1)

;------------------------------------------------------------------------------

define i8 @test_i8(i8 %a) {
; CHECK-LABEL: test_i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r0, #256
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i8:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    lsls r1, r0, #24
; CHECK-6M-NEXT:    beq .LBB0_3
; CHECK-6M-NEXT:  @ %bb.1: @ %cond.false
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB0_4
; CHECK-6M-NEXT:  @ %bb.2: @ %cond.false
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI0_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI0_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB0_3:
; CHECK-6M-NEXT:    movs r0, #8
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB0_4:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.5:
; CHECK-6M-NEXT:  .LCPI0_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI0_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i8:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    lsls r1, r0, #24
; CHECK-8MBASE-NEXT:    beq .LBB0_3
; CHECK-8MBASE-NEXT:  @ %bb.1: @ %cond.false
; CHECK-8MBASE-NEXT:    cbz r0, .LBB0_4
; CHECK-8MBASE-NEXT:  @ %bb.2: @ %cond.false
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI0_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB0_3:
; CHECK-8MBASE-NEXT:    movs r0, #8
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB0_4:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.5:
; CHECK-8MBASE-NEXT:  .LCPI0_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_i16(i16 %a) {
; CHECK-LABEL: test_i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orr r0, r0, #65536
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i16:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    lsls r1, r0, #16
; CHECK-6M-NEXT:    beq .LBB1_3
; CHECK-6M-NEXT:  @ %bb.1: @ %cond.false
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB1_4
; CHECK-6M-NEXT:  @ %bb.2: @ %cond.false
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI1_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI1_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB1_3:
; CHECK-6M-NEXT:    movs r0, #16
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB1_4:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.5:
; CHECK-6M-NEXT:  .LCPI1_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI1_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i16:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    lsls r1, r0, #16
; CHECK-8MBASE-NEXT:    beq .LBB1_3
; CHECK-8MBASE-NEXT:  @ %bb.1: @ %cond.false
; CHECK-8MBASE-NEXT:    cbz r0, .LBB1_4
; CHECK-8MBASE-NEXT:  @ %bb.2: @ %cond.false
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI1_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB1_3:
; CHECK-8MBASE-NEXT:    movs r0, #16
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB1_4:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.5:
; CHECK-8MBASE-NEXT:  .LCPI1_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_i32(i32 %a) {
; CHECK-LABEL: test_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i32:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB2_3
; CHECK-6M-NEXT:  @ %bb.1: @ %cond.false
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB2_3
; CHECK-6M-NEXT:  @ %bb.2: @ %cond.false
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI2_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI2_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB2_3:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.4:
; CHECK-6M-NEXT:  .LCPI2_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI2_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i32:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    cbz r0, .LBB2_3
; CHECK-8MBASE-NEXT:  @ %bb.1: @ %cond.false
; CHECK-8MBASE-NEXT:    cbz r0, .LBB2_3
; CHECK-8MBASE-NEXT:  @ %bb.2: @ %cond.false
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI2_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB2_3:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.4:
; CHECK-8MBASE-NEXT:  .LCPI2_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_i64(i64 %a) {
; CHECK-LABEL: test_i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r1, r1
; CHECK-NEXT:    rbit r2, r0
; CHECK-NEXT:    clz r1, r1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    add r1, r1, #32
; CHECK-NEXT:    clzne r1, r2
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i64:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    .save {r4, r5, r6, lr}
; CHECK-6M-NEXT:    push {r4, r5, r6, lr}
; CHECK-6M-NEXT:    mov r3, r1
; CHECK-6M-NEXT:    mov r2, r0
; CHECK-6M-NEXT:    movs r1, #0
; CHECK-6M-NEXT:    orrs r0, r3
; CHECK-6M-NEXT:    beq .LBB3_6
; CHECK-6M-NEXT:  @ %bb.1: @ %cond.false
; CHECK-6M-NEXT:    ldr r6, .LCPI3_0
; CHECK-6M-NEXT:    adr r4, .LCPI3_1
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    cmp r3, #0
; CHECK-6M-NEXT:    mov r5, r0
; CHECK-6M-NEXT:    beq .LBB3_3
; CHECK-6M-NEXT:  @ %bb.2: @ %cond.false
; CHECK-6M-NEXT:    rsbs r5, r3, #0
; CHECK-6M-NEXT:    ands r5, r3
; CHECK-6M-NEXT:    muls r5, r6, r5
; CHECK-6M-NEXT:    lsrs r3, r5, #27
; CHECK-6M-NEXT:    ldrb r5, [r4, r3]
; CHECK-6M-NEXT:  .LBB3_3: @ %cond.false
; CHECK-6M-NEXT:    adds r5, #32
; CHECK-6M-NEXT:    rsbs r3, r2, #0
; CHECK-6M-NEXT:    ands r3, r2
; CHECK-6M-NEXT:    muls r6, r3, r6
; CHECK-6M-NEXT:    lsrs r3, r6, #27
; CHECK-6M-NEXT:    cmp r2, #0
; CHECK-6M-NEXT:    bne .LBB3_7
; CHECK-6M-NEXT:  @ %bb.4: @ %cond.false
; CHECK-6M-NEXT:    beq .LBB3_8
; CHECK-6M-NEXT:  .LBB3_5: @ %cond.end
; CHECK-6M-NEXT:    pop {r4, r5, r6, pc}
; CHECK-6M-NEXT:  .LBB3_6:
; CHECK-6M-NEXT:    movs r0, #64
; CHECK-6M-NEXT:    pop {r4, r5, r6, pc}
; CHECK-6M-NEXT:  .LBB3_7: @ %cond.false
; CHECK-6M-NEXT:    ldrb r0, [r4, r3]
; CHECK-6M-NEXT:    bne .LBB3_5
; CHECK-6M-NEXT:  .LBB3_8: @ %cond.false
; CHECK-6M-NEXT:    mov r0, r5
; CHECK-6M-NEXT:    pop {r4, r5, r6, pc}
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.9:
; CHECK-6M-NEXT:  .LCPI3_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI3_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i64:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    .save {r4, r5, r6, lr}
; CHECK-8MBASE-NEXT:    push {r4, r5, r6, lr}
; CHECK-8MBASE-NEXT:    mov r3, r1
; CHECK-8MBASE-NEXT:    mov r2, r0
; CHECK-8MBASE-NEXT:    movs r1, #0
; CHECK-8MBASE-NEXT:    orrs r0, r3
; CHECK-8MBASE-NEXT:    beq .LBB3_6
; CHECK-8MBASE-NEXT:  @ %bb.1: @ %cond.false
; CHECK-8MBASE-NEXT:    movw r6, #46385
; CHECK-8MBASE-NEXT:    movt r6, #1916
; CHECK-8MBASE-NEXT:    adr r4, .LCPI3_0
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    mov r5, r0
; CHECK-8MBASE-NEXT:    cbz r3, .LBB3_3
; CHECK-8MBASE-NEXT:  @ %bb.2: @ %cond.false
; CHECK-8MBASE-NEXT:    rsbs r5, r3, #0
; CHECK-8MBASE-NEXT:    ands r5, r3
; CHECK-8MBASE-NEXT:    muls r5, r6, r5
; CHECK-8MBASE-NEXT:    lsrs r3, r5, #27
; CHECK-8MBASE-NEXT:    ldrb r5, [r4, r3]
; CHECK-8MBASE-NEXT:  .LBB3_3: @ %cond.false
; CHECK-8MBASE-NEXT:    adds r5, #32
; CHECK-8MBASE-NEXT:    rsbs r3, r2, #0
; CHECK-8MBASE-NEXT:    ands r3, r2
; CHECK-8MBASE-NEXT:    muls r6, r3, r6
; CHECK-8MBASE-NEXT:    lsrs r3, r6, #27
; CHECK-8MBASE-NEXT:    cmp r2, #0
; CHECK-8MBASE-NEXT:    bne .LBB3_7
; CHECK-8MBASE-NEXT:  @ %bb.4: @ %cond.false
; CHECK-8MBASE-NEXT:    beq .LBB3_8
; CHECK-8MBASE-NEXT:  .LBB3_5: @ %cond.end
; CHECK-8MBASE-NEXT:    pop {r4, r5, r6, pc}
; CHECK-8MBASE-NEXT:  .LBB3_6:
; CHECK-8MBASE-NEXT:    movs r0, #64
; CHECK-8MBASE-NEXT:    pop {r4, r5, r6, pc}
; CHECK-8MBASE-NEXT:  .LBB3_7: @ %cond.false
; CHECK-8MBASE-NEXT:    ldrb r0, [r4, r3]
; CHECK-8MBASE-NEXT:    bne .LBB3_5
; CHECK-8MBASE-NEXT:  .LBB3_8: @ %cond.false
; CHECK-8MBASE-NEXT:    mov r0, r5
; CHECK-8MBASE-NEXT:    pop {r4, r5, r6, pc}
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.9:
; CHECK-8MBASE-NEXT:  .LCPI3_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

;------------------------------------------------------------------------------

define i8 @test_i8_zero_undef(i8 %a) {
; CHECK-LABEL: test_i8_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i8_zero_undef:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB4_2
; CHECK-6M-NEXT:  @ %bb.1:
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI4_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI4_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB4_2:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.3:
; CHECK-6M-NEXT:  .LCPI4_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI4_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i8_zero_undef:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    cbz r0, .LBB4_2
; CHECK-8MBASE-NEXT:  @ %bb.1:
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI4_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB4_2:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.3:
; CHECK-8MBASE-NEXT:  .LCPI4_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 true)
  ret i8 %tmp
}

define i16 @test_i16_zero_undef(i16 %a) {
; CHECK-LABEL: test_i16_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i16_zero_undef:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB5_2
; CHECK-6M-NEXT:  @ %bb.1:
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI5_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI5_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB5_2:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.3:
; CHECK-6M-NEXT:  .LCPI5_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI5_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i16_zero_undef:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    cbz r0, .LBB5_2
; CHECK-8MBASE-NEXT:  @ %bb.1:
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI5_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB5_2:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.3:
; CHECK-8MBASE-NEXT:  .LCPI5_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 true)
  ret i16 %tmp
}


define i32 @test_i32_zero_undef(i32 %a) {
; CHECK-LABEL: test_i32_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r0, r0
; CHECK-NEXT:    clz r0, r0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i32_zero_undef:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    cmp r0, #0
; CHECK-6M-NEXT:    beq .LBB6_2
; CHECK-6M-NEXT:  @ %bb.1:
; CHECK-6M-NEXT:    rsbs r1, r0, #0
; CHECK-6M-NEXT:    ands r1, r0
; CHECK-6M-NEXT:    ldr r0, .LCPI6_0
; CHECK-6M-NEXT:    muls r0, r1, r0
; CHECK-6M-NEXT:    lsrs r0, r0, #27
; CHECK-6M-NEXT:    adr r1, .LCPI6_1
; CHECK-6M-NEXT:    ldrb r0, [r1, r0]
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:  .LBB6_2:
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    bx lr
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.3:
; CHECK-6M-NEXT:  .LCPI6_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI6_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i32_zero_undef:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    cbz r0, .LBB6_2
; CHECK-8MBASE-NEXT:  @ %bb.1:
; CHECK-8MBASE-NEXT:    rsbs r1, r0, #0
; CHECK-8MBASE-NEXT:    ands r1, r0
; CHECK-8MBASE-NEXT:    movw r0, #46385
; CHECK-8MBASE-NEXT:    movt r0, #1916
; CHECK-8MBASE-NEXT:    muls r0, r1, r0
; CHECK-8MBASE-NEXT:    lsrs r0, r0, #27
; CHECK-8MBASE-NEXT:    adr r1, .LCPI6_0
; CHECK-8MBASE-NEXT:    ldrb r0, [r1, r0]
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:  .LBB6_2:
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    bx lr
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.3:
; CHECK-8MBASE-NEXT:  .LCPI6_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i64 @test_i64_zero_undef(i64 %a) {
; CHECK-LABEL: test_i64_zero_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rbit r1, r1
; CHECK-NEXT:    rbit r2, r0
; CHECK-NEXT:    clz r1, r1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    add r1, r1, #32
; CHECK-NEXT:    clzne r1, r2
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    bx lr
;
; CHECK-6M-LABEL: test_i64_zero_undef:
; CHECK-6M:       @ %bb.0:
; CHECK-6M-NEXT:    .save {r4, r5, r7, lr}
; CHECK-6M-NEXT:    push {r4, r5, r7, lr}
; CHECK-6M-NEXT:    mov r2, r0
; CHECK-6M-NEXT:    ldr r5, .LCPI7_0
; CHECK-6M-NEXT:    adr r3, .LCPI7_1
; CHECK-6M-NEXT:    movs r0, #32
; CHECK-6M-NEXT:    cmp r1, #0
; CHECK-6M-NEXT:    mov r4, r0
; CHECK-6M-NEXT:    beq .LBB7_2
; CHECK-6M-NEXT:  @ %bb.1:
; CHECK-6M-NEXT:    rsbs r4, r1, #0
; CHECK-6M-NEXT:    ands r4, r1
; CHECK-6M-NEXT:    muls r4, r5, r4
; CHECK-6M-NEXT:    lsrs r1, r4, #27
; CHECK-6M-NEXT:    ldrb r4, [r3, r1]
; CHECK-6M-NEXT:  .LBB7_2:
; CHECK-6M-NEXT:    adds r4, #32
; CHECK-6M-NEXT:    rsbs r1, r2, #0
; CHECK-6M-NEXT:    ands r1, r2
; CHECK-6M-NEXT:    muls r5, r1, r5
; CHECK-6M-NEXT:    lsrs r1, r5, #27
; CHECK-6M-NEXT:    cmp r2, #0
; CHECK-6M-NEXT:    bne .LBB7_5
; CHECK-6M-NEXT:  @ %bb.3:
; CHECK-6M-NEXT:    beq .LBB7_6
; CHECK-6M-NEXT:  .LBB7_4:
; CHECK-6M-NEXT:    movs r1, #0
; CHECK-6M-NEXT:    pop {r4, r5, r7, pc}
; CHECK-6M-NEXT:  .LBB7_5:
; CHECK-6M-NEXT:    ldrb r0, [r3, r1]
; CHECK-6M-NEXT:    bne .LBB7_4
; CHECK-6M-NEXT:  .LBB7_6:
; CHECK-6M-NEXT:    mov r0, r4
; CHECK-6M-NEXT:    movs r1, #0
; CHECK-6M-NEXT:    pop {r4, r5, r7, pc}
; CHECK-6M-NEXT:    .p2align 2
; CHECK-6M-NEXT:  @ %bb.7:
; CHECK-6M-NEXT:  .LCPI7_0:
; CHECK-6M-NEXT:    .long 125613361 @ 0x77cb531
; CHECK-6M-NEXT:  .LCPI7_1:
; CHECK-6M-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
;
; CHECK-8MBASE-LABEL: test_i64_zero_undef:
; CHECK-8MBASE:       @ %bb.0:
; CHECK-8MBASE-NEXT:    .save {r4, r5, r7, lr}
; CHECK-8MBASE-NEXT:    push {r4, r5, r7, lr}
; CHECK-8MBASE-NEXT:    mov r2, r0
; CHECK-8MBASE-NEXT:    movw r5, #46385
; CHECK-8MBASE-NEXT:    movt r5, #1916
; CHECK-8MBASE-NEXT:    adr r3, .LCPI7_0
; CHECK-8MBASE-NEXT:    movs r0, #32
; CHECK-8MBASE-NEXT:    mov r4, r0
; CHECK-8MBASE-NEXT:    cbz r1, .LBB7_2
; CHECK-8MBASE-NEXT:  @ %bb.1:
; CHECK-8MBASE-NEXT:    rsbs r4, r1, #0
; CHECK-8MBASE-NEXT:    ands r4, r1
; CHECK-8MBASE-NEXT:    muls r4, r5, r4
; CHECK-8MBASE-NEXT:    lsrs r1, r4, #27
; CHECK-8MBASE-NEXT:    ldrb r4, [r3, r1]
; CHECK-8MBASE-NEXT:  .LBB7_2:
; CHECK-8MBASE-NEXT:    adds r4, #32
; CHECK-8MBASE-NEXT:    rsbs r1, r2, #0
; CHECK-8MBASE-NEXT:    ands r1, r2
; CHECK-8MBASE-NEXT:    muls r5, r1, r5
; CHECK-8MBASE-NEXT:    lsrs r1, r5, #27
; CHECK-8MBASE-NEXT:    cmp r2, #0
; CHECK-8MBASE-NEXT:    bne .LBB7_5
; CHECK-8MBASE-NEXT:  @ %bb.3:
; CHECK-8MBASE-NEXT:    beq .LBB7_6
; CHECK-8MBASE-NEXT:  .LBB7_4:
; CHECK-8MBASE-NEXT:    movs r1, #0
; CHECK-8MBASE-NEXT:    pop {r4, r5, r7, pc}
; CHECK-8MBASE-NEXT:  .LBB7_5:
; CHECK-8MBASE-NEXT:    ldrb r0, [r3, r1]
; CHECK-8MBASE-NEXT:    bne .LBB7_4
; CHECK-8MBASE-NEXT:  .LBB7_6:
; CHECK-8MBASE-NEXT:    mov r0, r4
; CHECK-8MBASE-NEXT:    movs r1, #0
; CHECK-8MBASE-NEXT:    pop {r4, r5, r7, pc}
; CHECK-8MBASE-NEXT:    .p2align 2
; CHECK-8MBASE-NEXT:  @ %bb.7:
; CHECK-8MBASE-NEXT:  .LCPI7_0:
; CHECK-8MBASE-NEXT:    .ascii "\000\001\034\002\035\016\030\003\036\026\024\017\031\021\004\b\037\033\r\027\025\023\020\007\032\f\022\006\013\005\n\t"
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 true)
  ret i64 %tmp
}
