; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -target-abi ilp32d -mattr=+c,+f,+d \
; RUN:     -M no-aliases < %s \
; RUN:   | FileCheck -check-prefix=RV32IFDC %s
; RUN: llc -mtriple=riscv32 -target-abi ilp32d -mattr=-c,+f,+d \
; RUN:     -M no-aliases < %s \
; RUN:   | FileCheck -check-prefix=RV32IFD %s

; constant is small and fit in 6 bit (compress imm)
define i32 @ne_small_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_small_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 20
; RV32IFDC-NEXT:    bne a0, a1, .LBB0_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB0_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_small_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 20
; RV32IFD-NEXT:    bne a0, a1, .LBB0_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB0_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 20
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @ne_small_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_small_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, -20
; RV32IFDC-NEXT:    bne a0, a1, .LBB1_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB1_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_small_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -20
; RV32IFD-NEXT:    bne a0, a1, .LBB1_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB1_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -20
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @ne_small_edge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_small_edge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 31
; RV32IFDC-NEXT:    bne a0, a1, .LBB2_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB2_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_small_edge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 31
; RV32IFD-NEXT:    bne a0, a1, .LBB2_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB2_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 31
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @ne_small_edge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_small_edge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, -32
; RV32IFDC-NEXT:    bne a0, a1, .LBB3_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB3_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_small_edge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -32
; RV32IFD-NEXT:    bne a0, a1, .LBB3_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB3_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -32
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @ne_medium_ledge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_ledge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -33
; RV32IFDC-NEXT:    c.bnez a0, .LBB4_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB4_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_ledge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 33
; RV32IFD-NEXT:    bne a0, a1, .LBB4_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB4_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 33
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @ne_medium_ledge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_ledge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 33
; RV32IFDC-NEXT:    c.bnez a0, .LBB5_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB5_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_ledge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -33
; RV32IFD-NEXT:    bne a0, a1, .LBB5_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB5_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -33
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @ne_medium_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -63
; RV32IFDC-NEXT:    c.bnez a0, .LBB6_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB6_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 63
; RV32IFD-NEXT:    bne a0, a1, .LBB6_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB6_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 63
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @ne_medium_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 63
; RV32IFDC-NEXT:    c.bnez a0, .LBB7_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB7_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -63
; RV32IFD-NEXT:    bne a0, a1, .LBB7_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB7_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -63
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @ne_medium_bedge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_bedge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -2047
; RV32IFDC-NEXT:    c.bnez a0, .LBB8_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB8_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_bedge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 2047
; RV32IFD-NEXT:    bne a0, a1, .LBB8_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB8_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 2047
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm), negative value fit in 12 bit too.
define i32 @ne_medium_bedge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_medium_bedge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 2047
; RV32IFDC-NEXT:    c.bnez a0, .LBB9_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB9_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_medium_bedge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -2047
; RV32IFD-NEXT:    bne a0, a1, .LBB9_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB9_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -2047
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is big and do not fit in 12 bit (imm), fit in i32
define i32 @ne_big_ledge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_big_ledge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 1
; RV32IFDC-NEXT:    c.slli a1, 11
; RV32IFDC-NEXT:    bne a0, a1, .LBB10_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB10_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_big_ledge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 1
; RV32IFD-NEXT:    slli a1, a1, 11
; RV32IFD-NEXT:    bne a0, a1, .LBB10_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB10_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, 2048
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is big and do not fit in 12 bit (imm), fit in i32
define i32 @ne_big_ledge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: ne_big_ledge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a1, zero, -2048
; RV32IFDC-NEXT:    bne a0, a1, .LBB11_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB11_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: ne_big_ledge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -2048
; RV32IFD-NEXT:    bne a0, a1, .LBB11_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB11_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp ne i32 %in0, -2048
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}


;; Same as above, but for eq

; constant is small and fit in 6 bit (compress imm)
define i32 @eq_small_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_small_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 20
; RV32IFDC-NEXT:    beq a0, a1, .LBB12_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB12_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_small_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 20
; RV32IFD-NEXT:    beq a0, a1, .LBB12_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB12_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 20
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @eq_small_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_small_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, -20
; RV32IFDC-NEXT:    beq a0, a1, .LBB13_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB13_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_small_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -20
; RV32IFD-NEXT:    beq a0, a1, .LBB13_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB13_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -20
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @eq_small_edge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_small_edge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 31
; RV32IFDC-NEXT:    beq a0, a1, .LBB14_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB14_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_small_edge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 31
; RV32IFD-NEXT:    beq a0, a1, .LBB14_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB14_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 31
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is small and fit in 6 bit (compress imm)
define i32 @eq_small_edge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_small_edge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, -32
; RV32IFDC-NEXT:    beq a0, a1, .LBB15_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB15_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_small_edge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -32
; RV32IFD-NEXT:    beq a0, a1, .LBB15_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB15_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -32
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @eq_medium_ledge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_ledge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -33
; RV32IFDC-NEXT:    c.beqz a0, .LBB16_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB16_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_ledge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 33
; RV32IFD-NEXT:    beq a0, a1, .LBB16_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB16_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 33
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @eq_medium_ledge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_ledge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 33
; RV32IFDC-NEXT:    c.beqz a0, .LBB17_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB17_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_ledge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -33
; RV32IFD-NEXT:    beq a0, a1, .LBB17_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB17_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -33
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @eq_medium_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -63
; RV32IFDC-NEXT:    c.beqz a0, .LBB18_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB18_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 63
; RV32IFD-NEXT:    beq a0, a1, .LBB18_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB18_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 63
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @eq_medium_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 63
; RV32IFDC-NEXT:    c.beqz a0, .LBB19_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB19_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -63
; RV32IFD-NEXT:    beq a0, a1, .LBB19_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB19_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -63
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm)
define i32 @eq_medium_bedge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_bedge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, -2047
; RV32IFDC-NEXT:    c.beqz a0, .LBB20_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB20_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_bedge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 2047
; RV32IFD-NEXT:    beq a0, a1, .LBB20_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB20_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 2047
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is medium and not fit in 6 bit (compress imm),
; but fit in 12 bit (imm), negative value fit in 12 bit too.
define i32 @eq_medium_bedge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_medium_bedge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a0, a0, 2047
; RV32IFDC-NEXT:    c.beqz a0, .LBB21_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB21_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_medium_bedge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -2047
; RV32IFD-NEXT:    beq a0, a1, .LBB21_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB21_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -2047
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is big and do not fit in 12 bit (imm), fit in i32
define i32 @eq_big_ledge_pos(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_big_ledge_pos:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    c.li a1, 1
; RV32IFDC-NEXT:    c.slli a1, 11
; RV32IFDC-NEXT:    beq a0, a1, .LBB22_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB22_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_big_ledge_pos:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, 1
; RV32IFD-NEXT:    slli a1, a1, 11
; RV32IFD-NEXT:    beq a0, a1, .LBB22_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB22_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, 2048
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}

; constant is big and do not fit in 12 bit (imm), fit in i32
define i32 @eq_big_ledge_neg(i32 %in0) minsize {
; RV32IFDC-LABEL: eq_big_ledge_neg:
; RV32IFDC:       # %bb.0:
; RV32IFDC-NEXT:    addi a1, zero, -2048
; RV32IFDC-NEXT:    beq a0, a1, .LBB23_2
; RV32IFDC-NEXT:  # %bb.1:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_1
; RV32IFDC-NEXT:  .LBB23_2:
; RV32IFDC-NEXT:    tail OUTLINED_FUNCTION_0
;
; RV32IFD-LABEL: eq_big_ledge_neg:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a1, zero, -2048
; RV32IFD-NEXT:    beq a0, a1, .LBB23_2
; RV32IFD-NEXT:  # %bb.1:
; RV32IFD-NEXT:    addi a0, zero, 42
; RV32IFD-NEXT:    jalr zero, 0(ra)
; RV32IFD-NEXT:  .LBB23_2:
; RV32IFD-NEXT:    addi a0, zero, -99
; RV32IFD-NEXT:    jalr zero, 0(ra)
  %cmp = icmp eq i32 %in0, -2048
  %toRet = select i1 %cmp, i32 -99, i32 42
  ret i32 %toRet
}
