; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck %s -check-prefix=GCN

define amdgpu_ps float @while_break(i32 %z, float %v, i32 %x, i32 %y) #0 {
; GCN-LABEL: while_break:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_mov_b32 s1, -1
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_branch .LBB0_2
; GCN-NEXT:  .LBB0_1: ; %Flow2
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GCN-NEXT:    s_and_b32 s2, exec_lo, s3
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_andn2_b32 exec_lo, exec_lo, s0
; GCN-NEXT:    s_cbranch_execz .LBB0_8
; GCN-NEXT:  .LBB0_2: ; %header
; GCN-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    s_add_i32 s1, s1, 1
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    v_cmp_ge_i32_e32 vcc_lo, s1, v2
; GCN-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GCN-NEXT:    s_xor_b32 s3, exec_lo, s3
; GCN-NEXT:  ; %bb.3: ; %else
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s1, v3
; GCN-NEXT:    s_and_b32 s2, vcc_lo, exec_lo
; GCN-NEXT:  ; %bb.4: ; %Flow
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    s_andn2_saveexec_b32 s3, s3
; GCN-NEXT:  ; %bb.5: ; %if
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GCN-NEXT:    s_or_b32 s2, s2, exec_lo
; GCN-NEXT:  ; %bb.6: ; %Flow1
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GCN-NEXT:    s_mov_b32 s3, -1
; GCN-NEXT:    s_and_saveexec_b32 s4, s2
; GCN-NEXT:    s_cbranch_execz .LBB0_1
; GCN-NEXT:  ; %bb.7: ; %latch
; GCN-NEXT:    ; in Loop: Header=BB0_2 Depth=1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s1, v0
; GCN-NEXT:    s_orn2_b32 s3, vcc_lo, exec_lo
; GCN-NEXT:    s_branch .LBB0_1
; GCN-NEXT:  .LBB0_8: ; %end
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GCN-NEXT:    v_mov_b32_e32 v0, v1
; GCN-NEXT:    ; return to shader part epilog
entry:
  br label %header

header:
  %v.1 = phi float [ %v, %entry ], [ %v.2, %latch ]
  %ind = phi i32 [ 0, %entry], [ %ind.inc, %latch ]
  %cc = icmp slt i32 %ind, %x
  br i1 %cc, label %if, label %else

if:
  %v.if = fadd float %v.1, 1.0
  br label %latch

else:
  %cc2 = icmp slt i32 %ind, %y
  br i1 %cc2, label %latch, label %end

latch:
  %v.2 = phi float [ %v.if, %if ], [ %v.1, %else ]
  %ind.inc = add i32 %ind, 1
  %cc3 = icmp slt i32 %ind, %z
  br i1 %cc3, label %end, label %header

end:
  %r = phi float [ %v.2, %latch ], [ %v.1, %else ]
  ret float %r
}

; Just different dfs order from while_break.
define amdgpu_ps float @while_break2(i32 %z, float %v, i32 %x, i32 %y) #0 {
; GCN-LABEL: while_break2:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_mov_b32 s1, -1
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_branch .LBB1_2
; GCN-NEXT:  .LBB1_1: ; %Flow2
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GCN-NEXT:    s_and_b32 s2, exec_lo, s3
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_andn2_b32 exec_lo, exec_lo, s0
; GCN-NEXT:    s_cbranch_execz .LBB1_8
; GCN-NEXT:  .LBB1_2: ; %header
; GCN-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    s_add_i32 s1, s1, 1
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    v_cmp_ge_i32_e32 vcc_lo, s1, v2
; GCN-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GCN-NEXT:    s_xor_b32 s3, exec_lo, s3
; GCN-NEXT:  ; %bb.3: ; %if
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GCN-NEXT:    s_mov_b32 s2, exec_lo
; GCN-NEXT:  ; %bb.4: ; %Flow
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    s_andn2_saveexec_b32 s3, s3
; GCN-NEXT:  ; %bb.5: ; %else
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s1, v3
; GCN-NEXT:    s_andn2_b32 s2, s2, exec_lo
; GCN-NEXT:    s_and_b32 s4, vcc_lo, exec_lo
; GCN-NEXT:    s_or_b32 s2, s2, s4
; GCN-NEXT:  ; %bb.6: ; %Flow1
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GCN-NEXT:    s_mov_b32 s3, -1
; GCN-NEXT:    s_and_saveexec_b32 s4, s2
; GCN-NEXT:    s_cbranch_execz .LBB1_1
; GCN-NEXT:  ; %bb.7: ; %latch
; GCN-NEXT:    ; in Loop: Header=BB1_2 Depth=1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s1, v0
; GCN-NEXT:    s_orn2_b32 s3, vcc_lo, exec_lo
; GCN-NEXT:    s_branch .LBB1_1
; GCN-NEXT:  .LBB1_8: ; %end
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GCN-NEXT:    v_mov_b32_e32 v0, v1
; GCN-NEXT:    ; return to shader part epilog
entry:
  br label %header

header:
  %v.1 = phi float [ %v, %entry ], [ %v.2, %latch ]
  %ind = phi i32 [ 0, %entry], [ %ind.inc, %latch ]
  %cc = icmp slt i32 %ind, %x
  br i1 %cc, label %else, label %if

if:
  %v.if = fadd float %v.1, 1.0
  br label %latch

else:
  %cc2 = icmp slt i32 %ind, %y
  br i1 %cc2, label %latch, label %end

latch:
  %v.2 = phi float [ %v.if, %if ], [ %v.1, %else ]
  %ind.inc = add i32 %ind, 1
  %cc3 = icmp slt i32 %ind, %z
  br i1 %cc3, label %end, label %header

end:
  %r = phi float [ %v.2, %latch ], [ %v.1, %else ]
  ret float %r
}

; Two chains of phi network that have the same value from %if block.
define amdgpu_ps < 2 x float> @while_break_two_chains_of_phi(float %v, i32 %x, i32 %y, i32 %z, ptr addrspace(1) %p) #0 {
; GCN-LABEL: while_break_two_chains_of_phi:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    v_mov_b32_e32 v6, 0
; GCN-NEXT:    s_mov_b32 s2, 0
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_branch .LBB2_2
; GCN-NEXT:  .LBB2_1: ; %Flow1
; GCN-NEXT:    ; in Loop: Header=BB2_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GCN-NEXT:    s_and_b32 s1, exec_lo, s1
; GCN-NEXT:    s_or_b32 s2, s1, s2
; GCN-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GCN-NEXT:    s_cbranch_execz .LBB2_6
; GCN-NEXT:  .LBB2_2: ; %header
; GCN-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_cmp_ge_i32_e64 s3, s0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s0, v1
; GCN-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GCN-NEXT:    s_cbranch_execz .LBB2_4
; GCN-NEXT:  ; %bb.3: ; %if
; GCN-NEXT:    ; in Loop: Header=BB2_2 Depth=1
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    s_lshl_b64 s[6:7], s[0:1], 2
; GCN-NEXT:    s_andn2_b32 s1, s3, exec_lo
; GCN-NEXT:    v_add_co_u32 v6, vcc_lo, v4, s6
; GCN-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, s7, v5, vcc_lo
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s0, v2
; GCN-NEXT:    global_load_dword v0, v[6:7], off
; GCN-NEXT:    s_and_b32 s3, vcc_lo, exec_lo
; GCN-NEXT:    s_or_b32 s3, s1, s3
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_add_f32_e32 v6, 1.0, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v6
; GCN-NEXT:  .LBB2_4: ; %Flow
; GCN-NEXT:    ; in Loop: Header=BB2_2 Depth=1
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GCN-NEXT:    s_mov_b32 s1, -1
; GCN-NEXT:    s_and_saveexec_b32 s4, s3
; GCN-NEXT:    s_cbranch_execz .LBB2_1
; GCN-NEXT:  ; %bb.5: ; %latch
; GCN-NEXT:    ; in Loop: Header=BB2_2 Depth=1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, s0, v3
; GCN-NEXT:    s_add_i32 s0, s0, 1
; GCN-NEXT:    s_orn2_b32 s1, vcc_lo, exec_lo
; GCN-NEXT:    s_branch .LBB2_1
; GCN-NEXT:  .LBB2_6: ; %end
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GCN-NEXT:    v_mov_b32_e32 v1, v6
; GCN-NEXT:    ; return to shader part epilog
entry:
  br label %header

header:
  %v.1 = phi float [ %v, %entry ], [ %v.2, %latch ]
  %v.copy = phi float [ 0.0, %entry ], [ %v.copy.2, %latch ]
  %ind = phi i32 [ 0, %entry], [ %ind.inc, %latch ]
  %cc = icmp slt i32 %ind, %x
  br i1 %cc, label %if, label %latch

if:
  %v.ptr = getelementptr float, ptr addrspace(1) %p, i32 %ind
  %v.load = load float, ptr addrspace(1) %v.ptr
  %v.if = fadd float %v.load, 1.0
  %cc2 = icmp slt i32 %ind, %y
  br i1 %cc2, label %latch, label %end

latch:
  %v.2 = phi float [ %v.1, %header ], [ %v.if, %if ]
  %v.copy.2 = phi float [ %v.copy, %header ], [ %v.if, %if ]
  %ind.inc = add i32 %ind, 1
  %cc3 = icmp slt i32 %ind, %z
  br i1 %cc3, label %end, label %header

end:
  %r = phi float [ %v.2, %latch ], [ %v.if, %if ]
  %r2 = phi float [ %v.copy.2, %latch ], [ %v.if, %if ]
  %packed0 = insertelement < 2 x float > poison, float %r, i32 0
  %packed1 = insertelement < 2 x float > %packed0, float %r2, i32 1
  ret < 2 x float> %packed1
}

attributes #0 = { nounwind }
