; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=GCN
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=GCN

declare void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) nocapture, i32 %size, i32 %vindex, i32 %voffset, i32 %soffset, i32 %offset, i32 %aux)

define amdgpu_ps float @buffer_load_lds_dword(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds) {
; GCN-LABEL: buffer_load_lds_dword:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    v_mov_b32_e32 v0, 8
; GCN-NEXT:    buffer_load_dword v0, s[0:3], 0 idxen lds
; GCN-NEXT:    buffer_load_dword v0, s[0:3], 0 idxen offset:4 glc lds
; GCN-NEXT:    buffer_load_dword v0, s[0:3], 0 idxen offset:8 slc lds
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ds_read_b32 v0, v0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    ; return to shader part epilog
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 8, i32 0, i32 0, i32 0, i32 0)
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 8, i32 0, i32 0, i32 4, i32 1)
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 8, i32 0, i32 0, i32 8, i32 2)
  %res = load float, ptr addrspace(3) %lds
  ret float %res
}

define amdgpu_ps void @buffer_load_lds_dword_imm_offset(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex) {
; GCN-LABEL: buffer_load_lds_dword_imm_offset:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_dword v0, s[0:3], 0 idxen offset:2048 lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 %vindex, i32 0, i32 0, i32 2048, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_dword_v_offset(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex, i32 %voffset) {
; GCN-LABEL: buffer_load_lds_dword_v_offset:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_dword v[0:1], s[0:3], 0 idxen offen lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 %vindex, i32 %voffset, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_dword_s_offset(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex, i32 inreg %soffset) {
; GCN-LABEL: buffer_load_lds_dword_s_offset:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_dword v0, s[0:3], s5 idxen lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 %vindex, i32 0, i32 %soffset, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_dword_vs_offset(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex, i32 %voffset, i32 inreg %soffset) {
; GCN-LABEL: buffer_load_lds_dword_vs_offset:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_dword v[0:1], s[0:3], s5 idxen offen lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 %vindex, i32 %voffset, i32 %soffset, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_dword_vs_imm_offset(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex, i32 %voffset, i32 inreg %soffset) {
; GCN-LABEL: buffer_load_lds_dword_vs_imm_offset:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_dword v[0:1], s[0:3], s5 idxen offen offset:2048 lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 4, i32 %vindex, i32 %voffset, i32 %soffset, i32 2048, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_ushort(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex) {
; GCN-LABEL: buffer_load_lds_ushort:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    v_mov_b32_e32 v1, 0x800
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_ushort v[0:1], s[0:3], 0 idxen offen lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 2, i32 %vindex, i32 2048, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @buffer_load_lds_ubyte(ptr addrspace(8) inreg %rsrc, ptr addrspace(3) inreg %lds, i32 %vindex) {
; GCN-LABEL: buffer_load_lds_ubyte:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    buffer_load_ubyte v0, s[0:3], 0 idxen offset:2048 lds
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.buffer.load.lds(ptr addrspace(8) %rsrc, ptr addrspace(3) %lds, i32 1, i32 %vindex, i32 0, i32 0, i32 2048, i32 0)
  ret void
}
