; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='instcombine' -S < %s | FileCheck %s

define target("aarch64.svcount") @test_alloca_store_reload(target("aarch64.svcount") %val) nounwind {
; CHECK-LABEL: @test_alloca_store_reload(
; CHECK-NEXT:    ret target("aarch64.svcount") [[VAL:%.*]]
;
  %ptr = alloca target("aarch64.svcount"), align 1
  store target("aarch64.svcount") %val, ptr %ptr
  %res = load target("aarch64.svcount"), ptr %ptr
  ret target("aarch64.svcount") %res
}

; Test that instcombine doesn't try to query the (scalable) size of target("aarch64.svcount")
; in foldSelectInstWithICmp.
define target("aarch64.svcount") @test_combine_on_select(target("aarch64.svcount") %x, target("aarch64.svcount") %y, i32 %k) {
; CHECK-LABEL: @test_combine_on_select(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[K:%.*]], 42
; CHECK-NEXT:    [[X_Y:%.*]] = select i1 [[CMP]], target("aarch64.svcount") [[X:%.*]], target("aarch64.svcount") [[Y:%.*]]
; CHECK-NEXT:    ret target("aarch64.svcount") [[X_Y]]
;
  %cmp = icmp sgt i32 %k, 42
  %x.y = select i1 %cmp, target("aarch64.svcount") %x, target("aarch64.svcount") %y
  ret target("aarch64.svcount") %x.y
}
