; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 < %s | FileCheck %s

%va_list = type { ptr, ptr, ptr, i32, i32 }

define preserve_nonecc i32 @callee(i32 %a1, i32 %a2, i32 %a3, i32 %a4, i32 %a5, ...) nounwind noinline ssp {
; CHECK-LABEL: callee:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #192
; CHECK-NEXT:    mov x8, #-24 // =0xffffffffffffffe8
; CHECK-NEXT:    mov x9, sp
; CHECK-NEXT:    add x10, sp, #136
; CHECK-NEXT:    movk x8, #65408, lsl #32
; CHECK-NEXT:    add x9, x9, #128
; CHECK-NEXT:    stp x6, x7, [sp, #144]
; CHECK-NEXT:    stp x9, x8, [sp, #176]
; CHECK-NEXT:    add x9, x10, #24
; CHECK-NEXT:    add x10, sp, #192
; CHECK-NEXT:    mov w8, #-24 // =0xffffffe8
; CHECK-NEXT:    str x5, [sp, #136]
; CHECK-NEXT:    stp q0, q1, [sp]
; CHECK-NEXT:    stp q2, q3, [sp, #32]
; CHECK-NEXT:    stp q4, q5, [sp, #64]
; CHECK-NEXT:    stp q6, q7, [sp, #96]
; CHECK-NEXT:    stp x10, x9, [sp, #160]
; CHECK-NEXT:    tbz w8, #31, .LBB0_3
; CHECK-NEXT:  // %bb.1: // %maybe_reg
; CHECK-NEXT:    add w9, w8, #8
; CHECK-NEXT:    cmp w9, #0
; CHECK-NEXT:    str w9, [sp, #184]
; CHECK-NEXT:    b.gt .LBB0_3
; CHECK-NEXT:  // %bb.2: // %in_reg
; CHECK-NEXT:    ldr x9, [sp, #168]
; CHECK-NEXT:    add x8, x9, w8, sxtw
; CHECK-NEXT:    b .LBB0_4
; CHECK-NEXT:  .LBB0_3: // %on_stack
; CHECK-NEXT:    ldr x8, [sp, #160]
; CHECK-NEXT:    add x9, x8, #8
; CHECK-NEXT:    str x9, [sp, #160]
; CHECK-NEXT:  .LBB0_4: // %end
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    add sp, sp, #192
; CHECK-NEXT:    ret
entry:
  %args = alloca %va_list, align 8
  call void @llvm.va_start(ptr %args)
  %gr_offs_p = getelementptr inbounds %va_list, ptr %args, i32 0, i32 3
  %gr_offs = load i32, ptr %gr_offs_p, align 8
  %0 = icmp sge i32 %gr_offs, 0
  br i1 %0, label %on_stack, label %maybe_reg

maybe_reg:
  %new_reg_offs = add i32 %gr_offs, 8
  store i32 %new_reg_offs, ptr %gr_offs_p, align 8
  %inreg = icmp sle i32 %new_reg_offs, 0
  br i1 %inreg, label %in_reg, label %on_stack

in_reg:
  %reg_top_p = getelementptr inbounds %va_list, ptr %args, i32 0, i32 1
  %reg_top = load ptr, ptr %reg_top_p, align 8
  %reg = getelementptr inbounds i8, ptr %reg_top, i32 %gr_offs
  br label %end

on_stack:
  %stack_p = getelementptr inbounds %va_list, ptr %args, i32 0, i32 0
  %stack = load ptr, ptr %stack_p, align 8
  %new_stack = getelementptr inbounds i8, ptr %stack, i64 8
  store ptr %new_stack, ptr %stack_p, align 8
  br label %end

end:
  %p = phi ptr [ %reg, %in_reg ], [ %stack, %on_stack ]
  %10 = load i32, ptr %p, align 8
  call void @llvm.va_end.p0(ptr %args)
  ret i32 %10
}

declare void @llvm.va_start(ptr) nounwind
declare void @llvm.va_end(ptr) nounwind

define i32 @caller() nounwind ssp {
; CHECK-LABEL: caller:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #176
; CHECK-NEXT:    mov w8, #10 // =0xa
; CHECK-NEXT:    mov w9, #9 // =0x9
; CHECK-NEXT:    mov w0, #1 // =0x1
; CHECK-NEXT:    mov w1, #2 // =0x2
; CHECK-NEXT:    mov w2, #3 // =0x3
; CHECK-NEXT:    mov w3, #4 // =0x4
; CHECK-NEXT:    mov w4, #5 // =0x5
; CHECK-NEXT:    mov w5, #6 // =0x6
; CHECK-NEXT:    mov w6, #7 // =0x7
; CHECK-NEXT:    mov w7, #8 // =0x8
; CHECK-NEXT:    stp d15, d14, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d13, d12, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #80] // 8-byte Folded Spill
; CHECK-NEXT:    stp x28, x27, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    stp x26, x25, [sp, #112] // 16-byte Folded Spill
; CHECK-NEXT:    stp x24, x23, [sp, #128] // 16-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #144] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #160] // 16-byte Folded Spill
; CHECK-NEXT:    str w8, [sp, #8]
; CHECK-NEXT:    str w9, [sp]
; CHECK-NEXT:    bl callee
; CHECK-NEXT:    ldp x20, x19, [sp, #160] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #80] // 8-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #144] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x24, x23, [sp, #128] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x26, x25, [sp, #112] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x28, x27, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d11, d10, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d13, d12, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    ldp d15, d14, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #176
; CHECK-NEXT:    ret
  %r = tail call preserve_nonecc i32 (i32, i32, i32, i32, i32, ...) @callee(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10)
  ret i32 %r
}

