; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi ilp32d \
; RUN:    -global-isel -stop-after=irtranslator -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32-ILP32D %s

; This file contains tests that will have differing output for the ilp32/ilp32f
; and ilp32d ABIs.

define i32 @callee_double_in_fpr(i32 %a, double %b) nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_in_fpr
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   liveins: $x10, $f10_d
  ; RV32-ILP32D-NEXT: {{  $}}
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY1]](s64)
  ; RV32-ILP32D-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[FPTOSI]]
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %b_fptosi = fptosi double %b to i32
  %1 = add i32 %a, %b_fptosi
  ret i32 %1
}

define i32 @caller_double_in_fpr() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_in_fpr
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_FCONSTANT double 2.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C1]](s64)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_in_fpr, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $f10_d, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_double_in_fpr(i32 1, double 2.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_double_in_fpr_exhausted_gprs(i64 %a, i64 %b, i64 %c, i64 %d, i32 %e, double %f) nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_in_fpr_exhausted_gprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $f10_d
  ; RV32-ILP32D-NEXT: {{  $}}
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32D-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32-ILP32D-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32-ILP32D-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32-ILP32D-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32-ILP32D-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32-ILP32D-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32-ILP32D-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32-ILP32D-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32-ILP32D-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s32) from %fixed-stack.0, align 16)
  ; RV32-ILP32D-NEXT:   [[COPY8:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY8]](s64)
  ; RV32-ILP32D-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[LOAD]], [[FPTOSI]]
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %f_fptosi = fptosi double %f to i32
  %1 = add i32 %e, %f_fptosi
  ret i32 %1
}

define i32 @caller_double_in_fpr_exhausted_gprs() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_in_fpr_exhausted_gprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 5
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_FCONSTANT double 6.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32D-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C1]](s64)
  ; RV32-ILP32D-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32D-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C3]](s64)
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32D-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C6]](s32)
  ; RV32-ILP32D-NEXT:   G_STORE [[C4]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32D-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32D-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32D-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32D-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32D-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C5]](s64)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_in_fpr_exhausted_gprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit $x14, implicit $x15, implicit $x16, implicit $x17, implicit $f10_d, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_double_in_fpr_exhausted_gprs(
      i64 1, i64 2, i64 3, i64 4, i32 5, double 6.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_double_in_gpr_exhausted_fprs(double %a, double %b, double %c, double %d, double %e, double %f, double %g, double %h, double %i) nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_in_gpr_exhausted_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   liveins: $x10, $x11, $f10_d, $f11_d, $f12_d, $f13_d, $f14_d, $f15_d, $f16_d, $f17_d
  ; RV32-ILP32D-NEXT: {{  $}}
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s64) = COPY $f11_d
  ; RV32-ILP32D-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $f12_d
  ; RV32-ILP32D-NEXT:   [[COPY3:%[0-9]+]]:_(s64) = COPY $f13_d
  ; RV32-ILP32D-NEXT:   [[COPY4:%[0-9]+]]:_(s64) = COPY $f14_d
  ; RV32-ILP32D-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $f15_d
  ; RV32-ILP32D-NEXT:   [[COPY6:%[0-9]+]]:_(s64) = COPY $f16_d
  ; RV32-ILP32D-NEXT:   [[COPY7:%[0-9]+]]:_(s64) = COPY $f17_d
  ; RV32-ILP32D-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32D-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; RV32-ILP32D-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY7]](s64)
  ; RV32-ILP32D-NEXT:   [[FPTOSI1:%[0-9]+]]:_(s32) = G_FPTOSI [[MV]](s64)
  ; RV32-ILP32D-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[FPTOSI]], [[FPTOSI1]]
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %h_fptosi = fptosi double %h to i32
  %i_fptosi = fptosi double %i to i32
  %1 = add i32 %h_fptosi, %i_fptosi
  ret i32 %1
}

define i32 @caller_double_in_gpr_exhausted_fprs() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_in_gpr_exhausted_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.000000e+00
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_FCONSTANT double 2.000000e+00
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_FCONSTANT double 3.000000e+00
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_FCONSTANT double 4.000000e+00
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_FCONSTANT double 5.000000e+00
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_FCONSTANT double 6.000000e+00
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_FCONSTANT double 7.000000e+00
  ; RV32-ILP32D-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_FCONSTANT double 8.000000e+00
  ; RV32-ILP32D-NEXT:   [[C8:%[0-9]+]]:_(s64) = G_FCONSTANT double 9.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C8]](s64)
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C]](s64)
  ; RV32-ILP32D-NEXT:   $f11_d = COPY [[C1]](s64)
  ; RV32-ILP32D-NEXT:   $f12_d = COPY [[C2]](s64)
  ; RV32-ILP32D-NEXT:   $f13_d = COPY [[C3]](s64)
  ; RV32-ILP32D-NEXT:   $f14_d = COPY [[C4]](s64)
  ; RV32-ILP32D-NEXT:   $f15_d = COPY [[C5]](s64)
  ; RV32-ILP32D-NEXT:   $f16_d = COPY [[C6]](s64)
  ; RV32-ILP32D-NEXT:   $f17_d = COPY [[C7]](s64)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_in_gpr_exhausted_fprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $f10_d, implicit $f11_d, implicit $f12_d, implicit $f13_d, implicit $f14_d, implicit $f15_d, implicit $f16_d, implicit $f17_d, implicit $x10, implicit $x11, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_double_in_gpr_exhausted_fprs(
      double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0,
      double 7.0, double 8.0, double 9.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_double_in_gpr_and_stack_almost_exhausted_gprs_fprs(i64 %a, double %b, i64 %c, double %d, i64 %e, double %f, i32 %g, double %h, double %i, double %j, double %k, double %l, double %m) nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_in_gpr_and_stack_almost_exhausted_gprs_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $f10_d, $f11_d, $f12_d, $f13_d, $f14_d, $f15_d, $f16_d, $f17_d
  ; RV32-ILP32D-NEXT: {{  $}}
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32D-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32-ILP32D-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32-ILP32D-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY3]](s32), [[COPY4]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $f11_d
  ; RV32-ILP32D-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32-ILP32D-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32-ILP32D-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY8:%[0-9]+]]:_(s64) = COPY $f12_d
  ; RV32-ILP32D-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32-ILP32D-NEXT:   [[COPY10:%[0-9]+]]:_(s64) = COPY $f13_d
  ; RV32-ILP32D-NEXT:   [[COPY11:%[0-9]+]]:_(s64) = COPY $f14_d
  ; RV32-ILP32D-NEXT:   [[COPY12:%[0-9]+]]:_(s64) = COPY $f15_d
  ; RV32-ILP32D-NEXT:   [[COPY13:%[0-9]+]]:_(s64) = COPY $f16_d
  ; RV32-ILP32D-NEXT:   [[COPY14:%[0-9]+]]:_(s64) = COPY $f17_d
  ; RV32-ILP32D-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32-ILP32D-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s32) from %fixed-stack.0, align 16)
  ; RV32-ILP32D-NEXT:   [[COPY15:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32-ILP32D-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY15]](s32), [[LOAD]](s32)
  ; RV32-ILP32D-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[MV3]](s64)
  ; RV32-ILP32D-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY9]], [[FPTOSI]]
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %m_fptosi = fptosi double %m to i32
  %1 = add i32 %g, %m_fptosi
  ret i32 %1
}

define i32 @caller_double_in_gpr_and_stack_almost_exhausted_gprs_fprs() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_in_gpr_and_stack_almost_exhausted_gprs_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_FCONSTANT double 2.000000e+00
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_FCONSTANT double 4.000000e+00
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_FCONSTANT double 6.000000e+00
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_CONSTANT i32 7
  ; RV32-ILP32D-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_FCONSTANT double 8.000000e+00
  ; RV32-ILP32D-NEXT:   [[C8:%[0-9]+]]:_(s64) = G_FCONSTANT double 9.000000e+00
  ; RV32-ILP32D-NEXT:   [[C9:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.000000e+01
  ; RV32-ILP32D-NEXT:   [[C10:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.100000e+01
  ; RV32-ILP32D-NEXT:   [[C11:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.200000e+01
  ; RV32-ILP32D-NEXT:   [[C12:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.300000e+01
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32D-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32D-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C4]](s64)
  ; RV32-ILP32D-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C12]](s64)
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32D-NEXT:   [[C13:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32D-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C13]](s32)
  ; RV32-ILP32D-NEXT:   G_STORE [[UV7]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C1]](s64)
  ; RV32-ILP32D-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32D-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32D-NEXT:   $f11_d = COPY [[C3]](s64)
  ; RV32-ILP32D-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32D-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32D-NEXT:   $f12_d = COPY [[C5]](s64)
  ; RV32-ILP32D-NEXT:   $x16 = COPY [[C6]](s32)
  ; RV32-ILP32D-NEXT:   $f13_d = COPY [[C7]](s64)
  ; RV32-ILP32D-NEXT:   $f14_d = COPY [[C8]](s64)
  ; RV32-ILP32D-NEXT:   $f15_d = COPY [[C9]](s64)
  ; RV32-ILP32D-NEXT:   $f16_d = COPY [[C10]](s64)
  ; RV32-ILP32D-NEXT:   $f17_d = COPY [[C11]](s64)
  ; RV32-ILP32D-NEXT:   $x17 = COPY [[UV6]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_in_gpr_and_stack_almost_exhausted_gprs_fprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $x11, implicit $f10_d, implicit $x12, implicit $x13, implicit $f11_d, implicit $x14, implicit $x15, implicit $f12_d, implicit $x16, implicit $f13_d, implicit $f14_d, implicit $f15_d, implicit $f16_d, implicit $f17_d, implicit $x17, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_double_in_gpr_and_stack_almost_exhausted_gprs_fprs(
      i64 1, double 2.0, i64 3, double 4.0, i64 5, double 6.0, i32 7, double 8.0,
      double 9.0, double 10.0, double 11.0, double 12.0, double 13.0)
  ret i32 %1
}


; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_double_on_stack_exhausted_gprs_fprs(i64 %a, double %b, i64 %c, double %d, i64 %e, double %f, i64 %g, double %h, double %i, double %j, double %k, double %l, double %m) nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_on_stack_exhausted_gprs_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $f10_d, $f11_d, $f12_d, $f13_d, $f14_d, $f15_d, $f16_d, $f17_d
  ; RV32-ILP32D-NEXT: {{  $}}
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32D-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY2:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32-ILP32D-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32-ILP32D-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY3]](s32), [[COPY4]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY5:%[0-9]+]]:_(s64) = COPY $f11_d
  ; RV32-ILP32D-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32-ILP32D-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32-ILP32D-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY8:%[0-9]+]]:_(s64) = COPY $f12_d
  ; RV32-ILP32D-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32-ILP32D-NEXT:   [[COPY10:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32-ILP32D-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY9]](s32), [[COPY10]](s32)
  ; RV32-ILP32D-NEXT:   [[COPY11:%[0-9]+]]:_(s64) = COPY $f13_d
  ; RV32-ILP32D-NEXT:   [[COPY12:%[0-9]+]]:_(s64) = COPY $f14_d
  ; RV32-ILP32D-NEXT:   [[COPY13:%[0-9]+]]:_(s64) = COPY $f15_d
  ; RV32-ILP32D-NEXT:   [[COPY14:%[0-9]+]]:_(s64) = COPY $f16_d
  ; RV32-ILP32D-NEXT:   [[COPY15:%[0-9]+]]:_(s64) = COPY $f17_d
  ; RV32-ILP32D-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32-ILP32D-NEXT:   [[LOAD:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s64) from %fixed-stack.0, align 16)
  ; RV32-ILP32D-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[MV3]](s64)
  ; RV32-ILP32D-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[LOAD]](s64)
  ; RV32-ILP32D-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[TRUNC]], [[FPTOSI]]
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %g_trunc = trunc i64 %g to i32
  %m_fptosi = fptosi double %m to i32
  %1 = add i32 %g_trunc, %m_fptosi
  ret i32 %1
}

define i32 @caller_double_on_stack_exhausted_gprs_fprs() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_on_stack_exhausted_gprs_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_FCONSTANT double 2.000000e+00
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_FCONSTANT double 4.000000e+00
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s64) = G_FCONSTANT double 6.000000e+00
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; RV32-ILP32D-NEXT:   [[C7:%[0-9]+]]:_(s64) = G_FCONSTANT double 8.000000e+00
  ; RV32-ILP32D-NEXT:   [[C8:%[0-9]+]]:_(s64) = G_FCONSTANT double 9.000000e+00
  ; RV32-ILP32D-NEXT:   [[C9:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.000000e+01
  ; RV32-ILP32D-NEXT:   [[C10:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.100000e+01
  ; RV32-ILP32D-NEXT:   [[C11:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.200000e+01
  ; RV32-ILP32D-NEXT:   [[C12:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.300000e+01
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 8, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32D-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32D-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C4]](s64)
  ; RV32-ILP32D-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C6]](s64)
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32D-NEXT:   [[C13:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32D-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C13]](s32)
  ; RV32-ILP32D-NEXT:   G_STORE [[C12]](s64), [[PTR_ADD]](p0) :: (store (s64) into stack, align 16)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C1]](s64)
  ; RV32-ILP32D-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32D-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32D-NEXT:   $f11_d = COPY [[C3]](s64)
  ; RV32-ILP32D-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32D-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32D-NEXT:   $f12_d = COPY [[C5]](s64)
  ; RV32-ILP32D-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32D-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32D-NEXT:   $f13_d = COPY [[C7]](s64)
  ; RV32-ILP32D-NEXT:   $f14_d = COPY [[C8]](s64)
  ; RV32-ILP32D-NEXT:   $f15_d = COPY [[C9]](s64)
  ; RV32-ILP32D-NEXT:   $f16_d = COPY [[C10]](s64)
  ; RV32-ILP32D-NEXT:   $f17_d = COPY [[C11]](s64)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_on_stack_exhausted_gprs_fprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $x11, implicit $f10_d, implicit $x12, implicit $x13, implicit $f11_d, implicit $x14, implicit $x15, implicit $f12_d, implicit $x16, implicit $x17, implicit $f13_d, implicit $f14_d, implicit $f15_d, implicit $f16_d, implicit $f17_d, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 8, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_double_on_stack_exhausted_gprs_fprs(
      i64 1, double 2.0, i64 3, double 4.0, i64 5, double 6.0, i64 7, double 8.0,
      double 9.0, double 10.0, double 11.0, double 12.0, double 13.0)
  ret i32 %1
}

define double @callee_double_ret() nounwind {
  ; RV32-ILP32D-LABEL: name: callee_double_ret
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_FCONSTANT double 1.000000e+00
  ; RV32-ILP32D-NEXT:   $f10_d = COPY [[C]](s64)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $f10_d
  ret double 1.0
}

define i32 @caller_double_ret() nounwind {
  ; RV32-ILP32D-LABEL: name: caller_double_ret
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_double_ret, csr_ilp32d_lp64d, implicit-def $x1, implicit-def $f10_d
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $f10_d
  ; RV32-ILP32D-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[COPY]](s64)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[TRUNC]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call double @callee_double_ret()
  %2 = bitcast double %1 to i64
  %3 = trunc i64 %2 to i32
  ret i32 %3
}
