; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi -mattr=+v6 %s -o - | FileCheck %s

; rotr (rotr x, 4), 6 -> rotr x, 10 -> ror r0, r0, #10
define i32 @test1(i32 %x) nounwind readnone {
; CHECK-LABEL: test1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ror r0, r0, #10
; CHECK-NEXT:    bx lr
entry:
  %result.i = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 4)
  %result.i.3 = call i32 @llvm.fshr.i32(i32 %result.i, i32 %result.i, i32 6)
  ret i32 %result.i.3
}

; rotl (rotr x, 4), 6 -> rotl x, 2 -> ror r0, r0, #30
define i32 @test1_alt(i32 %x) nounwind readnone {
; CHECK-LABEL: test1_alt:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ror r0, r0, #30
; CHECK-NEXT:    bx lr
entry:
  %result.i = call i32 @llvm.fshr.i32(i32 %x, i32 %x, i32 4)
  %result.i.3 = call i32 @llvm.fshl.i32(i32 %result.i, i32 %result.i, i32 6)
  ret i32 %result.i.3
}

; the same vector tests
define <2 x i32> @test2(<2 x i32> %x) nounwind readnone {
; CHECK-LABEL: test2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ror r0, r0, #10
; CHECK-NEXT:    ror r1, r1, #10
; CHECK-NEXT:    bx lr
entry:
  %result.i = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %x, <2 x i32> %x, <2 x i32> <i32 4, i32 4>)
  %result.i.3 = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %result.i, <2 x i32> %result.i, <2 x i32> <i32 6, i32 6>)
  ret <2 x i32> %result.i.3
}

define <2 x i32> @test2_alt(<2 x i32> %x) nounwind readnone {
; CHECK-LABEL: test2_alt:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ror r0, r0, #30
; CHECK-NEXT:    ror r1, r1, #30
; CHECK-NEXT:    bx lr
entry:
  %result.i = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %x, <2 x i32> %x, <2 x i32> <i32 4, i32 4>)
  %result.i.3 = call <2 x i32> @llvm.fshl.v2i32(<2 x i32> %result.i, <2 x i32> %result.i, <2 x i32> <i32 6, i32 6>)
  ret <2 x i32> %result.i.3
}

declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)

declare <2 x i32> @llvm.fshl.v2i32(<2 x i32>, <2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.fshr.v2i32(<2 x i32>, <2 x i32>, <2 x i32>)
