/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _ABW_SPREADSHEET_TO_TABLE_GENERATOR_HXX_
#define _ABW_SPREADSHEET_TO_TABLE_GENERATOR_HXX_

#include <librevenge/librevenge.h>

#include "librvngabw-api.hxx"
#include "ABWDocumentHandler.hxx"


namespace librvngabw
{
class ABWSpreadsheetToTableGeneratorPrivate;
/** A generator for helpping convert embedded spreadsheet in table
  *
  * See @c libdocumentinterface library for documentation of the librevenge::RVNGSpreadsheetInterface
  * interface.
  *
  * \note only the main spreadsheet content is converted....
  */
class RVNGABWAPI ABWSpreadsheetToTableGenerator final : public librevenge::RVNGSpreadsheetInterface
{
public:
	//! constructor
	ABWSpreadsheetToTableGenerator(ABWGenerator &documentGenerator);
	//! destructor
	~ABWSpreadsheetToTableGenerator() final;

	void setDocumentMetaData(const librevenge::RVNGPropertyList &propList) final;
	void startDocument(const librevenge::RVNGPropertyList &) final;
	void endDocument() final;

	void defineEmbeddedFont(const librevenge::RVNGPropertyList &propList) final;

	// TODO: move code in .cxx
	void definePageStyle(const librevenge::RVNGPropertyList &) final {}
	void openPageSpan(const librevenge::RVNGPropertyList &propList) final;
	void closePageSpan() final;

	// TODO: move code in .cxx
	void defineSectionStyle(const librevenge::RVNGPropertyList &) final {}
	void openSection(const librevenge::RVNGPropertyList &propList) final;
	void closeSection() final;

	void openHeader(const librevenge::RVNGPropertyList &propList) final;
	void closeHeader() final;
	void openFooter(const librevenge::RVNGPropertyList &propList) final;
	void closeFooter() final;

	void defineSheetNumberingStyle(const librevenge::RVNGPropertyList &propList) final;
	void openSheet(const librevenge::RVNGPropertyList &propList) final;
	void closeSheet() final;
	void openSheetRow(const librevenge::RVNGPropertyList &propList) final;
	void closeSheetRow() final;
	void openSheetCell(const librevenge::RVNGPropertyList &propList) final;
	void closeSheetCell() final;

	void defineChartStyle(const librevenge::RVNGPropertyList &propList) final;
	void openChart(const librevenge::RVNGPropertyList &propList) final;
	void closeChart() final;
	void openChartTextObject(const librevenge::RVNGPropertyList &propList) final;
	void closeChartTextObject() final;
	void openChartPlotArea(const librevenge::RVNGPropertyList &propList) final;
	void closeChartPlotArea() final;
	void insertChartAxis(const librevenge::RVNGPropertyList &axis) final;
	void openChartSerie(const librevenge::RVNGPropertyList &series) final;
	void closeChartSerie() final;

	void defineParagraphStyle(const librevenge::RVNGPropertyList &propList) final;
	void openParagraph(const librevenge::RVNGPropertyList &propList) final;
	void closeParagraph() final;

	void defineCharacterStyle(const librevenge::RVNGPropertyList &propList) final;
	void openSpan(const librevenge::RVNGPropertyList &propList) final;
	void closeSpan() final;

	void openLink(const librevenge::RVNGPropertyList &propList) final;
	void closeLink() final;

	void insertTab() final;
	void insertSpace() final;
	void insertText(const librevenge::RVNGString &text) final;
	void insertLineBreak() final;
	void insertField(const librevenge::RVNGPropertyList &propList) final;

	void openOrderedListLevel(const librevenge::RVNGPropertyList &propList) final;
	void openUnorderedListLevel(const librevenge::RVNGPropertyList &propList) final;
	void closeOrderedListLevel() final;
	void closeUnorderedListLevel() final;
	void openListElement(const librevenge::RVNGPropertyList &propList) final;
	void closeListElement() final;

	void openFootnote(const librevenge::RVNGPropertyList &propList) final;
	void closeFootnote() final;

	void openComment(const librevenge::RVNGPropertyList &propList) final;
	void closeComment() final;
	void openTextBox(const librevenge::RVNGPropertyList &propList) final;
	void closeTextBox() final;

	void openTable(const librevenge::RVNGPropertyList &propList) final;
	void openTableRow(const librevenge::RVNGPropertyList &propList) final;
	void closeTableRow() final;
	void openTableCell(const librevenge::RVNGPropertyList &propList) final;
	void closeTableCell() final;
	void insertCoveredTableCell(const librevenge::RVNGPropertyList &propList) final;
	void closeTable() final;

	void openFrame(const librevenge::RVNGPropertyList &propList) final;
	void closeFrame() final;

	void insertBinaryObject(const librevenge::RVNGPropertyList &propList) final;

	//
	// simple Graphic
	//

	void openGroup(const librevenge::RVNGPropertyList &propList) final;
	void closeGroup() final;

	void defineGraphicStyle(const librevenge::RVNGPropertyList &propList) final;
	void drawRectangle(const librevenge::RVNGPropertyList &propList) final;
	void drawEllipse(const librevenge::RVNGPropertyList &propList) final;
	void drawPolygon(const librevenge::RVNGPropertyList &propList) final;
	void drawPolyline(const librevenge::RVNGPropertyList &propList) final;
	void drawPath(const librevenge::RVNGPropertyList &propList) final;
	void drawConnector(const librevenge::RVNGPropertyList &propList) final;

	// TODO: move code in .cxx
	void insertEquation(const librevenge::RVNGPropertyList &) final {}

private:
	ABWSpreadsheetToTableGenerator(ABWSpreadsheetToTableGenerator const &);
	ABWSpreadsheetToTableGenerator &operator=(ABWSpreadsheetToTableGenerator const &);

	ABWSpreadsheetToTableGeneratorPrivate *m_data;
};
}

#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
