/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "prints to stdout the created OFX file based on the options you pass it. \ncurrently it will only create a statement request file.  you can POST this to \nan OFX server to request a statement from that financial institution for that \naccount.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]... [FILES]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                Print help and exit",
  "  -V, --version             Print version and exit",
  "      --fipid=STRING        FI partner identifier (looks up fid, org & url from \n                              partner server)",
  "      --fid=STRING          FI identifier",
  "      --org=STRING          FI org tag",
  "      --bank=STRING         IBAN bank identifier",
  "      --broker=STRING       Broker identifier",
  "      --user=STRING         User name",
  "      --pass=STRING         Password",
  "      --acct=STRING         Account ID",
  "      --type=INT            Account Type 1=checking 2=invest 3=ccard",
  "      --past=LONG           How far back to look from today (in days)",
  "      --url=STRING          Url to POST the data to (otherwise goes to stdout)",
  "      --trid=INT            Transaction id",
  "\n Group: command",
  "  -s, --statement-req       Request for a statement",
  "  -a, --accountinfo-req     Request for a list of accounts",
  "  -p, --payment-req         Request to make a payment",
  "  -i, --paymentinquiry-req  Request to inquire about the status of a payment",
  "  -b, --bank-list           List all known banks",
  "  -f, --bank-fipid          List all fipids for a given bank",
  "  -v, --bank-services       List supported services for a given fipid",
  "      --allsupport          List all banks which support online banking",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fipid_given = 0 ;
  args_info->fid_given = 0 ;
  args_info->org_given = 0 ;
  args_info->bank_given = 0 ;
  args_info->broker_given = 0 ;
  args_info->user_given = 0 ;
  args_info->pass_given = 0 ;
  args_info->acct_given = 0 ;
  args_info->type_given = 0 ;
  args_info->past_given = 0 ;
  args_info->url_given = 0 ;
  args_info->trid_given = 0 ;
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->payment_req_given = 0 ;
  args_info->paymentinquiry_req_given = 0 ;
  args_info->bank_list_given = 0 ;
  args_info->bank_fipid_given = 0 ;
  args_info->bank_services_given = 0 ;
  args_info->allsupport_given = 0 ;
  args_info->command_group_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->fipid_arg = NULL;
  args_info->fipid_orig = NULL;
  args_info->fid_arg = NULL;
  args_info->fid_orig = NULL;
  args_info->org_arg = NULL;
  args_info->org_orig = NULL;
  args_info->bank_arg = NULL;
  args_info->bank_orig = NULL;
  args_info->broker_arg = NULL;
  args_info->broker_orig = NULL;
  args_info->user_arg = NULL;
  args_info->user_orig = NULL;
  args_info->pass_arg = NULL;
  args_info->pass_orig = NULL;
  args_info->acct_arg = NULL;
  args_info->acct_orig = NULL;
  args_info->type_orig = NULL;
  args_info->past_orig = NULL;
  args_info->url_arg = NULL;
  args_info->url_orig = NULL;
  args_info->trid_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->fipid_help = gengetopt_args_info_help[2] ;
  args_info->fid_help = gengetopt_args_info_help[3] ;
  args_info->org_help = gengetopt_args_info_help[4] ;
  args_info->bank_help = gengetopt_args_info_help[5] ;
  args_info->broker_help = gengetopt_args_info_help[6] ;
  args_info->user_help = gengetopt_args_info_help[7] ;
  args_info->pass_help = gengetopt_args_info_help[8] ;
  args_info->acct_help = gengetopt_args_info_help[9] ;
  args_info->type_help = gengetopt_args_info_help[10] ;
  args_info->past_help = gengetopt_args_info_help[11] ;
  args_info->url_help = gengetopt_args_info_help[12] ;
  args_info->trid_help = gengetopt_args_info_help[13] ;
  args_info->statement_req_help = gengetopt_args_info_help[15] ;
  args_info->accountinfo_req_help = gengetopt_args_info_help[16] ;
  args_info->payment_req_help = gengetopt_args_info_help[17] ;
  args_info->paymentinquiry_req_help = gengetopt_args_info_help[18] ;
  args_info->bank_list_help = gengetopt_args_info_help[19] ;
  args_info->bank_fipid_help = gengetopt_args_info_help[20] ;
  args_info->bank_services_help = gengetopt_args_info_help[21] ;
  args_info->allsupport_help = gengetopt_args_info_help[22] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->fipid_arg));
  free_string_field (&(args_info->fipid_orig));
  free_string_field (&(args_info->fid_arg));
  free_string_field (&(args_info->fid_orig));
  free_string_field (&(args_info->org_arg));
  free_string_field (&(args_info->org_orig));
  free_string_field (&(args_info->bank_arg));
  free_string_field (&(args_info->bank_orig));
  free_string_field (&(args_info->broker_arg));
  free_string_field (&(args_info->broker_orig));
  free_string_field (&(args_info->user_arg));
  free_string_field (&(args_info->user_orig));
  free_string_field (&(args_info->pass_arg));
  free_string_field (&(args_info->pass_orig));
  free_string_field (&(args_info->acct_arg));
  free_string_field (&(args_info->acct_orig));
  free_string_field (&(args_info->type_orig));
  free_string_field (&(args_info->past_orig));
  free_string_field (&(args_info->url_arg));
  free_string_field (&(args_info->url_orig));
  free_string_field (&(args_info->trid_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->fipid_given)
    write_into_file(outfile, "fipid", args_info->fipid_orig, 0);
  if (args_info->fid_given)
    write_into_file(outfile, "fid", args_info->fid_orig, 0);
  if (args_info->org_given)
    write_into_file(outfile, "org", args_info->org_orig, 0);
  if (args_info->bank_given)
    write_into_file(outfile, "bank", args_info->bank_orig, 0);
  if (args_info->broker_given)
    write_into_file(outfile, "broker", args_info->broker_orig, 0);
  if (args_info->user_given)
    write_into_file(outfile, "user", args_info->user_orig, 0);
  if (args_info->pass_given)
    write_into_file(outfile, "pass", args_info->pass_orig, 0);
  if (args_info->acct_given)
    write_into_file(outfile, "acct", args_info->acct_orig, 0);
  if (args_info->type_given)
    write_into_file(outfile, "type", args_info->type_orig, 0);
  if (args_info->past_given)
    write_into_file(outfile, "past", args_info->past_orig, 0);
  if (args_info->url_given)
    write_into_file(outfile, "url", args_info->url_orig, 0);
  if (args_info->trid_given)
    write_into_file(outfile, "trid", args_info->trid_orig, 0);
  if (args_info->statement_req_given)
    write_into_file(outfile, "statement-req", 0, 0 );
  if (args_info->accountinfo_req_given)
    write_into_file(outfile, "accountinfo-req", 0, 0 );
  if (args_info->payment_req_given)
    write_into_file(outfile, "payment-req", 0, 0 );
  if (args_info->paymentinquiry_req_given)
    write_into_file(outfile, "paymentinquiry-req", 0, 0 );
  if (args_info->bank_list_given)
    write_into_file(outfile, "bank-list", 0, 0 );
  if (args_info->bank_fipid_given)
    write_into_file(outfile, "bank-fipid", 0, 0 );
  if (args_info->bank_services_given)
    write_into_file(outfile, "bank-services", 0, 0 );
  if (args_info->allsupport_given)
    write_into_file(outfile, "allsupport", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static void
reset_group_command(struct gengetopt_args_info *args_info)
{
  if (! args_info->command_group_counter)
    return;
  
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->payment_req_given = 0 ;
  args_info->paymentinquiry_req_given = 0 ;
  args_info->bank_list_given = 0 ;
  args_info->bank_fipid_given = 0 ;
  args_info->bank_services_given = 0 ;
  args_info->allsupport_given = 0 ;

  args_info->command_group_counter = 0;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fipid",	1, NULL, 0 },
        { "fid",	1, NULL, 0 },
        { "org",	1, NULL, 0 },
        { "bank",	1, NULL, 0 },
        { "broker",	1, NULL, 0 },
        { "user",	1, NULL, 0 },
        { "pass",	1, NULL, 0 },
        { "acct",	1, NULL, 0 },
        { "type",	1, NULL, 0 },
        { "past",	1, NULL, 0 },
        { "url",	1, NULL, 0 },
        { "trid",	1, NULL, 0 },
        { "statement-req",	0, NULL, 's' },
        { "accountinfo-req",	0, NULL, 'a' },
        { "payment-req",	0, NULL, 'p' },
        { "paymentinquiry-req",	0, NULL, 'i' },
        { "bank-list",	0, NULL, 'b' },
        { "bank-fipid",	0, NULL, 'f' },
        { "bank-services",	0, NULL, 'v' },
        { "allsupport",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVsapibfv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 's':	/* Request for a statement.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->statement_req_given),
              &(local_args_info.statement_req_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "statement-req", 's',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Request for a list of accounts.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->accountinfo_req_given),
              &(local_args_info.accountinfo_req_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "accountinfo-req", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Request to make a payment.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->payment_req_given),
              &(local_args_info.payment_req_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "payment-req", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Request to inquire about the status of a payment.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->paymentinquiry_req_given),
              &(local_args_info.paymentinquiry_req_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "paymentinquiry-req", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* List all known banks.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->bank_list_given),
              &(local_args_info.bank_list_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "bank-list", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* List all fipids for a given bank.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->bank_fipid_given),
              &(local_args_info.bank_fipid_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "bank-fipid", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* List supported services for a given fipid.  */
        
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->bank_services_given),
              &(local_args_info.bank_services_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "bank-services", 'v',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* FI partner identifier (looks up fid, org & url from partner server).  */
          if (strcmp (long_options[option_index].name, "fipid") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->fipid_arg), 
                 &(args_info->fipid_orig), &(args_info->fipid_given),
                &(local_args_info.fipid_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "fipid", '-',
                additional_error))
              goto failure;
          
          }
          /* FI identifier.  */
          else if (strcmp (long_options[option_index].name, "fid") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->fid_arg), 
                 &(args_info->fid_orig), &(args_info->fid_given),
                &(local_args_info.fid_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "fid", '-',
                additional_error))
              goto failure;
          
          }
          /* FI org tag.  */
          else if (strcmp (long_options[option_index].name, "org") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->org_arg), 
                 &(args_info->org_orig), &(args_info->org_given),
                &(local_args_info.org_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "org", '-',
                additional_error))
              goto failure;
          
          }
          /* IBAN bank identifier.  */
          else if (strcmp (long_options[option_index].name, "bank") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->bank_arg), 
                 &(args_info->bank_orig), &(args_info->bank_given),
                &(local_args_info.bank_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "bank", '-',
                additional_error))
              goto failure;
          
          }
          /* Broker identifier.  */
          else if (strcmp (long_options[option_index].name, "broker") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->broker_arg), 
                 &(args_info->broker_orig), &(args_info->broker_given),
                &(local_args_info.broker_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "broker", '-',
                additional_error))
              goto failure;
          
          }
          /* User name.  */
          else if (strcmp (long_options[option_index].name, "user") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->user_arg), 
                 &(args_info->user_orig), &(args_info->user_given),
                &(local_args_info.user_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "user", '-',
                additional_error))
              goto failure;
          
          }
          /* Password.  */
          else if (strcmp (long_options[option_index].name, "pass") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pass_arg), 
                 &(args_info->pass_orig), &(args_info->pass_given),
                &(local_args_info.pass_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "pass", '-',
                additional_error))
              goto failure;
          
          }
          /* Account ID.  */
          else if (strcmp (long_options[option_index].name, "acct") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->acct_arg), 
                 &(args_info->acct_orig), &(args_info->acct_given),
                &(local_args_info.acct_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "acct", '-',
                additional_error))
              goto failure;
          
          }
          /* Account Type 1=checking 2=invest 3=ccard.  */
          else if (strcmp (long_options[option_index].name, "type") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->type_arg), 
                 &(args_info->type_orig), &(args_info->type_given),
                &(local_args_info.type_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "type", '-',
                additional_error))
              goto failure;
          
          }
          /* How far back to look from today (in days).  */
          else if (strcmp (long_options[option_index].name, "past") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->past_arg), 
                 &(args_info->past_orig), &(args_info->past_given),
                &(local_args_info.past_given), optarg, 0, 0, ARG_LONG,
                check_ambiguity, override, 0, 0,
                "past", '-',
                additional_error))
              goto failure;
          
          }
          /* Url to POST the data to (otherwise goes to stdout).  */
          else if (strcmp (long_options[option_index].name, "url") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->url_arg), 
                 &(args_info->url_orig), &(args_info->url_given),
                &(local_args_info.url_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "url", '-',
                additional_error))
              goto failure;
          
          }
          /* Transaction id.  */
          else if (strcmp (long_options[option_index].name, "trid") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->trid_arg), 
                 &(args_info->trid_orig), &(args_info->trid_given),
                &(local_args_info.trid_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "trid", '-',
                additional_error))
              goto failure;
          
          }
          /* List all banks which support online banking.  */
          else if (strcmp (long_options[option_index].name, "allsupport") == 0)
          {
          
            if (args_info->command_group_counter && override)
              reset_group_command (args_info);
            args_info->command_group_counter += 1;
          
            if (update_arg( 0 , 
                 0 , &(args_info->allsupport_given),
                &(local_args_info.allsupport_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "allsupport", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */

  if (args_info->command_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group command were given. At most one is required%s.\n", argv[0], args_info->command_group_counter, (additional_error ? additional_error : ""));
      error = 1;
    }
  



  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
