/* candidate-list.c generated by valac 0.38.8, the Vala compiler
 * generated from candidate-list.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define KKC_TYPE_CANDIDATE_LIST (kkc_candidate_list_get_type ())
#define KKC_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateList))
#define KKC_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))
#define KKC_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE_LIST))
#define KKC_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE_LIST))
#define KKC_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))

typedef struct _KkcCandidateList KkcCandidateList;
typedef struct _KkcCandidateListClass KkcCandidateListClass;
typedef struct _KkcCandidateListPrivate KkcCandidateListPrivate;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;
enum  {
	KKC_CANDIDATE_LIST_0_PROPERTY,
	KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY,
	KKC_CANDIDATE_LIST_SIZE_PROPERTY,
	KKC_CANDIDATE_LIST_PAGE_START_PROPERTY,
	KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY,
	KKC_CANDIDATE_LIST_ROUND_PROPERTY,
	KKC_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY,
	KKC_CANDIDATE_LIST_NUM_PROPERTIES
};
static GParamSpec* kkc_candidate_list_properties[KKC_CANDIDATE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	KKC_CANDIDATE_LIST_POPULATED_SIGNAL,
	KKC_CANDIDATE_LIST_SELECTED_SIGNAL,
	KKC_CANDIDATE_LIST_NUM_SIGNALS
};
static guint kkc_candidate_list_signals[KKC_CANDIDATE_LIST_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcCandidateList {
	GObject parent_instance;
	KkcCandidateListPrivate * priv;
};

struct _KkcCandidateListClass {
	GObjectClass parent_class;
	gboolean (*next) (KkcCandidateList* self);
	gboolean (*previous) (KkcCandidateList* self);
};

struct _KkcCandidateListPrivate {
	GeeArrayList* _candidates;
	gint _cursor_pos;
	GeeMap* seen;
	guint _page_start;
	guint _page_size;
	gboolean _round;
};


static gpointer kkc_candidate_list_parent_class = NULL;

GType kkc_candidate_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
#define KKC_CANDIDATE_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListPrivate))
KkcCandidate* kkc_candidate_list_get (KkcCandidateList* self, gint index);
gint kkc_candidate_list_get_size (KkcCandidateList* self);
void kkc_candidate_list_clear (KkcCandidateList* self);
gboolean kkc_candidate_list_contains (KkcCandidateList* self, KkcCandidate* candidate);
const gchar* kkc_candidate_get_output (KkcCandidate* self);
gboolean kkc_candidate_list_add (KkcCandidateList* self, KkcCandidate* candidate);
const gchar* kkc_candidate_get_annotation (KkcCandidate* self);
void kkc_candidate_set_annotation (KkcCandidate* self, const gchar* value);
gboolean kkc_candidate_list_add_all (KkcCandidateList* self, KkcCandidateList* other);
KkcCandidate** kkc_candidate_list_to_array (KkcCandidateList* self, int* result_length1);
static guint kkc_candidate_list_get_page_start_cursor_pos (KkcCandidateList* self, guint pos);
guint kkc_candidate_list_get_page_start (KkcCandidateList* self);
guint kkc_candidate_list_get_page_size (KkcCandidateList* self);
gboolean kkc_candidate_list_select_at (KkcCandidateList* self, guint index_in_page);
gint kkc_candidate_list_get_cursor_pos (KkcCandidateList* self);
void kkc_candidate_list_select (KkcCandidateList* self);
KkcCandidateList* kkc_candidate_list_new (guint page_start, guint page_size, gboolean round);
KkcCandidateList* kkc_candidate_list_construct (GType object_type, guint page_start, guint page_size, gboolean round);
void kkc_candidate_list_set_page_start (KkcCandidateList* self, guint value);
void kkc_candidate_list_set_page_size (KkcCandidateList* self, guint value);
void kkc_candidate_list_set_round (KkcCandidateList* self, gboolean value);
gboolean kkc_candidate_list_first (KkcCandidateList* self);
gboolean kkc_candidate_list_next (KkcCandidateList* self);
static gboolean kkc_candidate_list_real_next (KkcCandidateList* self);
gboolean kkc_candidate_list_cursor_down (KkcCandidateList* self);
gboolean kkc_candidate_list_page_down (KkcCandidateList* self);
gboolean kkc_candidate_list_previous (KkcCandidateList* self);
static gboolean kkc_candidate_list_real_previous (KkcCandidateList* self);
gboolean kkc_candidate_list_cursor_up (KkcCandidateList* self);
gboolean kkc_candidate_list_page_up (KkcCandidateList* self);
static gboolean kkc_candidate_list_update_cursor_pos (KkcCandidateList* self, guint pos);
static gboolean kkc_candidate_list_cursor_move (KkcCandidateList* self, gint step);
gboolean kkc_candidate_list_get_round (KkcCandidateList* self);
static gboolean kkc_candidate_list_page_move (KkcCandidateList* self, gint step);
void kkc_candidate_list_set_cursor_pos (KkcCandidateList* self, gint value);
gboolean kkc_candidate_list_get_page_visible (KkcCandidateList* self);
static void kkc_candidate_list_finalize (GObject * obj);
static void _vala_kkc_candidate_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_candidate_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * Get the current candidate at the given index.
         *
         * @param index candidate position (-1 for the current cursor position)
         *
         * @return a Candidate
         */
KkcCandidate* kkc_candidate_list_get (KkcCandidateList* self, gint index) {
	KkcCandidate* result = NULL;
	gint _tmp0_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = index;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->_cursor_pos;
		index = _tmp1_;
	}
	_tmp3_ = index;
	if (0 <= _tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = index;
		_tmp5_ = kkc_candidate_list_get_size (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "0 <= index && index < size");
	_tmp7_ = self->priv->_candidates;
	_tmp8_ = index;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
	result = (KkcCandidate*) _tmp9_;
	return result;
}


void kkc_candidate_list_clear (KkcCandidateList* self) {
	gboolean is_populated = FALSE;
	gboolean is_cursor_changed = FALSE;
	GeeMap* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	is_populated = FALSE;
	is_cursor_changed = FALSE;
	_tmp0_ = self->priv->seen;
	gee_map_clear (_tmp0_);
	_tmp1_ = self->priv->_candidates;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		_tmp4_ = self->priv->_candidates;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
		is_populated = TRUE;
	}
	_tmp5_ = self->priv->_cursor_pos;
	if (_tmp5_ >= 0) {
		self->priv->_cursor_pos = -1;
		is_cursor_changed = TRUE;
	}
	_tmp6_ = is_populated;
	if (_tmp6_) {
		g_signal_emit (self, kkc_candidate_list_signals[KKC_CANDIDATE_LIST_POPULATED_SIGNAL], 0);
	}
	_tmp7_ = is_cursor_changed;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "cursor-pos");
	}
}


gboolean kkc_candidate_list_contains (KkcCandidateList* self, KkcCandidate* candidate) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	KkcCandidate* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = self->priv->seen;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = candidate;
	_tmp5_ = kkc_candidate_get_output (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp3_);
	result = _tmp8_;
	return result;
}


gboolean kkc_candidate_list_add (KkcCandidateList* self, KkcCandidate* candidate) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	KkcCandidate* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = self->priv->seen;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = candidate;
	_tmp5_ = kkc_candidate_get_output (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp3_);
	if (_tmp8_) {
		KkcCandidate* c = NULL;
		GeeMap* _tmp9_;
		KkcCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_;
		gboolean _tmp14_ = FALSE;
		KkcCandidate* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp9_ = self->priv->seen;
		_tmp10_ = candidate;
		_tmp11_ = kkc_candidate_get_output (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_map_get (_tmp9_, _tmp12_);
		c = (KkcCandidate*) _tmp13_;
		_tmp15_ = c;
		_tmp16_ = kkc_candidate_get_annotation (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			KkcCandidate* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = candidate;
			_tmp19_ = kkc_candidate_get_annotation (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp14_ = _tmp20_ != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			KkcCandidate* _tmp21_;
			KkcCandidate* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp21_ = c;
			_tmp22_ = candidate;
			_tmp23_ = kkc_candidate_get_annotation (_tmp22_);
			_tmp24_ = _tmp23_;
			kkc_candidate_set_annotation (_tmp21_, _tmp24_);
		}
		result = FALSE;
		_g_object_unref0 (c);
		return result;
	} else {
		GeeArrayList* _tmp25_;
		KkcCandidate* _tmp26_;
		GeeMap* _tmp27_;
		KkcCandidate* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		KkcCandidate* _tmp31_;
		_tmp25_ = self->priv->_candidates;
		_tmp26_ = candidate;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
		_tmp27_ = self->priv->seen;
		_tmp28_ = candidate;
		_tmp29_ = kkc_candidate_get_output (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = candidate;
		gee_map_set (_tmp27_, _tmp30_, _tmp31_);
		result = TRUE;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean kkc_candidate_list_add_all (KkcCandidateList* self, KkcCandidateList* other) {
	gboolean result = FALSE;
	gboolean retval = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	retval = FALSE;
	{
		GeeArrayList* _c_list = NULL;
		KkcCandidateList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _c_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _c_index = 0;
		_tmp0_ = other;
		_tmp1_ = _tmp0_->priv->_candidates;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_c_list = _tmp2_;
		_tmp3_ = _c_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_c_size = _tmp5_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			KkcCandidate* c = NULL;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			KkcCandidate* _tmp12_;
			gboolean _tmp13_;
			_tmp6_ = _c_index;
			_c_index = _tmp6_ + 1;
			_tmp7_ = _c_index;
			_tmp8_ = _c_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _c_list;
			_tmp10_ = _c_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			c = (KkcCandidate*) _tmp11_;
			_tmp12_ = c;
			_tmp13_ = kkc_candidate_list_add (self, _tmp12_);
			if (_tmp13_) {
				retval = TRUE;
			}
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	result = retval;
	return result;
}


KkcCandidate** kkc_candidate_list_to_array (KkcCandidateList* self, int* result_length1) {
	KkcCandidate** result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer* _tmp2_;
	KkcCandidate** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_candidates;
	_tmp2_ = gee_collection_to_array ((GeeCollection*) _tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static guint kkc_candidate_list_get_page_start_cursor_pos (KkcCandidateList* self, guint pos) {
	guint result = 0U;
	guint page_index = 0U;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = pos;
	_tmp1_ = self->priv->_page_start;
	_tmp2_ = self->priv->_page_size;
	page_index = (_tmp0_ - _tmp1_) / _tmp2_;
	_tmp3_ = self->priv->_page_size;
	_tmp4_ = self->priv->_page_start;
	result = (page_index * _tmp3_) + _tmp4_;
	return result;
}


/**
         * Select a candidate in the current page.
         *
         * @param index_in_page cursor position in the page to select
         *
         * @return `true` if a candidate is selected, `false` otherwise
         */
gboolean kkc_candidate_list_select_at (KkcCandidateList* self, guint index_in_page) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint page_offset = 0U;
	gint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = index_in_page;
	_tmp1_ = self->priv->_page_size;
	_vala_assert (_tmp0_ < _tmp1_, "index_in_page < page_size");
	_tmp2_ = kkc_candidate_list_get_cursor_pos (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = kkc_candidate_list_get_page_start_cursor_pos (self, (guint) _tmp3_);
	page_offset = _tmp4_;
	_tmp5_ = page_offset;
	_tmp6_ = index_in_page;
	_tmp7_ = kkc_candidate_list_get_size (self);
	_tmp8_ = _tmp7_;
	if ((_tmp5_ + _tmp6_) < ((guint) _tmp8_)) {
		guint _tmp9_;
		guint _tmp10_;
		_tmp9_ = page_offset;
		_tmp10_ = index_in_page;
		self->priv->_cursor_pos = (gint) (_tmp9_ + _tmp10_);
		g_object_notify ((GObject*) self, "cursor-pos");
		kkc_candidate_list_select (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Select the current candidate.
         */
void kkc_candidate_list_select (KkcCandidateList* self) {
	KkcCandidate* candidate = NULL;
	KkcCandidate* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = kkc_candidate_list_get (self, -1);
	candidate = _tmp0_;
	g_signal_emit (self, kkc_candidate_list_signals[KKC_CANDIDATE_LIST_SELECTED_SIGNAL], 0, candidate);
	_g_object_unref0 (candidate);
}


/**
         * Create a new CandidateList.
         *
         * @param page_start starting index of pagination
         * @param page_size page size
         * @param round whether to loop over the candidate list
         *
         * @return a new CandidateList
         */
KkcCandidateList* kkc_candidate_list_construct (GType object_type, guint page_start, guint page_size, gboolean round) {
	KkcCandidateList * self = NULL;
	guint _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_;
	self = (KkcCandidateList*) g_object_new (object_type, NULL);
	_tmp0_ = page_start;
	kkc_candidate_list_set_page_start (self, _tmp0_);
	_tmp1_ = page_size;
	kkc_candidate_list_set_page_size (self, _tmp1_);
	_tmp2_ = round;
	kkc_candidate_list_set_round (self, _tmp2_);
	return self;
}


KkcCandidateList* kkc_candidate_list_new (guint page_start, guint page_size, gboolean round) {
	return kkc_candidate_list_construct (KKC_TYPE_CANDIDATE_LIST, page_start, page_size, round);
}


/**
         * Select the first candidate.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
gboolean kkc_candidate_list_first (KkcCandidateList* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_candidates;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		self->priv->_cursor_pos = 0;
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Move cursor forward.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean kkc_candidate_list_real_next (KkcCandidateList* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	_tmp0_ = kkc_candidate_list_get_cursor_pos (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_page_start;
	if (((guint) _tmp1_) < _tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = kkc_candidate_list_cursor_down (self);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = kkc_candidate_list_page_down (self);
		result = _tmp4_;
		return result;
	}
}


gboolean kkc_candidate_list_next (KkcCandidateList* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_CANDIDATE_LIST_GET_CLASS (self)->next (self);
}


/**
         * Move cursor backward.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
static gboolean kkc_candidate_list_real_previous (KkcCandidateList* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	_tmp0_ = kkc_candidate_list_get_cursor_pos (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_page_start;
	if (((guint) _tmp1_) <= _tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = kkc_candidate_list_cursor_up (self);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = kkc_candidate_list_page_up (self);
		result = _tmp4_;
		return result;
	}
}


gboolean kkc_candidate_list_previous (KkcCandidateList* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_CANDIDATE_LIST_GET_CLASS (self)->previous (self);
}


static gboolean kkc_candidate_list_update_cursor_pos (KkcCandidateList* self, guint pos) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = pos;
	if (((guint) 0) <= _tmp2_) {
		guint _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = pos;
		_tmp4_ = self->priv->_candidates;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_ < ((guint) _tmp6_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		guint _tmp7_;
		gint _tmp8_;
		_tmp7_ = pos;
		_tmp8_ = self->priv->_cursor_pos;
		_tmp0_ = _tmp7_ != ((guint) _tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp9_;
		_tmp9_ = pos;
		self->priv->_cursor_pos = (gint) _tmp9_;
		g_object_notify ((GObject*) self, "cursor-pos");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_candidate_list_cursor_move (KkcCandidateList* self, gint step) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint start = 0;
	gint _tmp5_;
	guint _tmp6_;
	gint total = 0;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	guint _tmp10_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_candidates;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = step;
		_tmp0_ = _tmp4_ == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_cursor_pos;
	_tmp6_ = self->priv->_page_start;
	start = _tmp5_ - ((gint) _tmp6_);
	_tmp7_ = self->priv->_candidates;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_page_start;
	total = ((gint) _tmp9_) - ((gint) _tmp10_);
	_tmp11_ = self->priv->_round;
	if (_tmp11_) {
		gint pos = 0;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp18_;
		guint _tmp19_;
		gboolean _tmp20_;
		_tmp12_ = start;
		_tmp13_ = step;
		_tmp14_ = total;
		pos = (_tmp12_ + _tmp13_) % _tmp14_;
		_tmp15_ = pos;
		if (_tmp15_ < 0) {
			gint _tmp16_;
			gint _tmp17_;
			_tmp16_ = pos;
			_tmp17_ = total;
			pos = _tmp16_ + _tmp17_;
		}
		_tmp18_ = pos;
		_tmp19_ = self->priv->_page_start;
		_tmp20_ = kkc_candidate_list_update_cursor_pos (self, _tmp18_ + _tmp19_);
		if (_tmp20_) {
			result = TRUE;
			return result;
		}
	} else {
		gint pos = 0;
		gint _tmp21_;
		gint _tmp22_;
		gboolean _tmp23_ = FALSE;
		gint _tmp24_;
		_tmp21_ = start;
		_tmp22_ = step;
		pos = _tmp21_ + _tmp22_;
		_tmp24_ = pos;
		if (0 <= _tmp24_) {
			gint _tmp25_;
			gint _tmp26_;
			_tmp25_ = pos;
			_tmp26_ = total;
			_tmp23_ = _tmp25_ < _tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gint _tmp27_;
			guint _tmp28_;
			gboolean _tmp29_;
			_tmp27_ = pos;
			_tmp28_ = self->priv->_page_start;
			_tmp29_ = kkc_candidate_list_update_cursor_pos (self, _tmp27_ + _tmp28_);
			if (_tmp29_) {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


/**
         * Move cursor to the previous candidate.
         *
         * @return `true` if cursor position has changed, `false` otherwise.
         */
gboolean kkc_candidate_list_cursor_up (KkcCandidateList* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_cursor_pos;
	_tmp1_ = self->priv->_page_start;
	if (((guint) _tmp0_) >= _tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = kkc_candidate_list_cursor_move (self, -1);
		result = _tmp2_;
		return result;
	} else {
		gint _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->_cursor_pos;
		_tmp4_ = kkc_candidate_list_update_cursor_pos (self, (guint) (_tmp3_ - 1));
		if (_tmp4_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


/**
         * Move cursor to the next candidate.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
gboolean kkc_candidate_list_cursor_down (KkcCandidateList* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_cursor_pos;
	_tmp1_ = self->priv->_page_start;
	if (((guint) _tmp0_) >= _tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = kkc_candidate_list_cursor_move (self, 1);
		result = _tmp2_;
		return result;
	} else {
		gint _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->_cursor_pos;
		_tmp4_ = kkc_candidate_list_update_cursor_pos (self, (guint) (_tmp3_ + 1));
		if (_tmp4_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean kkc_candidate_list_page_move (KkcCandidateList* self, gint step) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint start = 0;
	gint _tmp5_;
	guint _tmp6_;
	gint total = 0;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	guint _tmp10_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_candidates;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = step;
		_tmp0_ = _tmp4_ == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_cursor_pos;
	_tmp6_ = self->priv->_page_start;
	start = _tmp5_ - ((gint) _tmp6_);
	_tmp7_ = self->priv->_candidates;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_page_start;
	total = ((gint) _tmp9_) - ((gint) _tmp10_);
	_tmp11_ = self->priv->_round;
	if (_tmp11_) {
		gint pos = 0;
		gint _tmp12_;
		guint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp19_;
		guint _tmp20_;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp12_ = start;
		_tmp13_ = self->priv->_page_size;
		_tmp14_ = step;
		_tmp15_ = total;
		pos = (_tmp12_ + (((gint) _tmp13_) * _tmp14_)) % _tmp15_;
		_tmp16_ = pos;
		if (_tmp16_ < 0) {
			gint _tmp17_;
			gint _tmp18_;
			_tmp17_ = pos;
			_tmp18_ = total;
			pos = _tmp17_ + _tmp18_;
		}
		_tmp19_ = pos;
		_tmp20_ = self->priv->_page_start;
		_tmp21_ = self->priv->_candidates;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		if ((_tmp19_ + ((gint) _tmp20_)) < _tmp23_) {
			guint new_pos = 0U;
			gint _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			guint _tmp27_;
			gboolean _tmp28_;
			_tmp24_ = pos;
			_tmp25_ = self->priv->_page_start;
			_tmp26_ = kkc_candidate_list_get_page_start_cursor_pos (self, _tmp24_ + _tmp25_);
			new_pos = _tmp26_;
			_tmp27_ = new_pos;
			_tmp28_ = kkc_candidate_list_update_cursor_pos (self, _tmp27_);
			if (_tmp28_) {
				result = TRUE;
				return result;
			}
		}
	} else {
		gint pos = 0;
		gint _tmp29_;
		guint _tmp30_;
		gint _tmp31_;
		gboolean _tmp32_ = FALSE;
		gint _tmp33_;
		_tmp29_ = start;
		_tmp30_ = self->priv->_page_size;
		_tmp31_ = step;
		pos = _tmp29_ + (((gint) _tmp30_) * _tmp31_);
		_tmp33_ = pos;
		if (0 <= _tmp33_) {
			gint _tmp34_;
			gint _tmp35_;
			_tmp34_ = pos;
			_tmp35_ = total;
			_tmp32_ = _tmp34_ < _tmp35_;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			guint new_pos = 0U;
			gint _tmp36_;
			guint _tmp37_;
			guint _tmp38_;
			guint _tmp39_;
			gboolean _tmp40_;
			_tmp36_ = pos;
			_tmp37_ = self->priv->_page_start;
			_tmp38_ = kkc_candidate_list_get_page_start_cursor_pos (self, _tmp36_ + _tmp37_);
			new_pos = _tmp38_;
			_tmp39_ = new_pos;
			_tmp40_ = kkc_candidate_list_update_cursor_pos (self, _tmp39_);
			if (_tmp40_) {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


/**
         * Move cursor to the previous page.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
gboolean kkc_candidate_list_page_up (KkcCandidateList* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = kkc_candidate_list_page_move (self, -1);
	result = _tmp0_;
	return result;
}


/**
         * Move cursor to the next page.
         *
         * @return `true` if cursor position has changed, `false` otherwise
         */
gboolean kkc_candidate_list_page_down (KkcCandidateList* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = kkc_candidate_list_page_move (self, 1);
	result = _tmp0_;
	return result;
}


gint kkc_candidate_list_get_cursor_pos (KkcCandidateList* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cursor_pos;
	result = _tmp0_;
	return result;
}


void kkc_candidate_list_set_cursor_pos (KkcCandidateList* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cursor_pos = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY]);
}


gint kkc_candidate_list_get_size (KkcCandidateList* self) {
	gint result;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_candidates;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


guint kkc_candidate_list_get_page_start (KkcCandidateList* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_page_start;
	result = _tmp0_;
	return result;
}


void kkc_candidate_list_set_page_start (KkcCandidateList* self, guint value) {
	g_return_if_fail (self != NULL);
	if (kkc_candidate_list_get_page_start (self) != value) {
		guint _tmp0_;
		_tmp0_ = value;
		self->priv->_page_start = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_PAGE_START_PROPERTY]);
	}
}


guint kkc_candidate_list_get_page_size (KkcCandidateList* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_page_size;
	result = _tmp0_;
	return result;
}


void kkc_candidate_list_set_page_size (KkcCandidateList* self, guint value) {
	g_return_if_fail (self != NULL);
	if (kkc_candidate_list_get_page_size (self) != value) {
		guint _tmp0_;
		_tmp0_ = value;
		self->priv->_page_size = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY]);
	}
}


gboolean kkc_candidate_list_get_round (KkcCandidateList* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void kkc_candidate_list_set_round (KkcCandidateList* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (kkc_candidate_list_get_round (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_round = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_ROUND_PROPERTY]);
	}
}


gboolean kkc_candidate_list_get_page_visible (KkcCandidateList* self) {
	gboolean result;
	gint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_cursor_pos;
	_tmp1_ = self->priv->_page_start;
	result = _tmp0_ >= ((gint) _tmp1_);
	return result;
}


static void kkc_candidate_list_class_init (KkcCandidateListClass * klass) {
	kkc_candidate_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcCandidateListPrivate));
	((KkcCandidateListClass *) klass)->next = (gboolean (*) (KkcCandidateList *)) kkc_candidate_list_real_next;
	((KkcCandidateListClass *) klass)->previous = (gboolean (*) (KkcCandidateList *)) kkc_candidate_list_real_previous;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_candidate_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_candidate_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_candidate_list_finalize;
	/**
	         * Current cursor position.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY] = g_param_spec_int ("cursor-pos", "cursor-pos", "cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The number of candidate in the candidate list.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_SIZE_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Starting index of paging.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_PAGE_START_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_PAGE_START_PROPERTY] = g_param_spec_uint ("page-start", "page-start", "page-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Page size.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY] = g_param_spec_uint ("page-size", "page-size", "page-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Flag to indicate whether to loop over the candidates.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_ROUND_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_ROUND_PROPERTY] = g_param_spec_boolean ("round", "round", "round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Flag to indicate whether page (lookup table) is visible.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY, kkc_candidate_list_properties[KKC_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY] = g_param_spec_boolean ("page-visible", "page-visible", "page-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Signal emitted when candidates are filled and ready for traversal.
	         */
	kkc_candidate_list_signals[KKC_CANDIDATE_LIST_POPULATED_SIGNAL] = g_signal_new ("populated", KKC_TYPE_CANDIDATE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Signal emitted when a candidate is selected.
	         *
	         * @param candidate selected candidate
	         */
	kkc_candidate_list_signals[KKC_CANDIDATE_LIST_SELECTED_SIGNAL] = g_signal_new ("selected", KKC_TYPE_CANDIDATE_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, KKC_TYPE_CANDIDATE);
}


static void kkc_candidate_list_instance_init (KkcCandidateList * self) {
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = KKC_CANDIDATE_LIST_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_candidates = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->seen = (GeeMap*) _tmp1_;
}


static void kkc_candidate_list_finalize (GObject * obj) {
	KkcCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_CANDIDATE_LIST, KkcCandidateList);
	_g_object_unref0 (self->priv->_candidates);
	_g_object_unref0 (self->priv->seen);
	G_OBJECT_CLASS (kkc_candidate_list_parent_class)->finalize (obj);
}


/**
     * Object representing a candidate list.
     */
GType kkc_candidate_list_get_type (void) {
	static volatile gsize kkc_candidate_list_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_candidate_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcCandidateListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_candidate_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcCandidateList), 0, (GInstanceInitFunc) kkc_candidate_list_instance_init, NULL };
		GType kkc_candidate_list_type_id;
		kkc_candidate_list_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcCandidateList", &g_define_type_info, 0);
		g_once_init_leave (&kkc_candidate_list_type_id__volatile, kkc_candidate_list_type_id);
	}
	return kkc_candidate_list_type_id__volatile;
}


static void _vala_kkc_candidate_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CANDIDATE_LIST, KkcCandidateList);
	switch (property_id) {
		case KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY:
		g_value_set_int (value, kkc_candidate_list_get_cursor_pos (self));
		break;
		case KKC_CANDIDATE_LIST_SIZE_PROPERTY:
		g_value_set_int (value, kkc_candidate_list_get_size (self));
		break;
		case KKC_CANDIDATE_LIST_PAGE_START_PROPERTY:
		g_value_set_uint (value, kkc_candidate_list_get_page_start (self));
		break;
		case KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		g_value_set_uint (value, kkc_candidate_list_get_page_size (self));
		break;
		case KKC_CANDIDATE_LIST_ROUND_PROPERTY:
		g_value_set_boolean (value, kkc_candidate_list_get_round (self));
		break;
		case KKC_CANDIDATE_LIST_PAGE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, kkc_candidate_list_get_page_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_candidate_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcCandidateList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CANDIDATE_LIST, KkcCandidateList);
	switch (property_id) {
		case KKC_CANDIDATE_LIST_CURSOR_POS_PROPERTY:
		kkc_candidate_list_set_cursor_pos (self, g_value_get_int (value));
		break;
		case KKC_CANDIDATE_LIST_PAGE_START_PROPERTY:
		kkc_candidate_list_set_page_start (self, g_value_get_uint (value));
		break;
		case KKC_CANDIDATE_LIST_PAGE_SIZE_PROPERTY:
		kkc_candidate_list_set_page_size (self, g_value_get_uint (value));
		break;
		case KKC_CANDIDATE_LIST_ROUND_PROPERTY:
		kkc_candidate_list_set_round (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



