; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse,-sse2 -global-isel | FileCheck %s --check-prefixes=CHECK-32,GISEL_X86
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse,-sse2 | FileCheck %s --check-prefixes=CHECK-32,SDAG_X86
; RUN: llc < %s -mtriple=i686-- -mattr=+x87,-sse,-sse2 -fast-isel=true | FileCheck %s --check-prefixes=CHECK-32,SDAG_X86,FAST_X86
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse,-sse2 -global-isel | FileCheck %s --check-prefixes=CHECK-64,GISEL_X64
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse,-sse2 | FileCheck %s --check-prefixes=CHECK-64,SDAG_X64
; RUN: llc < %s -mtriple=x86_64-- -mattr=+x87,-sse,-sse2 -fast-isel=true | FileCheck %s --check-prefixes=CHECK-64,SDAG_X64,FAST_X64

define x86_fp80 @f0(x86_fp80 noundef %a) nounwind {
; GISEL_X86-LABEL: f0:
; GISEL_X86:       # %bb.0:
; GISEL_X86-NEXT:    pushl %ebp
; GISEL_X86-NEXT:    movl %esp, %ebp
; GISEL_X86-NEXT:    andl $-16, %esp
; GISEL_X86-NEXT:    subl $48, %esp
; GISEL_X86-NEXT:    fldt 8(%ebp)
; GISEL_X86-NEXT:    fldt {{\.?LCPI[0-9]+_[0-9]+}}
; GISEL_X86-NEXT:    fxch %st(1)
; GISEL_X86-NEXT:    fstpt {{[0-9]+}}(%esp)
; GISEL_X86-NEXT:    fstpt (%esp)
; GISEL_X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL_X86-NEXT:    fldt (%esp)
; GISEL_X86-NEXT:    faddp %st, %st(1)
; GISEL_X86-NEXT:    movl %ebp, %esp
; GISEL_X86-NEXT:    popl %ebp
; GISEL_X86-NEXT:    retl
;
; SDAG_X86-LABEL: f0:
; SDAG_X86:       # %bb.0:
; SDAG_X86-NEXT:    pushl %ebp
; SDAG_X86-NEXT:    movl %esp, %ebp
; SDAG_X86-NEXT:    andl $-16, %esp
; SDAG_X86-NEXT:    subl $48, %esp
; SDAG_X86-NEXT:    fldt 8(%ebp)
; SDAG_X86-NEXT:    fld %st(0)
; SDAG_X86-NEXT:    fstpt {{[0-9]+}}(%esp)
; SDAG_X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SDAG_X86-NEXT:    fld %st(0)
; SDAG_X86-NEXT:    fstpt (%esp)
; SDAG_X86-NEXT:    faddp %st, %st(1)
; SDAG_X86-NEXT:    movl %ebp, %esp
; SDAG_X86-NEXT:    popl %ebp
; SDAG_X86-NEXT:    retl
;
; GISEL_X64-LABEL: f0:
; GISEL_X64:       # %bb.0:
; GISEL_X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL_X64-NEXT:    fldt {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; GISEL_X64-NEXT:    fxch %st(1)
; GISEL_X64-NEXT:    fstpt -{{[0-9]+}}(%rsp)
; GISEL_X64-NEXT:    fstpt -{{[0-9]+}}(%rsp)
; GISEL_X64-NEXT:    fldt -{{[0-9]+}}(%rsp)
; GISEL_X64-NEXT:    fldt -{{[0-9]+}}(%rsp)
; GISEL_X64-NEXT:    faddp %st, %st(1)
; GISEL_X64-NEXT:    retq
;
; SDAG_X64-LABEL: f0:
; SDAG_X64:       # %bb.0:
; SDAG_X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG_X64-NEXT:    fld %st(0)
; SDAG_X64-NEXT:    fstpt -{{[0-9]+}}(%rsp)
; SDAG_X64-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; SDAG_X64-NEXT:    fld %st(0)
; SDAG_X64-NEXT:    fstpt -{{[0-9]+}}(%rsp)
; SDAG_X64-NEXT:    faddp %st, %st(1)
; SDAG_X64-NEXT:    retq
  %a.addr = alloca x86_fp80, align 16
  %x = alloca x86_fp80, align 16
  store x86_fp80 %a, ptr %a.addr, align 16
  store x86_fp80 0xK400A8000000000000000, ptr %x, align 16
  %load1 = load x86_fp80, ptr %a.addr, align 16
  %load2 = load x86_fp80, ptr %x, align 16
  %add = fadd x86_fp80 %load1, %load2
  ret x86_fp80 %add
}


define void @f1(ptr %a, ptr %b) nounwind {
; GISEL_X86-LABEL: f1:
; GISEL_X86:       # %bb.0:
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL_X86-NEXT:    fldt (%eax)
; GISEL_X86-NEXT:    fldt (%ecx)
; GISEL_X86-NEXT:    fsubrp %st, %st(1)
; GISEL_X86-NEXT:    fstpt (%eax)
; GISEL_X86-NEXT:    retl
;
; SDAG_X86-LABEL: f1:
; SDAG_X86:       # %bb.0:
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG_X86-NEXT:    fldt (%ecx)
; SDAG_X86-NEXT:    fldt (%eax)
; SDAG_X86-NEXT:    fsubrp %st, %st(1)
; SDAG_X86-NEXT:    fstpt (%ecx)
; SDAG_X86-NEXT:    retl
;
; CHECK-64-LABEL: f1:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    fldt (%rdi)
; CHECK-64-NEXT:    fldt (%rsi)
; CHECK-64-NEXT:    fsubrp %st, %st(1)
; CHECK-64-NEXT:    fstpt (%rdi)
; CHECK-64-NEXT:    retq
  %load1 = load x86_fp80, ptr %a, align 4
  %load2 = load x86_fp80, ptr %b, align 4
  %sub = fsub x86_fp80 %load1, %load2
  store x86_fp80 %sub, ptr %a, align 4
  ret void
}

define void @f2(ptr %a, ptr %b) nounwind {
; GISEL_X86-LABEL: f2:
; GISEL_X86:       # %bb.0:
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL_X86-NEXT:    fldt (%eax)
; GISEL_X86-NEXT:    fldt (%ecx)
; GISEL_X86-NEXT:    fmulp %st, %st(1)
; GISEL_X86-NEXT:    fstpt (%eax)
; GISEL_X86-NEXT:    retl
;
; SDAG_X86-LABEL: f2:
; SDAG_X86:       # %bb.0:
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG_X86-NEXT:    fldt (%ecx)
; SDAG_X86-NEXT:    fldt (%eax)
; SDAG_X86-NEXT:    fmulp %st, %st(1)
; SDAG_X86-NEXT:    fstpt (%ecx)
; SDAG_X86-NEXT:    retl
;
; CHECK-64-LABEL: f2:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    fldt (%rdi)
; CHECK-64-NEXT:    fldt (%rsi)
; CHECK-64-NEXT:    fmulp %st, %st(1)
; CHECK-64-NEXT:    fstpt (%rdi)
; CHECK-64-NEXT:    retq
  %load1 = load x86_fp80, ptr %a, align 16
  %load2 = load x86_fp80, ptr %b, align 16
  %mul = fmul x86_fp80 %load1, %load2
  store x86_fp80 %mul, ptr %a, align 16
  ret void
}

define void @f3(ptr %a, ptr %b) nounwind {
; GISEL_X86-LABEL: f3:
; GISEL_X86:       # %bb.0:
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL_X86-NEXT:    fldt (%eax)
; GISEL_X86-NEXT:    fldt (%ecx)
; GISEL_X86-NEXT:    fdivrp %st, %st(1)
; GISEL_X86-NEXT:    fstpt (%eax)
; GISEL_X86-NEXT:    retl
;
; SDAG_X86-LABEL: f3:
; SDAG_X86:       # %bb.0:
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG_X86-NEXT:    fldt (%ecx)
; SDAG_X86-NEXT:    fldt (%eax)
; SDAG_X86-NEXT:    fdivrp %st, %st(1)
; SDAG_X86-NEXT:    fstpt (%ecx)
; SDAG_X86-NEXT:    retl
;
; CHECK-64-LABEL: f3:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    fldt (%rdi)
; CHECK-64-NEXT:    fldt (%rsi)
; CHECK-64-NEXT:    fdivrp %st, %st(1)
; CHECK-64-NEXT:    fstpt (%rdi)
; CHECK-64-NEXT:    retq
  %load1 = load x86_fp80, ptr %a, align 4
  %load2 = load x86_fp80, ptr %b, align 4
  %div = fdiv x86_fp80 %load1, %load2
  store x86_fp80 %div, ptr %a, align 4
  ret void
}

define void @f6(ptr %a, ptr %b) nounwind {
; GISEL_X86-LABEL: f6:
; GISEL_X86:       # %bb.0:
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL_X86-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; GISEL_X86-NEXT:    fadds (%eax)
; GISEL_X86-NEXT:    fstps (%ecx)
; GISEL_X86-NEXT:    retl
;
; SDAG_X86-LABEL: f6:
; SDAG_X86:       # %bb.0:
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG_X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG_X86-NEXT:    flds (%ecx)
; SDAG_X86-NEXT:    fadds {{\.?LCPI[0-9]+_[0-9]+}}
; SDAG_X86-NEXT:    fstps (%eax)
; SDAG_X86-NEXT:    retl
;
; GISEL_X64-LABEL: f6:
; GISEL_X64:       # %bb.0:
; GISEL_X64-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; GISEL_X64-NEXT:    fadds (%rdi)
; GISEL_X64-NEXT:    fstps (%rsi)
; GISEL_X64-NEXT:    retq
;
; SDAG_X64-LABEL: f6:
; SDAG_X64:       # %bb.0:
; SDAG_X64-NEXT:    flds (%rdi)
; SDAG_X64-NEXT:    fadds {{\.?LCPI[0-9]+_[0-9]+}}(%rip)
; SDAG_X64-NEXT:    fstps (%rsi)
; SDAG_X64-NEXT:    retq
  %load1 = load float, ptr %a
  %add = fadd float %load1, 20.0
  store float %add, ptr %b
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-32: {{.*}}
; FAST_X64: {{.*}}
; FAST_X86: {{.*}}
