; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mips < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32
; RUN: llc -mtriple=mips -mcpu mips32r2 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32R2
; RUN: llc -mtriple=mips64 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64
; RUN: llc -mtriple=mips64 -mcpu mips64r2 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64R2

define float @fmuladd_intrinsic_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    .cfi_offset 16, -8
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $16, $6
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    move $5, $16
; SOFT-FLOAT-32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 16, -8
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $16, $6
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $16
; SOFT-FLOAT-32R2-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $5, 0
; SOFT-FLOAT-64-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64R2-NEXT:    move $16, $6
; SOFT-FLOAT-64R2-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $5, 0
; SOFT-FLOAT-64R2-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 16
  %result = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  ret float %result
}

define double @fmuladd_intrinsic_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $6, 40($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 44($sp)
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    nop
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $6, 40($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 44($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    move $5, $16
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $16, $6
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $16
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 16
  %result = call double @llvm.fmuladd.f64(double %a, double %b, double %c)
  ret double %result
}

define float @fmuladd_contract_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    .cfi_offset 16, -8
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $16, $6
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    move $5, $16
; SOFT-FLOAT-32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 16, -8
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $16, $6
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $16
; SOFT-FLOAT-32R2-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $5, 0
; SOFT-FLOAT-64-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64R2-NEXT:    move $16, $6
; SOFT-FLOAT-64R2-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $5, 0
; SOFT-FLOAT-64R2-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 16
  %product = fmul contract float %a, %b
  %result = fadd contract float %product, %c
  ret float %result
}

define double @fmuladd_contract_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $6, 40($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 44($sp)
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    nop
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $6, 40($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 44($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    move $5, $16
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -16
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $16, $6
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $16
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 16
  %product = fmul contract double %a, %b
  %result = fadd contract double %product, %c
  ret double %result
}

define <4 x float> @fmuladd_contract_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -48
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-32-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $21, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $20, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    .cfi_offset 21, -8
; SOFT-FLOAT-32-NEXT:    .cfi_offset 20, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset 19, -16
; SOFT-FLOAT-32-NEXT:    .cfi_offset 18, -20
; SOFT-FLOAT-32-NEXT:    .cfi_offset 17, -24
; SOFT-FLOAT-32-NEXT:    .cfi_offset 16, -28
; SOFT-FLOAT-32-NEXT:    move $17, $7
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    lw $4, 64($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 80($sp)
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $18, $6
; SOFT-FLOAT-32-NEXT:    lw $5, 96($sp)
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $4, 68($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 84($sp)
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $19, $2
; SOFT-FLOAT-32-NEXT:    lw $5, 100($sp)
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    move $20, $2
; SOFT-FLOAT-32-NEXT:    lw $5, 76($sp)
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $4, $17
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $17, 88($sp)
; SOFT-FLOAT-32-NEXT:    lw $21, 72($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 92($sp)
; SOFT-FLOAT-32-NEXT:    sw $20, 12($16)
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    sw $19, 8($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 4($16)
; SOFT-FLOAT-32-NEXT:    move $4, $18
; SOFT-FLOAT-32-NEXT:    jal __mulsf3
; SOFT-FLOAT-32-NEXT:    move $5, $21
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    jal __addsf3
; SOFT-FLOAT-32-NEXT:    move $5, $17
; SOFT-FLOAT-32-NEXT:    sw $2, 0($16)
; SOFT-FLOAT-32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $20, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $21, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -48
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $21, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $20, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 21, -8
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 20, -12
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 19, -16
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 18, -20
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 17, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 16, -28
; SOFT-FLOAT-32R2-NEXT:    move $17, $7
; SOFT-FLOAT-32R2-NEXT:    move $16, $4
; SOFT-FLOAT-32R2-NEXT:    lw $4, 64($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 80($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $18, $6
; SOFT-FLOAT-32R2-NEXT:    lw $5, 96($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $4, 68($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 84($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $19, $2
; SOFT-FLOAT-32R2-NEXT:    lw $5, 100($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    move $20, $2
; SOFT-FLOAT-32R2-NEXT:    lw $5, 76($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $4, $17
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $17, 88($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $21, 72($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 92($sp)
; SOFT-FLOAT-32R2-NEXT:    sw $20, 12($16)
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    sw $19, 8($16)
; SOFT-FLOAT-32R2-NEXT:    sw $2, 4($16)
; SOFT-FLOAT-32R2-NEXT:    move $4, $18
; SOFT-FLOAT-32R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $21
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    jal __addsf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $17
; SOFT-FLOAT-32R2-NEXT:    sw $2, 0($16)
; SOFT-FLOAT-32R2-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $20, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $21, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -64
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-NEXT:    sd $ra, 56($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $22, 48($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $21, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $20, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $19, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-64-NEXT:    .cfi_offset 21, -24
; SOFT-FLOAT-64-NEXT:    .cfi_offset 20, -32
; SOFT-FLOAT-64-NEXT:    .cfi_offset 19, -40
; SOFT-FLOAT-64-NEXT:    .cfi_offset 18, -48
; SOFT-FLOAT-64-NEXT:    .cfi_offset 17, -56
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -64
; SOFT-FLOAT-64-NEXT:    move $16, $9
; SOFT-FLOAT-64-NEXT:    move $17, $8
; SOFT-FLOAT-64-NEXT:    move $18, $7
; SOFT-FLOAT-64-NEXT:    move $19, $6
; SOFT-FLOAT-64-NEXT:    move $20, $5
; SOFT-FLOAT-64-NEXT:    move $21, $4
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $6, 0
; SOFT-FLOAT-64-NEXT:    move $22, $2
; SOFT-FLOAT-64-NEXT:    dsra $4, $21, 32
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    dsra $5, $19, 32
; SOFT-FLOAT-64-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    dsra $5, $17, 32
; SOFT-FLOAT-64-NEXT:    # kill: def $v0 killed $v0 def $v0_64
; SOFT-FLOAT-64-NEXT:    sll $4, $22, 0
; SOFT-FLOAT-64-NEXT:    sll $5, $17, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    dsll $17, $2, 32
; SOFT-FLOAT-64-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64-NEXT:    dsrl $1, $1, 32
; SOFT-FLOAT-64-NEXT:    sll $4, $20, 0
; SOFT-FLOAT-64-NEXT:    sll $5, $18, 0
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    or $17, $1, $17
; SOFT-FLOAT-64-NEXT:    move $19, $2
; SOFT-FLOAT-64-NEXT:    dsra $4, $20, 32
; SOFT-FLOAT-64-NEXT:    jal __mulsf3
; SOFT-FLOAT-64-NEXT:    dsra $5, $18, 32
; SOFT-FLOAT-64-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    dsra $5, $16, 32
; SOFT-FLOAT-64-NEXT:    # kill: def $v0 killed $v0 def $v0_64
; SOFT-FLOAT-64-NEXT:    dsll $18, $2, 32
; SOFT-FLOAT-64-NEXT:    sll $4, $19, 0
; SOFT-FLOAT-64-NEXT:    jal __addsf3
; SOFT-FLOAT-64-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64-NEXT:    dsrl $1, $1, 32
; SOFT-FLOAT-64-NEXT:    or $3, $1, $18
; SOFT-FLOAT-64-NEXT:    move $2, $17
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $19, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $20, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $21, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $22, 48($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 56($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 64
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -64
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 56($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $22, 48($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $21, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $20, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $19, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 21, -24
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 20, -32
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 19, -40
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 18, -48
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 17, -56
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -64
; SOFT-FLOAT-64R2-NEXT:    move $16, $9
; SOFT-FLOAT-64R2-NEXT:    move $17, $8
; SOFT-FLOAT-64R2-NEXT:    move $18, $7
; SOFT-FLOAT-64R2-NEXT:    move $19, $6
; SOFT-FLOAT-64R2-NEXT:    move $20, $5
; SOFT-FLOAT-64R2-NEXT:    move $21, $4
; SOFT-FLOAT-64R2-NEXT:    dsra $4, $4, 32
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    dsra $5, $6, 32
; SOFT-FLOAT-64R2-NEXT:    move $22, $2
; SOFT-FLOAT-64R2-NEXT:    sll $4, $21, 0
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $19, 0
; SOFT-FLOAT-64R2-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $17, 0
; SOFT-FLOAT-64R2-NEXT:    sll $4, $22, 0
; SOFT-FLOAT-64R2-NEXT:    dsra $5, $17, 32
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    dext $17, $2, 0, 32
; SOFT-FLOAT-64R2-NEXT:    # kill: def $v0 killed $v0 def $v0_64
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64R2-NEXT:    dsra $4, $20, 32
; SOFT-FLOAT-64R2-NEXT:    dsra $5, $18, 32
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    or $17, $17, $1
; SOFT-FLOAT-64R2-NEXT:    move $19, $2
; SOFT-FLOAT-64R2-NEXT:    sll $4, $20, 0
; SOFT-FLOAT-64R2-NEXT:    jal __mulsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $18, 0
; SOFT-FLOAT-64R2-NEXT:    sll $4, $2, 0
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    sll $5, $16, 0
; SOFT-FLOAT-64R2-NEXT:    dext $18, $2, 0, 32
; SOFT-FLOAT-64R2-NEXT:    sll $4, $19, 0
; SOFT-FLOAT-64R2-NEXT:    jal __addsf3
; SOFT-FLOAT-64R2-NEXT:    dsra $5, $16, 32
; SOFT-FLOAT-64R2-NEXT:    # kill: def $v0 killed $v0 def $v0_64
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64R2-NEXT:    or $3, $18, $1
; SOFT-FLOAT-64R2-NEXT:    move $2, $17
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $19, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $20, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $21, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $22, 48($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 56($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 64
  %product = fmul contract <4 x float> %a, %b
  %result = fadd contract <4 x float> %product, %c
  ret <4 x float> %result
}

define <4 x double> @fmuladd_contract_v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -64
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-32-NEXT:    sw $ra, 60($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $fp, 56($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $23, 52($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $22, 48($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $21, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $20, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $19, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32-NEXT:    .cfi_offset 30, -8
; SOFT-FLOAT-32-NEXT:    .cfi_offset 23, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-32-NEXT:    .cfi_offset 21, -20
; SOFT-FLOAT-32-NEXT:    .cfi_offset 20, -24
; SOFT-FLOAT-32-NEXT:    .cfi_offset 19, -28
; SOFT-FLOAT-32-NEXT:    .cfi_offset 18, -32
; SOFT-FLOAT-32-NEXT:    .cfi_offset 17, -36
; SOFT-FLOAT-32-NEXT:    .cfi_offset 16, -40
; SOFT-FLOAT-32-NEXT:    sw $7, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $6, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    lw $4, 88($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 92($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 120($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 124($sp)
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $6, 152($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 156($sp)
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    move $19, $2
; SOFT-FLOAT-32-NEXT:    lw $4, 96($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 100($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 128($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 132($sp)
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    move $20, $3
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    lw $6, 160($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 164($sp)
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    move $21, $2
; SOFT-FLOAT-32-NEXT:    lw $4, 80($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 84($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 112($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 116($sp)
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    move $22, $3
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    lw $23, 140($sp)
; SOFT-FLOAT-32-NEXT:    lw $fp, 136($sp)
; SOFT-FLOAT-32-NEXT:    lw $17, 108($sp)
; SOFT-FLOAT-32-NEXT:    lw $18, 104($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 148($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 144($sp)
; SOFT-FLOAT-32-NEXT:    sw $22, 28($16)
; SOFT-FLOAT-32-NEXT:    sw $21, 24($16)
; SOFT-FLOAT-32-NEXT:    sw $20, 20($16)
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    sw $19, 16($16)
; SOFT-FLOAT-32-NEXT:    sw $3, 12($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 8($16)
; SOFT-FLOAT-32-NEXT:    lw $4, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $5, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    move $6, $18
; SOFT-FLOAT-32-NEXT:    jal __muldf3
; SOFT-FLOAT-32-NEXT:    move $7, $17
; SOFT-FLOAT-32-NEXT:    move $4, $2
; SOFT-FLOAT-32-NEXT:    move $5, $3
; SOFT-FLOAT-32-NEXT:    move $6, $fp
; SOFT-FLOAT-32-NEXT:    jal __adddf3
; SOFT-FLOAT-32-NEXT:    move $7, $23
; SOFT-FLOAT-32-NEXT:    sw $3, 4($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 0($16)
; SOFT-FLOAT-32-NEXT:    lw $16, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $19, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $20, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $21, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $22, 48($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $23, 52($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $fp, 56($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 60($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 64
;
; SOFT-FLOAT-32R2-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -64
; SOFT-FLOAT-32R2-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 60($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $fp, 56($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $23, 52($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $22, 48($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $21, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $20, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $19, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $18, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $17, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $16, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 31, -4
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 30, -8
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 23, -12
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 21, -20
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 20, -24
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 19, -28
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 18, -32
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 17, -36
; SOFT-FLOAT-32R2-NEXT:    .cfi_offset 16, -40
; SOFT-FLOAT-32R2-NEXT:    sw $7, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $6, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    move $16, $4
; SOFT-FLOAT-32R2-NEXT:    lw $4, 88($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 92($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $6, 120($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 124($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    nop
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $6, 152($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 156($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    move $19, $2
; SOFT-FLOAT-32R2-NEXT:    lw $4, 96($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 100($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $6, 128($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 132($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    move $20, $3
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    lw $6, 160($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 164($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    move $21, $2
; SOFT-FLOAT-32R2-NEXT:    lw $4, 80($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $5, 84($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $6, 112($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 116($sp)
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    move $22, $3
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    lw $23, 140($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $fp, 136($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $17, 108($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $18, 104($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $7, 148($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $6, 144($sp)
; SOFT-FLOAT-32R2-NEXT:    sw $22, 28($16)
; SOFT-FLOAT-32R2-NEXT:    sw $21, 24($16)
; SOFT-FLOAT-32R2-NEXT:    sw $20, 20($16)
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    sw $19, 16($16)
; SOFT-FLOAT-32R2-NEXT:    sw $3, 12($16)
; SOFT-FLOAT-32R2-NEXT:    sw $2, 8($16)
; SOFT-FLOAT-32R2-NEXT:    lw $4, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $5, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    move $6, $18
; SOFT-FLOAT-32R2-NEXT:    jal __muldf3
; SOFT-FLOAT-32R2-NEXT:    move $7, $17
; SOFT-FLOAT-32R2-NEXT:    move $4, $2
; SOFT-FLOAT-32R2-NEXT:    move $5, $3
; SOFT-FLOAT-32R2-NEXT:    move $6, $fp
; SOFT-FLOAT-32R2-NEXT:    jal __adddf3
; SOFT-FLOAT-32R2-NEXT:    move $7, $23
; SOFT-FLOAT-32R2-NEXT:    sw $3, 4($16)
; SOFT-FLOAT-32R2-NEXT:    sw $2, 0($16)
; SOFT-FLOAT-32R2-NEXT:    lw $16, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $17, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $18, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $19, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $20, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $21, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $22, 48($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $23, 52($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $fp, 56($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 60($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 64
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -64
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-NEXT:    sd $ra, 56($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $22, 48($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $21, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $20, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $19, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-64-NEXT:    .cfi_offset 21, -24
; SOFT-FLOAT-64-NEXT:    .cfi_offset 20, -32
; SOFT-FLOAT-64-NEXT:    .cfi_offset 19, -40
; SOFT-FLOAT-64-NEXT:    .cfi_offset 18, -48
; SOFT-FLOAT-64-NEXT:    .cfi_offset 17, -56
; SOFT-FLOAT-64-NEXT:    .cfi_offset 16, -64
; SOFT-FLOAT-64-NEXT:    move $17, $10
; SOFT-FLOAT-64-NEXT:    move $18, $9
; SOFT-FLOAT-64-NEXT:    move $19, $8
; SOFT-FLOAT-64-NEXT:    move $20, $6
; SOFT-FLOAT-64-NEXT:    move $21, $5
; SOFT-FLOAT-64-NEXT:    move $16, $4
; SOFT-FLOAT-64-NEXT:    move $4, $7
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $5, $11
; SOFT-FLOAT-64-NEXT:    ld $5, 88($sp)
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    move $22, $2
; SOFT-FLOAT-64-NEXT:    ld $5, 64($sp)
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $4, $19
; SOFT-FLOAT-64-NEXT:    ld $5, 96($sp)
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    move $19, $2
; SOFT-FLOAT-64-NEXT:    move $4, $20
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $5, $17
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    ld $17, 72($sp)
; SOFT-FLOAT-64-NEXT:    ld $5, 80($sp)
; SOFT-FLOAT-64-NEXT:    sd $19, 24($16)
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    sd $22, 16($16)
; SOFT-FLOAT-64-NEXT:    sd $2, 8($16)
; SOFT-FLOAT-64-NEXT:    move $4, $21
; SOFT-FLOAT-64-NEXT:    jal __muldf3
; SOFT-FLOAT-64-NEXT:    move $5, $18
; SOFT-FLOAT-64-NEXT:    move $4, $2
; SOFT-FLOAT-64-NEXT:    jal __adddf3
; SOFT-FLOAT-64-NEXT:    move $5, $17
; SOFT-FLOAT-64-NEXT:    sd $2, 0($16)
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $19, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $20, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $21, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $22, 48($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 56($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 64
;
; SOFT-FLOAT-64R2-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -64
; SOFT-FLOAT-64R2-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 56($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $22, 48($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $21, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $20, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $19, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 31, -8
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 22, -16
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 21, -24
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 20, -32
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 19, -40
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 18, -48
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 17, -56
; SOFT-FLOAT-64R2-NEXT:    .cfi_offset 16, -64
; SOFT-FLOAT-64R2-NEXT:    move $17, $10
; SOFT-FLOAT-64R2-NEXT:    move $18, $9
; SOFT-FLOAT-64R2-NEXT:    move $19, $8
; SOFT-FLOAT-64R2-NEXT:    move $20, $6
; SOFT-FLOAT-64R2-NEXT:    move $21, $5
; SOFT-FLOAT-64R2-NEXT:    move $16, $4
; SOFT-FLOAT-64R2-NEXT:    move $4, $7
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $11
; SOFT-FLOAT-64R2-NEXT:    ld $5, 88($sp)
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    move $22, $2
; SOFT-FLOAT-64R2-NEXT:    ld $5, 64($sp)
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $4, $19
; SOFT-FLOAT-64R2-NEXT:    ld $5, 96($sp)
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    move $19, $2
; SOFT-FLOAT-64R2-NEXT:    move $4, $20
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $17
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    ld $17, 72($sp)
; SOFT-FLOAT-64R2-NEXT:    ld $5, 80($sp)
; SOFT-FLOAT-64R2-NEXT:    sd $19, 24($16)
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    sd $22, 16($16)
; SOFT-FLOAT-64R2-NEXT:    sd $2, 8($16)
; SOFT-FLOAT-64R2-NEXT:    move $4, $21
; SOFT-FLOAT-64R2-NEXT:    jal __muldf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $18
; SOFT-FLOAT-64R2-NEXT:    move $4, $2
; SOFT-FLOAT-64R2-NEXT:    jal __adddf3
; SOFT-FLOAT-64R2-NEXT:    move $5, $17
; SOFT-FLOAT-64R2-NEXT:    sd $2, 0($16)
; SOFT-FLOAT-64R2-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $19, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $20, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $21, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $22, 48($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 56($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 64
  %product = fmul contract <4 x double> %a, %b
  %result = fadd contract <4 x double> %product, %c
  ret <4 x double> %result
}

attributes #0 = { "use-soft-float"="true" }

declare float @llvm.fmuladd.f32(float %a, float %b, float %c)
declare double @llvm.fmuladd.f64(double %a, double %b, double %c)
