// RUN: llvm-mc -triple=amdgcn -show-encoding -mcpu=gfx1100 %s | FileCheck --check-prefix=GFX11 %s

v_dot2_f32_bf16 v5, v1, v2, v3
// GFX11: [0x05,0x40,0x1a,0xcc,0x01,0x05,0x0e,0x1c]

v_dot2_f32_bf16 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x1a,0xcc,0x01,0x05,0x0e,0x18]

v_dot2_f32_bf16 v5, v255, v255, s105
// GFX11: [0x05,0x40,0x1a,0xcc,0xff,0xff,0xa7,0x19]

v_dot2_f32_bf16 v5, s1, s2, v255
// GFX11: [0x05,0x40,0x1a,0xcc,0x01,0x04,0xfc,0x1f]

v_dot2_f32_bf16 v5, s105, s105, m0
// GFX11: [0x05,0x40,0x1a,0xcc,0x69,0xd2,0xf4,0x19]

v_dot2_f32_bf16 v5, vcc_lo, ttmp15, vcc_lo
// GFX11: [0x05,0x40,0x1a,0xcc,0x6a,0xf6,0xa8,0x19]

v_dot2_f32_bf16 v5, vcc_hi, 0xfe0b, vcc_hi
// GFX11: [0x05,0x40,0x1a,0xcc,0x6b,0xfe,0xad,0x19,0x0b,0xfe,0x00,0x00]

v_dot2_f32_bf16 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x1a,0xcc,0x7b,0xfa,0xed,0x19]

v_dot2_f32_bf16 v5, m0, -1, exec_hi
// GFX11: [0x05,0x40,0x1a,0xcc,0x7d,0x82,0xfd,0x19]

v_dot2_f32_bf16 v5, exec_lo, null, exec_lo
// GFX11: [0x05,0x40,0x1a,0xcc,0x7e,0xf8,0xf8,0x19]

v_dot2_f32_bf16 v5, exec_hi, exec_lo, null
// GFX11: [0x05,0x40,0x1a,0xcc,0x7f,0xfc,0xf0,0x19]

v_dot2_f32_bf16 v5, null, exec_hi, -1
// GFX11: [0x05,0x40,0x1a,0xcc,0x7c,0xfe,0x04,0x1b]

v_dot2_f32_bf16 v5, -1, m0, 0xaf123456
// GFX11: [0x05,0x40,0x1a,0xcc,0xc1,0xfa,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot2_f32_bf16 v5, src_scc, vcc_lo, src_scc neg_lo:[1,0,0] neg_hi:[1,0,0]
// GFX11: [0x05,0x41,0x1a,0xcc,0xfd,0xd4,0xf4,0x3b]

v_dot2_f32_bf16 v255, 0xfe0b, vcc_hi, 0.5 neg_lo:[0,1,0] neg_hi:[0,1,0] clamp
// GFX11: [0xff,0xc2,0x1a,0xcc,0xff,0xd6,0xc0,0x5b,0x0b,0xfe,0x00,0x00]

v_dot2_f32_f16 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x13,0xcc,0x01,0x05,0x0e,0x18]

v_dot2_f32_f16 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x13,0xcc,0xff,0x05,0xa4,0x19]

v_dot2_f32_f16 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x13,0xcc,0x01,0xfe,0xff,0x19]

v_dot2_f32_f16 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x13,0xcc,0x69,0xd2,0xf8,0x19]

v_dot2_f32_f16 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x13,0xcc,0x6a,0xf6,0x0c,0x1c]

v_dot2_f32_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: [0x05,0x40,0x13,0xcc,0x6b,0xfe,0xfd,0x1f,0x0b,0xfe,0x00,0x00]

v_dot2_f32_f16 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x13,0xcc,0x7b,0xfa,0xed,0x19]

v_dot2_f32_f16 v5, m0, 0.5, m0
// GFX11: [0x05,0x40,0x13,0xcc,0x7d,0xe0,0xf5,0x19]

v_dot2_f32_f16 v5, exec_lo, -1, vcc_hi
// GFX11: [0x05,0x40,0x13,0xcc,0x7e,0x82,0xad,0x19]

v_dot2_f32_f16 v5, exec_hi, null, vcc_lo
// GFX11: [0x05,0x40,0x13,0xcc,0x7f,0xf8,0xa8,0x19]

v_dot2_f32_f16 v5, null, exec_lo, 0xaf123456
// GFX11: [0x05,0x40,0x13,0xcc,0x7c,0xfc,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot2_f32_f16 v5, -1, exec_hi, src_scc
// GFX11: [0x05,0x40,0x13,0xcc,0xc1,0xfe,0xf4,0x1b]

v_dot2_f32_f16 v5, 0.5, m0, 0.5 neg_lo:[1,0,0] neg_hi:[1,0,0]
// GFX11: [0x05,0x41,0x13,0xcc,0xf0,0xfa,0xc0,0x3b]

v_dot2_f32_f16 v5, src_scc, vcc_lo, -1 neg_lo:[0,1,0] neg_hi:[0,1,0]
// GFX11: [0x05,0x42,0x13,0xcc,0xfd,0xd4,0x04,0x5b]

v_dot2_f32_f16 v255, 0xfe0b, vcc_hi, null neg_lo:[0,0,0] neg_hi:[0,0,0] clamp
// GFX11: [0xff,0xc0,0x13,0xcc,0xff,0xd6,0xf0,0x19,0x0b,0xfe,0x00,0x00]

v_dot4_i32_iu8 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x16,0xcc,0x01,0x05,0x0e,0x18]

v_dot4_i32_iu8 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x16,0xcc,0xff,0x05,0xa4,0x19]

v_dot4_i32_iu8 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x16,0xcc,0x01,0xfe,0xff,0x19]

v_dot4_i32_iu8 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x16,0xcc,0x69,0xd2,0xf8,0x19]

v_dot4_i32_iu8 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x16,0xcc,0x6a,0xf6,0x0c,0x1c]

v_dot4_i32_iu8 v5, vcc_hi, 0xaf123456, v255
// GFX11: [0x05,0x40,0x16,0xcc,0x6b,0xfe,0xfd,0x1f,0x56,0x34,0x12,0xaf]

v_dot4_i32_iu8 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x16,0xcc,0x7b,0xfa,0xed,0x19]

v_dot4_i32_iu8 v5, m0, 0.5, m0
// GFX11: [0x05,0x40,0x16,0xcc,0x7d,0xe0,0xf5,0x19]

v_dot4_i32_iu8 v5, exec_lo, -1, vcc_hi
// GFX11: [0x05,0x40,0x16,0xcc,0x7e,0x82,0xad,0x19]

v_dot4_i32_iu8 v5, exec_hi, null, vcc_lo
// GFX11: [0x05,0x40,0x16,0xcc,0x7f,0xf8,0xa8,0x19]

v_dot4_i32_iu8 v5, null, exec_lo, 0xaf123456
// GFX11: [0x05,0x40,0x16,0xcc,0x7c,0xfc,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot4_i32_iu8 v5, -1, exec_hi, src_scc
// GFX11: [0x05,0x40,0x16,0xcc,0xc1,0xfe,0xf4,0x1b]

v_dot4_i32_iu8 v5, 0.5, m0, 0.5 neg_lo:[1,0,0]
// GFX11: [0x05,0x40,0x16,0xcc,0xf0,0xfa,0xc0,0x3b]

v_dot4_i32_iu8 v5, src_scc, vcc_lo, -1 neg_lo:[0,1,0]
// GFX11: [0x05,0x40,0x16,0xcc,0xfd,0xd4,0x04,0x5b]

v_dot4_i32_iu8 v255, 0xaf123456, vcc_hi, null neg_lo:[0,0,0]
// GFX11: [0xff,0x40,0x16,0xcc,0xff,0xd6,0xf0,0x19,0x56,0x34,0x12,0xaf]

v_dot4_u32_u8 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x17,0xcc,0x01,0x05,0x0e,0x18]

v_dot4_u32_u8 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x17,0xcc,0xff,0x05,0xa4,0x19]

v_dot4_u32_u8 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x17,0xcc,0x01,0xfe,0xff,0x19]

v_dot4_u32_u8 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x17,0xcc,0x69,0xd2,0xf8,0x19]

v_dot4_u32_u8 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x17,0xcc,0x6a,0xf6,0x0c,0x1c]

v_dot4_u32_u8 v5, vcc_hi, 0xaf123456, v255
// GFX11: [0x05,0x40,0x17,0xcc,0x6b,0xfe,0xfd,0x1f,0x56,0x34,0x12,0xaf]

v_dot4_u32_u8 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x17,0xcc,0x7b,0xfa,0xed,0x19]

v_dot4_u32_u8 v5, m0, 0.5, m0
// GFX11: [0x05,0x40,0x17,0xcc,0x7d,0xe0,0xf5,0x19]

v_dot4_u32_u8 v5, exec_lo, -1, vcc_hi
// GFX11: [0x05,0x40,0x17,0xcc,0x7e,0x82,0xad,0x19]

v_dot4_u32_u8 v5, exec_hi, null, vcc_lo
// GFX11: [0x05,0x40,0x17,0xcc,0x7f,0xf8,0xa8,0x19]

v_dot4_u32_u8 v5, null, exec_lo, 0xaf123456
// GFX11: [0x05,0x40,0x17,0xcc,0x7c,0xfc,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot4_u32_u8 v5, -1, exec_hi, src_scc
// GFX11: [0x05,0x40,0x17,0xcc,0xc1,0xfe,0xf4,0x1b]

v_dot4_u32_u8 v5, 0.5, m0, 0.5
// GFX11: [0x05,0x40,0x17,0xcc,0xf0,0xfa,0xc0,0x1b]

v_dot4_u32_u8 v5, src_scc, vcc_lo, -1
// GFX11: [0x05,0x40,0x17,0xcc,0xfd,0xd4,0x04,0x1b]

v_dot4_u32_u8 v255, 0xaf123456, vcc_hi, null
// GFX11: [0xff,0x40,0x17,0xcc,0xff,0xd6,0xf0,0x19,0x56,0x34,0x12,0xaf]

v_dot8_i32_iu4 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x18,0xcc,0x01,0x05,0x0e,0x18]

v_dot8_i32_iu4 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x18,0xcc,0xff,0x05,0xa4,0x19]

v_dot8_i32_iu4 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x18,0xcc,0x01,0xfe,0xff,0x19]

v_dot8_i32_iu4 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x18,0xcc,0x69,0xd2,0xf8,0x19]

v_dot8_i32_iu4 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x18,0xcc,0x6a,0xf6,0x0c,0x1c]

v_dot8_i32_iu4 v5, vcc_hi, 0xaf123456, v255
// GFX11: [0x05,0x40,0x18,0xcc,0x6b,0xfe,0xfd,0x1f,0x56,0x34,0x12,0xaf]

v_dot8_i32_iu4 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x18,0xcc,0x7b,0xfa,0xed,0x19]

v_dot8_i32_iu4 v5, m0, 0.5, m0
// GFX11: [0x05,0x40,0x18,0xcc,0x7d,0xe0,0xf5,0x19]

v_dot8_i32_iu4 v5, exec_lo, -1, vcc_hi
// GFX11: [0x05,0x40,0x18,0xcc,0x7e,0x82,0xad,0x19]

v_dot8_i32_iu4 v5, exec_hi, null, vcc_lo
// GFX11: [0x05,0x40,0x18,0xcc,0x7f,0xf8,0xa8,0x19]

v_dot8_i32_iu4 v5, null, exec_lo, 0xaf123456
// GFX11: [0x05,0x40,0x18,0xcc,0x7c,0xfc,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot8_i32_iu4 v5, -1, exec_hi, src_scc
// GFX11: [0x05,0x40,0x18,0xcc,0xc1,0xfe,0xf4,0x1b]

v_dot8_i32_iu4 v5, 0.5, m0, 0.5 neg_lo:[1,0,0]
// GFX11: [0x05,0x40,0x18,0xcc,0xf0,0xfa,0xc0,0x3b]

v_dot8_i32_iu4 v5, src_scc, vcc_lo, -1 neg_lo:[0,1,0]
// GFX11: [0x05,0x40,0x18,0xcc,0xfd,0xd4,0x04,0x5b]

v_dot8_i32_iu4 v255, 0xaf123456, vcc_hi, null neg_lo:[0,0,0] clamp
// GFX11: [0xff,0xc0,0x18,0xcc,0xff,0xd6,0xf0,0x19,0x56,0x34,0x12,0xaf]

v_dot8_u32_u4 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x19,0xcc,0x01,0x05,0x0e,0x18]

v_dot8_u32_u4 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x19,0xcc,0xff,0x05,0xa4,0x19]

v_dot8_u32_u4 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x19,0xcc,0x01,0xfe,0xff,0x19]

v_dot8_u32_u4 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x19,0xcc,0x69,0xd2,0xf8,0x19]

v_dot8_u32_u4 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x19,0xcc,0x6a,0xf6,0x0c,0x1c]

v_dot8_u32_u4 v5, vcc_hi, 0xaf123456, v255
// GFX11: [0x05,0x40,0x19,0xcc,0x6b,0xfe,0xfd,0x1f,0x56,0x34,0x12,0xaf]

v_dot8_u32_u4 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x19,0xcc,0x7b,0xfa,0xed,0x19]

v_dot8_u32_u4 v5, m0, 0.5, m0
// GFX11: [0x05,0x40,0x19,0xcc,0x7d,0xe0,0xf5,0x19]

v_dot8_u32_u4 v5, exec_lo, -1, vcc_hi
// GFX11: [0x05,0x40,0x19,0xcc,0x7e,0x82,0xad,0x19]

v_dot8_u32_u4 v5, exec_hi, null, vcc_lo
// GFX11: [0x05,0x40,0x19,0xcc,0x7f,0xf8,0xa8,0x19]

v_dot8_u32_u4 v5, null, exec_lo, 0xaf123456
// GFX11: [0x05,0x40,0x19,0xcc,0x7c,0xfc,0xfc,0x1b,0x56,0x34,0x12,0xaf]

v_dot8_u32_u4 v5, -1, exec_hi, src_scc
// GFX11: [0x05,0x40,0x19,0xcc,0xc1,0xfe,0xf4,0x1b]

v_dot8_u32_u4 v5, 0.5, m0, 0.5
// GFX11: [0x05,0x40,0x19,0xcc,0xf0,0xfa,0xc0,0x1b]

v_dot8_u32_u4 v5, src_scc, vcc_lo, -1
// GFX11: [0x05,0x40,0x19,0xcc,0xfd,0xd4,0x04,0x1b]

v_dot8_u32_u4 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: [0xff,0xc0,0x19,0xcc,0xff,0xd6,0xf0,0x19,0x56,0x34,0x12,0xaf]

v_fma_mix_f32 v5, v1, v2, s3
// GFX11: [0x05,0x00,0x20,0xcc,0x01,0x05,0x0e,0x00]

v_fma_mix_f32 v5, v255, v255, s105
// GFX11: [0x05,0x00,0x20,0xcc,0xff,0xff,0xa7,0x01]

v_fma_mix_f32 v5, s1, s2, v3
// GFX11: [0x05,0x00,0x20,0xcc,0x01,0x04,0x0c,0x04]

v_fma_mix_f32 v5, s105, s105, m0
// GFX11: [0x05,0x00,0x20,0xcc,0x69,0xd2,0xf4,0x01]

v_fma_mix_f32 v5, vcc_lo, ttmp15, ttmp15
// GFX11: [0x05,0x00,0x20,0xcc,0x6a,0xf6,0xec,0x01]

v_fma_mix_f32 v5, vcc_hi, src_scc, v255
// GFX11: [0x05,0x00,0x20,0xcc,0x6b,0xfa,0xfd,0x07]

v_fma_mix_f32 v5, |ttmp15|, 0.5, -vcc_hi
// GFX11: [0x05,0x01,0x20,0xcc,0x7b,0xe0,0xad,0x81]

v_fma_mix_f32 v5, -m0, -1, |vcc_lo|
// GFX11: [0x05,0x04,0x20,0xcc,0x7d,0x82,0xa9,0x21]

v_fma_mix_f32 v5, -|exec_lo|, null, -|src_scc|
// GFX11: [0x05,0x05,0x20,0xcc,0x7e,0xf8,0xf4,0xa3]

v_fma_mix_f32 v5, -|exec_hi|, -|exec_lo|, -|exec_lo| op_sel:[1,1,1] op_sel_hi:[1,1,1]
// GFX11: [0x05,0x7f,0x20,0xcc,0x7f,0xfc,0xf8,0xf9]

v_fma_mix_f32 v5, null, exec_hi, 0.5 op_sel:[0,0,0] op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x20,0xcc,0x7c,0xfe,0xc0,0x03]

v_fma_mix_f32 v5, -1, -|m0|, -1 op_sel:[1,0,0] op_sel_hi:[0,1,0]
// GFX11: [0x05,0x0a,0x20,0xcc,0xc1,0xfa,0x04,0x53]

v_fma_mix_f32 v5, 0.5, -|vcc_lo|, -|exec_hi| op_sel:[0,1,0] op_sel_hi:[1,0,0]
// GFX11: [0x05,0x16,0x20,0xcc,0xf0,0xd4,0xfc,0xc9]

v_fma_mix_f32 v255, -|src_scc|, -|vcc_hi|, null op_sel:[0,0,1] op_sel_hi:[0,0,0] clamp
// GFX11: [0xff,0xa3,0x20,0xcc,0xfd,0xd6,0xf0,0x61]

v_fma_mixhi_f16 v5, v1, v2, s3
// GFX11: [0x05,0x00,0x22,0xcc,0x01,0x05,0x0e,0x00]

v_fma_mixhi_f16 v5, v255, v255, s105
// GFX11: [0x05,0x00,0x22,0xcc,0xff,0xff,0xa7,0x01]

v_fma_mixhi_f16 v5, s1, s2, v3
// GFX11: [0x05,0x00,0x22,0xcc,0x01,0x04,0x0c,0x04]

v_fma_mixhi_f16 v5, s105, s105, m0
// GFX11: [0x05,0x00,0x22,0xcc,0x69,0xd2,0xf4,0x01]

v_fma_mixhi_f16 v5, vcc_lo, ttmp15, ttmp15
// GFX11: [0x05,0x00,0x22,0xcc,0x6a,0xf6,0xec,0x01]

v_fma_mixhi_f16 v5, vcc_hi, src_scc, v255
// GFX11: [0x05,0x00,0x22,0xcc,0x6b,0xfa,0xfd,0x07]

v_fma_mixhi_f16 v5, |ttmp15|, 0.5, -vcc_hi
// GFX11: [0x05,0x01,0x22,0xcc,0x7b,0xe0,0xad,0x81]

v_fma_mixhi_f16 v5, -m0, -1, |vcc_lo|
// GFX11: [0x05,0x04,0x22,0xcc,0x7d,0x82,0xa9,0x21]

v_fma_mixhi_f16 v5, -|exec_lo|, null, -|src_scc|
// GFX11: [0x05,0x05,0x22,0xcc,0x7e,0xf8,0xf4,0xa3]

v_fma_mixhi_f16 v5, -|exec_hi|, -|exec_lo|, -|exec_lo| op_sel:[1,1,1] op_sel_hi:[1,1,1]
// GFX11: [0x05,0x7f,0x22,0xcc,0x7f,0xfc,0xf8,0xf9]

v_fma_mixhi_f16 v5, null, exec_hi, 0.5 op_sel:[0,0,0] op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x22,0xcc,0x7c,0xfe,0xc0,0x03]

v_fma_mixhi_f16 v5, -1, -|m0|, -1 op_sel:[1,0,0] op_sel_hi:[0,1,0]
// GFX11: [0x05,0x0a,0x22,0xcc,0xc1,0xfa,0x04,0x53]

v_fma_mixhi_f16 v5, 0.5, -|vcc_lo|, -|exec_hi| op_sel:[0,1,0] op_sel_hi:[1,0,0]
// GFX11: [0x05,0x16,0x22,0xcc,0xf0,0xd4,0xfc,0xc9]

v_fma_mixhi_f16 v255, -|src_scc|, -|vcc_hi|, null op_sel:[0,0,1] op_sel_hi:[0,0,0] clamp
// GFX11: [0xff,0xa3,0x22,0xcc,0xfd,0xd6,0xf0,0x61]

v_fma_mixlo_f16 v5, v1, v2, s3
// GFX11: [0x05,0x00,0x21,0xcc,0x01,0x05,0x0e,0x00]

v_fma_mixlo_f16 v5, v255, v255, s105
// GFX11: [0x05,0x00,0x21,0xcc,0xff,0xff,0xa7,0x01]

v_fma_mixlo_f16 v5, s1, s2, v3
// GFX11: [0x05,0x00,0x21,0xcc,0x01,0x04,0x0c,0x04]

v_fma_mixlo_f16 v5, s105, s105, m0
// GFX11: [0x05,0x00,0x21,0xcc,0x69,0xd2,0xf4,0x01]

v_fma_mixlo_f16 v5, vcc_lo, ttmp15, ttmp15
// GFX11: [0x05,0x00,0x21,0xcc,0x6a,0xf6,0xec,0x01]

v_fma_mixlo_f16 v5, vcc_hi, src_scc, v255
// GFX11: [0x05,0x00,0x21,0xcc,0x6b,0xfa,0xfd,0x07]

v_fma_mixlo_f16 v5, |ttmp15|, 0.5, -vcc_hi
// GFX11: [0x05,0x01,0x21,0xcc,0x7b,0xe0,0xad,0x81]

v_fma_mixlo_f16 v5, -m0, -1, |vcc_lo|
// GFX11: [0x05,0x04,0x21,0xcc,0x7d,0x82,0xa9,0x21]

v_fma_mixlo_f16 v5, -|exec_lo|, null, -|src_scc|
// GFX11: [0x05,0x05,0x21,0xcc,0x7e,0xf8,0xf4,0xa3]

v_fma_mixlo_f16 v5, -|exec_hi|, -|exec_lo|, -|exec_lo| op_sel:[1,1,1] op_sel_hi:[1,1,1]
// GFX11: [0x05,0x7f,0x21,0xcc,0x7f,0xfc,0xf8,0xf9]

v_fma_mixlo_f16 v5, null, exec_hi, 0.5 op_sel:[0,0,0] op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x21,0xcc,0x7c,0xfe,0xc0,0x03]

v_fma_mixlo_f16 v5, -1, -|m0|, -1 op_sel:[1,0,0] op_sel_hi:[0,1,0]
// GFX11: [0x05,0x0a,0x21,0xcc,0xc1,0xfa,0x04,0x53]

v_fma_mixlo_f16 v5, 0.5, -|vcc_lo|, -|exec_hi| op_sel:[0,1,0] op_sel_hi:[1,0,0]
// GFX11: [0x05,0x16,0x21,0xcc,0xf0,0xd4,0xfc,0xc9]

v_fma_mixlo_f16 v255, -|src_scc|, -|vcc_hi|, null op_sel:[0,0,1] op_sel_hi:[0,0,0] clamp
// GFX11: [0xff,0xa3,0x21,0xcc,0xfd,0xd6,0xf0,0x61]

v_pk_add_f16 v5, v1, v2
// GFX11: [0x05,0x40,0x0f,0xcc,0x01,0x05,0x02,0x18]

v_pk_add_f16 v5, v255, v255
// GFX11: [0x05,0x40,0x0f,0xcc,0xff,0xff,0x03,0x18]

v_pk_add_f16 v5, s1, s2
// GFX11: [0x05,0x40,0x0f,0xcc,0x01,0x04,0x00,0x18]

v_pk_add_f16 v5, s105, s105
// GFX11: [0x05,0x40,0x0f,0xcc,0x69,0xd2,0x00,0x18]

v_pk_add_f16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x0f,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_add_f16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x0f,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_add_f16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x0f,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_add_f16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x0f,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_add_f16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x0f,0xcc,0x7e,0x82,0x01,0x18]

v_pk_add_f16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x0f,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_add_f16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x0f,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_add_f16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0] neg_lo:[1,0] neg_hi:[1,0]
// GFX11: [0x05,0x59,0x0f,0xcc,0xc1,0xfe,0x00,0x20]

v_pk_add_f16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1] neg_lo:[0,1] neg_hi:[0,1]
// GFX11: [0x05,0x42,0x0f,0xcc,0xf0,0xfa,0x00,0x58]

v_pk_add_f16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1] neg_lo:[0,0] neg_hi:[0,0]
// GFX11: [0x05,0x48,0x0f,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_add_f16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] neg_lo:[1,1] neg_hi:[1,1] clamp
// GFX11: [0xff,0xd3,0x0f,0xcc,0xff,0xd6,0x00,0x68,0x0b,0xfe,0x00,0x00]

v_pk_add_i16 v5, v1, v2
// GFX11: [0x05,0x40,0x02,0xcc,0x01,0x05,0x02,0x18]

v_pk_add_i16 v5, v255, v255
// GFX11: [0x05,0x40,0x02,0xcc,0xff,0xff,0x03,0x18]

v_pk_add_i16 v5, s1, s2
// GFX11: [0x05,0x40,0x02,0xcc,0x01,0x04,0x00,0x18]

v_pk_add_i16 v5, s105, s105
// GFX11: [0x05,0x40,0x02,0xcc,0x69,0xd2,0x00,0x18]

v_pk_add_i16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x02,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_add_i16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x02,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_add_i16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x02,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_add_i16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x02,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_add_i16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x02,0xcc,0x7e,0x82,0x01,0x18]

v_pk_add_i16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x02,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_add_i16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x02,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_add_i16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x02,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_add_i16 v5, 0x3800, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x02,0xcc,0xff,0xfa,0x00,0x18,0x00,0x38,0x00,0x00]

v_pk_add_i16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x02,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_add_i16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x02,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_add_i16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] clamp
// GFX11: [0xff,0xd0,0x02,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_add_u16 v5, v1, v2
// GFX11: [0x05,0x40,0x0a,0xcc,0x01,0x05,0x02,0x18]

v_pk_add_u16 v5, v255, v255
// GFX11: [0x05,0x40,0x0a,0xcc,0xff,0xff,0x03,0x18]

v_pk_add_u16 v5, s1, s2
// GFX11: [0x05,0x40,0x0a,0xcc,0x01,0x04,0x00,0x18]

v_pk_add_u16 v5, s105, s105
// GFX11: [0x05,0x40,0x0a,0xcc,0x69,0xd2,0x00,0x18]

v_pk_add_u16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x0a,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_add_u16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x0a,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_add_u16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x0a,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_add_u16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x0a,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_add_u16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x0a,0xcc,0x7e,0x82,0x01,0x18]

v_pk_add_u16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x0a,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_add_u16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x0a,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_add_u16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x0a,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_add_u16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x0a,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_add_u16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x0a,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_add_u16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] clamp
// GFX11: [0xff,0xd0,0x0a,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_ashrrev_i16 v5, v1, v2
// GFX11: [0x05,0x40,0x06,0xcc,0x01,0x05,0x02,0x18]

v_pk_ashrrev_i16 v5, v255, v255
// GFX11: [0x05,0x40,0x06,0xcc,0xff,0xff,0x03,0x18]

v_pk_ashrrev_i16 v5, s1, s2
// GFX11: [0x05,0x40,0x06,0xcc,0x01,0x04,0x00,0x18]

v_pk_ashrrev_i16 v5, s105, s105
// GFX11: [0x05,0x40,0x06,0xcc,0x69,0xd2,0x00,0x18]

v_pk_ashrrev_i16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x06,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_ashrrev_i16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x06,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_ashrrev_i16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x06,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_ashrrev_i16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x06,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_ashrrev_i16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x06,0xcc,0x7e,0x82,0x01,0x18]

v_pk_ashrrev_i16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x06,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_ashrrev_i16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x06,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_ashrrev_i16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x06,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_ashrrev_i16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x06,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_ashrrev_i16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x06,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_ashrrev_i16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x06,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_fma_f16 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x0e,0xcc,0x01,0x05,0x0e,0x18]

v_pk_fma_f16 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x0e,0xcc,0xff,0x05,0xa4,0x19]

v_pk_fma_f16 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x0e,0xcc,0x01,0xfe,0xff,0x19]

v_pk_fma_f16 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x0e,0xcc,0x69,0xd2,0xf8,0x19]

v_pk_fma_f16 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x0e,0xcc,0x6a,0xf6,0x0c,0x1c]

v_pk_fma_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: [0x05,0x40,0x0e,0xcc,0x6b,0xfe,0xfd,0x1f,0x0b,0xfe,0x00,0x00]

v_pk_fma_f16 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x0e,0xcc,0x7b,0xfa,0xed,0x19]

v_pk_fma_f16 v5, m0, 0.5, m0 op_sel_hi:[0,0,0]
// GFX11: [0x05,0x00,0x0e,0xcc,0x7d,0xe0,0xf5,0x01]

v_pk_fma_f16 v5, exec_lo, -1, vcc_hi op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x0e,0xcc,0x7e,0x82,0xad,0x01]

v_pk_fma_f16 v5, exec_hi, null, vcc_lo op_sel_hi:[0,1,0]
// GFX11: [0x05,0x00,0x0e,0xcc,0x7f,0xf8,0xa8,0x11]

v_pk_fma_f16 v5, null, exec_lo, 0xfe0b op_sel:[1,1,1] op_sel_hi:[1,0,0] neg_lo:[1,0,0] neg_hi:[1,0,0]
// GFX11: [0x05,0x39,0x0e,0xcc,0x7c,0xfc,0xfc,0x2b,0x0b,0xfe,0x00,0x00]

v_pk_fma_f16 v5, -1, exec_hi, src_scc op_sel:[0,0,0] op_sel_hi:[1,1,1] neg_lo:[0,1,0] neg_hi:[0,1,0]
// GFX11: [0x05,0x42,0x0e,0xcc,0xc1,0xfe,0xf4,0x5b]

v_pk_fma_f16 v5, 0.5, m0, 0.5 op_sel:[1,0,0] op_sel_hi:[0,1,1] neg_lo:[0,0,1] neg_hi:[0,0,1]
// GFX11: [0x05,0x4c,0x0e,0xcc,0xf0,0xfa,0xc0,0x93]

v_pk_fma_f16 v5, src_scc, vcc_lo, -1 op_sel:[0,1,0] op_sel_hi:[1,0,1] neg_lo:[0,0,0] neg_hi:[0,0,0]
// GFX11: [0x05,0x50,0x0e,0xcc,0xfd,0xd4,0x04,0x0b]

v_pk_fma_f16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,1] op_sel_hi:[1,1,0] neg_lo:[1,1,1] neg_hi:[1,1,1] clamp
// GFX11: [0xff,0xa7,0x0e,0xcc,0xff,0xd6,0xf0,0xf9,0x0b,0xfe,0x00,0x00]

v_pk_lshlrev_b16 v5, v1, v2
// GFX11: [0x05,0x40,0x04,0xcc,0x01,0x05,0x02,0x18]

v_pk_lshlrev_b16 v5, v255, v255
// GFX11: [0x05,0x40,0x04,0xcc,0xff,0xff,0x03,0x18]

v_pk_lshlrev_b16 v5, s1, s2
// GFX11: [0x05,0x40,0x04,0xcc,0x01,0x04,0x00,0x18]

v_pk_lshlrev_b16 v5, s105, s105
// GFX11: [0x05,0x40,0x04,0xcc,0x69,0xd2,0x00,0x18]

v_pk_lshlrev_b16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x04,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_lshlrev_b16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x04,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_lshlrev_b16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x04,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_lshlrev_b16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x04,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_lshlrev_b16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x04,0xcc,0x7e,0x82,0x01,0x18]

v_pk_lshlrev_b16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x04,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_lshlrev_b16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x04,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_lshlrev_b16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x04,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_lshlrev_b16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x04,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_lshlrev_b16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x04,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_lshlrev_b16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x04,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_lshrrev_b16 v5, v1, v2
// GFX11: [0x05,0x40,0x05,0xcc,0x01,0x05,0x02,0x18]

v_pk_lshrrev_b16 v5, v255, v255
// GFX11: [0x05,0x40,0x05,0xcc,0xff,0xff,0x03,0x18]

v_pk_lshrrev_b16 v5, s1, s2
// GFX11: [0x05,0x40,0x05,0xcc,0x01,0x04,0x00,0x18]

v_pk_lshrrev_b16 v5, s105, s105
// GFX11: [0x05,0x40,0x05,0xcc,0x69,0xd2,0x00,0x18]

v_pk_lshrrev_b16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x05,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_lshrrev_b16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x05,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_lshrrev_b16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x05,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_lshrrev_b16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x05,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_lshrrev_b16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x05,0xcc,0x7e,0x82,0x01,0x18]

v_pk_lshrrev_b16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x05,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_lshrrev_b16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x05,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_lshrrev_b16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x05,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_lshrrev_b16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x05,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_lshrrev_b16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x05,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_lshrrev_b16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x05,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_mad_i16 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x00,0xcc,0x01,0x05,0x0e,0x18]

v_pk_mad_i16 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x00,0xcc,0xff,0x05,0xa4,0x19]

v_pk_mad_i16 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x00,0xcc,0x01,0xfe,0xff,0x19]

v_pk_mad_i16 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x00,0xcc,0x69,0xd2,0xf8,0x19]

v_pk_mad_i16 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x00,0xcc,0x6a,0xf6,0x0c,0x1c]

v_pk_mad_i16 v5, vcc_hi, 0xfe0b, v255
// GFX11: [0x05,0x40,0x00,0xcc,0x6b,0xfe,0xfd,0x1f,0x0b,0xfe,0x00,0x00]

v_pk_mad_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x00,0xcc,0x7b,0xfa,0xed,0x19]

v_pk_mad_i16 v5, m0, 0.5, m0 op_sel_hi:[0,0,0]
// GFX11: [0x05,0x00,0x00,0xcc,0x7d,0xe0,0xf5,0x01]

v_pk_mad_i16 v5, exec_lo, -1, vcc_hi op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x00,0xcc,0x7e,0x82,0xad,0x01]

v_pk_mad_i16 v5, exec_hi, null, vcc_lo op_sel_hi:[0,1,0]
// GFX11: [0x05,0x00,0x00,0xcc,0x7f,0xf8,0xa8,0x11]

v_pk_mad_i16 v5, null, exec_lo, 0xfe0b op_sel:[1,1,1] op_sel_hi:[1,0,0]
// GFX11: [0x05,0x38,0x00,0xcc,0x7c,0xfc,0xfc,0x0b,0x0b,0xfe,0x00,0x00]

v_pk_mad_i16 v5, -1, exec_hi, src_scc op_sel:[0,0,0] op_sel_hi:[1,1,1]
// GFX11: [0x05,0x40,0x00,0xcc,0xc1,0xfe,0xf4,0x1b]

v_pk_mad_i16 v5, 0.5, m0, 0.5 op_sel:[1,0,0] op_sel_hi:[0,1,1]
// GFX11: [0x05,0x48,0x00,0xcc,0xf0,0xfa,0xc0,0x13]

v_pk_mad_i16 v5, src_scc, vcc_lo, -1 op_sel:[0,1,0] op_sel_hi:[1,0,1]
// GFX11: [0x05,0x50,0x00,0xcc,0xfd,0xd4,0x04,0x0b]

v_pk_mad_i16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,1] op_sel_hi:[1,1,0] clamp
// GFX11: [0xff,0xa0,0x00,0xcc,0xff,0xd6,0xf0,0x19,0x0b,0xfe,0x00,0x00]

v_pk_mad_u16 v5, v1, v2, s3
// GFX11: [0x05,0x40,0x09,0xcc,0x01,0x05,0x0e,0x18]

v_pk_mad_u16 v5, v255, s2, s105
// GFX11: [0x05,0x40,0x09,0xcc,0xff,0x05,0xa4,0x19]

v_pk_mad_u16 v5, s1, v255, exec_hi
// GFX11: [0x05,0x40,0x09,0xcc,0x01,0xfe,0xff,0x19]

v_pk_mad_u16 v5, s105, s105, exec_lo
// GFX11: [0x05,0x40,0x09,0xcc,0x69,0xd2,0xf8,0x19]

v_pk_mad_u16 v5, vcc_lo, ttmp15, v3
// GFX11: [0x05,0x40,0x09,0xcc,0x6a,0xf6,0x0c,0x1c]

v_pk_mad_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: [0x05,0x40,0x09,0xcc,0x6b,0xfe,0xfd,0x1f,0x0b,0xfe,0x00,0x00]

v_pk_mad_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: [0x05,0x40,0x09,0xcc,0x7b,0xfa,0xed,0x19]

v_pk_mad_u16 v5, m0, 0.5, m0 op_sel_hi:[0,0,0]
// GFX11: [0x05,0x00,0x09,0xcc,0x7d,0xe0,0xf5,0x01]

v_pk_mad_u16 v5, exec_lo, -1, vcc_hi op_sel_hi:[0,0,1]
// GFX11: [0x05,0x40,0x09,0xcc,0x7e,0x82,0xad,0x01]

v_pk_mad_u16 v5, exec_hi, null, vcc_lo op_sel_hi:[0,1,0]
// GFX11: [0x05,0x00,0x09,0xcc,0x7f,0xf8,0xa8,0x11]

v_pk_mad_u16 v5, null, exec_lo, 0xfe0b op_sel:[1,1,1] op_sel_hi:[1,0,0]
// GFX11: [0x05,0x38,0x09,0xcc,0x7c,0xfc,0xfc,0x0b,0x0b,0xfe,0x00,0x00]

v_pk_mad_u16 v5, -1, exec_hi, src_scc op_sel:[0,0,0] op_sel_hi:[1,1,1]
// GFX11: [0x05,0x40,0x09,0xcc,0xc1,0xfe,0xf4,0x1b]

v_pk_mad_u16 v5, 0.5, m0, 0.5 op_sel:[1,0,0] op_sel_hi:[0,1,1]
// GFX11: [0x05,0x48,0x09,0xcc,0xf0,0xfa,0xc0,0x13]

v_pk_mad_u16 v5, src_scc, vcc_lo, -1 op_sel:[0,1,0] op_sel_hi:[1,0,1]
// GFX11: [0x05,0x50,0x09,0xcc,0xfd,0xd4,0x04,0x0b]

v_pk_mad_u16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,1] op_sel_hi:[1,1,0] clamp
// GFX11: [0xff,0xa0,0x09,0xcc,0xff,0xd6,0xf0,0x19,0x0b,0xfe,0x00,0x00]

v_pk_max_f16 v5, v1, v2
// GFX11: [0x05,0x40,0x12,0xcc,0x01,0x05,0x02,0x18]

v_pk_max_f16 v5, v255, v255
// GFX11: [0x05,0x40,0x12,0xcc,0xff,0xff,0x03,0x18]

v_pk_max_f16 v5, s1, s2
// GFX11: [0x05,0x40,0x12,0xcc,0x01,0x04,0x00,0x18]

v_pk_max_f16 v5, s105, s105
// GFX11: [0x05,0x40,0x12,0xcc,0x69,0xd2,0x00,0x18]

v_pk_max_f16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x12,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_max_f16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x12,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_max_f16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x12,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_max_f16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x12,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_max_f16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x12,0xcc,0x7e,0x82,0x01,0x18]

v_pk_max_f16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x12,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_max_f16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x12,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_max_f16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0] neg_lo:[1,0] neg_hi:[1,0]
// GFX11: [0x05,0x59,0x12,0xcc,0xc1,0xfe,0x00,0x20]

v_pk_max_f16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1] neg_lo:[0,1] neg_hi:[0,1]
// GFX11: [0x05,0x42,0x12,0xcc,0xf0,0xfa,0x00,0x58]

v_pk_max_f16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1] neg_lo:[0,0] neg_hi:[0,0]
// GFX11: [0x05,0x48,0x12,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_max_f16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] neg_lo:[1,1] neg_hi:[1,1] clamp
// GFX11: [0xff,0xd3,0x12,0xcc,0xff,0xd6,0x00,0x68,0x0b,0xfe,0x00,0x00]

v_pk_max_i16 v5, v1, v2
// GFX11: [0x05,0x40,0x07,0xcc,0x01,0x05,0x02,0x18]

v_pk_max_i16 v5, v255, v255
// GFX11: [0x05,0x40,0x07,0xcc,0xff,0xff,0x03,0x18]

v_pk_max_i16 v5, s1, s2
// GFX11: [0x05,0x40,0x07,0xcc,0x01,0x04,0x00,0x18]

v_pk_max_i16 v5, s105, s105
// GFX11: [0x05,0x40,0x07,0xcc,0x69,0xd2,0x00,0x18]

v_pk_max_i16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x07,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_max_i16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x07,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_max_i16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x07,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_max_i16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x07,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_max_i16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x07,0xcc,0x7e,0x82,0x01,0x18]

v_pk_max_i16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x07,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_max_i16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x07,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_max_i16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x07,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_max_i16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x07,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_max_i16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x07,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_max_i16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x07,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_max_u16 v5, v1, v2
// GFX11: [0x05,0x40,0x0c,0xcc,0x01,0x05,0x02,0x18]

v_pk_max_u16 v5, v255, v255
// GFX11: [0x05,0x40,0x0c,0xcc,0xff,0xff,0x03,0x18]

v_pk_max_u16 v5, s1, s2
// GFX11: [0x05,0x40,0x0c,0xcc,0x01,0x04,0x00,0x18]

v_pk_max_u16 v5, s105, s105
// GFX11: [0x05,0x40,0x0c,0xcc,0x69,0xd2,0x00,0x18]

v_pk_max_u16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x0c,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_max_u16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x0c,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_max_u16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x0c,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_max_u16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x0c,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_max_u16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x0c,0xcc,0x7e,0x82,0x01,0x18]

v_pk_max_u16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x0c,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_max_u16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x0c,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_max_u16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x0c,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_max_u16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x0c,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_max_u16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x0c,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_max_u16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x0c,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_min_f16 v5, v1, v2
// GFX11: [0x05,0x40,0x11,0xcc,0x01,0x05,0x02,0x18]

v_pk_min_f16 v5, v255, v255
// GFX11: [0x05,0x40,0x11,0xcc,0xff,0xff,0x03,0x18]

v_pk_min_f16 v5, s1, s2
// GFX11: [0x05,0x40,0x11,0xcc,0x01,0x04,0x00,0x18]

v_pk_min_f16 v5, s105, s105
// GFX11: [0x05,0x40,0x11,0xcc,0x69,0xd2,0x00,0x18]

v_pk_min_f16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x11,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_min_f16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x11,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_min_f16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x11,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_min_f16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x11,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_min_f16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x11,0xcc,0x7e,0x82,0x01,0x18]

v_pk_min_f16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x11,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_min_f16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x11,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_min_f16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0] neg_lo:[1,0] neg_hi:[1,0]
// GFX11: [0x05,0x59,0x11,0xcc,0xc1,0xfe,0x00,0x20]

v_pk_min_f16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1] neg_lo:[0,1] neg_hi:[0,1]
// GFX11: [0x05,0x42,0x11,0xcc,0xf0,0xfa,0x00,0x58]

v_pk_min_f16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1] neg_lo:[0,0] neg_hi:[0,0]
// GFX11: [0x05,0x48,0x11,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_min_f16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] neg_lo:[1,1] neg_hi:[1,1] clamp
// GFX11: [0xff,0xd3,0x11,0xcc,0xff,0xd6,0x00,0x68,0x0b,0xfe,0x00,0x00]

v_pk_min_i16 v5, v1, v2
// GFX11: [0x05,0x40,0x08,0xcc,0x01,0x05,0x02,0x18]

v_pk_min_i16 v5, v255, v255
// GFX11: [0x05,0x40,0x08,0xcc,0xff,0xff,0x03,0x18]

v_pk_min_i16 v5, s1, s2
// GFX11: [0x05,0x40,0x08,0xcc,0x01,0x04,0x00,0x18]

v_pk_min_i16 v5, s105, s105
// GFX11: [0x05,0x40,0x08,0xcc,0x69,0xd2,0x00,0x18]

v_pk_min_i16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x08,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_min_i16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x08,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_min_i16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x08,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_min_i16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x08,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_min_i16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x08,0xcc,0x7e,0x82,0x01,0x18]

v_pk_min_i16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x08,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_min_i16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x08,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_min_i16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x08,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_min_i16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x08,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_min_i16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x08,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_min_i16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x08,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_min_u16 v5, v1, v2
// GFX11: [0x05,0x40,0x0d,0xcc,0x01,0x05,0x02,0x18]

v_pk_min_u16 v5, v255, v255
// GFX11: [0x05,0x40,0x0d,0xcc,0xff,0xff,0x03,0x18]

v_pk_min_u16 v5, s1, s2
// GFX11: [0x05,0x40,0x0d,0xcc,0x01,0x04,0x00,0x18]

v_pk_min_u16 v5, s105, s105
// GFX11: [0x05,0x40,0x0d,0xcc,0x69,0xd2,0x00,0x18]

v_pk_min_u16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x0d,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_min_u16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x0d,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_min_u16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x0d,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_min_u16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x0d,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_min_u16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x0d,0xcc,0x7e,0x82,0x01,0x18]

v_pk_min_u16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x0d,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_min_u16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x0d,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_min_u16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x0d,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_min_u16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x0d,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_min_u16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x0d,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_min_u16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x0d,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_mul_f16 v5, v1, v2
// GFX11: [0x05,0x40,0x10,0xcc,0x01,0x05,0x02,0x18]

v_pk_mul_f16 v5, v255, v255
// GFX11: [0x05,0x40,0x10,0xcc,0xff,0xff,0x03,0x18]

v_pk_mul_f16 v5, s1, s2
// GFX11: [0x05,0x40,0x10,0xcc,0x01,0x04,0x00,0x18]

v_pk_mul_f16 v5, s105, s105
// GFX11: [0x05,0x40,0x10,0xcc,0x69,0xd2,0x00,0x18]

v_pk_mul_f16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x10,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_mul_f16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x10,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_mul_f16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x10,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_mul_f16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x10,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_mul_f16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x10,0xcc,0x7e,0x82,0x01,0x18]

v_pk_mul_f16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x10,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_mul_f16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x10,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_mul_f16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0] neg_lo:[1,0] neg_hi:[1,0]
// GFX11: [0x05,0x59,0x10,0xcc,0xc1,0xfe,0x00,0x20]

v_pk_mul_f16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1] neg_lo:[0,1] neg_hi:[0,1]
// GFX11: [0x05,0x42,0x10,0xcc,0xf0,0xfa,0x00,0x58]

v_pk_mul_f16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1] neg_lo:[0,0] neg_hi:[0,0]
// GFX11: [0x05,0x48,0x10,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_mul_f16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] neg_lo:[1,1] neg_hi:[1,1] clamp
// GFX11: [0xff,0xd3,0x10,0xcc,0xff,0xd6,0x00,0x68,0x0b,0xfe,0x00,0x00]

v_pk_mul_lo_u16 v5, v1, v2
// GFX11: [0x05,0x40,0x01,0xcc,0x01,0x05,0x02,0x18]

v_pk_mul_lo_u16 v5, v255, v255
// GFX11: [0x05,0x40,0x01,0xcc,0xff,0xff,0x03,0x18]

v_pk_mul_lo_u16 v5, s1, s2
// GFX11: [0x05,0x40,0x01,0xcc,0x01,0x04,0x00,0x18]

v_pk_mul_lo_u16 v5, s105, s105
// GFX11: [0x05,0x40,0x01,0xcc,0x69,0xd2,0x00,0x18]

v_pk_mul_lo_u16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x01,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_mul_lo_u16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x01,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_mul_lo_u16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x01,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_mul_lo_u16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x01,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_mul_lo_u16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x01,0xcc,0x7e,0x82,0x01,0x18]

v_pk_mul_lo_u16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x01,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_mul_lo_u16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x01,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_mul_lo_u16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x01,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_mul_lo_u16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x01,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_mul_lo_u16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x01,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_mul_lo_u16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0]
// GFX11: [0xff,0x50,0x01,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_sub_i16 v5, v1, v2
// GFX11: [0x05,0x40,0x03,0xcc,0x01,0x05,0x02,0x18]

v_pk_sub_i16 v5, v255, v255
// GFX11: [0x05,0x40,0x03,0xcc,0xff,0xff,0x03,0x18]

v_pk_sub_i16 v5, s1, s2
// GFX11: [0x05,0x40,0x03,0xcc,0x01,0x04,0x00,0x18]

v_pk_sub_i16 v5, s105, s105
// GFX11: [0x05,0x40,0x03,0xcc,0x69,0xd2,0x00,0x18]

v_pk_sub_i16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x03,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_sub_i16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x03,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_sub_i16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x03,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_sub_i16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x03,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_sub_i16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x03,0xcc,0x7e,0x82,0x01,0x18]

v_pk_sub_i16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x03,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_sub_i16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x03,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_sub_i16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x03,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_sub_i16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x03,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_sub_i16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x03,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_sub_i16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] clamp
// GFX11: [0xff,0xd0,0x03,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]

v_pk_sub_u16 v5, v1, v2
// GFX11: [0x05,0x40,0x0b,0xcc,0x01,0x05,0x02,0x18]

v_pk_sub_u16 v5, v255, v255
// GFX11: [0x05,0x40,0x0b,0xcc,0xff,0xff,0x03,0x18]

v_pk_sub_u16 v5, s1, s2
// GFX11: [0x05,0x40,0x0b,0xcc,0x01,0x04,0x00,0x18]

v_pk_sub_u16 v5, s105, s105
// GFX11: [0x05,0x40,0x0b,0xcc,0x69,0xd2,0x00,0x18]

v_pk_sub_u16 v5, vcc_lo, ttmp15
// GFX11: [0x05,0x40,0x0b,0xcc,0x6a,0xf6,0x00,0x18]

v_pk_sub_u16 v5, vcc_hi, 0xfe0b
// GFX11: [0x05,0x40,0x0b,0xcc,0x6b,0xfe,0x01,0x18,0x0b,0xfe,0x00,0x00]

v_pk_sub_u16 v5, ttmp15, src_scc
// GFX11: [0x05,0x40,0x0b,0xcc,0x7b,0xfa,0x01,0x18]

v_pk_sub_u16 v5, m0, 0.5
// GFX11: [0x05,0x40,0x0b,0xcc,0x7d,0xe0,0x01,0x18]

v_pk_sub_u16 v5, exec_lo, -1
// GFX11: [0x05,0x40,0x0b,0xcc,0x7e,0x82,0x01,0x18]

v_pk_sub_u16 v5, exec_hi, null
// GFX11: [0x05,0x40,0x0b,0xcc,0x7f,0xf8,0x00,0x18]

v_pk_sub_u16 v5, null, exec_lo
// GFX11: [0x05,0x40,0x0b,0xcc,0x7c,0xfc,0x00,0x18]

v_pk_sub_u16 v5, -1, exec_hi op_sel:[1,1] op_sel_hi:[0,0]
// GFX11: [0x05,0x58,0x0b,0xcc,0xc1,0xfe,0x00,0x00]

v_pk_sub_u16 v5, 0.5, m0 op_sel:[0,0] op_sel_hi:[1,1]
// GFX11: [0x05,0x40,0x0b,0xcc,0xf0,0xfa,0x00,0x18]

v_pk_sub_u16 v5, src_scc, vcc_lo op_sel:[1,0] op_sel_hi:[0,1]
// GFX11: [0x05,0x48,0x0b,0xcc,0xfd,0xd4,0x00,0x10]

v_pk_sub_u16 v255, 0xfe0b, vcc_hi op_sel:[0,1] op_sel_hi:[1,0] clamp
// GFX11: [0xff,0xd0,0x0b,0xcc,0xff,0xd6,0x00,0x08,0x0b,0xfe,0x00,0x00]
