// -*- Mode: C++; c-basic-offset: 4; indent-tabs-mode: nil; -*-
/**
 * Copyright 2006  Zack Rusin <zack@kde.org>
 * KDE 3 backport Copyright 2007 Kevin Kofler <Kevin@tigcc.ticalc.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef QSPELL_ENCHANTCLIENT_H
#define QSPELL_ENCHANTCLIENT_H

#include "client.h"

#include <qmap.h>
#include <enchant.h>

namespace KSpell2 {
    class Dictionary;
}
using KSpell2::Dictionary;

class QSpellEnchantClient : public KSpell2::Client
{
    Q_OBJECT
public:
    QSpellEnchantClient(QObject *parent, const char *name, const QStringList & /* args */);
    ~QSpellEnchantClient();

    virtual int reliability() const {
        return 30;
    }

    virtual Dictionary *dictionary(const QString &language);

    virtual QStringList languages() const;

    virtual QString name() const {
        return QString::fromLatin1("Enchant");
    }

    void addLanguage(const QString &lang);

    void removeDictRef(EnchantDict *dict);

private:
    EnchantBroker *m_broker;
    QStringList m_languages;
    QMap<EnchantDict*, int> m_dictRefs;
};

#endif
