/** @file
 * @brief Macro for icon names used in Inkscape
 */
/* Authors:
 *   Krzysztof Kosiński <tweenk.pl@gmail.com>
 *
 * Copyright (C) 2009 Authors
 * Released under GNU GPL, read the file 'COPYING' for more information
 */

#ifndef SEEN_INKSCAPE_ICON_NAMES_H
#define SEEN_INKSCAPE_ICON_NAMES_H

/** @brief Icon name annotation.
 * Use this macro to mark strings which are used as icon names.
 * This greatly simplifies tasks such as obtaining a full list of icons
 * used by Inkscape. */
#define INKSCAPE_ICON(icon) icon

#endif /* ifdef SEEN_INKSCAPE_ICON_NAMES_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:fileencoding=utf-8:textwidth=99 :
