/* $Id: d_bjt.model,v 26.136 2009/12/08 02:03:49 al Exp $ -*- C++ -*-
 * Copyright (C) 2002 Albert Davis
 * Author: Albert Davis <aldavis@gnu.org>
 *
 * This file is part of "Gnucap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *------------------------------------------------------------------
 * Berkeley BJT model
 * Derived from Spice code, both from 2g6 and 3f4
 * Recoded for Gnucap model compiler, Al Davis, 2002
 *------------------------------------------------------------------
 * data structures and defaults for bjt model.
 *
 * netlist syntax:
 * device:  qxxxx c b e s mname <device args>
 * model:   .model mname NPN <args>
 *	or  .model mname PNP <args>
 *
 * known BUGs
 * 1. excess phase partially implemented, disabled, as if PTF == 0.
 */
/* This file is automatically generated. DO NOT EDIT */
#ifndef D_BJT_H_INCLUDED
#define D_BJT_H_INCLUDED

#include "d_diode.h"
#include "u_sdp.h"
#include "e_node.h"
#include "e_subckt.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class SDP_BUILT_IN_BJT
  :public SDP_BUILT_IN_DIODE{
public:
  explicit SDP_BUILT_IN_BJT(const COMMON_COMPONENT* c) : SDP_BUILT_IN_DIODE(c) {init(c);}
  void init(const COMMON_COMPONENT*);
public:
};
/*--------------------------------------------------------------------------*/
class DEV_BUILT_IN_BJT;
class TDP_BUILT_IN_BJT{
public:
  explicit TDP_BUILT_IN_BJT(const DEV_BUILT_IN_BJT*);
public:
  double vt;	// 
  double ibc;	// BJTtSatCur
  double ibe;	// BJTtSatCur
  double BetaF;	// BJTtBetaF
  double BetaR;	// BJTtBetaR
  double BEleakCur;	// BJTtBEleakCur
  double BCleakCur;	// BJTtBCleakCur
  double BEpot;	// BJTtBEpot
  double BEcap;	// BJTtBEcap
  double DepCap;	// 
  double f1;	// 
  double BCpot;	// BJTtBCpot
  double BCcap;	// BJTtBCcap
  double f4;	// 
  double f5;	// 
  double Vcrit;	// 
};
/*--------------------------------------------------------------------------*/
class MODEL_BUILT_IN_BJT
  :public MODEL_BUILT_IN_DIODE{
protected:
  explicit MODEL_BUILT_IN_BJT(const MODEL_BUILT_IN_BJT& p);
public:
  explicit MODEL_BUILT_IN_BJT(const BASE_SUBCKT*);
  ~MODEL_BUILT_IN_BJT() {--_count;}
public: // override virtual
  std::string dev_type()const;
  void      set_dev_type(const std::string& nt);
  CARD*     clone()const {return new MODEL_BUILT_IN_BJT(*this);}
  void      precalc_first();
  void      precalc_last();
  SDP_CARD* new_sdp(COMMON_COMPONENT* c)const;
  void      set_param_by_index(int, std::string&, int);
  bool      param_is_printable(int)const;
  std::string param_name(int)const;
  std::string param_name(int,int)const;
  std::string param_value(int)const;
  int param_count()const {return (50);}
  bool      is_valid(const COMPONENT*)const;
  void      tr_eval(COMPONENT*)const;
public: // not virtual
  static int count() {return _count;}
private: // strictly internal
  static int _count;
public: // input parameters
  PARAMETER<int> level;	// dummy
  PARAMETER<double> bf;	// Ideal forward beta
  PARAMETER<double> br;	// Ideal reverse beta
  PARAMETER<double> ibc;	// bc Saturation Current
  PARAMETER<double> ibe;	// be Saturation Current
  PARAMETER<double> i_s;	// Saturation Current
  PARAMETER<double> nf;	// Forward emission coefficient
  PARAMETER<double> nr;	// Reverse emission coefficient
  PARAMETER<double> vaf;	// Forward Early voltage
  PARAMETER<double> var;	// Reverse Early voltage
  PARAMETER<double> isc;	// B-C leakage saturation current
  PARAMETER<double> c4;	// obsolete, don't use
  PARAMETER<double> nc;	// B-C leakage emission coefficient
  PARAMETER<double> ise;	// B-E leakage saturation current
  PARAMETER<double> c2;	// obsolete, don't use
  PARAMETER<double> ne;	// B-E leakage emission coefficient
  PARAMETER<double> ikf;	// Forward beta roll-off corner current
  PARAMETER<double> ikr;	// reverse beta roll-off corner current
  PARAMETER<double> irb;	// Current for base resistance=(rb+rbm)/2
  PARAMETER<double> rb;	// Zero bias base resistance
  PARAMETER<double> rbm;	// Minimum base resistance
  PARAMETER<double> re;	// Emitter resistance
  PARAMETER<double> rc;	// Collector resistance
  PARAMETER<double> cbcp;	// external BC capacitance
  PARAMETER<double> cbep;	// external BE capacitance
  PARAMETER<double> cbsp;	// external BS capacitance (lateral)
  PARAMETER<double> ccsp;	// external BS capacitance (vertical)
  PARAMETER<double> cjc;	// Zero bias B-C depletion capacitance
  PARAMETER<double> cje;	// Zero bias B-E depletion capacitance
  PARAMETER<double> cjs;	// Zero bias C-S capacitance
  PARAMETER<double> fc;	// Forward bias junction fit parameter
  PARAMETER<double> mjc;	// B-C junction grading coefficient
  PARAMETER<double> mje;	// B-E junction grading coefficient
  PARAMETER<double> mjs;	// Substrate junction grading coefficient
  PARAMETER<double> vjc;	// B-C built in potential
  PARAMETER<double> vje;	// B-E built in potential
  PARAMETER<double> vjs;	// Substrate junction built in potential
  PARAMETER<double> xcjc;	// Fraction of B-C cap to internal base
  PARAMETER<double> itf;	// High current dependence of TF
  PARAMETER<double> ptf;	// Excess phase
  PARAMETER<double> tf;	// Ideal forward transit time
  PARAMETER<double> tr;	// Ideal reverse transit time
  PARAMETER<double> vtf;	// Voltage giving VBC dependence of TF
  PARAMETER<double> xtf;	// Coefficient for bias dependence of TF
  PARAMETER<double> xtb;	// Forward and reverse beta temp. exp.
  PARAMETER<double> xti;	// Temp. exponent for IS
  PARAMETER<double> eg;	// Energy gap for IS temp. dependency
public: // calculated parameters
  double tnom_k;	// nominal temperature, kelvin
  polarity_t polarity;	// 
  double invearlyvoltf;	// Inverse early voltage:forward
  double invearlyvoltr;	// Inverse early voltage:reverse
  double invrollofff;	// Inverse roll off - forward
  double invrolloffr;	// Inverse roll off - reverse
  double transtimevbcfact;	// Transit time VBC factor
  double excessphasefactor;	// Excess phase fact.
  double xfc;	// 
  double f2;	// 
  double f3;	// 
  double f6;	// 
  double f7;	// 
};
/*--------------------------------------------------------------------------*/
class COMMON_BUILT_IN_BJT
  :public COMMON_COMPONENT{
public:
  explicit COMMON_BUILT_IN_BJT(const COMMON_BUILT_IN_BJT& p);
  explicit COMMON_BUILT_IN_BJT(int c=0);
           ~COMMON_BUILT_IN_BJT();
  bool     operator==(const COMMON_COMPONENT&)const;
  COMMON_COMPONENT* clone()const {return new COMMON_BUILT_IN_BJT(*this);}
  void     set_param_by_index(int, std::string&, int);
  bool     param_is_printable(int)const;
  std::string param_name(int)const;
  std::string param_name(int,int)const;
  std::string param_value(int)const;
  int param_count()const {return (5 + COMMON_COMPONENT::param_count());}
  void     precalc_first(const CARD_LIST*);
  void     expand(const COMPONENT*);
  void     precalc_last(const CARD_LIST*);
  std::string name()const {itested();return "bjt";}
  const SDP_CARD* sdp()const {return _sdp;}
  bool     has_sdp()const {untested();return _sdp;}
  static int  count() {return _count;}
private: // strictly internal
  static int _count;
public: // input parameters
  PARAMETER<double> area;	// area factor
  PARAMETER<bool> off;	// device initially off
  PARAMETER<double> icvbe;	// Initial B-E voltage
  PARAMETER<double> icvce;	// Initial C-E voltage
  PARAMETER<double> temp_c;	// instance temperature
public: // calculated parameters
  SDP_CARD* _sdp;
  double oik;	// 
  double oikr;	// 
public: // attached commons
};
/*--------------------------------------------------------------------------*/
class DEV_BUILT_IN_BJT : public BASE_SUBCKT {
private:
  explicit DEV_BUILT_IN_BJT(const DEV_BUILT_IN_BJT& p);
public:
  explicit DEV_BUILT_IN_BJT();
           ~DEV_BUILT_IN_BJT() {--_count;}
private: // override virtual
  char      id_letter()const     {untested();return 'Q';}
  bool      print_type_in_spice()const {return true;}
  std::string value_name()const  {return "area";}
  //std::string dev_type()const;   //BASE_SUBCKT
  int       max_nodes()const     {return 4;}
  int       min_nodes()const     {return 3;}
  //int     matrix_nodes()const; //BASE_SUBCKT
  //int     net_nodes()const;    //BASE_SUBCKT
  int       int_nodes()const     {return 3;}
  CARD*     clone()const         {return new DEV_BUILT_IN_BJT(*this);}
  void      precalc_first() {COMPONENT::precalc_first(); if(subckt()) subckt()->precalc_first();}
  void      expand();
  void      precalc_last()  {COMPONENT::precalc_last(); assert(subckt()); subckt()->precalc_last();}
  //void    map_nodes();         //BASE_SUBCKT
  //void    tr_begin();          //BASE_SUBCKT
  //void    tr_restore();        //BASE_SUBCKT
  void      dc_advance() {set_not_converged(); BASE_SUBCKT::dc_advance();}
  void      tr_advance() {set_not_converged(); BASE_SUBCKT::tr_advance();}
  void      tr_regress() {set_not_converged(); BASE_SUBCKT::tr_regress();}
  bool      tr_needs_eval()const;
  void      tr_queue_eval()      {if(tr_needs_eval()){q_eval();}}
  bool      do_tr();
  //void    tr_load();           //BASE_SUBCKT
  //double  tr_review();         //BASE_SUBCKT
  //void    tr_accept();         //BASE_SUBCKT
  //void    tr_unload();         //BASE_SUBCKT
  double    tr_probe_num(const std::string&)const;
  //void    ac_begin();          //BASE_SUBCKT
  //void    do_ac();             //BASE_SUBCKT
  //void    ac_load();           //BASE_SUBCKT
  //XPROBE  ac_probe_ext(CS&)const;//CKT_BASE/nothing
public:
  static int  count() {return _count;}
public: // may be used by models
private: // not available even to models
  static int _count;
public: // input parameters
public: // calculated parameters
  double vbe;	// B-E voltage
  double vbc;	// B-C voltage
  double vbx;	// B-C voltage (ext base)
  double vcs;	// C-S voltage
  double cce;	// collector-emitter current
  double ccexxx;	// 
  double go;	// Small signal output conductance
  double gm;	// Small signal transconductance
  double cpi;	// emitter-base current
  double cpixxx;	// 
  double gpi;	// Small signal input conductance - pi
  double cmu;	// collector-base current
  double cmuxxx;	// 
  double gmu;	// Small signal conductance - mu
  double ixxxx;	// Current offset at base node, constant
  double gx;	// dix/dvbb Conductance from base to internal base
  double qbx;	// Charge storage B-X junction
  double cqbx;	// Cap. due to charge storage in B-X jct.
  double qbc;	// Charge storage B-C junction
  double cqbc;	// Cap. due to charge storage in B-C jct.
  double qcs;	// Charge storage C-S junction
  double cqcs;	// Cap. due to charge storage in C-S jct.
  double qbe;	// Charge storage B-E junction
  double cqbe;	// Cap. due to charge storage in B-E jct.
  double geqcb;	// d(Ieb)/d(Vcb)
  double cexbc_0;	// Total Capacitance in B-X junction
  double cexbc_1;	// 
  double cexbc_2;	// 
  double _dt_0;	// time step
  double _dt_1;	// 
public: // netlist
  COMPONENT* _Ice;
  COMPONENT* _Ipi;
  COMPONENT* _Imu;
  COMPONENT* _Cbx;
  COMPONENT* _Cbc;
  COMPONENT* _Ccs;
  COMPONENT* _Cbe;
  COMPONENT* _Rc;
  COMPONENT* _Re;
  COMPONENT* _Yb;
  COMPONENT* _Cbcp;
  COMPONENT* _Cbep;
  COMPONENT* _Cbs;
private: // node list
  enum {n_c, n_b, n_e, n_s, n_ic, n_ib, n_ie};
  node_t _nodes[7];
  std::string port_name(int i)const {
    assert(i >= 0);
    assert(i < 4);
    static std::string names[] = {"c", "b", "e", "s", ""};
    return names[i];
  }
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
