/* gmpc-song-links.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-song-links.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <plugin.h>
#include <glib/gstdio.h>
#include <gmpc_easy_download.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _GmpcMetaDataWidgetsSongLinksPrivate {
	GmpcMetaDataWidgetsSongLinksType type;
	mpd_Song* song;
};


extern gboolean initialized;
gboolean initialized = FALSE;
static gpointer gmpc_meta_data_widgets_song_links_parent_class = NULL;

#define use_transition_sl TRUE
#define GMPC_META_DATA_WIDGETS_SONG_LINKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_META_DATA_WIDGETS_TYPE_SONG_LINKS, GmpcMetaDataWidgetsSongLinksPrivate))
enum  {
	GMPC_META_DATA_WIDGETS_SONG_LINKS_DUMMY_PROPERTY
};
#define GMPC_META_DATA_WIDGETS_SONG_LINKS_some_unique_name VERSION
static void gmpc_meta_data_widgets_song_links_open_uri_function (GtkLinkButton* but, const gchar* uri);
static void gmpc_meta_data_widgets_song_links_parse_uris (GmpcMetaDataWidgetsSongLinks* self);
static void _gmpc_meta_data_widgets_song_links_open_uri_function_gtk_link_button_uri_func (GtkLinkButton* button, const gchar* link_, gpointer self);
static void gmpc_meta_data_widgets_song_links_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gmpc_meta_data_widgets_song_links_type_get_type (void) {
	static volatile gsize gmpc_meta_data_widgets_song_links_type_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_data_widgets_song_links_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ARTIST, "GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ARTIST", "artist"}, {GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ALBUM, "GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ALBUM", "album"}, {GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_SONG, "GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_SONG", "song"}, {0, NULL, NULL}};
		GType gmpc_meta_data_widgets_song_links_type_type_id;
		gmpc_meta_data_widgets_song_links_type_type_id = g_enum_register_static ("GmpcMetaDataWidgetsSongLinksType", values);
		g_once_init_leave (&gmpc_meta_data_widgets_song_links_type_type_id__volatile, gmpc_meta_data_widgets_song_links_type_type_id);
	}
	return gmpc_meta_data_widgets_song_links_type_type_id__volatile;
}


static void gmpc_meta_data_widgets_song_links_open_uri_function (GtkLinkButton* but, const gchar* uri) {
	g_return_if_fail (but != NULL);
	g_return_if_fail (uri != NULL);
	open_uri (uri);
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_meta_data_widgets_song_links_open_uri_function_gtk_link_button_uri_func (GtkLinkButton* button, const gchar* link_, gpointer self) {
	gmpc_meta_data_widgets_song_links_open_uri_function (button, link_);
}


GmpcMetaDataWidgetsSongLinks* gmpc_meta_data_widgets_song_links_construct (GType object_type, GmpcMetaDataWidgetsSongLinksType type, const mpd_Song* song) {
	GmpcMetaDataWidgetsSongLinks * self = NULL;
	mpd_Song* _tmp0_;
	GtkEventBox* _tmp1_ = NULL;
	GtkEventBox* event;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* label;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (song != NULL, NULL);
	self = (GmpcMetaDataWidgetsSongLinks*) g_object_new (object_type, NULL);
	g_debug ("gmpc-song-links.vala:53: Links created");
	self->priv->type = type;
	_tmp0_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (self->priv->song);
	self->priv->song = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	event = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) event, (GtkWidget*) label);
	gtk_event_box_set_visible_window (event, FALSE);
	gtk_frame_set_label_widget ((GtkFrame*) self, (GtkWidget*) event);
	_tmp3_ = _ ("Web Links");
	_tmp4_ = g_strdup_printf ("<b>%s:</b>", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (label, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_set ((GtkFrame*) self, "shadow", GTK_SHADOW_NONE, NULL);
	gmpc_meta_data_widgets_song_links_parse_uris (self);
	if (!initialized) {
		gtk_link_button_set_uri_hook (_gmpc_meta_data_widgets_song_links_open_uri_function_gtk_link_button_uri_func, NULL, NULL);
		initialized = TRUE;
	}
	_g_object_unref0 (label);
	_g_object_unref0 (event);
	return self;
}


GmpcMetaDataWidgetsSongLinks* gmpc_meta_data_widgets_song_links_new (GmpcMetaDataWidgetsSongLinksType type, const mpd_Song* song) {
	return gmpc_meta_data_widgets_song_links_construct (GMPC_META_DATA_WIDGETS_TYPE_SONG_LINKS, type, song);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void gmpc_meta_data_widgets_song_links_parse_uris (GmpcMetaDataWidgetsSongLinks* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* child;
	GKeyFile* _tmp2_ = NULL;
	GKeyFile* file;
	gchar* _tmp3_ = NULL;
	gchar* path;
	gboolean _tmp4_;
	GtkAlignment* _tmp7_ = NULL;
	GtkAlignment* ali;
	GtkVBox* _tmp8_ = NULL;
	GtkVBox* vbox;
	gsize _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	child = _tmp1_;
	if (child != NULL) {
		gtk_object_destroy ((GtkObject*) child);
	}
	_tmp2_ = g_key_file_new ();
	file = _tmp2_;
	_tmp3_ = gmpc_get_user_path ("weblinks.list");
	path = _tmp3_;
	_tmp4_ = g_file_test (path, G_FILE_TEST_EXISTS);
	if (!_tmp4_) {
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp5_ = gmpc_get_full_glade_path ("weblinks.list");
		_g_free0 (path);
		path = _tmp5_;
		_tmp6_ = g_file_test (path, G_FILE_TEST_EXISTS);
		if (!_tmp6_) {
			_g_free0 (path);
			_g_key_file_free0 (file);
			_g_object_unref0 (child);
			return;
		}
	}
	g_key_file_load_from_file (file, path, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_key_file_free0 (file);
		_g_object_unref0 (child);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_key_file_free0 (file);
		_g_object_unref0 (child);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 0.0f, 0.0f);
	ali = g_object_ref_sink (_tmp7_);
	gtk_alignment_set_padding (ali, (guint) 8, (guint) 8, (guint) 12, (guint) 6);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) ali);
	_tmp8_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vbox = g_object_ref_sink (_tmp8_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) vbox);
	_tmp10_ = g_key_file_get_groups (file, &_tmp9_);
	groups = _tmp10_;
	groups_length1 = _tmp9_;
	_groups_size_ = _tmp9_;
	{
		gchar** entry_collection;
		int entry_collection_length1;
		int entry_it;
		entry_collection = groups;
		entry_collection_length1 = groups_length1;
		for (entry_it = 0; entry_it < groups_length1; entry_it = entry_it + 1) {
			gchar* _tmp11_;
			gchar* entry;
			_tmp11_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp11_;
			{
				gchar* _tmp12_ = NULL;
				gchar* typestr;
				gchar* _tmp13_ = NULL;
				gchar* uri;
				GmpcMetaDataWidgetsSongLinksType type = 0;
				const gchar* _tmp14_;
				GQuark _tmp15_;
				static GQuark _tmp15__label0 = 0;
				static GQuark _tmp15__label1 = 0;
				gchar* _tmp34_ = NULL;
				gchar* sar;
				_tmp12_ = g_key_file_get_string (file, entry, "type", &_inner_error_);
				typestr = _tmp12_;
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				_tmp13_ = g_key_file_get_string (file, entry, "url", &_inner_error_);
				uri = _tmp13_;
				if (_inner_error_ != NULL) {
					_g_free0 (typestr);
					goto __catch1_g_error;
				}
				_tmp14_ = typestr;
				_tmp15_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
				if (_tmp15_ == ((0 != _tmp15__label0) ? _tmp15__label0 : (_tmp15__label0 = g_quark_from_static_string ("artist")))) {
					switch (0) {
						default:
						{
							type = GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ARTIST;
							if (self->priv->song->artist != NULL) {
								gchar* _tmp16_ = NULL;
								gchar* _tmp17_;
								gchar* _tmp18_ = NULL;
								_tmp16_ = gmpc_easy_download_uri_escape (self->priv->song->artist);
								_tmp17_ = _tmp16_;
								_tmp18_ = string_replace (uri, "%ARTIST%", _tmp17_);
								_g_free0 (uri);
								uri = _tmp18_;
								_g_free0 (_tmp17_);
							}
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp15__label1) ? _tmp15__label1 : (_tmp15__label1 = g_quark_from_static_string ("album")))) {
					switch (0) {
						default:
						{
							type = GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ALBUM;
							if (self->priv->song->album != NULL) {
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_;
								gchar* _tmp21_ = NULL;
								_tmp19_ = gmpc_easy_download_uri_escape (self->priv->song->album);
								_tmp20_ = _tmp19_;
								_tmp21_ = string_replace (uri, "%ALBUM%", _tmp20_);
								_g_free0 (uri);
								uri = _tmp21_;
								_g_free0 (_tmp20_);
							}
							if (self->priv->song->artist != NULL) {
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_;
								gchar* _tmp24_ = NULL;
								_tmp22_ = gmpc_easy_download_uri_escape (self->priv->song->artist);
								_tmp23_ = _tmp22_;
								_tmp24_ = string_replace (uri, "%ARTIST%", _tmp23_);
								_g_free0 (uri);
								uri = _tmp24_;
								_g_free0 (_tmp23_);
							}
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							type = GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_SONG;
							if (self->priv->song->title != NULL) {
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_;
								gchar* _tmp27_ = NULL;
								_tmp25_ = gmpc_easy_download_uri_escape (self->priv->song->title);
								_tmp26_ = _tmp25_;
								_tmp27_ = string_replace (uri, "%TITLE%", _tmp26_);
								_g_free0 (uri);
								uri = _tmp27_;
								_g_free0 (_tmp26_);
							}
							if (self->priv->song->album != NULL) {
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								gchar* _tmp30_ = NULL;
								_tmp28_ = gmpc_easy_download_uri_escape (self->priv->song->album);
								_tmp29_ = _tmp28_;
								_tmp30_ = string_replace (uri, "%ALBUM%", _tmp29_);
								_g_free0 (uri);
								uri = _tmp30_;
								_g_free0 (_tmp29_);
							}
							if (self->priv->song->artist != NULL) {
								gchar* _tmp31_ = NULL;
								gchar* _tmp32_;
								gchar* _tmp33_ = NULL;
								_tmp31_ = gmpc_easy_download_uri_escape (self->priv->song->artist);
								_tmp32_ = _tmp31_;
								_tmp33_ = string_replace (uri, "%ARTIST%", _tmp32_);
								_g_free0 (uri);
								uri = _tmp33_;
								_g_free0 (_tmp32_);
							}
							break;
						}
					}
				}
				_tmp34_ = g_key_file_get_string (file, entry, "search-and-replace", &_inner_error_);
				sar = _tmp34_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				if (sar != NULL) {
					gchar** _tmp35_;
					gchar** _tmp36_ = NULL;
					gchar** s;
					gint s_length1;
					gint _s_size_;
					_tmp36_ = _tmp35_ = g_strsplit (sar, "::", 0);
					s = _tmp36_;
					s_length1 = _vala_array_length (_tmp35_);
					_s_size_ = _vala_array_length (_tmp35_);
					if (s_length1 == 2) {
						GRegex* _tmp37_ = NULL;
						GRegex* regex;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						_tmp37_ = g_regex_new (s[0], 0, 0, &_inner_error_);
						regex = _tmp37_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch4_g_regex_error;
							}
							s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (sar);
							_g_free0 (uri);
							_g_free0 (typestr);
							_g_free0 (entry);
							groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (vbox);
							_g_object_unref0 (ali);
							_g_free0 (path);
							_g_key_file_free0 (file);
							_g_object_unref0 (child);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp38_ = g_regex_replace_literal (regex, uri, (gssize) (-1), 0, s[1], 0, &_inner_error_);
						_tmp39_ = _tmp38_;
						if (_inner_error_ != NULL) {
							_g_regex_unref0 (regex);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch4_g_regex_error;
							}
							_g_regex_unref0 (regex);
							s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (sar);
							_g_free0 (uri);
							_g_free0 (typestr);
							_g_free0 (entry);
							groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (vbox);
							_g_object_unref0 (ali);
							_g_free0 (path);
							_g_key_file_free0 (file);
							_g_object_unref0 (child);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_free0 (uri);
						uri = _tmp39_;
						_g_regex_unref0 (regex);
						goto __finally4;
						__catch4_g_regex_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							g_debug ("gmpc-song-links.vala:147: Failed to compile regex: '%s'\n", e->message);
							_g_error_free0 (e);
						}
						__finally4:
						if (_inner_error_ != NULL) {
							s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (sar);
							goto __catch3_g_error;
						}
					}
					s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (sar);
				goto __finally3;
				__catch3_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_free0 (uri);
					_g_free0 (typestr);
					goto __catch1_g_error;
				}
				if (((gint) type) <= ((gint) self->priv->type)) {
					GtkLinkButton* _tmp40_ = NULL;
					GtkLinkButton* label;
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_;
					_tmp40_ = (GtkLinkButton*) gtk_link_button_new (uri);
					label = g_object_ref_sink (_tmp40_);
					_tmp41_ = _ ("Lookup %s on %s");
					_tmp42_ = _ (typestr);
					_tmp43_ = g_strdup_printf (_tmp41_, _tmp42_, entry);
					_tmp44_ = _tmp43_;
					gtk_button_set_label ((GtkButton*) label, _tmp44_);
					_g_free0 (_tmp44_);
					gtk_button_set_alignment ((GtkButton*) label, 0.0f, 0.5f);
					gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
					_g_object_unref0 (label);
				}
				_g_free0 (uri);
				_g_free0 (typestr);
				goto __finally1;
				__catch1_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("gmpc-song-links.vala:163: Failed to get entry from %s: '%s'\n", path, e->message);
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_free0 (entry);
					groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (vbox);
					_g_object_unref0 (ali);
					_g_free0 (path);
					_g_key_file_free0 (file);
					_g_object_unref0 (child);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (entry);
			}
		}
	}
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (vbox);
	_g_object_unref0 (ali);
	_g_free0 (path);
	_g_key_file_free0 (file);
	_g_object_unref0 (child);
}


static void gmpc_meta_data_widgets_song_links_class_init (GmpcMetaDataWidgetsSongLinksClass * klass) {
	gmpc_meta_data_widgets_song_links_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaDataWidgetsSongLinksPrivate));
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_data_widgets_song_links_finalize;
}


static void gmpc_meta_data_widgets_song_links_instance_init (GmpcMetaDataWidgetsSongLinks * self) {
	self->priv = GMPC_META_DATA_WIDGETS_SONG_LINKS_GET_PRIVATE (self);
	self->priv->type = GMPC_META_DATA_WIDGETS_SONG_LINKS_TYPE_ARTIST;
	self->priv->song = NULL;
}


static void gmpc_meta_data_widgets_song_links_finalize (GObject* obj) {
	GmpcMetaDataWidgetsSongLinks * self;
	self = GMPC_META_DATA_WIDGETS_SONG_LINKS (obj);
	_mpd_freeSong0 (self->priv->song);
	G_OBJECT_CLASS (gmpc_meta_data_widgets_song_links_parent_class)->finalize (obj);
}


GType gmpc_meta_data_widgets_song_links_get_type (void) {
	static volatile gsize gmpc_meta_data_widgets_song_links_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_data_widgets_song_links_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaDataWidgetsSongLinksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_data_widgets_song_links_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaDataWidgetsSongLinks), 0, (GInstanceInitFunc) gmpc_meta_data_widgets_song_links_instance_init, NULL };
		GType gmpc_meta_data_widgets_song_links_type_id;
		gmpc_meta_data_widgets_song_links_type_id = g_type_register_static (GTK_TYPE_FRAME, "GmpcMetaDataWidgetsSongLinks", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_meta_data_widgets_song_links_type_id__volatile, gmpc_meta_data_widgets_song_links_type_id);
	}
	return gmpc_meta_data_widgets_song_links_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



