// 2005-08-26  Paolo Carlini  <pcarlini@suse.de>
//
// Copyright (C) 2005-2017 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// 6.2.2 Class template array

#include <tr1/array>
#include <testsuite_hooks.h>

void
test01()
{
  using namespace std::tr1;

  const size_t len = 5;
  typedef array<int, len> array_type;

  {
    array_type a = { { 0, 1, 2, 3, 4 } };
    int& ri = get<0>(a);
    VERIFY( ri == 0 );
  }

  {
    const array_type a = { { 4, 3, 2, 1, 0 } };
    const int& cri = get<1>(a);
    VERIFY( cri == 3 );
  }
}

int main()
{
  test01();
  return 0;
}
