# In Cygwin, the user has admin rights if they're a member of group 544
# (Administrators). For discussion see the thread beginning at
# https://cygwin.com/ml/cygwin/2016-03/msg00255.html. Also per the discussion at
# https://superuser.com/a/874615/97499, group 114 (Local account and member of
# Administrator group) is sometimes present.
#
# Cache the result for each shell instance, to avoid running id each time. That
# could be slow, especially in a prompt, since it may need network traffic.

if not set -q __fish_is_root_user
	set -g __fish_is_root_user (id -G | grep -qE '\<(114|544)\>'; and echo yes; or echo no)
end

function fish_is_root_user --description "True if the user has admin privileges, else false"
	test $__fish_is_root_user = yes
end
