/* CompletionTextView.c generated by valac 0.38.7, the Vala compiler
 * generated from CompletionTextView.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbUserCompletionModel.h"
#include "CbUtils.h"
#include "CbSnippetManager.h"
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "libtl/libtweetlength.h"
#include "CbUserCounter.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbFilter.h"
#include <sqlite3.h>
#include "rest/rest-proxy.h"
#include "CbTypes.h"
#include <glib/gi18n-lib.h>
#include <gspell/gspell.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;
typedef struct _CompletionTextViewPrivate CompletionTextViewPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
enum  {
	COMPLETION_TEXT_VIEW_0_PROPERTY,
	COMPLETION_TEXT_VIEW_COMPLETION_LISTBOX_PROPERTY,
	COMPLETION_TEXT_VIEW_NUM_PROPERTIES
};
static GParamSpec* completion_text_view_properties[COMPLETION_TEXT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_COMPLETION_ROW (user_completion_row_get_type ())
#define USER_COMPLETION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COMPLETION_ROW, UserCompletionRow))
#define USER_COMPLETION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COMPLETION_ROW, UserCompletionRowClass))
#define IS_USER_COMPLETION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COMPLETION_ROW))
#define IS_USER_COMPLETION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COMPLETION_ROW))
#define USER_COMPLETION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COMPLETION_ROW, UserCompletionRowClass))

typedef struct _UserCompletionRow UserCompletionRow;
typedef struct _UserCompletionRowClass UserCompletionRowClass;
typedef struct _Block51Data Block51Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	COMPLETION_TEXT_VIEW_SHOW_COMPLETION_SIGNAL,
	COMPLETION_TEXT_VIEW_HIDE_COMPLETION_SIGNAL,
	COMPLETION_TEXT_VIEW_UPDATE_COMPLETION_SIGNAL,
	COMPLETION_TEXT_VIEW_NUM_SIGNALS
};
static guint completion_text_view_signals[COMPLETION_TEXT_VIEW_NUM_SIGNALS] = {0};
typedef struct _UserCompletionRowPrivate UserCompletionRowPrivate;
enum  {
	USER_COMPLETION_ROW_0_PROPERTY,
	USER_COMPLETION_ROW_NUM_PROPERTIES
};
static GParamSpec* user_completion_row_properties[USER_COMPLETION_ROW_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CompletionTextView {
	GtkTextView parent_instance;
	CompletionTextViewPrivate * priv;
};

struct _CompletionTextViewClass {
	GtkTextViewClass parent_class;
};

struct _CompletionTextViewPrivate {
	GtkWindow* completion_window;
	gint current_match;
	gchar* current_word;
	GCancellable* completion_cancellable;
	gboolean _default_listbox;
	GtkListBox* completion_list;
	CbUserCompletionModel* completion_model;
	Account* account;
};

struct _Block51Data {
	int _ref_count_;
	CompletionTextView* self;
	gboolean corpus_was_empty;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _UserCompletionRow {
	GtkListBoxRow parent_instance;
	UserCompletionRowPrivate * priv;
};

struct _UserCompletionRowClass {
	GtkListBoxRowClass parent_class;
};

struct _UserCompletionRowPrivate {
	GtkLabel* user_name_label;
	GtkLabel* screen_name_label;
};


static gpointer completion_text_view_parent_class = NULL;
extern CbSnippetManager* corebird_snippet_manager;
static gpointer user_completion_row_parent_class = NULL;
static cairo_surface_t* user_completion_row_verified_surface;
static cairo_surface_t* user_completion_row_verified_surface = NULL;

GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COMPLETION_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewPrivate))
#define COMPLETION_TEXT_VIEW_NO_SPELL_CHECK "gtksourceview:context-classes:no-spell-check"
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static gboolean completion_text_view_insert_snippet (CompletionTextView* self);
static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self);
static void completion_text_view_select_completion_row (CompletionTextView* self, GtkListBoxRow* row);
static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt);
GType user_completion_row_get_type (void) G_GNUC_CONST;
gchar* user_completion_row_get_screen_name (UserCompletionRow* self);
static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl);
static void completion_text_view_hide_completion_window (CompletionTextView* self);
static void completion_text_view_buffer_changed_cb (CompletionTextView* self);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
static void completion_text_view_show_completion_window (CompletionTextView* self);
static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self);
static void completion_text_view_update_completion_listbox (CompletionTextView* self);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length);
static void ___lambda31_ (Block51Data* _data51_, GObject* obj, GAsyncResult* res);
static void _vala_CbUserIdentity_array_free (CbUserIdentity * array, gint array_length);
static void ____lambda31__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GtkWidget* completion_text_view_create_completion_row (CompletionTextView* self, void* id_ptr);
UserCompletionRow* user_completion_row_new (gint64 id, const gchar* user_name, const gchar* screen_name, gboolean verified);
UserCompletionRow* user_completion_row_construct (GType object_type, gint64 id, const gchar* user_name, const gchar* screen_name, gboolean verified);
CompletionTextView* completion_text_view_new (void);
CompletionTextView* completion_text_view_construct (GType object_type);
void completion_text_view_set_completion_listbox (CompletionTextView* self, GtkListBox* value);
static GtkWidget* _completion_text_view_create_completion_row_cbutils_createwidgetfunc (void* item, gpointer self);
static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _completion_text_view_update_completion_listbox_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void completion_text_view_finalize (GObject * obj);
static void _vala_completion_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define USER_COMPLETION_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_COMPLETION_ROW, UserCompletionRowPrivate))
static void user_completion_row_finalize (GObject * obj);

static const gchar* COMPLETION_TEXT_VIEW_TEXT_TAGS[4] = {"link", "mention", "hashtag", "snippet"};

void completion_text_view_set_account (CompletionTextView* self, Account* account) {
	Account* _tmp0_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean completion_text_view_insert_snippet (CompletionTextView* self) {
	gboolean result = FALSE;
	GtkTextIter cursor_word_start = {0};
	GtkTextIter cursor_word_end = {0};
	gchar* cursor_word = NULL;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gunichar _tmp6_;
	gchar* snippet = NULL;
	CbSnippetManager* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkTextIter start_word_iter = {0};
	GtkTextBuffer* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* _tmp24_;
	GtkTextBuffer* _tmp25_;
	GtkTextIter _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp28_;
	GtkTextBuffer* _tmp29_;
	GtkTextMark* _tmp30_;
	GtkTextMark* _tmp31_;
	GtkTextBuffer* _tmp32_;
	GtkTextBuffer* _tmp33_;
	GtkTextMark* _tmp34_;
	GtkTextIter _tmp35_ = {0};
	GtkTextBuffer* _tmp36_;
	GtkTextBuffer* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GtkTextBuffer* _tmp42_;
	GtkTextBuffer* _tmp43_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp2_ = completion_text_view_get_cursor_word (self, &_tmp0_, &_tmp1_);
	cursor_word_start = _tmp0_;
	cursor_word_end = _tmp1_;
	cursor_word = _tmp2_;
	_tmp5_ = cursor_word;
	_tmp6_ = string_get_char (_tmp5_, (glong) 0);
	if (_tmp6_ == ((gunichar) ' ')) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_;
		gunichar _tmp8_;
		_tmp7_ = cursor_word;
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
		_tmp4_ = _tmp8_ == ((gunichar) '\t');
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gunichar _tmp10_;
		_tmp9_ = cursor_word;
		_tmp10_ = string_get_char (_tmp9_, (glong) 0);
		_tmp3_ = _tmp10_ == ((gunichar) '\n');
	}
	if (_tmp3_) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = cursor_word;
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
		_g_free0 (cursor_word);
		cursor_word = _tmp12_;
		gtk_text_iter_forward_char (&cursor_word_start);
	}
	_tmp13_ = corebird_snippet_manager;
	_tmp14_ = cursor_word;
	_tmp15_ = string_strip (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = cb_snippet_manager_get_snippet (_tmp13_, _tmp16_);
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp16_);
	snippet = _tmp19_;
	_tmp20_ = snippet;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_;
		_tmp21_ = cursor_word;
		g_debug ("CompletionTextView.vala:152: No snippet for cursor_word '%s' found.", _tmp21_);
		result = FALSE;
		_g_free0 (snippet);
		_g_free0 (cursor_word);
		return result;
	}
	_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp23_ = _tmp22_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, G_TYPE_OBJECT, GObject));
	_tmp24_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp25_ = _tmp24_;
	_tmp26_ = cursor_word_start;
	_tmp27_ = cursor_word_end;
	g_signal_emit_by_name (_tmp25_, "delete-range", &_tmp26_, &_tmp27_);
	_tmp28_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp29_ = _tmp28_;
	_tmp30_ = gtk_text_buffer_get_insert (_tmp29_);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	cursor_mark = _tmp31_;
	_tmp32_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp33_ = _tmp32_;
	_tmp34_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp33_, &_tmp35_, _tmp34_);
	start_word_iter = _tmp35_;
	_tmp36_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp37_ = _tmp36_;
	_tmp38_ = snippet;
	_tmp39_ = snippet;
	_tmp40_ = strlen (_tmp39_);
	_tmp41_ = _tmp40_;
	g_signal_emit_by_name (_tmp37_, "insert-text", &start_word_iter, _tmp38_, _tmp41_);
	_tmp42_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp43_ = _tmp42_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, G_TYPE_OBJECT, GObject));
	result = TRUE;
	_g_object_unref0 (cursor_mark);
	_g_free0 (snippet);
	_g_free0 (cursor_word);
	return result;
}


static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self) {
	gboolean result = FALSE;
	CbSnippetManager* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = corebird_snippet_manager;
	_tmp1_ = cb_snippet_manager_n_snippets (_tmp0_);
	result = _tmp1_ > ((guint) 0);
	return result;
}


static void completion_text_view_select_completion_row (CompletionTextView* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkContainer* _tmp2_;
	GtkListBox* _tmp3_;
	GtkAllocation alloc = {0};
	GtkListBoxRow* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	GtkListBox* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GtkViewport* viewport = NULL;
	GtkListBox* _tmp8_;
	GtkContainer* _tmp9_;
	GtkViewport* _tmp10_;
	GtkViewport* _tmp11_;
	GtkScrolledWindow* scroller = NULL;
	GtkViewport* _tmp12_;
	GtkContainer* _tmp13_;
	GtkScrolledWindow* _tmp14_;
	GtkScrolledWindow* _tmp15_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail ((row == NULL) || GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = row;
	_tmp2_ = (GtkContainer*) gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->completion_list;
	_vala_assert (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), "row.get_parent () == completion_list");
	_tmp4_ = row;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), &_tmp5_);
	alloc = _tmp5_;
	_tmp6_ = self->priv->completion_list;
	_tmp7_ = row;
	gtk_list_box_select_row (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->completion_list;
	_tmp9_ = (GtkContainer*) gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_viewport_get_type ()) ? ((GtkViewport*) _tmp9_) : NULL);
	viewport = _tmp10_;
	_tmp11_ = viewport;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (viewport);
		return;
	}
	_tmp12_ = viewport;
	_tmp13_ = (GtkContainer*) gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp13_) : NULL);
	scroller = _tmp14_;
	_tmp15_ = scroller;
	if (_tmp15_ != NULL) {
		GtkAdjustment* adjustment = NULL;
		GtkScrolledWindow* _tmp16_;
		GtkAdjustment* _tmp17_;
		GtkAdjustment* _tmp18_;
		GtkAdjustment* _tmp19_;
		GtkAllocation _tmp20_;
		gint _tmp21_;
		GtkAllocation _tmp22_;
		gint _tmp23_;
		GtkAllocation _tmp24_;
		gint _tmp25_;
		_tmp16_ = scroller;
		_tmp17_ = gtk_scrolled_window_get_vadjustment (_tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		adjustment = _tmp18_;
		_tmp19_ = adjustment;
		_tmp20_ = alloc;
		_tmp21_ = _tmp20_.y;
		_tmp22_ = alloc;
		_tmp23_ = _tmp22_.y;
		_tmp24_ = alloc;
		_tmp25_ = _tmp24_.height;
		gtk_adjustment_clamp_page (_tmp19_, (gdouble) _tmp21_, (gdouble) (_tmp23_ + _tmp25_));
		_g_object_unref0 (adjustment);
	}
	_g_object_unref0 (scroller);
	_g_object_unref0 (viewport);
}


static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	GtkListBox* _tmp5_;
	gboolean _tmp6_;
	gint n_results = 0;
	CbUserCompletionModel* _tmp7_;
	guint _tmp8_;
	GdkEventKey* _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Tab)) {
		gboolean _tmp3_;
		_tmp3_ = completion_text_view_snippets_configured (self);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_;
		_tmp4_ = completion_text_view_insert_snippet (self);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->completion_list;
	_tmp6_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	if (!_tmp6_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp7_ = self->priv->completion_model;
	_tmp8_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_list_model_get_type (), GListModel));
	n_results = (gint) _tmp8_;
	_tmp9_ = evt;
	_tmp10_ = _tmp9_->keyval;
	switch (_tmp10_) {
		case GDK_KEY_Down:
		{
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp14_;
			gint _tmp15_;
			GtkListBoxRow* _tmp16_;
			GtkListBoxRow* _tmp17_;
			gboolean _tmp18_;
			GtkListBoxRow* _tmp20_;
			_tmp11_ = n_results;
			if (_tmp11_ == 0) {
				result = GDK_EVENT_PROPAGATE;
				return result;
			}
			_tmp12_ = self->priv->current_match;
			_tmp13_ = n_results;
			self->priv->current_match = (_tmp12_ + 1) % _tmp13_;
			_tmp14_ = self->priv->completion_list;
			_tmp15_ = self->priv->current_match;
			_tmp16_ = gtk_list_box_get_row_at_index (_tmp14_, _tmp15_);
			_tmp17_ = _g_object_ref0 (_tmp16_);
			row = _tmp17_;
			_tmp18_ = self->priv->_default_listbox;
			if (_tmp18_) {
				GtkListBoxRow* _tmp19_;
				_tmp19_ = row;
				gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
			}
			_tmp20_ = row;
			completion_text_view_select_completion_row (self, _tmp20_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (row);
			return result;
		}
		case GDK_KEY_Up:
		{
			gint _tmp21_;
			gint _tmp22_;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp24_;
			gint _tmp25_;
			GtkListBoxRow* _tmp26_;
			GtkListBoxRow* _tmp27_;
			gboolean _tmp28_;
			GtkListBoxRow* _tmp30_;
			_tmp21_ = self->priv->current_match;
			self->priv->current_match = _tmp21_ - 1;
			_tmp22_ = self->priv->current_match;
			if (_tmp22_ < 0) {
				gint _tmp23_;
				_tmp23_ = n_results;
				self->priv->current_match = _tmp23_ - 1;
			}
			_tmp24_ = self->priv->completion_list;
			_tmp25_ = self->priv->current_match;
			_tmp26_ = gtk_list_box_get_row_at_index (_tmp24_, _tmp25_);
			_tmp27_ = _g_object_ref0 (_tmp26_);
			row = _tmp27_;
			_tmp28_ = self->priv->_default_listbox;
			if (_tmp28_) {
				GtkListBoxRow* _tmp29_;
				_tmp29_ = row;
				gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
			}
			_tmp30_ = row;
			completion_text_view_select_completion_row (self, _tmp30_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (row);
			return result;
		}
		case GDK_KEY_Return:
		{
			gint _tmp31_;
			gint _tmp32_;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp33_;
			gint _tmp34_;
			GtkListBoxRow* _tmp35_;
			GtkListBoxRow* _tmp36_;
			GtkListBoxRow* _tmp37_;
			gchar* compl = NULL;
			GtkListBoxRow* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp31_ = n_results;
			if (_tmp31_ == 0) {
				result = GDK_EVENT_PROPAGATE;
				return result;
			}
			_tmp32_ = self->priv->current_match;
			if (_tmp32_ == -1) {
				self->priv->current_match = 0;
			}
			_tmp33_ = self->priv->completion_list;
			_tmp34_ = self->priv->current_match;
			_tmp35_ = gtk_list_box_get_row_at_index (_tmp33_, _tmp34_);
			_tmp36_ = _g_object_ref0 (_tmp35_);
			row = _tmp36_;
			_tmp37_ = row;
			_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, TYPE_USER_COMPLETION_ROW), "row is UserCompletionRow");
			_tmp38_ = row;
			_tmp39_ = user_completion_row_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_USER_COMPLETION_ROW, UserCompletionRow));
			compl = _tmp39_;
			_tmp40_ = compl;
			_tmp41_ = string_substring (_tmp40_, (glong) 1, (glong) -1);
			_tmp42_ = _tmp41_;
			completion_text_view_insert_completion (self, _tmp42_);
			_g_free0 (_tmp42_);
			self->priv->current_match = -1;
			completion_text_view_hide_completion_window (self);
			result = GDK_EVENT_STOP;
			_g_free0 (compl);
			_g_object_unref0 (row);
			return result;
		}
		case GDK_KEY_Escape:
		{
			completion_text_view_hide_completion_window (self);
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		{
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static void completion_text_view_buffer_changed_cb (CompletionTextView* self) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextTagTable* tag_table = NULL;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextTagTable* _tmp12_;
	GtkTextTagTable* _tmp13_;
	gchar* text = NULL;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	GtkTextIter* _tmp29_;
	GtkTextIter* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
	gchar* _tmp33_;
	gsize text_length = 0UL;
	TlEntity* entities = NULL;
	const gchar* _tmp34_;
	gsize _tmp35_ = 0UL;
	gint _tmp36_;
	TlEntity* _tmp37_;
	gint entities_length1;
	gint _entities_size_;
	TlEntity* _tmp38_;
	gint _tmp38__length1;
	GtkTextBuffer* _tmp111_;
	GtkTextBuffer* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gint _tmp116_;
	gint _tmp117_;
	gboolean _tmp118_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	_g_free0 (start_iter);
	_tmp3_ = _tmp2_;
	_tmp4_ = __gtk_text_iter_dup0 (&_tmp3_);
	start_iter = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_end_iter (_tmp6_, &_tmp7_);
	_g_free0 (end_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
	end_iter = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_buffer_get_tag_table (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	tag_table = _tmp13_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				GtkTextBuffer* _tmp17_;
				GtkTextBuffer* _tmp18_;
				GtkTextTagTable* _tmp19_;
				gint _tmp20_;
				const gchar* _tmp21_;
				GtkTextTag* _tmp22_;
				GtkTextIter* _tmp23_;
				GtkTextIter* _tmp24_;
				GtkTextIter _tmp25_;
				GtkTextIter _tmp26_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (COMPLETION_TEXT_VIEW_TEXT_TAGS))) {
					break;
				}
				_tmp17_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
				_tmp18_ = _tmp17_;
				_tmp19_ = tag_table;
				_tmp20_ = i;
				_tmp21_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[_tmp20_];
				_tmp22_ = gtk_text_tag_table_lookup (_tmp19_, _tmp21_);
				_tmp23_ = start_iter;
				_tmp24_ = end_iter;
				_tmp25_ = *_tmp23_;
				_tmp26_ = *_tmp24_;
				gtk_text_buffer_remove_tag (_tmp18_, _tmp22_, &_tmp25_, &_tmp26_);
			}
		}
	}
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	_tmp29_ = start_iter;
	_tmp30_ = end_iter;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	_tmp33_ = gtk_text_buffer_get_text (_tmp28_, &_tmp31_, &_tmp32_, TRUE);
	text = _tmp33_;
	_tmp34_ = text;
	_tmp37_ = tl_extract_entities_and_text (_tmp34_, &_tmp36_, &_tmp35_);
	text_length = _tmp35_;
	entities = _tmp37_;
	entities_length1 = _tmp36_;
	_entities_size_ = entities_length1;
	_tmp38_ = entities;
	_tmp38__length1 = entities_length1;
	{
		TlEntity* e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp38_;
		e_collection_length1 = _tmp38__length1;
		for (e_it = 0; e_it < _tmp38__length1; e_it = e_it + 1) {
			TlEntity e = {0};
			e = e_collection[e_it];
			{
				GtkTextIter* e_start_iter = NULL;
				GtkTextIter* e_end_iter = NULL;
				GtkTextBuffer* _tmp39_;
				GtkTextBuffer* _tmp40_;
				TlEntity _tmp41_;
				gsize _tmp42_;
				GtkTextIter _tmp43_ = {0};
				GtkTextIter _tmp44_;
				GtkTextIter* _tmp45_;
				GtkTextBuffer* _tmp46_;
				GtkTextBuffer* _tmp47_;
				TlEntity _tmp48_;
				gsize _tmp49_;
				TlEntity _tmp50_;
				gsize _tmp51_;
				GtkTextIter _tmp52_ = {0};
				GtkTextIter _tmp53_;
				GtkTextIter* _tmp54_;
				TlEntity _tmp55_;
				TlEntityType _tmp56_;
				_tmp39_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
				_tmp40_ = _tmp39_;
				_tmp41_ = e;
				_tmp42_ = _tmp41_.start_character_index;
				gtk_text_buffer_get_iter_at_offset (_tmp40_, &_tmp43_, (gint) _tmp42_);
				_g_free0 (e_start_iter);
				_tmp44_ = _tmp43_;
				_tmp45_ = __gtk_text_iter_dup0 (&_tmp44_);
				e_start_iter = _tmp45_;
				_tmp46_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
				_tmp47_ = _tmp46_;
				_tmp48_ = e;
				_tmp49_ = _tmp48_.start_character_index;
				_tmp50_ = e;
				_tmp51_ = _tmp50_.length_in_characters;
				gtk_text_buffer_get_iter_at_offset (_tmp47_, &_tmp52_, (gint) (_tmp49_ + _tmp51_));
				_g_free0 (e_end_iter);
				_tmp53_ = _tmp52_;
				_tmp54_ = __gtk_text_iter_dup0 (&_tmp53_);
				e_end_iter = _tmp54_;
				_tmp55_ = e;
				_tmp56_ = _tmp55_.type;
				switch (_tmp56_) {
					case TL_ENT_HASHTAG:
					{
						GtkTextBuffer* _tmp57_;
						GtkTextBuffer* _tmp58_;
						GtkTextIter* _tmp59_;
						GtkTextIter* _tmp60_;
						GtkTextIter _tmp61_;
						GtkTextIter _tmp62_;
						GtkTextBuffer* _tmp63_;
						GtkTextBuffer* _tmp64_;
						GtkTextIter* _tmp65_;
						GtkTextIter* _tmp66_;
						GtkTextIter _tmp67_;
						GtkTextIter _tmp68_;
						_tmp57_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp58_ = _tmp57_;
						_tmp59_ = e_start_iter;
						_tmp60_ = e_end_iter;
						_tmp61_ = *_tmp59_;
						_tmp62_ = *_tmp60_;
						gtk_text_buffer_apply_tag_by_name (_tmp58_, COMPLETION_TEXT_VIEW_NO_SPELL_CHECK, &_tmp61_, &_tmp62_);
						_tmp63_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp64_ = _tmp63_;
						_tmp65_ = e_start_iter;
						_tmp66_ = e_end_iter;
						_tmp67_ = *_tmp65_;
						_tmp68_ = *_tmp66_;
						gtk_text_buffer_apply_tag_by_name (_tmp64_, "hashtag", &_tmp67_, &_tmp68_);
						break;
					}
					case TL_ENT_MENTION:
					{
						GtkTextBuffer* _tmp69_;
						GtkTextBuffer* _tmp70_;
						GtkTextIter* _tmp71_;
						GtkTextIter* _tmp72_;
						GtkTextIter _tmp73_;
						GtkTextIter _tmp74_;
						GtkTextBuffer* _tmp75_;
						GtkTextBuffer* _tmp76_;
						GtkTextIter* _tmp77_;
						GtkTextIter* _tmp78_;
						GtkTextIter _tmp79_;
						GtkTextIter _tmp80_;
						_tmp69_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp70_ = _tmp69_;
						_tmp71_ = e_start_iter;
						_tmp72_ = e_end_iter;
						_tmp73_ = *_tmp71_;
						_tmp74_ = *_tmp72_;
						gtk_text_buffer_apply_tag_by_name (_tmp70_, COMPLETION_TEXT_VIEW_NO_SPELL_CHECK, &_tmp73_, &_tmp74_);
						_tmp75_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp76_ = _tmp75_;
						_tmp77_ = e_start_iter;
						_tmp78_ = e_end_iter;
						_tmp79_ = *_tmp77_;
						_tmp80_ = *_tmp78_;
						gtk_text_buffer_apply_tag_by_name (_tmp76_, "mention", &_tmp79_, &_tmp80_);
						break;
					}
					case TL_ENT_LINK:
					{
						GtkTextBuffer* _tmp81_;
						GtkTextBuffer* _tmp82_;
						GtkTextIter* _tmp83_;
						GtkTextIter* _tmp84_;
						GtkTextIter _tmp85_;
						GtkTextIter _tmp86_;
						GtkTextBuffer* _tmp87_;
						GtkTextBuffer* _tmp88_;
						GtkTextIter* _tmp89_;
						GtkTextIter* _tmp90_;
						GtkTextIter _tmp91_;
						GtkTextIter _tmp92_;
						_tmp81_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp82_ = _tmp81_;
						_tmp83_ = e_start_iter;
						_tmp84_ = e_end_iter;
						_tmp85_ = *_tmp83_;
						_tmp86_ = *_tmp84_;
						gtk_text_buffer_apply_tag_by_name (_tmp82_, COMPLETION_TEXT_VIEW_NO_SPELL_CHECK, &_tmp85_, &_tmp86_);
						_tmp87_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
						_tmp88_ = _tmp87_;
						_tmp89_ = e_start_iter;
						_tmp90_ = e_end_iter;
						_tmp91_ = *_tmp89_;
						_tmp92_ = *_tmp90_;
						gtk_text_buffer_apply_tag_by_name (_tmp88_, "link", &_tmp91_, &_tmp92_);
						break;
					}
					case TL_ENT_TEXT:
					{
						CbSnippetManager* _tmp93_;
						TlEntity _tmp94_;
						const gchar* _tmp95_;
						TlEntity _tmp96_;
						gsize _tmp97_;
						gboolean _tmp98_;
						_tmp93_ = corebird_snippet_manager;
						_tmp94_ = e;
						_tmp95_ = _tmp94_.start;
						_tmp96_ = e;
						_tmp97_ = _tmp96_.length_in_bytes;
						_tmp98_ = cb_snippet_manager_has_snippet_n (_tmp93_, _tmp95_, _tmp97_);
						if (_tmp98_) {
							GtkTextBuffer* _tmp99_;
							GtkTextBuffer* _tmp100_;
							GtkTextIter* _tmp101_;
							GtkTextIter* _tmp102_;
							GtkTextIter _tmp103_;
							GtkTextIter _tmp104_;
							GtkTextBuffer* _tmp105_;
							GtkTextBuffer* _tmp106_;
							GtkTextIter* _tmp107_;
							GtkTextIter* _tmp108_;
							GtkTextIter _tmp109_;
							GtkTextIter _tmp110_;
							_tmp99_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
							_tmp100_ = _tmp99_;
							_tmp101_ = e_start_iter;
							_tmp102_ = e_end_iter;
							_tmp103_ = *_tmp101_;
							_tmp104_ = *_tmp102_;
							gtk_text_buffer_apply_tag_by_name (_tmp100_, COMPLETION_TEXT_VIEW_NO_SPELL_CHECK, &_tmp103_, &_tmp104_);
							_tmp105_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
							_tmp106_ = _tmp105_;
							_tmp107_ = e_start_iter;
							_tmp108_ = e_end_iter;
							_tmp109_ = *_tmp107_;
							_tmp110_ = *_tmp108_;
							gtk_text_buffer_apply_tag_by_name (_tmp106_, "snippet", &_tmp109_, &_tmp110_);
						}
						break;
					}
					default:
					{
						break;
					}
				}
				_g_free0 (e_end_iter);
				_g_free0 (e_start_iter);
			}
		}
	}
	_tmp111_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp112_ = _tmp111_;
	g_object_get (_tmp112_, "text", &_tmp113_, NULL);
	_tmp114_ = _tmp113_;
	_tmp115_ = _tmp114_;
	_tmp116_ = strlen (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = _tmp117_ == 0;
	_g_free0 (_tmp115_);
	if (_tmp118_) {
		completion_text_view_hide_completion_window (self);
	}
	entities = (g_free (entities), NULL);
	_g_free0 (text);
	_g_object_unref0 (tag_table);
	_g_free0 (end_iter);
	_g_free0 (start_iter);
}


static void completion_text_view_show_completion_window (CompletionTextView* self) {
	gboolean _tmp0_;
	CbUserCompletionModel* _tmp1_;
	gboolean _tmp2_;
	gint x = 0;
	gint y = 0;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp3_ = {0};
	GdkWindow* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GtkWindow* _tmp10_;
	GtkWindow* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWindow* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GtkWindow* _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	GtkWindow* _tmp19_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->completion_model;
	cb_user_completion_model_clear (_tmp1_);
	_tmp2_ = self->priv->_default_listbox;
	if (!_tmp2_) {
		g_signal_emit (self, completion_text_view_signals[COMPLETION_TEXT_VIEW_SHOW_COMPLETION_SIGNAL], 0);
		return;
	}
	g_debug ("CompletionTextView.vala:322: show_completion_window");
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp3_);
	alloc = _tmp3_;
	_tmp4_ = gtk_text_view_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), GTK_TEXT_WINDOW_WIDGET);
	gdk_window_get_origin (_tmp4_, &_tmp5_, &_tmp6_);
	x = _tmp5_;
	y = _tmp6_;
	_tmp7_ = y;
	_tmp8_ = alloc;
	_tmp9_ = _tmp8_.height;
	y = _tmp7_ + _tmp9_;
	_tmp10_ = self->priv->completion_window;
	gtk_window_set_attached_to (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = self->priv->completion_window;
	_tmp12_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow));
	_tmp13_ = self->priv->completion_window;
	_tmp14_ = x;
	_tmp15_ = y;
	gtk_window_move (_tmp13_, _tmp14_ - 1, _tmp15_);
	_tmp16_ = self->priv->completion_window;
	_tmp17_ = alloc;
	_tmp18_ = _tmp17_.width;
	gtk_window_resize (_tmp16_, _tmp18_ + 2, 50);
	_tmp19_ = self->priv->completion_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
}


static void completion_text_view_hide_completion_window (CompletionTextView* self) {
	gboolean _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_g_free0 (self->priv->current_word);
	self->priv->current_word = NULL;
	_tmp0_ = self->priv->_default_listbox;
	if (!_tmp0_) {
		g_signal_emit (self, completion_text_view_signals[COMPLETION_TEXT_VIEW_HIDE_COMPLETION_SIGNAL], 0);
		return;
	}
	_tmp1_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = self->priv->_default_listbox;
	if (_tmp0_) {
		completion_text_view_hide_completion_window (self);
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static Block51Data* block51_data_ref (Block51Data* _data51_) {
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}


static void block51_data_unref (void * _userdata_) {
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		CompletionTextView* self;
		self = _data51_->self;
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}


static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _vala_CbUserIdentity_array_free (CbUserIdentity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_identity_free (&array[i]);
		}
	}
	g_free (array);
}


static void ___lambda31_ (Block51Data* _data51_, GObject* obj, GAsyncResult* res) {
	CompletionTextView* self;
	CbUserIdentity* users = NULL;
	gint users_length1 = 0;
	gint _users_size_ = 0;
	CbUserCompletionModel* _tmp8_;
	CbUserIdentity* _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_ = FALSE;
	CbUserIdentity* _tmp11_;
	gint _tmp11__length1;
	GError * _inner_error_ = NULL;
	self = _data51_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		CbUserIdentity* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		gint _tmp2_;
		CbUserIdentity* _tmp3_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		CbUserIdentity* _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = res;
		_tmp3_ = cb_utils_query_users_finish (_tmp1_, &_tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		_tmp0__length1 = _tmp2_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch53_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp4__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		users = (_vala_CbUserIdentity_array_free (users, users_length1), NULL);
		users = _tmp4_;
		users_length1 = _tmp4__length1;
		_users_size_ = users_length1;
		_tmp0_ = (_vala_CbUserIdentity_array_free (_tmp0_, _tmp0__length1), NULL);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		if (!g_error_matches (_tmp5_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("CompletionTextView.vala:420: User completion call error: %s", _tmp7_);
		}
		_g_error_free0 (e);
		users = (_vala_CbUserIdentity_array_free (users, users_length1), NULL);
		return;
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		users = (_vala_CbUserIdentity_array_free (users, users_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->completion_model;
	_tmp9_ = users;
	_tmp9__length1 = users_length1;
	cb_user_completion_model_insert_items (_tmp8_, _tmp9_, _tmp9__length1);
	_tmp11_ = users;
	_tmp11__length1 = users_length1;
	if (_tmp11__length1 > 0) {
		gboolean _tmp12_;
		_tmp12_ = _data51_->corpus_was_empty;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GtkListBox* _tmp13_;
		GtkListBoxRow* _tmp14_;
		_tmp13_ = self->priv->completion_list;
		_tmp14_ = gtk_list_box_get_row_at_index (_tmp13_, 0);
		completion_text_view_select_completion_row (self, _tmp14_);
		self->priv->current_match = 0;
	}
	users = (_vala_CbUserIdentity_array_free (users, users_length1), NULL);
}


static void ____lambda31__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda31_ (self, source_object, res);
	block51_data_unref (self);
}


static void completion_text_view_update_completion_listbox (CompletionTextView* self) {
	gchar* cur_word = NULL;
	gchar* _tmp0_;
	gint n_chars = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar end_char = '\0';
	const gchar* _tmp4_;
	gint _tmp5_;
	gchar _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar _tmp10_;
	gboolean _tmp11_;
	gboolean word_has_alpha_end = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = completion_text_view_get_cursor_word (self, NULL, NULL);
	cur_word = _tmp0_;
	_tmp1_ = cur_word;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) -1);
	n_chars = _tmp2_;
	_tmp3_ = n_chars;
	if (_tmp3_ == 0) {
		completion_text_view_hide_completion_window (self);
		_g_free0 (cur_word);
		return;
	}
	_tmp4_ = cur_word;
	_tmp5_ = n_chars;
	_tmp6_ = string_get (_tmp4_, (glong) (_tmp5_ - 1));
	end_char = _tmp6_;
	_tmp10_ = end_char;
	_tmp11_ = g_ascii_isalpha (_tmp10_);
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		gchar _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = end_char;
		_tmp13_ = g_ascii_isdigit (_tmp12_);
		_tmp9_ = _tmp13_;
	}
	if (_tmp9_) {
		gchar _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = end_char;
		_tmp15_ = g_ascii_isgraph (_tmp14_);
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gchar _tmp16_;
		_tmp16_ = end_char;
		_tmp7_ = _tmp16_ == '@';
	}
	word_has_alpha_end = _tmp7_;
	_tmp19_ = cur_word;
	_tmp20_ = g_str_has_prefix (_tmp19_, "@");
	if (!_tmp20_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = word_has_alpha_end;
		_tmp18_ = !_tmp21_;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
		_tmp23_ = _tmp22_;
		_tmp24_ = gtk_text_buffer_get_has_selection (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp17_ = _tmp25_;
	}
	if (_tmp17_) {
		completion_text_view_hide_completion_window (self);
		_g_free0 (cur_word);
		return;
	}
	_tmp26_ = cur_word;
	_tmp27_ = string_substring (_tmp26_, (glong) 1, (glong) -1);
	_g_free0 (cur_word);
	cur_word = _tmp27_;
	_tmp29_ = cur_word;
	if (_tmp29_ == NULL) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp30_ = cur_word;
		_tmp31_ = strlen (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp28_ = _tmp32_ == 0;
	}
	if (_tmp28_) {
		completion_text_view_hide_completion_window (self);
		_g_free0 (cur_word);
		return;
	}
	_tmp33_ = cur_word;
	_tmp34_ = self->priv->current_word;
	if (g_strcmp0 (_tmp33_, _tmp34_) != 0) {
		Block51Data* _data51_;
		GCancellable* _tmp35_;
		CbUserInfo* corpus = NULL;
		gint corpus_length1 = 0;
		gint _corpus_size_ = 0;
		Account* _tmp37_;
		CbUserCounter* _tmp38_;
		Account* _tmp39_;
		SqlDatabase* _tmp40_;
		sqlite3* _tmp41_;
		const gchar* _tmp42_;
		CbUserInfo* _tmp43_ = NULL;
		gint _tmp44_;
		CbUserCompletionModel* _tmp45_;
		CbUserInfo* _tmp46_;
		gint _tmp46__length1;
		CbUserInfo* _tmp47_;
		gint _tmp47__length1;
		CbUserInfo* _tmp48_;
		gint _tmp48__length1;
		GCancellable* _tmp51_;
		Account* _tmp52_;
		OAuthProxy* _tmp53_;
		const gchar* _tmp54_;
		GCancellable* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		GtkListBox* _tmp58_;
		_data51_ = g_slice_new0 (Block51Data);
		_data51_->_ref_count_ = 1;
		_data51_->self = g_object_ref (self);
		_tmp35_ = self->priv->completion_cancellable;
		if (_tmp35_ != NULL) {
			GCancellable* _tmp36_;
			g_debug ("CompletionTextView.vala:390: Cancelling earlier completion call...");
			_tmp36_ = self->priv->completion_cancellable;
			g_cancellable_cancel (_tmp36_);
		}
		completion_text_view_show_completion_window (self);
		_tmp37_ = self->priv->account;
		_tmp38_ = _tmp37_->user_counter;
		_tmp39_ = self->priv->account;
		_tmp40_ = _tmp39_->db;
		_tmp41_ = sql_database_get_sqlite_db (_tmp40_);
		_tmp42_ = cur_word;
		cb_user_counter_query_by_prefix (_tmp38_, _tmp41_, _tmp42_, 10, &_tmp43_, &_tmp44_);
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
		corpus = _tmp43_;
		corpus_length1 = _tmp44_;
		_corpus_size_ = corpus_length1;
		_tmp45_ = self->priv->completion_model;
		_tmp46_ = corpus;
		_tmp46__length1 = corpus_length1;
		cb_user_completion_model_insert_infos (_tmp45_, _tmp46_, _tmp46__length1);
		_tmp47_ = corpus;
		_tmp47__length1 = corpus_length1;
		_data51_->corpus_was_empty = _tmp47__length1 == 0;
		_tmp48_ = corpus;
		_tmp48__length1 = corpus_length1;
		if (_tmp48__length1 > 0) {
			GtkListBox* _tmp49_;
			GtkListBoxRow* _tmp50_;
			_tmp49_ = self->priv->completion_list;
			_tmp50_ = gtk_list_box_get_row_at_index (_tmp49_, 0);
			completion_text_view_select_completion_row (self, _tmp50_);
			self->priv->current_match = 0;
		}
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
		corpus = NULL;
		corpus_length1 = 0;
		_corpus_size_ = corpus_length1;
		_tmp51_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->completion_cancellable);
		self->priv->completion_cancellable = _tmp51_;
		_tmp52_ = self->priv->account;
		_tmp53_ = _tmp52_->proxy;
		_tmp54_ = cur_word;
		_tmp55_ = self->priv->completion_cancellable;
		cb_utils_query_users_async (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, rest_proxy_get_type (), RestProxy), _tmp54_, _tmp55_, ____lambda31__gasync_ready_callback, block51_data_ref (_data51_));
		_tmp56_ = cur_word;
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (self->priv->current_word);
		self->priv->current_word = _tmp57_;
		_tmp58_ = self->priv->completion_list;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget));
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
		block51_data_unref (_data51_);
		_data51_ = NULL;
	}
	_g_free0 (cur_word);
}


static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gchar* result = NULL;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter test_iter = {0};
	GtkTextIter _tmp8_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
	GtkTextIter _tmp33_;
	GtkTextIter _tmp34_;
	GtkTextBuffer* _tmp35_;
	GtkTextBuffer* _tmp36_;
	GtkTextIter _tmp37_;
	GtkTextIter _tmp38_;
	gchar* _tmp39_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cursor_mark = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	_tmp6_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp7_, _tmp6_);
	cursor_iter = _tmp7_;
	memset (&test_iter, 0, sizeof (GtkTextIter));
	_tmp8_ = cursor_iter;
	gtk_text_iter_assign (&test_iter, &_tmp8_);
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GtkTextIter left_iter = {0};
			GtkTextIter _tmp10_;
			GtkTextIter _tmp11_;
			gchar* s = NULL;
			GtkTextBuffer* _tmp12_;
			GtkTextBuffer* _tmp13_;
			GtkTextIter _tmp14_;
			GtkTextIter _tmp15_;
			gchar* _tmp16_;
			gunichar c = 0U;
			const gchar* _tmp17_;
			gunichar _tmp18_;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_;
			gint _tmp21_;
			gboolean _tmp24_;
			gboolean _tmp26_ = FALSE;
			gunichar _tmp27_;
			gboolean _tmp28_;
			GtkTextIter _tmp30_;
			if (!_tmp9_) {
			}
			_tmp9_ = FALSE;
			_tmp10_ = test_iter;
			left_iter = _tmp10_;
			_tmp11_ = test_iter;
			gtk_text_iter_assign (&left_iter, &_tmp11_);
			gtk_text_iter_backward_char (&left_iter);
			_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
			_tmp13_ = _tmp12_;
			_tmp14_ = left_iter;
			_tmp15_ = test_iter;
			_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, FALSE);
			s = _tmp16_;
			_tmp17_ = s;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			c = _tmp18_;
			_tmp20_ = s;
			_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
			if (_tmp21_ == 1) {
				_tmp19_ = TRUE;
			} else {
				const gchar* _tmp22_;
				gint _tmp23_;
				_tmp22_ = s;
				_tmp23_ = g_utf8_strlen (_tmp22_, (gssize) -1);
				_tmp19_ = _tmp23_ == 0;
			}
			_vala_assert (_tmp19_, "s.char_count () == 1 ||               s.char_count () == 0");
			_tmp24_ = gtk_text_iter_is_start (&left_iter);
			if (_tmp24_) {
				GtkTextIter _tmp25_;
				_tmp25_ = left_iter;
				gtk_text_iter_assign (&test_iter, &_tmp25_);
			}
			_tmp27_ = c;
			_tmp28_ = g_unichar_isspace (_tmp27_);
			if (_tmp28_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp29_;
				_tmp29_ = gtk_text_iter_is_start (&left_iter);
				_tmp26_ = _tmp29_;
			}
			if (_tmp26_) {
				_g_free0 (s);
				break;
			}
			_tmp30_ = left_iter;
			gtk_text_iter_assign (&test_iter, &_tmp30_);
			_g_free0 (s);
		}
	}
	_tmp31_ = test_iter;
	_vala_start_iter = _tmp31_;
	_tmp32_ = test_iter;
	gtk_text_iter_assign (&_vala_start_iter, &_tmp32_);
	_tmp33_ = cursor_iter;
	_vala_end_iter = _tmp33_;
	_tmp34_ = cursor_iter;
	gtk_text_iter_assign (&_vala_end_iter, &_tmp34_);
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = test_iter;
	_tmp38_ = cursor_iter;
	_tmp39_ = gtk_text_buffer_get_text (_tmp36_, &_tmp37_, &_tmp38_, FALSE);
	result = _tmp39_;
	_g_object_unref0 (cursor_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter start_word_iter = {0};
	GtkTextIter end_word_iter = {0};
	gchar* word_to_delete = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextMark* _tmp11_;
	GtkTextMark* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (compl != NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp4_ = completion_text_view_get_cursor_word (self, &_tmp2_, &_tmp3_);
	start_word_iter = _tmp2_;
	end_word_iter = _tmp3_;
	word_to_delete = _tmp4_;
	g_debug ("CompletionTextView.vala:484: Delete word: %s", word_to_delete);
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	_tmp7_ = start_word_iter;
	_tmp8_ = end_word_iter;
	g_signal_emit_by_name (_tmp6_, "delete-range", &_tmp7_, &_tmp8_);
	_tmp9_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_buffer_get_insert (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	cursor_mark = _tmp12_;
	_tmp13_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp14_ = _tmp13_;
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp15_, cursor_mark);
	start_word_iter = _tmp15_;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	_tmp18_ = compl;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = compl;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_emit_by_name (_tmp17_, "insert-text", &start_word_iter, _tmp22_, _tmp25_ + 2);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp26_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp27_ = _tmp26_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G_TYPE_OBJECT, GObject));
	_g_object_unref0 (cursor_mark);
	_g_free0 (word_to_delete);
}


static GtkWidget* completion_text_view_create_completion_row (CompletionTextView* self, void* id_ptr) {
	GtkWidget* result = NULL;
	CbUserIdentity* id = NULL;
	void* _tmp0_;
	UserCompletionRow* row = NULL;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	UserCompletionRow* _tmp5_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), NULL);
	_tmp0_ = id_ptr;
	id = (CbUserIdentity*) _tmp0_;
	_tmp1_ = (*id).id;
	_tmp2_ = (*id).user_name;
	_tmp3_ = (*id).screen_name;
	_tmp4_ = (*id).verified;
	_tmp5_ = user_completion_row_new (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	row = _tmp5_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget));
	result = G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget);
	return result;
}


CompletionTextView* completion_text_view_construct (GType object_type) {
	CompletionTextView * self = NULL;
	self = (CompletionTextView*) g_object_new (object_type, NULL);
	return self;
}


CompletionTextView* completion_text_view_new (void) {
	return completion_text_view_construct (TYPE_COMPLETION_TEXT_VIEW);
}


static GtkWidget* _completion_text_view_create_completion_row_cbutils_createwidgetfunc (void* item, gpointer self) {
	GtkWidget* result;
	result = completion_text_view_create_completion_row ((CompletionTextView*) self, item);
	return result;
}


void completion_text_view_set_completion_listbox (CompletionTextView* self, GtkListBox* value) {
	GtkListBox* _tmp0_;
	CbUserCompletionModel* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	CbUserCompletionModel* _tmp5_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	self->priv->_default_listbox = FALSE;
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = self->priv->completion_model;
	cb_utils_unbind_non_gobject_model (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_list_model_get_type (), GListModel));
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->completion_list);
	self->priv->completion_list = _tmp3_;
	_tmp4_ = self->priv->completion_list;
	_tmp5_ = self->priv->completion_model;
	cb_utils_bind_non_gobject_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_list_model_get_type (), GListModel), _completion_text_view_create_completion_row_cbutils_createwidgetfunc, self);
	g_object_notify_by_pspec ((GObject *) self, completion_text_view_properties[COMPLETION_TEXT_VIEW_COMPLETION_LISTBOX_PROPERTY]);
}


static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = completion_text_view_completion_window_focus_out_cb ((CompletionTextView*) self);
	return result;
}


static void _completion_text_view_update_completion_listbox_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	completion_text_view_update_completion_listbox ((CompletionTextView*) self);
}


static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	completion_text_view_buffer_changed_cb ((CompletionTextView*) self);
}


static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = completion_text_view_key_press_event_cb ((CompletionTextView*) self, event);
	return result;
}


static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CompletionTextView * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GdkScreen* _tmp4_;
	GtkListBox* _tmp5_;
	CbUserCompletionModel* _tmp6_;
	GtkListBox* _tmp7_;
	CbUserCompletionModel* _tmp8_;
	GtkLabel* placeholder_label = NULL;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkLabel* _tmp12_;
	GtkListBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp15_;
	GtkScrolledWindow* _tmp16_;
	GtkListBox* _tmp17_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp18_;
	GtkFrame* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkWindow* _tmp21_;
	GtkFrame* _tmp22_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStyleContext* _tmp26_;
	GdkRGBA link_color = {0};
	GtkStyleContext* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkStateFlags _tmp29_;
	GdkRGBA _tmp30_ = {0};
	GtkStyleContext* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GdkRGBA _tmp35_;
	gdouble _tmp36_;
	GdkRGBA snippet_color = {0};
	GdkRGBA _tmp44_ = {0};
	GtkTextBuffer* _tmp45_;
	GtkTextBuffer* _tmp46_;
	const gchar* _tmp47_;
	GdkRGBA _tmp48_;
	GtkTextBuffer* _tmp49_;
	GtkTextBuffer* _tmp50_;
	const gchar* _tmp51_;
	GdkRGBA _tmp52_;
	GtkTextBuffer* _tmp53_;
	GtkTextBuffer* _tmp54_;
	const gchar* _tmp55_;
	GdkRGBA _tmp56_;
	GtkTextBuffer* _tmp57_;
	GtkTextBuffer* _tmp58_;
	const gchar* _tmp59_;
	GdkRGBA _tmp60_;
	GtkTextBuffer* _tmp61_;
	GtkTextBuffer* _tmp62_;
	GtkTextBuffer* _tmp63_;
	GtkTextBuffer* _tmp64_;
	GtkTextBuffer* _tmp65_;
	GtkTextBuffer* _tmp66_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp67_;
	GspellTextView* _tmp68_;
	GspellTextView* _tmp69_;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp70_;
	GtkTextBuffer* _tmp71_;
	GspellTextBuffer* _tmp72_;
	GspellTextBuffer* _tmp73_;
	GspellChecker* checker = NULL;
	GspellLanguage* _tmp74_;
	GspellChecker* _tmp75_;
	GspellTextBuffer* _tmp76_;
	GspellChecker* _tmp77_;
	parent_class = G_OBJECT_CLASS (completion_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->completion_window);
	self->priv->completion_window = _tmp0_;
	_tmp1_ = self->priv->completion_window;
	gtk_window_set_type_hint (_tmp1_, GDK_WINDOW_TYPE_HINT_COMBO);
	_tmp2_ = self->priv->completion_window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp3_ = self->priv->completion_window;
	_tmp4_ = gtk_widget_get_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_screen (_tmp3_, _tmp4_);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->completion_list);
	self->priv->completion_list = _tmp5_;
	_tmp6_ = cb_user_completion_model_new ();
	_g_object_unref0 (self->priv->completion_model);
	self->priv->completion_model = _tmp6_;
	_tmp7_ = self->priv->completion_list;
	_tmp8_ = self->priv->completion_model;
	cb_utils_bind_non_gobject_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_list_model_get_type (), GListModel), _completion_text_view_create_completion_row_cbutils_createwidgetfunc, self);
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("No users found"));
	g_object_ref_sink (_tmp9_);
	placeholder_label = _tmp9_;
	_tmp10_ = placeholder_label;
	_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp11_, "dim-label");
	_tmp12_ = placeholder_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = self->priv->completion_list;
	_tmp14_ = placeholder_label;
	gtk_list_box_set_placeholder (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp15_);
	scroller = _tmp15_;
	_tmp16_ = scroller;
	_tmp17_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp18_);
	frame = _tmp18_;
	_tmp19_ = frame;
	_tmp20_ = scroller;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	_tmp21_ = self->priv->completion_window;
	_tmp22_ = frame;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp23_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp24_ = _g_object_ref0 (_tmp23_);
	style_context = _tmp24_;
	_tmp25_ = style_context;
	gtk_style_context_save (_tmp25_);
	_tmp26_ = style_context;
	gtk_style_context_set_state (_tmp26_, GTK_STATE_FLAG_LINK);
	_tmp27_ = style_context;
	_tmp28_ = style_context;
	_tmp29_ = gtk_style_context_get_state (_tmp28_);
	gtk_style_context_get_color (_tmp27_, _tmp29_, &_tmp30_);
	link_color = _tmp30_;
	_tmp31_ = style_context;
	gtk_style_context_restore (_tmp31_);
	_tmp35_ = link_color;
	_tmp36_ = _tmp35_.red;
	if (_tmp36_ == 1.0) {
		GdkRGBA _tmp37_;
		gdouble _tmp38_;
		_tmp37_ = link_color;
		_tmp38_ = _tmp37_.green;
		_tmp34_ = _tmp38_ == 1.0;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		GdkRGBA _tmp39_;
		gdouble _tmp40_;
		_tmp39_ = link_color;
		_tmp40_ = _tmp39_.blue;
		_tmp33_ = _tmp40_ == 1.0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GdkRGBA _tmp41_;
		gdouble _tmp42_;
		_tmp41_ = link_color;
		_tmp42_ = _tmp41_.alpha;
		_tmp32_ = _tmp42_ == 1.0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkRGBA _tmp43_ = {0};
		_tmp43_.red = 0.16470;
		_tmp43_.green = 0.462735;
		_tmp43_.blue = 0.77647;
		_tmp43_.alpha = 1.0;
		link_color = _tmp43_;
	}
	_tmp44_.red = 0.0;
	_tmp44_.green = 0.65;
	_tmp44_.blue = 0.0627;
	_tmp44_.alpha = 1.0;
	snippet_color = _tmp44_;
	_tmp45_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp46_ = _tmp45_;
	_tmp47_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[0];
	_tmp48_ = link_color;
	gtk_text_buffer_create_tag (_tmp46_, _tmp47_, "foreground_rgba", &_tmp48_, NULL, NULL);
	_tmp49_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp50_ = _tmp49_;
	_tmp51_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[1];
	_tmp52_ = link_color;
	gtk_text_buffer_create_tag (_tmp50_, _tmp51_, "foreground_rgba", &_tmp52_, NULL, NULL);
	_tmp53_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp54_ = _tmp53_;
	_tmp55_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[2];
	_tmp56_ = link_color;
	gtk_text_buffer_create_tag (_tmp54_, _tmp55_, "foreground_rgba", &_tmp56_, NULL, NULL);
	_tmp57_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp58_ = _tmp57_;
	_tmp59_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[3];
	_tmp60_ = snippet_color;
	gtk_text_buffer_create_tag (_tmp58_, _tmp59_, "foreground_rgba", &_tmp60_, NULL, NULL);
	_tmp61_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp62_ = _tmp61_;
	gtk_text_buffer_create_tag (_tmp62_, COMPLETION_TEXT_VIEW_NO_SPELL_CHECK, NULL, NULL);
	_tmp63_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp64_ = _tmp63_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, G_TYPE_OBJECT, GObject), "notify::cursor-position", (GCallback) _completion_text_view_update_completion_listbox_g_object_notify, self, 0);
	_tmp65_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp66_ = _tmp65_;
	g_signal_connect_object (_tmp66_, "changed", (GCallback) _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _completion_text_view_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	gtk_text_view_set_right_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_left_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_top_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_bottom_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	_tmp67_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp68_ = _g_object_ref0 (_tmp67_);
	gspell_view = _tmp68_;
	_tmp69_ = gspell_view;
	gspell_text_view_set_inline_spell_checking (_tmp69_, TRUE);
	_tmp70_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp71_ = _tmp70_;
	_tmp72_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp71_);
	_tmp73_ = _g_object_ref0 (_tmp72_);
	gspell_buffer = _tmp73_;
	_tmp74_ = gspell_language_get_default ();
	_tmp75_ = gspell_checker_new (_tmp74_);
	checker = _tmp75_;
	_tmp76_ = gspell_buffer;
	_tmp77_ = checker;
	gspell_text_buffer_set_spell_checker (_tmp76_, _tmp77_);
	_g_object_unref0 (checker);
	_g_object_unref0 (gspell_buffer);
	_g_object_unref0 (gspell_view);
	_g_object_unref0 (style_context);
	_g_object_unref0 (frame);
	_g_object_unref0 (scroller);
	_g_object_unref0 (placeholder_label);
	return obj;
}


static void completion_text_view_class_init (CompletionTextViewClass * klass) {
	completion_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionTextViewPrivate));
	G_OBJECT_CLASS (klass)->set_property = _vala_completion_text_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = completion_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = completion_text_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_TEXT_VIEW_COMPLETION_LISTBOX_PROPERTY, completion_text_view_properties[COMPLETION_TEXT_VIEW_COMPLETION_LISTBOX_PROPERTY] = g_param_spec_object ("completion-listbox", "completion-listbox", "completion-listbox", gtk_list_box_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	completion_text_view_signals[COMPLETION_TEXT_VIEW_SHOW_COMPLETION_SIGNAL] = g_signal_new ("show-completion", TYPE_COMPLETION_TEXT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	completion_text_view_signals[COMPLETION_TEXT_VIEW_HIDE_COMPLETION_SIGNAL] = g_signal_new ("hide-completion", TYPE_COMPLETION_TEXT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	completion_text_view_signals[COMPLETION_TEXT_VIEW_UPDATE_COMPLETION_SIGNAL] = g_signal_new ("update-completion", TYPE_COMPLETION_TEXT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void completion_text_view_instance_init (CompletionTextView * self) {
	self->priv = COMPLETION_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->current_match = 0;
	self->priv->current_word = NULL;
	self->priv->completion_cancellable = NULL;
	self->priv->_default_listbox = TRUE;
}


static void completion_text_view_finalize (GObject * obj) {
	CompletionTextView * self;
	GtkListBox* _tmp0_;
	CbUserCompletionModel* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = self->priv->completion_model;
	cb_utils_unbind_non_gobject_model (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_list_model_get_type (), GListModel));
	_g_object_unref0 (self->priv->completion_window);
	_g_free0 (self->priv->current_word);
	_g_object_unref0 (self->priv->completion_cancellable);
	_g_object_unref0 (self->priv->completion_list);
	_g_object_unref0 (self->priv->completion_model);
	G_OBJECT_CLASS (completion_text_view_parent_class)->finalize (obj);
}


GType completion_text_view_get_type (void) {
	static volatile gsize completion_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&completion_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionTextView), 0, (GInstanceInitFunc) completion_text_view_instance_init, NULL };
		GType completion_text_view_type_id;
		completion_text_view_type_id = g_type_register_static (gtk_text_view_get_type (), "CompletionTextView", &g_define_type_info, 0);
		g_once_init_leave (&completion_text_view_type_id__volatile, completion_text_view_type_id);
	}
	return completion_text_view_type_id__volatile;
}


static void _vala_completion_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CompletionTextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	switch (property_id) {
		case COMPLETION_TEXT_VIEW_COMPLETION_LISTBOX_PROPERTY:
		completion_text_view_set_completion_listbox (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UserCompletionRow* user_completion_row_construct (GType object_type, gint64 id, const gchar* user_name, const gchar* screen_name, gboolean verified) {
	UserCompletionRow * self = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkBox* _tmp15_;
	GtkLabel* _tmp16_;
	gboolean _tmp17_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	g_return_val_if_fail (user_name != NULL, NULL);
	g_return_val_if_fail (screen_name != NULL, NULL);
	self = (UserCompletionRow*) g_object_new (object_type, NULL);
	_tmp0_ = user_name;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->user_name_label);
	self->priv->user_name_label = _tmp1_;
	_tmp2_ = screen_name;
	_tmp3_ = g_strconcat ("@", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->screen_name_label);
	self->priv->screen_name_label = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	_tmp7_ = self->priv->user_name_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp8_ = self->priv->user_name_label;
	gtk_label_set_use_markup (_tmp8_, TRUE);
	_tmp9_ = self->priv->user_name_label;
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_END);
	_tmp10_ = box;
	_tmp11_ = self->priv->user_name_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = self->priv->screen_name_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp13_ = self->priv->screen_name_label;
	_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp14_, "dim-label");
	_tmp15_ = box;
	_tmp16_ = self->priv->screen_name_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	_tmp17_ = verified;
	if (_tmp17_) {
		GtkImage* verified_image = NULL;
		cairo_surface_t* _tmp18_;
		GtkImage* _tmp19_;
		GtkBox* _tmp20_;
		GtkImage* _tmp21_;
		_tmp18_ = user_completion_row_verified_surface;
		_tmp19_ = (GtkImage*) gtk_image_new_from_surface (_tmp18_);
		g_object_ref_sink (_tmp19_);
		verified_image = _tmp19_;
		_tmp20_ = box;
		_tmp21_ = verified_image;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (verified_image);
	}
	_tmp22_ = box;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "margin", 2, NULL);
	_tmp23_ = box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (box);
	return self;
}


UserCompletionRow* user_completion_row_new (gint64 id, const gchar* user_name, const gchar* screen_name, gboolean verified) {
	return user_completion_row_construct (TYPE_USER_COMPLETION_ROW, id, user_name, screen_name, verified);
}


gchar* user_completion_row_get_screen_name (UserCompletionRow* self) {
	gchar* result = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (IS_USER_COMPLETION_ROW (self), NULL);
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static void user_completion_row_class_init (UserCompletionRowClass * klass) {
	GError * _inner_error_ = NULL;
	user_completion_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserCompletionRowPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_completion_row_finalize;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		cairo_surface_t* _tmp2_;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/verified-small.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch54_g_error;
		}
		_tmp2_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_cairo_surface_destroy0 (user_completion_row_verified_surface);
		user_completion_row_verified_surface = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_error ("CompletionTextView.vala:519: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally54:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void user_completion_row_instance_init (UserCompletionRow * self) {
	self->priv = USER_COMPLETION_ROW_GET_PRIVATE (self);
}


static void user_completion_row_finalize (GObject * obj) {
	UserCompletionRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_COMPLETION_ROW, UserCompletionRow);
	_g_object_unref0 (self->priv->user_name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	G_OBJECT_CLASS (user_completion_row_parent_class)->finalize (obj);
}


GType user_completion_row_get_type (void) {
	static volatile gsize user_completion_row_type_id__volatile = 0;
	if (g_once_init_enter (&user_completion_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserCompletionRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_completion_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserCompletionRow), 0, (GInstanceInitFunc) user_completion_row_instance_init, NULL };
		GType user_completion_row_type_id;
		user_completion_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "UserCompletionRow", &g_define_type_info, 0);
		g_once_init_leave (&user_completion_row_type_id__volatile, user_completion_row_type_id);
	}
	return user_completion_row_type_id__volatile;
}



