/* AvatarBannerWidget.c generated by valac 0.38.7, the Vala compiler
 * generated from AvatarBannerWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;
typedef struct _AvatarBannerWidgetPrivate AvatarBannerWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PIXBUF_BUTTON (pixbuf_button_get_type ())
#define PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_BUTTON, PixbufButton))
#define PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_BUTTON, PixbufButtonClass))
#define IS_PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_BUTTON))
#define IS_PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_BUTTON))
#define PIXBUF_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_BUTTON, PixbufButtonClass))

typedef struct _PixbufButton PixbufButton;
typedef struct _PixbufButtonClass PixbufButtonClass;
enum  {
	AVATAR_BANNER_WIDGET_0_PROPERTY,
	AVATAR_BANNER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* avatar_banner_widget_properties[AVATAR_BANNER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AvatarBannerWidgetFetchBannerData AvatarBannerWidgetFetchBannerData;
enum  {
	AVATAR_BANNER_WIDGET_AVATAR_CHANGED_SIGNAL,
	AVATAR_BANNER_WIDGET_BANNER_CHANGED_SIGNAL,
	AVATAR_BANNER_WIDGET_AVATAR_CLICKED_SIGNAL,
	AVATAR_BANNER_WIDGET_BANNER_CLICKED_SIGNAL,
	AVATAR_BANNER_WIDGET_NUM_SIGNALS
};
static guint avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_NUM_SIGNALS] = {0};

struct _AvatarBannerWidget {
	GtkContainer parent_instance;
	AvatarBannerWidgetPrivate * priv;
};

struct _AvatarBannerWidgetClass {
	GtkContainerClass parent_class;
};

struct _AvatarBannerWidgetPrivate {
	Account* account;
	PixbufButton* set_banner_button;
	PixbufButton* set_avatar_button;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _AvatarBannerWidgetFetchBannerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AvatarBannerWidget* self;
	Account* _tmp0_;
	const gchar* _tmp1_;
	PixbufButton* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* pixbuf;
	Account* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	PixbufButton* _tmp10_;
	GdkPixbuf* _tmp11_;
};


static gpointer avatar_banner_widget_parent_class = NULL;
extern GdkPixbuf* twitter_no_banner;

GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType pixbuf_button_get_type (void) G_GNUC_CONST;
#define AVATAR_BANNER_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetPrivate))
#define AVATAR_BANNER_WIDGET_MIN_HEIGHT 200
#define AVATAR_BANNER_WIDGET_MAX_HEIGHT 250
#define AVATAR_BANNER_WIDGET_BANNER_RATIO 0.5
#define AVATAR_BANNER_WIDGET_AVATAR_SIZE 48
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_);
void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg);
cairo_surface_t* account_get_avatar (Account* self);
static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct);
static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self);
static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self);
static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base);
static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat);
static void avatar_banner_widget_fetch_banner_data_free (gpointer _data);
static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target);
static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self);
static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self);
void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar);
void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner);
AvatarBannerWidget* avatar_banner_widget_new (void);
AvatarBannerWidget* avatar_banner_widget_construct (GType object_type);
static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
PixbufButton* pixbuf_button_new (void);
PixbufButton* pixbuf_button_construct (GType object_type);
static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GSettings* settings_get (void);
static void avatar_banner_widget_finalize (GObject * obj);


void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account) {
	Account* _tmp0_;
	PixbufButton* _tmp1_;
	Account* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	avatar_banner_widget_fetch_banner (self, NULL, NULL);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->set_avatar_button;
	_tmp2_ = account;
	_tmp3_ = account_get_avatar (_tmp2_);
	_tmp4_ = _tmp3_;
	pixbuf_button_set_bg (_tmp1_, (cairo_surface_t*) _tmp4_);
}


static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct) {
	AvatarBannerWidget * self;
	gboolean result = FALSE;
	PixbufButton* _tmp0_;
	cairo_t* _tmp1_;
	PixbufButton* _tmp2_;
	cairo_t* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp1_);
	_tmp2_ = self->priv->set_avatar_button;
	_tmp3_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), _tmp3_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = (_tmp0_ / 2) - (AVATAR_BANNER_WIDGET_AVATAR_SIZE / 2);
	return result;
}


static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = _tmp0_ - AVATAR_BANNER_WIDGET_AVATAR_SIZE;
	return result;
}


static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base) {
	AvatarBannerWidget * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_vala_min = AVATAR_BANNER_WIDGET_AVATAR_SIZE + 40;
	_vala_nat = (gint) (AVATAR_BANNER_WIDGET_MIN_HEIGHT * (1 / AVATAR_BANNER_WIDGET_BANNER_RATIO));
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_vala_min = (AVATAR_BANNER_WIDGET_AVATAR_SIZE / 3) + AVATAR_BANNER_WIDGET_MIN_HEIGHT;
	_tmp0_ = width;
	_tmp1_ = MIN (AVATAR_BANNER_WIDGET_MAX_HEIGHT, ((gint) (_tmp0_ * AVATAR_BANNER_WIDGET_BANNER_RATIO)) + (AVATAR_BANNER_WIDGET_AVATAR_SIZE / 3));
	_tmp2_ = MAX (_vala_min, _tmp1_);
	_vala_nat = _tmp2_;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_fetch_banner_data_free (gpointer _data) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AvatarBannerWidgetFetchBannerData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	AvatarBannerWidget* _tmp0_;
	_data_ = g_slice_new0 (AvatarBannerWidgetFetchBannerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, avatar_banner_widget_fetch_banner_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->account;
	_data_->_tmp1_ = _data_->_tmp0_->banner_url;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = _data_->self->priv->set_banner_button;
		_data_->_tmp3_ = twitter_no_banner;
		pixbuf_button_set_pixbuf (_data_->_tmp2_, _data_->_tmp3_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->account;
	_data_->_tmp5_ = _data_->_tmp4_->banner_url;
	_data_->_tmp6_ = g_strconcat (_data_->_tmp5_, "/600x200", NULL);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 1;
	utils_download_pixbuf (_data_->_tmp7_, NULL, avatar_banner_widget_fetch_banner_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = utils_download_pixbuf_finish (_data_->_res_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_g_free0 (_data_->_tmp7_);
	_data_->pixbuf = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->self->priv->set_banner_button;
	_data_->_tmp11_ = _data_->pixbuf;
	pixbuf_button_set_pixbuf (_data_->_tmp10_, _data_->_tmp11_);
	_g_object_unref0 (_data_->pixbuf);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	AvatarBannerWidget * self;
	GtkAllocation _tmp0_;
	GtkRequisition child_requisition = {0};
	GtkAllocation child_allocation = {0};
	PixbufButton* _tmp1_;
	GtkRequisition _tmp2_ = {0};
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	GtkRequisition _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	GtkRequisition _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	PixbufButton* _tmp19_;
	GtkAllocation _tmp20_;
	PixbufButton* _tmp21_;
	GtkRequisition _tmp22_ = {0};
	gint _tmp23_;
	GtkAllocation _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GtkAllocation _tmp27_;
	gint _tmp28_;
	PixbufButton* _tmp29_;
	GtkAllocation _tmp30_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (avatar_banner_widget_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	_tmp1_ = self->priv->set_banner_button;
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), &_tmp2_, NULL);
	child_requisition = _tmp2_;
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.x;
	child_allocation.x = _tmp4_;
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.y;
	child_allocation.y = _tmp6_;
	_tmp7_ = *allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = child_requisition;
	_tmp10_ = _tmp9_.width;
	_tmp11_ = MAX (_tmp8_, _tmp10_);
	child_allocation.width = _tmp11_;
	_tmp12_ = *allocation;
	_tmp13_ = _tmp12_.width;
	child_allocation.height = (gint) (_tmp13_ * AVATAR_BANNER_WIDGET_BANNER_RATIO);
	_tmp14_ = *allocation;
	_tmp15_ = _tmp14_.height;
	_tmp16_ = child_requisition;
	_tmp17_ = _tmp16_.height;
	_tmp18_ = MAX (_tmp15_ - (AVATAR_BANNER_WIDGET_AVATAR_SIZE / 2), _tmp17_);
	child_allocation.height = _tmp18_;
	_tmp19_ = self->priv->set_banner_button;
	_tmp20_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), &_tmp20_);
	_tmp21_ = self->priv->set_avatar_button;
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), &_tmp22_, NULL);
	child_requisition = _tmp22_;
	_tmp23_ = avatar_banner_widget_get_avatar_x (self);
	_tmp24_ = *allocation;
	_tmp25_ = _tmp24_.x;
	child_allocation.x = _tmp23_ + _tmp25_;
	_tmp26_ = avatar_banner_widget_get_avatar_y (self);
	_tmp27_ = *allocation;
	_tmp28_ = _tmp27_.y;
	child_allocation.y = _tmp26_ + _tmp28_;
	child_allocation.width = AVATAR_BANNER_WIDGET_AVATAR_SIZE;
	child_allocation.height = AVATAR_BANNER_WIDGET_AVATAR_SIZE;
	_tmp29_ = self->priv->set_avatar_button;
	_tmp30_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), &_tmp30_);
}


static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_set_parent (_tmp0_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
}


static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_unparent (_tmp0_);
}


static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target) {
	AvatarBannerWidget * self;
	GtkCallback _tmp0_;
	void* _tmp0__target;
	PixbufButton* _tmp1_;
	GtkCallback _tmp2_;
	void* _tmp2__target;
	PixbufButton* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp1_ = self->priv->set_banner_button;
	_tmp0_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp0__target);
	_tmp2_ = cb;
	_tmp2__target = cb_target;
	_tmp3_ = self->priv->set_avatar_button;
	_tmp2_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp2__target);
}


static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self) {
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_signal_emit (self, avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_BANNER_CLICKED_SIGNAL], 0);
}


static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self) {
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_signal_emit (self, avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_AVATAR_CLICKED_SIGNAL], 0);
}


void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar) {
	PixbufButton* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (GDK_IS_PIXBUF (avatar));
	_tmp0_ = self->priv->set_avatar_button;
	_tmp1_ = avatar;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
}


void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner) {
	PixbufButton* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (GDK_IS_PIXBUF (banner));
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = banner;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
}


AvatarBannerWidget* avatar_banner_widget_construct (GType object_type) {
	AvatarBannerWidget * self = NULL;
	self = (AvatarBannerWidget*) g_object_new (object_type, NULL);
	return self;
}


AvatarBannerWidget* avatar_banner_widget_new (void) {
	return avatar_banner_widget_construct (TYPE_AVATAR_BANNER_WIDGET);
}


static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_banner_clicked_cb ((AvatarBannerWidget*) self);
}


static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_avatar_clicked_cb ((AvatarBannerWidget*) self);
}


static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarBannerWidget * self;
	GtkStyleContext* _tmp0_;
	PixbufButton* _tmp1_;
	PixbufButton* _tmp2_;
	PixbufButton* _tmp3_;
	PixbufButton* _tmp4_;
	PixbufButton* _tmp5_;
	PixbufButton* _tmp6_;
	PixbufButton* _tmp7_;
	PixbufButton* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	PixbufButton* _tmp11_;
	parent_class = G_OBJECT_CLASS (avatar_banner_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "avatar");
	_tmp1_ = pixbuf_button_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->set_banner_button);
	self->priv->set_banner_button = _tmp1_;
	_tmp2_ = self->priv->set_banner_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->set_banner_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->set_banner_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = pixbuf_button_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->set_avatar_button);
	self->priv->set_avatar_button = _tmp5_;
	_tmp6_ = self->priv->set_avatar_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->set_avatar_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->set_avatar_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = settings_get ();
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->set_avatar_button;
	g_settings_bind (_tmp10_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, G_TYPE_OBJECT, GObject), "round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp10_);
	return obj;
}


static void avatar_banner_widget_class_init (AvatarBannerWidgetClass * klass) {
	avatar_banner_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarBannerWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) avatar_banner_widget_real_draw;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) avatar_banner_widget_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) avatar_banner_widget_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) avatar_banner_widget_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) avatar_banner_widget_real_size_allocate;
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer *, GtkWidget*)) avatar_banner_widget_real_add;
	((GtkContainerClass *) klass)->remove = (void (*) (GtkContainer *, GtkWidget*)) avatar_banner_widget_real_remove;
	((GtkContainerClass *) klass)->forall = (void (*) (GtkContainer *, gboolean, GtkCallback, void*)) avatar_banner_widget_real_forall_internal;
	G_OBJECT_CLASS (klass)->constructor = avatar_banner_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_banner_widget_finalize;
	avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_AVATAR_CHANGED_SIGNAL] = g_signal_new ("avatar-changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gdk_pixbuf_get_type ());
	avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_BANNER_CHANGED_SIGNAL] = g_signal_new ("banner-changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gdk_pixbuf_get_type ());
	avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_AVATAR_CLICKED_SIGNAL] = g_signal_new ("avatar-clicked", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	avatar_banner_widget_signals[AVATAR_BANNER_WIDGET_BANNER_CLICKED_SIGNAL] = g_signal_new ("banner-clicked", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void avatar_banner_widget_instance_init (AvatarBannerWidget * self) {
	self->priv = AVATAR_BANNER_WIDGET_GET_PRIVATE (self);
}


static void avatar_banner_widget_finalize (GObject * obj) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_g_object_unref0 (self->priv->set_banner_button);
	_g_object_unref0 (self->priv->set_avatar_button);
	G_OBJECT_CLASS (avatar_banner_widget_parent_class)->finalize (obj);
}


GType avatar_banner_widget_get_type (void) {
	static volatile gsize avatar_banner_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_banner_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarBannerWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_banner_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarBannerWidget), 0, (GInstanceInitFunc) avatar_banner_widget_instance_init, NULL };
		GType avatar_banner_widget_type_id;
		avatar_banner_widget_type_id = g_type_register_static (gtk_container_get_type (), "AvatarBannerWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_banner_widget_type_id__volatile, avatar_banner_widget_type_id);
	}
	return avatar_banner_widget_type_id__volatile;
}



