/* DMListEntry.c generated by valac 0.38.7, the Vala compiler
 * generated from DMListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTwitterItem.h"
#include <pango/pango.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>


#define TYPE_DM_LIST_ENTRY (dm_list_entry_get_type ())
#define DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_LIST_ENTRY, DMListEntry))
#define DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_LIST_ENTRY, DMListEntryClass))
#define IS_DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_LIST_ENTRY))
#define IS_DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_LIST_ENTRY))
#define DM_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_LIST_ENTRY, DMListEntryClass))

typedef struct _DMListEntry DMListEntry;
typedef struct _DMListEntryClass DMListEntryClass;
typedef struct _DMListEntryPrivate DMListEntryPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;
enum  {
	DM_LIST_ENTRY_0_PROPERTY,
	DM_LIST_ENTRY_TEXT_PROPERTY,
	DM_LIST_ENTRY_SCREEN_NAME_PROPERTY,
	DM_LIST_ENTRY_NAME_PROPERTY,
	DM_LIST_ENTRY_AVATAR_PROPERTY,
	DM_LIST_ENTRY_SEEN_PROPERTY,
	DM_LIST_ENTRY_NUM_PROPERTIES
};
static GParamSpec* dm_list_entry_properties[DM_LIST_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PAGE (page_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _DMListEntry {
	GtkListBoxRow parent_instance;
	DMListEntryPrivate * priv;
	gint64 timestamp;
	gint64 id;
	gint64 user_id;
	MainWindow* main_window;
};

struct _DMListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _DMListEntryPrivate {
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
	GTimeSpan last_timediff;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;


static gpointer dm_list_entry_parent_class = NULL;
static CbTwitterItemInterface * dm_list_entry_cb_twitter_item_parent_iface = NULL;

GType dm_list_entry_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
#define DM_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_LIST_ENTRY, DMListEntryPrivate))
DMListEntry* dm_list_entry_new (void);
DMListEntry* dm_list_entry_construct (GType object_type);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
void avatar_widget_set_size (AvatarWidget* self, gint value);
TextButton* text_button_new (void);
TextButton* text_button_construct (GType object_type);
static void __lambda87_ (DMListEntry* self);
#define PROFILE_PAGE_KEY_USER_ID 1
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self);
void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
static gint dm_list_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
static gint64 dm_list_entry_real_get_sort_factor (CbTwitterItem* base);
static gint64 dm_list_entry_real_get_timestamp (CbTwitterItem* base);
static GTimeSpan dm_list_entry_real_get_last_set_timediff (CbTwitterItem* base);
static void dm_list_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span);
void dm_list_entry_set_text (DMListEntry* self, const gchar* value);
void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_name (DMListEntry* self, const gchar* value);
void text_button_set_markup (TextButton* self, const gchar* text);
void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
gboolean dm_list_entry_get_seen (DMListEntry* self);
void dm_list_entry_set_seen (DMListEntry* self, gboolean value);
static void dm_list_entry_finalize (GObject * obj);
static void _vala_dm_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dm_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void __lambda87_ (DMListEntry* self) {
	CbBundle* bundle = NULL;
	CbBundle* _tmp0_;
	gint64 _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	MainWindow* _tmp7_;
	MainWidget* _tmp8_;
	_tmp0_ = cb_bundle_new ();
	bundle = _tmp0_;
	_tmp1_ = self->user_id;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp1_);
	_tmp2_ = self->priv->screen_name_label;
	_tmp3_ = gtk_label_get_label (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
	_tmp6_ = _tmp5_;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->main_window;
	_tmp8_ = _tmp7_->main_widget;
	main_widget_switch_page (_tmp8_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda87_ ((DMListEntry*) self);
}


DMListEntry* dm_list_entry_construct (GType object_type) {
	DMListEntry * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp1_;
	AvatarWidget* _tmp2_;
	AvatarWidget* _tmp3_;
	AvatarWidget* _tmp4_;
	AvatarWidget* _tmp5_;
	AvatarWidget* _tmp6_;
	AvatarWidget* _tmp7_;
	AvatarWidget* _tmp8_;
	TextButton* _tmp9_;
	TextButton* _tmp10_;
	TextButton* _tmp11_;
	TextButton* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	TextButton* _tmp43_;
	self = (DMListEntry*) g_object_new (object_type, NULL);
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "tweet");
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp1_);
	grid = _tmp1_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget), "margin", 6, NULL);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = avatar_widget_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->avatar_image);
	self->priv->avatar_image = _tmp2_;
	_tmp3_ = self->priv->avatar_image;
	avatar_widget_set_size (_tmp3_, 48);
	_tmp4_ = self->priv->avatar_image;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp5_ = self->priv->avatar_image;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), "margin", 4, NULL);
	_tmp6_ = self->priv->avatar_image;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), 12);
	_tmp7_ = self->priv->avatar_image;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->avatar_image;
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), 0, 0, 1, 2);
	_tmp9_ = text_button_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->name_button);
	self->priv->name_button = _tmp9_;
	_tmp10_ = self->priv->name_button;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp11_ = self->priv->name_button;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = self->priv->name_button;
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 1, 0, 1, 1);
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->screen_name_label);
	self->priv->screen_name_label = _tmp13_;
	_tmp14_ = self->priv->screen_name_label;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp15_ = self->priv->screen_name_label;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp16_ = self->priv->screen_name_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp17_ = self->priv->screen_name_label;
	_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp18_, "dim-label");
	_tmp19_ = self->priv->screen_name_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->screen_name_label;
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), 2, 0, 1, 1);
	_tmp21_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->time_delta_label);
	self->priv->time_delta_label = _tmp21_;
	_tmp22_ = self->priv->time_delta_label;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	_tmp23_ = self->priv->time_delta_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp24_ = self->priv->time_delta_label;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp25_ = self->priv->time_delta_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	_tmp26_ = self->priv->time_delta_label;
	_tmp27_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp27_, "dim-label");
	_tmp28_ = self->priv->time_delta_label;
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), 3, 0, 1, 1);
	_tmp29_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->text_label);
	self->priv->text_label = _tmp29_;
	_tmp30_ = self->priv->text_label;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp31_ = self->priv->text_label;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp32_ = self->priv->text_label;
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp33_ = self->priv->text_label;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp34_ = self->priv->text_label;
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp35_ = self->priv->text_label;
	gtk_label_set_xalign (_tmp35_, 0.0f);
	_tmp36_ = self->priv->text_label;
	gtk_label_set_line_wrap (_tmp36_, TRUE);
	_tmp37_ = self->priv->text_label;
	gtk_label_set_line_wrap_mode (_tmp37_, PANGO_WRAP_WORD_CHAR);
	_tmp38_ = self->priv->text_label;
	gtk_label_set_use_markup (_tmp38_, TRUE);
	_tmp39_ = self->priv->text_label;
	gtk_label_set_use_markup (_tmp39_, TRUE);
	_tmp40_ = self->priv->text_label;
	gtk_label_set_selectable (_tmp40_, TRUE);
	_tmp41_ = self->priv->text_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget));
	_tmp42_ = self->priv->text_label;
	gtk_grid_attach (grid, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), 1, 1, 3, 1);
	_tmp43_ = self->priv->name_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) ___lambda87__gtk_button_clicked, self, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (grid);
	return self;
}


DMListEntry* dm_list_entry_new (void) {
	return dm_list_entry_construct (TYPE_DM_LIST_ENTRY);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch77_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch77_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally77;
	__catch77_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally77:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url) {
	gchar* url = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	Twitter* _tmp5_;
	Twitter* _tmp6_;
	gint64 _tmp7_;
	const gchar* _tmp8_;
	AvatarWidget* _tmp9_;
	gint _tmp10_;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	url = _tmp1_;
	_tmp2_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp2_ == 2) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = url;
		_tmp4_ = string_replace (_tmp3_, "_normal", "_bigger");
		_g_free0 (url);
		url = _tmp4_;
	}
	_tmp5_ = twitter_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = self->user_id;
	_tmp8_ = url;
	_tmp9_ = self->priv->avatar_image;
	_tmp10_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_get_avatar (_tmp6_, _tmp7_, _tmp8_, _tmp9_, 48 * _tmp10_, FALSE, NULL, NULL);
	_g_object_unref0 (_tmp6_);
	_g_free0 (url);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint dm_list_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now) {
	DMListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* then = NULL;
	gint64 _tmp4_;
	GDateTime* _tmp5_;
	GtkLabel* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GDateTime* _tmp10_;
	GTimeSpan _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp4_ = self->timestamp;
	_tmp5_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp5_;
	_tmp6_ = self->priv->time_delta_label;
	_tmp7_ = cur_time;
	_tmp8_ = utils_get_time_delta (then, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = cur_time;
	_tmp11_ = g_date_time_difference (_tmp10_, then);
	result = (gint) ((_tmp11_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


static gint64 dm_list_entry_real_get_sort_factor (CbTwitterItem* base) {
	DMListEntry * self;
	gint64 result = 0LL;
	gint64 _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = self->timestamp;
	result = _tmp0_;
	return result;
}


static gint64 dm_list_entry_real_get_timestamp (CbTwitterItem* base) {
	DMListEntry * self;
	gint64 result = 0LL;
	gint64 _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = self->timestamp;
	result = _tmp0_;
	return result;
}


static GTimeSpan dm_list_entry_real_get_last_set_timediff (CbTwitterItem* base) {
	DMListEntry * self;
	GTimeSpan result = 0LL;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = self->priv->last_timediff;
	result = _tmp0_;
	return result;
}


static void dm_list_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span) {
	DMListEntry * self;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_LIST_ENTRY, DMListEntry);
	_tmp0_ = span;
	self->priv->last_timediff = _tmp0_;
}


void dm_list_entry_set_text (DMListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, dm_list_entry_properties[DM_LIST_ENTRY_TEXT_PROPERTY]);
}


void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = value;
	_tmp2_ = g_strconcat ("@", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify_by_pspec ((GObject *) self, dm_list_entry_properties[DM_LIST_ENTRY_SCREEN_NAME_PROPERTY]);
}


void dm_list_entry_set_name (DMListEntry* self, const gchar* value) {
	TextButton* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->name_button;
	_tmp1_ = value;
	_tmp2_ = string_replace (_tmp1_, "&", "&amp;");
	_tmp3_ = _tmp2_;
	text_button_set_markup (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify_by_pspec ((GObject *) self, dm_list_entry_properties[DM_LIST_ENTRY_NAME_PROPERTY]);
}


void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value) {
	AvatarWidget* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = value;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, dm_list_entry_properties[DM_LIST_ENTRY_AVATAR_PROPERTY]);
}


gboolean dm_list_entry_get_seen (DMListEntry* self) {
	gboolean result;
	g_return_val_if_fail (IS_DM_LIST_ENTRY (self), FALSE);
	result = TRUE;
	return result;
}


void dm_list_entry_set_seen (DMListEntry* self, gboolean value) {
	g_return_if_fail (IS_DM_LIST_ENTRY (self));
	g_object_notify_by_pspec ((GObject *) self, dm_list_entry_properties[DM_LIST_ENTRY_SEEN_PROPERTY]);
}


static void dm_list_entry_class_init (DMListEntryClass * klass) {
	dm_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_TEXT_PROPERTY, dm_list_entry_properties[DM_LIST_ENTRY_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_SCREEN_NAME_PROPERTY, dm_list_entry_properties[DM_LIST_ENTRY_SCREEN_NAME_PROPERTY] = g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_NAME_PROPERTY, dm_list_entry_properties[DM_LIST_ENTRY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_AVATAR_PROPERTY, dm_list_entry_properties[DM_LIST_ENTRY_AVATAR_PROPERTY] = g_param_spec_pointer ("avatar", "avatar", "avatar", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_LIST_ENTRY_SEEN_PROPERTY, dm_list_entry_properties[DM_LIST_ENTRY_SEEN_PROPERTY] = g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dm_list_entry_cb_twitter_item_interface_init (CbTwitterItemInterface * iface) {
	dm_list_entry_cb_twitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*) (CbTwitterItem *, GDateTime*)) dm_list_entry_real_update_time_delta;
	iface->get_sort_factor = (gint64 (*) (CbTwitterItem *)) dm_list_entry_real_get_sort_factor;
	iface->get_timestamp = (gint64 (*) (CbTwitterItem *)) dm_list_entry_real_get_timestamp;
	iface->get_last_set_timediff = (GTimeSpan (*) (CbTwitterItem *)) dm_list_entry_real_get_last_set_timediff;
	iface->set_last_set_timediff = (void (*) (CbTwitterItem *, GTimeSpan)) dm_list_entry_real_set_last_set_timediff;
}


static void dm_list_entry_instance_init (DMListEntry * self) {
	self->priv = DM_LIST_ENTRY_GET_PRIVATE (self);
}


static void dm_list_entry_finalize (GObject * obj) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_LIST_ENTRY, DMListEntry);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	G_OBJECT_CLASS (dm_list_entry_parent_class)->finalize (obj);
}


GType dm_list_entry_get_type (void) {
	static volatile gsize dm_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&dm_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMListEntry), 0, (GInstanceInitFunc) dm_list_entry_instance_init, NULL };
		static const GInterfaceInfo cb_twitter_item_info = { (GInterfaceInitFunc) dm_list_entry_cb_twitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_list_entry_type_id;
		dm_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "DMListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (dm_list_entry_type_id, CB_TYPE_TWITTER_ITEM, &cb_twitter_item_info);
		g_once_init_leave (&dm_list_entry_type_id__volatile, dm_list_entry_type_id);
	}
	return dm_list_entry_type_id__volatile;
}


static void _vala_dm_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_LIST_ENTRY, DMListEntry);
	switch (property_id) {
		case DM_LIST_ENTRY_SEEN_PROPERTY:
		g_value_set_boolean (value, dm_list_entry_get_seen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_LIST_ENTRY, DMListEntry);
	switch (property_id) {
		case DM_LIST_ENTRY_TEXT_PROPERTY:
		dm_list_entry_set_text (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_SCREEN_NAME_PROPERTY:
		dm_list_entry_set_screen_name (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_NAME_PROPERTY:
		dm_list_entry_set_name (self, g_value_get_string (value));
		break;
		case DM_LIST_ENTRY_AVATAR_PROPERTY:
		dm_list_entry_set_avatar (self, g_value_get_pointer (value));
		break;
		case DM_LIST_ENTRY_SEEN_PROPERTY:
		dm_list_entry_set_seen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



