; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=infer-alignment -S | FileCheck %s

define void @non_pow2_size(i177 %X) {
; CHECK-LABEL: define void @non_pow2_size
; CHECK-SAME: (i177 [[X:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = alloca i177, align 8
; CHECK-NEXT:    [[L1:%.*]] = load i177, ptr [[A]], align 8
; CHECK-NEXT:    store i177 [[X]], ptr [[A]], align 8
; CHECK-NEXT:    ret void
;
  %A = alloca i177, align 1
  %L1 = load i177, ptr %A, align 1
  store i177 %X, ptr %A, align 1
  ret void
}

; TODO: For non-byte-sized vectors, current implementation assumes there is
; padding to the next byte boundary between elements.
@vector_i4 = constant [16 x <2 x i4>] zeroinitializer, align 8

define void @load_vector_i4(i4 %X) {
; CHECK-LABEL: define void @load_vector_i4
; CHECK-SAME: (i4 [[X:%.*]]) {
; CHECK-NEXT:    [[PTR_0:%.*]] = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 1
; CHECK-NEXT:    [[PTR_1:%.*]] = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 2
; CHECK-NEXT:    [[PTR_2:%.*]] = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 4
; CHECK-NEXT:    [[PTR_3:%.*]] = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 8
; CHECK-NEXT:    [[RES_0:%.*]] = load i4, ptr [[PTR_0]], align 1
; CHECK-NEXT:    [[RES_1:%.*]] = load i4, ptr [[PTR_1]], align 2
; CHECK-NEXT:    [[RES_2:%.*]] = load i4, ptr [[PTR_2]], align 4
; CHECK-NEXT:    [[RES_3:%.*]] = load i4, ptr [[PTR_3]], align 8
; CHECK-NEXT:    store i4 [[X]], ptr [[PTR_0]], align 1
; CHECK-NEXT:    store i4 [[X]], ptr [[PTR_1]], align 2
; CHECK-NEXT:    store i4 [[X]], ptr [[PTR_2]], align 4
; CHECK-NEXT:    store i4 [[X]], ptr [[PTR_3]], align 8
; CHECK-NEXT:    ret void
;
  %ptr.0 = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 1
  %ptr.1 = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 2
  %ptr.2 = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 4
  %ptr.3 = getelementptr [16 x <2 x i4>], ptr @vector_i4, i64 0, i64 8

  %res.0 = load i4, ptr %ptr.0, align 1
  %res.1 = load i4, ptr %ptr.1, align 1
  %res.2 = load i4, ptr %ptr.2, align 1
  %res.3 = load i4, ptr %ptr.3, align 1

  store i4 %X, ptr %ptr.0, align 1
  store i4 %X, ptr %ptr.1, align 1
  store i4 %X, ptr %ptr.2, align 1
  store i4 %X, ptr %ptr.3, align 1

  ret void
}
