# Manifest of KOMA-Script

This file is a listing of all files considered to be part of the
KOMA-Script bundle of LaTeX classes and packages. It is *not* automatically
generated but handmade.

## Source files

The following files are source files of the KOMA-Script bundle of LaTeX
classes and packages. All these files are also included in the TDS and the
CTAN files. All these files are mandatory for legal distributions of the
KOMA-Script bundle of LaTeX classes and packages.

**Note:** You can generate the implementation documentation of every file with
  extension “`.dtx`” using `lualatex-dev` and `mkindex`. However, you first need
  to unpack `koma-script-source-doc.cls` using
  “`tex koma-script-source-doc.dtx`”.

* `japanlco.dtx`
* `koma-script-source-doc.dtx`
* `scraddr.dtx`
* `scrextend.dtx`
* `scrjura.dtx`
* `scrkernel-addressfiles.dtx`
* `scrkernel-basics.dtx`
* `scrkernel-bibliography.dtx`
* `scrkernel-compatibility.dtx`
* `scrkernel-floats.dtx`
* `scrkernel-fonts.dtx`
* `scrkernel-footnotes.dtx`
* `scrkernel-index.dtx`
* `scrkernel-language.dtx`
* `scrkernel-letterclassoptions.dtx`
* `scrkernel-listsof.dtx`
* `scrkernel-miscellaneous.dtx`
* `scrkernel-notepaper.dtx`
* `scrkernel-pagestyles.dtx`
* `scrkernel-paragraphs.dtx`
* `scrkernel-pseudolength.dtx`
* `scrkernel-sections.dtx`
* `scrkernel-title.dtx`
* `scrkernel-tocstyle.dtx`
* `scrkernel-typearea.dtx`
* `scrkernel-variables.dtx`
* `scrkernel-version.dtx`
* `scrlayer.dtx`
* `scrlayer-notecolumn.dtx`
* `scrlayer-scrpage.dtx`
* `scrlfile.dtx`
* `scrlfile-hook.dtx`
* `scrlfile-patcholdlatex.dtx`
* `scrlogo.dtx`
* `scrtime.dtx`
* `tocbasic.dtx`
* `scrjura.dtx`
* `scrmain.ins`
* `scrstrip.inc`
* `scrstrop.inc`
* `scrdocstrip.tex`

## Typeset documentation source files

### User manual main files

These files are typeset using LaTeX to produce the user manuals of the
KOMA-Script bundle of LaTeX classes and packages. All these files are also
include in the TDS and the CTAN files. All these files are mandatory for legal
distributions of the KOMA-Script bundle of LaTeX classes and packages.

* `scrguide-en.tex` (English user manual main file)
* `scrguide-de.tex` (German user manual main file)

### User manual additional files

These files are also needed to produce the user manuals of the KOMA-Script
bundle of LaTeX classes and packages. All these files are also include in
the TDS and the CTAN files. All these files are mandatory for legal
distributions of the KOMA-Script bundle of LaTeX classes and packages.

**Note:** Files ending with “`-en.tex`” are part of the English user
  manual. Files ending with “`-de.tex`” are part of the German user
  manual. All other files are part of both, the English and the German user
  manual.

* `scrlttr2-examples.dtx` (has to be unpacked using 
  “`tex scrlttr2-examples.dtx`” before using LaTeX to produce the user
  manuals)
* `scrguide.cls`
* `scrguide.ist`
* `scrguide.gst`
* `scrguide-body.tex`
* `linkalias.tex`
* `plength-tikz.tex`
* `variables-tikz.tex`
* `terms-en.tex`
* `preface-en.tex`
* `introduction-en.tex`
* `authorpart-en.tex`
* `typearea-en.tex`
* `scrbookreportarticle-en.tex` 
* `scrlttr2-en.tex` 
* `scrlayer-scrpage-en.tex` 
* `scrdate-en.tex` 
* `scrtime-en.tex` 
* `scraddr-en.tex` 
* `scrextend-en.tex` 
* `scrjura-en.tex`
* `scrjura-example-en.tex`
* `scrlogo-en.tex` 
* `common-options-en.tex` 
* `common-compatibility-en.tex` 
* `common-draftmode-en.tex` 
* `common-typearea-en.tex` 
* `common-fontsize-en.tex` 
* `common-textmarkup-en.tex` 
* `common-titles-en.tex` 
* `common-parmarkup-en.tex` 
* `common-oddorevenpage-en.tex` 
* `common-interleafpage-en.tex` 
* `common-footnotes-en.tex` 
* `common-dictum-en.tex` 
* `common-lists-en.tex` 
* `common-marginpar-en.tex` 
* `common-headfootheight-en.tex` 
* `common-pagestylemanipulation-en.tex` 
* `expertpart-en.tex` 
* `scrbase-en.tex` 
* `scrlfile-en.tex` 
* `scrwfile-en.tex` 
* `tocbasic-en.tex` 
* `book-remarkbox-nopatch-en.tex`
* `book-remarkbox-patch-en.tex`
* `scrlayer-en.tex` 
* `scrlayer-scrpage-experts-en.tex` 
* `scrlayer-notecolumn-en.tex`
* `scrlayer-notecolumn-example-en.tex`
* `typearea-experts-en.tex` 
* `scrbookreportarticle-experts-en.tex` 
* `scrlttr2-experts-en.tex` 
* `common-footnotes-experts-en.tex` 
* `japanlco-en.tex` 
* `terms-de.tex`
* `preface-de.tex`
* `introduction-de.tex`
* `authorpart-de.tex`
* `typearea-de.tex`
* `scrbookreportarticle-de.tex` 
* `scrlttr2-de.tex` 
* `scrlayer-scrpage-de.tex` 
* `scrdate-de.tex` 
* `scrtime-de.tex` 
* `scraddr-de.tex` 
* `scrextend-de.tex` 
* `scrjura-de.tex` 
* `scrjura-example-de.tex`
* `scrlogo-de.tex` 
* `common-options-de.tex` 
* `common-compatibility-de.tex` 
* `common-draftmode-de.tex` 
* `common-typearea-de.tex` 
* `common-fontsize-de.tex` 
* `common-textmarkup-de.tex` 
* `common-titles-de.tex` 
* `common-parmarkup-de.tex` 
* `common-oddorevenpage-de.tex` 
* `common-interleafpage-de.tex` 
* `common-footnotes-de.tex` 
* `common-dictum-de.tex` 
* `common-lists-de.tex` 
* `common-marginpar-de.tex` 
* `common-headfootheight-de.tex` 
* `common-pagestylemanipulation-de.tex` 
* `expertpart-de.tex` 
* `scrbase-de.tex` 
* `scrlfile-de.tex` 
* `scrwfile-de.tex` 
* `tocbasic-de.tex` 
* `book-remarkbox-nopatch-de.tex`
* `book-remarkbox-patch-de.tex`
* `scrlayer-de.tex` 
* `scrlayer-scrpage-experts-de.tex`
* `scrlayer-notecolumn-de.tex`
* `scrlayer-notecolumn-example-de.tex`
* `typearea-experts-de.tex` 
* `scrbookreportarticle-experts-de.tex` 
* `scrlttr2-experts-de.tex` 
* `common-footnotes-experts-de.tex` 

## Text files

These plain text files are included as documentation or metadata. Files
listed with “`²`” marker are also included to the TDS and the CTAN files.
The files listed with “`²`” marker are also mandatory for legal distributions
of the KOMA-Script bundle of LaTeX classes and packages.

* `lppl-de.txt`²
* `lppl.txt`²
* `MANIFEST.md`²
* `README.md`² (files is generated using `l3build` with every new release)
* `README.komascript-source-doc.cls`
* `README.scraddr.sty`
* `README.scrartcl.cls`
* `README.scrarticle.cls`
* `README.scrbase.sty`
* `README.scrbook.cls`
* `README.scrdate.sty`
* `README.scrextend.sty`
* `README.scrfontsizes.sty`
* `README.scrjura.sty`
* `README.scrkbase.sty`
* `README.scrlayer-notecolumn.sty`
* `README.scrlayer-scrpage.sty`
* `README.scrlayer.sty`
* `README.scrletter.cls`
* `README.scrletter.sty`
* `README.scrlfile-hook.sty`
* `README.scrlfile-hook-3.34.sty`
* `README.scrlfile-patcholdlatex.sty`
* `README.scrlfile.sty`
* `README.scrlogo.sty`
* `README.scrlttr2.cls`
* `README.scrreport.cls`
* `README.scrreprt.cls`
* `README.scrtime.sty`
* `README.tocbasic.sty`
* `README.typearea.sty`
* `releaselist.txt`

## Derived files

The files are created by *unpacking* the package sources. These are only
included in the TDS but neither the developer repository nor the CTAN files.
All these files are optional for legal distributions of the KOMA-Script bundle
of LaTeX classes and packages.

* `scraddr.sty`
* `scrbase.sty`
* `scrdate.sty`
* `scrextend.sty`
* `scrfontsizes.sty`
* `scrjura.sty`
* `scrkbase.sty`
* `scrlayer-notecolumn.sty`
* `scrlayer-scrpage.sty`
* `scrlayer.sty`
* `scrletter.sty`
* `scrlfile-hook-3.34.sty`
* `scrlfile-hook.sty`
* `scrlfile-patcholdlatex.sty`
* `scrlfile.sty`
* `scrlogo.sty`
* `scrtime.sty`
* `tocbasic.sty`
* `typearea.sty`
* `koma-script-source-doc.cls`
* `scrartcl.cls`
* `scrarticle.cls`
* `scrbook.cls`
* `scrletter.cls`
* `scrlttr2.cls`
* `scrreport.cls`
* `scrreprt.cls`
* `scrsize10pt.clo`
* `scrsize11pt.clo`
* `scrsize12pt.clo`
* `DIN.lco`
* `DIN5008A.lco`
* `DIN5008B.lco`
* `DINmtext.lco`
* `KOMAold.lco`
* `KakuLL.lco`
* `NF.lco`
* `NipponEH.lco`
* `NipponEL.lco`
* `NipponLH.lco`
* `NipponLL.lco`
* `NipponRL.lco`
* `SN.lco`
* `SNleft.lco`
* `UScommercial9.lco`
* `UScommercial9DW.lco`
* `visualize.lco`
* `float.hak`
* `floatrow.hak`
* `hyperref.hak`
* `listings.hak`
* `lscape.hak`
* `nomencl.hak`
* `setspace.hak`
* `standardsections.hak`

## Typeset documents

The output files from typesetting the various source files.

### Main user manual

These are the main user manuals. They are included into the TDS and the CTAN
files but not part of the developers repository. All these files are mandatory
for legal distributions of the KOMA-Script bundle of LaTeX classes and
packages unless the developer source repository.

* `scrguide-en.pdf`
* `scrguide-de.pdf`

### Class and package reference files

These files can help users to quickly find the user manual of classes and
packages. All these files are optional for legal distributions of the
KOMA-Script bundle of LaTeX classes and packages.

* `tocbasic.html`
* `scrlayer.html`
* `scrextend.html`
* `scrlayer-scrpage.html`
* `scrlfile-hook.html`
* `scrdate.html`
* `scrartcl.html`
* `scrlfile.html`
* `scrjura.html`
* `scrreport.html`
* `typearea.html`
* `scrarticle.html`
* `scrlayer-notecolumn.html`
* `scraddr.html`
* `scrlfile-hook-3.34.html`
* `scrtime.html`
* `scrlttr2.html`
* `scrletter.html`
* `scrbase.html`
* `scrlfile-patcholdlatex.html`
* `scrlogo.html`
* `scrkbase.html`
* `scrreprt.html`
* `scrbook.html`

## Test files

These files form the test suite for the KOMA-Script bundle of LaTeX classes
and packages.  These are part of the developer repository but neither the
TDS nor the CTAN files.

* `scrbase-load-test.lvt`
* `scrbook-counterwithin.lvt`
* `scrextend-options.lvt`
* `scrlfile-packages.lvt`
* `scrlttr2-depreactedlcoloading.lvt`
* `typearea-pagesize.lvt`
* `scrbase-load-test.tlg`
* `scrbook-counterwithin.tlg`
* `scrextend-options.tlg`
* `scrlfile-packages.tlg`
* `scrlttr2-depreactedlcoloading.tlg`
* `typearea-pagesize.tlg`
