/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class SetNonStrokingColorSpace
extends OperatorProcessor {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        COSName name = (COSName)arguments.get(0);
        PDColorSpace cs = PDColorSpaceFactory.createColorSpace(name, this.context.getColorSpaces(), this.context.getResources().getPatterns());
        PDColorState colorInstance = this.context.getGraphicsState().getNonStrokingColor();
        colorInstance.setColorSpace(cs);
        int numComponents = cs.getNumberOfComponents();
        float[] values = EMPTY_FLOAT_ARRAY;
        if (numComponents >= 0) {
            values = new float[numComponents];
            for (int i = 0; i < numComponents; ++i) {
                values[i] = 0.0f;
            }
            if (cs instanceof PDDeviceCMYK) {
                values[3] = 1.0f;
            }
        }
        colorInstance.setColorSpaceValue(values);
    }
}

